/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.jms;

import com.metamatrix.connector.xml.CachingConnector;
import com.metamatrix.connector.xml.IQueryPreprocessor;
import com.metamatrix.connector.xml.TrustedPayloadHandler;
import com.metamatrix.connector.xml.XMLConnection;
import com.metamatrix.connector.xml.XMLConnectorState;
import com.metamatrix.connector.xml.jms.JMSExecution;
import com.metamatrix.connector.xml.jms.JMSXMLConnectorState;
import com.metamatrix.connector.xml.jms.Messages;
import com.metamatrix.data.api.ConnectorCapabilities;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorMetadata;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JMSConnection
implements XMLConnection {
    SecurityContext secCtx;
    ConnectorEnvironment connectorEnv;
    CachingConnector connector;
    private JMSXMLConnectorState state;
    private Context context;
    private ConnectionFactory factory;
    private Connection jmsConnection;
    private Destination outboundDestination;
    private Destination inboundDestination;
    private String password;
    private String userName;

    public JMSConnection(CachingConnector connector, SecurityContext secCtx, ConnectorEnvironment connectorEnv) throws ConnectorException {
        this.connector = connector;
        this.secCtx = secCtx;
        this.connectorEnv = connectorEnv;
        this.state = (JMSXMLConnectorState)connector.getState();
        if (null == this.state) {
            throw new ConnectorException(Messages.getString("JMSConnection.no.state"));
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("java.naming.factory.initial", this.state.getInitialContextFactoryName());
        properties.put("java.naming.provider.url", this.state.getPrimaryProviderUrl());
        try {
            this.context = new InitialContext(properties);
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e, Messages.getString("JMSConnection.cannot.construct.InitialContext"));
        }
        try {
            this.factory = (ConnectionFactory)this.context.lookup(this.state.getConnectionFactoryName());
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e, Messages.getString("JMSConnection.cannot.get.ConnectionFactory"));
        }
        try {
            this.jmsConnection = this.usingCredentials() ? this.factory.createConnection(this.getUserName(), this.getPassword()) : this.factory.createConnection();
        }
        catch (JMSSecurityException e) {
            throw new ConnectorException((Throwable)e, Messages.getString("JMSConnection.auth.failed"));
        }
        catch (JMSException e) {
            throw new ConnectorException((Throwable)e, Messages.getString("JMSConnection.cannot.create.Connection"));
        }
        try {
            String outboundDestinationName = this.state.getOutboundJMSDestination();
            if (null != outboundDestinationName) {
                this.setOutboundDestination((Destination)this.context.lookup(outboundDestinationName));
            }
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e, Messages.getString("JMSConnection.cannot.get.OutboundDestination"));
        }
        try {
            String inboundDestinationName = this.state.getInboundJMSDestination();
            if (null != inboundDestinationName) {
                this.setInboundDestination((Destination)this.context.lookup(inboundDestinationName));
            }
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e, Messages.getString("JMSConnection.cannot.get.InboundDestination"));
        }
    }

    public XMLConnectorState getState() {
        return this.state;
    }

    private String getUserName() {
        return this.userName;
    }

    private String getPassword() {
        return this.password;
    }

    private boolean usingCredentials() {
        return this.userName != null && this.password != null;
    }

    public ConnectorCapabilities getCapabilities() {
        return this.state.getConnectorCapabilities();
    }

    public Execution createExecution(int executionMode, ExecutionContext exeCtx, RuntimeMetadata metadata) throws ConnectorException {
        try {
            JMSExecution retVal = null;
            String errKey = null;
            switch (executionMode) {
                case 5: {
                    retVal = new JMSExecution(this, metadata, exeCtx, this.connectorEnv, this.connector.getLogger());
                    break;
                }
                case 1: {
                    errKey = Messages.getString("XMLConnectionImpl.update.not.supported");
                    break;
                }
                case 2: {
                    errKey = Messages.getString("XMLConnectionImpl.no.xml.procedures");
                    break;
                }
                default: {
                    errKey = Messages.getString("XMLConnectionImpl.invalid.execution.mode");
                }
            }
            if (errKey != null) {
                throw new ConnectorException(errKey);
            }
            return retVal;
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public ConnectorMetadata getMetadata() {
        return null;
    }

    public void release() {
        try {
            this.jmsConnection.close();
        }
        catch (JMSException e) {
            this.connector.getLogger().logError(Messages.getString("JMSConnection.exception.on.close"), (Throwable)e);
        }
    }

    public Destination getInboundDestination() {
        return this.inboundDestination;
    }

    private void setInboundDestination(Destination inboundDestination) {
        this.inboundDestination = inboundDestination;
    }

    public Destination getOutboundDestination() {
        return this.outboundDestination;
    }

    private void setOutboundDestination(Destination outboundDestination) {
        this.outboundDestination = outboundDestination;
    }

    public Session getJMSSession() throws JMSException {
        return this.jmsConnection.createSession(false, this.state.getAcknowledgementMode());
    }

    public IQueryPreprocessor getQueryPreprocessor() {
        return this.state.getPreprocessor();
    }

    public CachingConnector getConnector() {
        return this.connector;
    }

    public TrustedPayloadHandler getTrustedPayloadHandler() throws ConnectorException {
        return this.state.getTrustDeserializerInstance();
    }

    public String getQueryId() {
        return this.secCtx.getRequestIdentifier();
    }

    public String getUser() {
        return this.secCtx.getUser();
    }

    public void start() throws ConnectorException {
        try {
            this.jmsConnection.start();
        }
        catch (JMSException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public void stop() throws ConnectorException {
        try {
            this.jmsConnection.close();
        }
        catch (JMSException e) {
            throw new ConnectorException((Throwable)e);
        }
    }
}

