/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.CachingConnector;
import com.metamatrix.connector.xml.SecureConnectorState;
import com.metamatrix.connector.xml.TrustedPayloadHandler;
import com.metamatrix.connector.xml.XMLConnection;
import com.metamatrix.connector.xml.XMLConnectorState;
import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.connector.xml.base.SecureConnectorStateImpl;
import com.metamatrix.connector.xml.base.XMLExecutionImpl;
import com.metamatrix.data.api.ConnectorCapabilities;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ConnectorMetadata;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.io.Serializable;

public class XMLConnectionImpl
implements XMLConnection {
    private CachingConnector connector;
    private ConnectorEnvironment connectorEnv;
    private ConnectorLogger logger;
    private String m_queryId;
    private String m_user;
    private Serializable m_executionPayload;
    private Serializable m_trustedPayload;
    private TrustedPayloadHandler payloadHandler;

    public XMLConnectionImpl(CachingConnector connector, SecurityContext context, ConnectorEnvironment connectorEnv) throws ConnectorException {
        this.connector = connector;
        this.connectorEnv = connectorEnv;
        this.logger = connector.getState().getLogger();
        this.logger.logTrace("XMLConnection initialized for Request Identifier " + context.getRequestIdentifier());
        this.setQueryId(context.getRequestIdentifier());
        this.setUser(context.getUser());
        this.setTrustedPayload(context.getTrustedPayload());
        this.setExecutionPayload(context.getExecutionPayload());
        this.processTrustPayload();
    }

    public ConnectorCapabilities getCapabilities() {
        return this.connector.getState().getConnectorCapabilities();
    }

    public Execution createExecution(int executionMode, ExecutionContext context, RuntimeMetadata metadata) throws ConnectorException {
        try {
            XMLExecutionImpl retVal = null;
            String errKey = null;
            switch (executionMode) {
                case 0: {
                    retVal = new XMLExecutionImpl(this, metadata, context, this.connectorEnv);
                    break;
                }
                case 1: {
                    errKey = Messages.getString("XMLConnectionImpl.update.not.supported");
                    break;
                }
                case 2: {
                    errKey = Messages.getString("XMLConnectionImpl.no.xml.procedures");
                    break;
                }
                default: {
                    errKey = Messages.getString("XMLConnectionImpl.invalid.execution.mode");
                }
            }
            if (errKey != null) {
                throw new ConnectorException(errKey);
            }
            return retVal;
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public ConnectorMetadata getMetadata() {
        return null;
    }

    public void release() {
        this.logger.logTrace("XMLConnection released for RequestIdentifier " + this.getQueryId());
    }

    public XMLConnectorState getState() {
        return this.connector.getState();
    }

    public CachingConnector getConnector() {
        return this.connector;
    }

    public TrustedPayloadHandler getTrustedPayloadHandler() {
        return this.payloadHandler;
    }

    public String getQueryId() {
        return this.m_queryId;
    }

    public String getUser() {
        return this.m_user;
    }

    private void setQueryId(String queryId) {
        this.m_queryId = queryId;
    }

    private void setUser(String user) {
        this.m_user = user;
    }

    private void setExecutionPayload(Serializable ser) {
        this.m_executionPayload = ser;
    }

    private Serializable getExecutionPayload() {
        return this.m_executionPayload;
    }

    private void setTrustedPayload(Serializable ser) {
        this.m_trustedPayload = ser;
    }

    private Serializable getTrustedPayload() {
        return this.m_trustedPayload;
    }

    private void processTrustPayload() throws ConnectorException {
        if (this.getState() instanceof SecureConnectorStateImpl) {
            this.payloadHandler = ((SecureConnectorState)((Object)this.getState())).getTrustDeserializerInstance();
            this.payloadHandler.setExecutionPayload(this.getExecutionPayload());
            this.payloadHandler.setTrustedPayload(this.getTrustedPayload());
            this.payloadHandler.setConnectorName(this.connectorEnv.getConnectorName());
            this.payloadHandler.setLogger(this.connector.getLogger());
            try {
                this.payloadHandler.processPayloads();
            }
            catch (Throwable e) {
                String message = Messages.getString("XMLConnectionImpl.exception.processing.trusted.payload");
                throw new ConnectorException(e, message);
            }
        }
    }
}

