/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.salesforce;

import com.metamatrix.connector.salesforce.Connector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SalesforceSessionMonitor {
    public static final int CLEAN_INTERVAL_MS = 60000;
    public static final int DISCARD_AGE_MS = 0x6DDD00;
    private Map sessions;
    private CleanerThread cleaner;
    private Connector connector;
    private long discardAgems = 0x6DDD00L;
    private long cleanItervalms = 60000L;

    public SalesforceSessionMonitor(Connector connector, long discardAgems, long cleanItervalms) {
        this.connector = connector;
        this.discardAgems = discardAgems;
        this.cleanItervalms = cleanItervalms;
        this.sessions = Collections.synchronizedMap(new HashMap());
        this.cleaner = new CleanerThread(this);
        this.cleaner.start();
    }

    public SalesforceSessionMonitor(Connector connector) {
        this(connector, 0x6DDD00L, 60000L);
    }

    public void addSession(String id) {
        this.sessions.put(id, new Long(System.currentTimeMillis()));
    }

    public long timestampForId(String id) {
        Long timestamp = (Long)this.sessions.get(id);
        if (timestamp == null) {
            return -1L;
        }
        return timestamp;
    }

    public int size() {
        return this.sessions.size();
    }

    public void close() {
        this.sessions.clear();
        this.cleaner.end();
    }

    public boolean isMonitored(String id) {
        return this.sessions.containsKey(id);
    }

    public static class CleanerThread
    extends Thread {
        private long lastCleanTimems;
        private SalesforceSessionMonitor monitor;
        private boolean done;

        public CleanerThread(SalesforceSessionMonitor monitor) {
            this.monitor = monitor;
        }

        public void run() {
            while (!this.done) {
                long now = System.currentTimeMillis();
                if (now - this.lastCleanTimems < this.monitor.cleanItervalms || this.monitor.sessions.size() == 0) {
                    this.lastCleanTimems = now;
                    try {
                        CleanerThread.sleep(this.monitor.cleanItervalms);
                    }
                    catch (InterruptedException e) {
                        this.done = true;
                    }
                    continue;
                }
                Set entries = this.monitor.sessions.entrySet();
                Iterator i = entries.iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    String key = (String)entry.getKey();
                    Long time = (Long)entry.getValue();
                    if (now - time < this.monitor.discardAgems) continue;
                    i.remove();
                }
                this.lastCleanTimems = now;
            }
        }

        public void end() {
            this.done = true;
            this.interrupt();
        }
    }
}

