/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.Describable;
import com.metamatrix.query.processor.DescribableUtil;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.relational.RelationalNodeStatistics;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class RelationalNode
implements Cloneable,
Describable {
    private CommandContext context;
    private BufferManager bufferManager;
    private ProcessorDataManager dataMgr;
    private int nodeID;
    private List elements;
    private int batchSize;
    private RelationalNodeStatistics nodeStatistics;
    private int beginBatch = 1;
    private List batchRows;
    private boolean lastBatch = false;
    private List topElements;
    private Map symbolMap;
    private RelationalNode parent;
    private RelationalNode[] children = new RelationalNode[2];
    private Number estimateNodeCardinality;
    private Number setSizeEstimate;
    private Number depAccessEstimate;
    private Number estimateDepJoinCost;
    private Number estimateJoinCost;
    private boolean closed = false;
    private static final String TAB = "  ";

    public RelationalNode(int nodeID) {
        this.nodeID = nodeID;
    }

    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        this.context = context;
        this.bufferManager = bufferManager;
        this.dataMgr = dataMgr;
        if (context.getCollectNodeStatistics()) {
            this.nodeStatistics = new RelationalNodeStatistics();
        }
        this.batchSize = bufferManager.getProcessorBatchSize();
    }

    public CommandContext getContext() {
        return this.context;
    }

    public int getID() {
        return this.nodeID;
    }

    public void setID(int nodeID) {
        this.nodeID = nodeID;
    }

    protected BufferManager getBufferManager() {
        return this.bufferManager;
    }

    protected ProcessorDataManager getDataManager() {
        return this.dataMgr;
    }

    protected String getConnectionID() {
        return this.context.getConnectionID();
    }

    protected int getBatchSize() {
        return this.batchSize;
    }

    public void reset() {
        for (int i = 0; i < this.children.length && this.children[i] != null; ++i) {
            this.children[i].reset();
        }
        this.beginBatch = 1;
        this.batchRows = null;
        this.lastBatch = false;
        this.closed = false;
    }

    public void setElements(List elements) {
        this.elements = elements;
    }

    public List getElements() {
        return this.elements;
    }

    public void setTopElements(List topElements) {
        this.topElements = topElements;
    }

    public List getTopElements() {
        return this.topElements;
    }

    public void setSymbolMap(Map symbolMap) {
        this.symbolMap = symbolMap;
    }

    public Map getSymbolMap() {
        return this.symbolMap;
    }

    public RelationalNode getParent() {
        return this.parent;
    }

    public void setParent(RelationalNode parent) {
        this.parent = parent;
    }

    public RelationalNode[] getChildren() {
        return this.children;
    }

    public void addChild(RelationalNode child) {
        child.setParent(this);
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != null) continue;
            this.children[i] = child;
            return;
        }
        RelationalNode[] newChildren = new RelationalNode[this.children.length * 2];
        System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
        newChildren[this.children.length] = child;
        this.children = newChildren;
    }

    protected void addBatchRow(List row) {
        if (this.batchRows == null) {
            this.batchRows = new ArrayList(this.batchSize);
        }
        this.batchRows.add(row);
    }

    protected void terminateBatches() {
        this.lastBatch = true;
    }

    protected boolean isBatchFull() {
        return this.batchRows != null && this.batchRows.size() >= this.batchSize;
    }

    protected TupleBatch pullBatch() {
        TupleBatch batch = null;
        if (this.batchRows != null) {
            batch = new TupleBatch(this.beginBatch, this.batchRows);
            this.beginBatch += this.batchRows.size();
        } else {
            batch = new TupleBatch(this.beginBatch, Collections.EMPTY_LIST);
        }
        batch.setTerminationFlag(this.lastBatch);
        this.batchRows = null;
        this.lastBatch = false;
        return batch;
    }

    public void open() throws MetaMatrixComponentException {
        for (int i = 0; i < this.children.length && this.children[i] != null; ++i) {
            this.children[i].open();
        }
    }

    public TupleBatch nextBatch() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        boolean recordStats;
        boolean bl = recordStats = this.context != null && (this.context.getCollectNodeStatistics() || this.context.getProcessDebug());
        if (recordStats && this.context.getCollectNodeStatistics()) {
            this.nodeStatistics.startBatchTimer();
        }
        TupleBatch batch = null;
        try {
            do {
                batch = this.nextBatchDirect();
                if (!recordStats) continue;
                if (this.context.getCollectNodeStatistics()) {
                    this.nodeStatistics.stopBatchTimer();
                    this.nodeStatistics.collectCumulativeNodeStats(batch, 0);
                    if (batch.getTerminationFlag()) {
                        this.nodeStatistics.collectNodeStats(this.getChildren(), this.getClassName());
                    }
                }
                if (!this.context.getProcessDebug()) continue;
                this.recordBatch(batch);
            } while (batch.getRowCount() == 0 && !batch.getTerminationFlag());
            return batch;
        }
        catch (BlockedException e) {
            if (recordStats && this.context.getCollectNodeStatistics()) {
                this.nodeStatistics.stopBatchTimer();
                this.nodeStatistics.collectCumulativeNodeStats(batch, 1);
            }
            throw e;
        }
        catch (MetaMatrixComponentException e) {
            if (recordStats && this.context.getCollectNodeStatistics()) {
                this.nodeStatistics.stopBatchTimer();
            }
            throw e;
        }
    }

    protected abstract TupleBatch nextBatchDirect() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException;

    public void close() throws MetaMatrixComponentException {
        if (!this.closed) {
            for (int i = 0; i < this.children.length && this.children[i] != null; ++i) {
                this.children[i].close();
            }
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected boolean acceptID(int nodeID) {
        return this.nodeID == nodeID;
    }

    protected void setTupleSource(TupleSource tupleSource, int nodeID) {
    }

    protected List projectTuple(Map tupleElements, List tupleValues, List projectElements) throws MetaMatrixComponentException {
        ArrayList projectedTuple = new ArrayList(projectElements.size());
        Iterator projectIter = projectElements.iterator();
        while (projectIter.hasNext()) {
            Expression mappedSymbol;
            Map symbolMap;
            SingleElementSymbol symbol = (SingleElementSymbol)projectIter.next();
            Integer index = (Integer)tupleElements.get(symbol);
            if (index == null && (symbolMap = this.getSymbolMap()) != null && (mappedSymbol = (Expression)this.getSymbolMap().get(symbol)) != null && (index = (Integer)tupleElements.get(mappedSymbol)) == null) {
                String shortName = symbol.getShortName();
                Iterator tupleSymbolIter = tupleElements.keySet().iterator();
                while (tupleSymbolIter.hasNext()) {
                    SingleElementSymbol tupleElem = (SingleElementSymbol)tupleSymbolIter.next();
                    if (!tupleElem.getShortName().equalsIgnoreCase(shortName)) continue;
                    index = (Integer)tupleElements.get(tupleElem);
                    break;
                }
            }
            if (index == null) {
                throw new MetaMatrixComponentException(QueryExecPlugin.Util.getString("ERR.015.006.0035", new Object[]{symbol, tupleElements}));
            }
            projectedTuple.add(tupleValues.get(index));
        }
        return projectedTuple;
    }

    protected Map createLookupMap(List elements) {
        HashMap lookupMap = new HashMap();
        for (int i = 0; i < elements.size(); ++i) {
            Object element = elements.get(i);
            lookupMap.put(element, new Integer(i));
        }
        return lookupMap;
    }

    private void recordBatch(TupleBatch batch) {
        StringBuffer str = new StringBuffer();
        str.append(this.getClassName());
        str.append("(");
        str.append(this.getID());
        str.append(") sending ");
        str.append(batch);
        System.out.println(str.toString());
        if (batch.getRowCount() > 0) {
            for (int row = batch.getBeginRow(); row <= batch.getEndRow(); ++row) {
                System.out.println("\t" + row + ": " + batch.getTuple(row));
            }
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        this.getRecursiveString(str, 0);
        return str.toString();
    }

    public String nodeToString() {
        StringBuffer str = new StringBuffer();
        this.getNodeString(str);
        return str.toString();
    }

    private void setTab(StringBuffer str, int tabStop) {
        for (int i = 0; i < tabStop; ++i) {
            str.append(TAB);
        }
    }

    private void getRecursiveString(StringBuffer str, int tabLevel) {
        this.setTab(str, tabLevel);
        this.getNodeString(str);
        str.append("\n");
        for (int i = 0; i < this.children.length && this.children[i] != null; ++i) {
            this.children[i].getRecursiveString(str, tabLevel + 1);
        }
    }

    protected void getNodeString(StringBuffer str) {
        str.append(this.getClassName());
        str.append("(");
        str.append(this.getID());
        str.append(") output=");
        str.append(this.getElements());
        str.append(" ");
    }

    protected String getClassName() {
        String fullClassName = this.getClass().getName();
        int index = fullClassName.lastIndexOf(".");
        return fullClassName.substring(index + 1);
    }

    public abstract Object clone();

    protected void copy(RelationalNode source, RelationalNode target) {
        if (source.elements != null) {
            target.elements = new ArrayList(source.elements);
        }
        if (source.topElements != null) {
            target.topElements = new ArrayList(source.topElements);
        }
        if (source.symbolMap != null) {
            target.symbolMap = new HashMap(source.symbolMap);
        }
        target.children = new RelationalNode[source.children.length];
        for (int i = 0; i < source.children.length && source.children[i] != null; ++i) {
            target.children[i] = (RelationalNode)source.children[i].clone();
            target.children[i].setParent(target);
        }
    }

    public List getChildPlans() {
        return null;
    }

    public Map getDescriptionProperties() {
        List costEstimates;
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.context != null && this.context.getCollectNodeStatistics()) {
            this.nodeStatistics.setStatisticsList();
            props.put("nodeStatistics", this.nodeStatistics.getStatisticsList());
        }
        if ((costEstimates = this.getCostEstimates()) != null) {
            props.put("nodeCostEstimates", costEstimates);
        }
        props.put("type", "Relational");
        props.put("children", this.getChildDescriptionProperties());
        props.put("outputCols", DescribableUtil.getOutputColumnProperties((List)this.elements));
        return props;
    }

    protected List getChildDescriptionProperties() {
        ArrayList<Map> childrenProps = new ArrayList<Map>(this.children.length);
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == null) continue;
            childrenProps.add(this.children[i].getDescriptionProperties());
        }
        return childrenProps;
    }

    public RelationalNodeStatistics getNodeStatistics() {
        return this.nodeStatistics;
    }

    public void setEstimateNodeCardinality(Number estimateNodeCardinality) {
        this.estimateNodeCardinality = estimateNodeCardinality;
    }

    public void setEstimateNodeSetSize(Number setSizeEstimate) {
        this.setSizeEstimate = setSizeEstimate;
    }

    public void setEstimateDepAccessCardinality(Number depAccessEstimate) {
        this.depAccessEstimate = depAccessEstimate;
    }

    public void setEstimateDepJoinCost(Number estimateDepJoinCost) {
        this.estimateDepJoinCost = estimateDepJoinCost;
    }

    public void setEstimateJoinCost(Number estimateJoinCost) {
        this.estimateJoinCost = estimateJoinCost;
    }

    private List getCostEstimates() {
        ArrayList<String> costEstimates = new ArrayList<String>();
        if (this.estimateNodeCardinality != null) {
            costEstimates.add("Estimated Node Cardinality: " + this.estimateNodeCardinality);
        }
        if (this.setSizeEstimate != null) {
            costEstimates.add("Estimated Independent Node Produced Set Size: " + this.setSizeEstimate);
        }
        if (this.depAccessEstimate != null) {
            costEstimates.add("Estimated Dependent Access Cardinality: " + this.depAccessEstimate);
        }
        if (this.estimateDepJoinCost != null) {
            costEstimates.add("Estimated Dependent Join Cost: " + this.estimateDepJoinCost);
        }
        if (this.estimateJoinCost != null) {
            costEstimates.add("Estimated Join Cost: " + this.estimateJoinCost);
        }
        if (costEstimates.size() <= 0) {
            return null;
        }
        return costEstimates;
    }

    public Number getEstimateNodeCardinality() {
        return this.estimateNodeCardinality;
    }
}

