/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.salesforce.connection.impl;

import com.metamatrix.connector.salesforce.execution.DataPayload;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.QueryOptions;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.SessionHeader;
import com.sforce.soap.partner.SforceServiceLocator;
import com.sforce.soap.partner.SoapBindingStub;
import com.sforce.soap.partner.fault.ApiFault;
import com.sforce.soap.partner.fault.InvalidQueryLocatorFault;
import com.sforce.soap.partner.fault.UnexpectedErrorFault;
import com.sforce.soap.partner.sobject.SObject;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.rpc.ServiceException;

public class ConnectionImpl {
    private SoapBindingStub binding;
    private ConnectorLogger logger;
    private long prevTime;
    private long pingInterval;

    public ConnectionImpl(String username, String password, URL url, long pingInterval, ConnectorLogger logger, int timeout) throws ConnectorException {
        this.pingInterval = pingInterval;
        this.logger = logger;
        this.login(username, password, url, timeout);
        this.prevTime = System.currentTimeMillis();
    }

    String getUserName() throws ConnectorException {
        try {
            return this.binding.getUserInfo().getUserName();
        }
        catch (UnexpectedErrorFault e) {
            throw new ConnectorException(e.getExceptionMessage());
        }
        catch (RemoteException e) {
            throw new ConnectorException(e.getCause().getMessage());
        }
    }

    SoapBindingStub getBinding() {
        return this.binding;
    }

    private void login(String username, String password, URL url, int timeout) throws ConnectorException {
        if (!this.isAlive()) {
            LoginResult loginResult = null;
            this.binding = null;
            try {
                this.binding = null != url ? (SoapBindingStub)new SforceServiceLocator().getSoap(url) : (SoapBindingStub)new SforceServiceLocator().getSoap();
                this.binding.setTimeout(timeout);
                loginResult = this.binding.login(username, password);
            }
            catch (ApiFault ex) {
                throw new ConnectorException(ex.getExceptionMessage());
            }
            catch (RemoteException e) {
                throw new ConnectorException(e.getCause().getMessage());
            }
            catch (ServiceException e) {
                throw new ConnectorException(e.getCause().getMessage());
            }
            this.logger.logTrace("Login was successful for username " + username);
            this.binding._setProperty("javax.xml.rpc.service.endpoint.address", (Object)loginResult.getServerUrl());
            SessionHeader sh = new SessionHeader();
            sh.setSessionId(loginResult.getSessionId());
            this.binding.setHeader(new SforceServiceLocator().getServiceName().getNamespaceURI(), "SessionHeader", (Object)sh);
            try {
                this.binding.getUserInfo();
            }
            catch (UnexpectedErrorFault e) {
                throw new ConnectorException(e.getExceptionMessage());
            }
            catch (RemoteException e) {
                throw new ConnectorException(e.getCause().getMessage());
            }
        }
    }

    public boolean isAlive() {
        boolean result = true;
        if (null != this.binding) {
            try {
                long currentTime = System.currentTimeMillis();
                if ((currentTime - this.prevTime) / 1000L > this.pingInterval) {
                    this.prevTime = currentTime;
                    this.binding.getServerTimestamp();
                }
            }
            catch (UnexpectedErrorFault e) {
                result = false;
            }
            catch (RemoteException e) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    public QueryResult query(String queryString, int batchSize) throws ConnectorException {
        QueryResult qr = null;
        QueryOptions qo = new QueryOptions();
        qo.setBatchSize(new Integer(batchSize));
        this.binding.setHeader(new SforceServiceLocator().getServiceName().getNamespaceURI(), "QueryOptions", (Object)qo);
        try {
            qr = this.binding.query(queryString);
        }
        catch (ApiFault ex) {
            throw new ConnectorException(ex.getExceptionMessage());
        }
        catch (RemoteException ex) {
            throw new ConnectorException((Throwable)ex, ex.getMessage());
        }
        return qr;
    }

    public QueryResult queryMore(String queryLocator) throws ConnectorException {
        try {
            return this.binding.queryMore(queryLocator);
        }
        catch (InvalidQueryLocatorFault e) {
            throw new ConnectorException(e.getMessage());
        }
        catch (UnexpectedErrorFault e) {
            throw new ConnectorException(e.getMessage());
        }
        catch (ApiFault e) {
            throw new ConnectorException(e.getMessage());
        }
        catch (RemoteException e) {
            throw new ConnectorException(e.getCause());
        }
    }

    public int delete(String[] ids) throws ConnectorException {
        DeleteResult[] results = null;
        try {
            results = this.binding.delete(ids);
        }
        catch (UnexpectedErrorFault e) {
            throw new ConnectorException(e.getExceptionMessage());
        }
        catch (RemoteException e) {
            throw new ConnectorException(e.getCause());
        }
        boolean allGood = true;
        StringBuffer errorMessages = new StringBuffer();
        for (int i = 0; i < results.length; ++i) {
            Error[] errors;
            DeleteResult result = results[i];
            if (result.isSuccess()) continue;
            if (allGood) {
                errorMessages.append("Error(s) executing DELETE: ");
                allGood = false;
            }
            if (null == (errors = result.getErrors()) || errors.length <= 0) continue;
            for (int x = 0; x < errors.length; ++x) {
                Error error = errors[x];
                errorMessages.append(error.getMessage()).append(';');
            }
        }
        if (!allGood) {
            throw new ConnectorException(errorMessages.toString());
        }
        return results.length;
    }

    public int create(DataPayload data) throws ConnectorException {
        SaveResult[] result;
        SObject toCreate = new SObject();
        toCreate.setType(data.getType());
        toCreate.set_any(data.getMessageElements());
        SObject[] create = new SObject[]{toCreate};
        try {
            result = this.binding.create(create);
        }
        catch (ApiFault e) {
            String message = e.getExceptionMessage();
            throw new ConnectorException((Throwable)e, message);
        }
        catch (RemoteException e) {
            throw new ConnectorException(e.getCause());
        }
        return this.analyzeResult(result);
    }

    public int update(List updateDataList) throws ConnectorException {
        SaveResult[] result;
        SObject[] params = new SObject[updateDataList.size()];
        for (int i = 0; i < updateDataList.size(); ++i) {
            DataPayload data = (DataPayload)updateDataList.get(i);
            SObject toCreate = new SObject();
            toCreate.setType(data.getType());
            toCreate.setId(data.getID());
            toCreate.set_any(data.getMessageElements());
            params[i] = toCreate;
        }
        try {
            result = this.binding.update(params);
        }
        catch (ApiFault e) {
            String message = e.getExceptionMessage();
            throw new ConnectorException((Throwable)e, message);
        }
        catch (RemoteException e) {
            throw new ConnectorException(e.getCause());
        }
        return this.analyzeResult(result);
    }

    private int analyzeResult(SaveResult[] results) throws ConnectorException {
        for (int i = 0; i < results.length; ++i) {
            SaveResult result = results[i];
            if (result.isSuccess()) continue;
            throw new ConnectorException(result.getErrors()[0].getMessage());
        }
        return results.length;
    }
}

