/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.schema.tools.model.schema.impl;

import com.metamatrix.modeler.schema.tools.model.jdbc.Column;
import com.metamatrix.modeler.schema.tools.model.jdbc.DataType;
import com.metamatrix.modeler.schema.tools.model.jdbc.internal.SoapDataTypeImpl;
import com.metamatrix.modeler.schema.tools.model.schema.Column;
import com.metamatrix.modeler.schema.tools.model.schema.ComplexSchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.ISchemaModelCopyTraversalContext;
import com.metamatrix.modeler.schema.tools.model.schema.RootElement;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObjectKey;
import com.metamatrix.modeler.schema.tools.model.schema.impl.BaseSchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.impl.RootElementImpl;
import com.metamatrix.modeler.schema.tools.model.schema.impl.TypeDefinitionKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;

public class SOAPArrayDefinition
extends BaseSchemaObject
implements ComplexSchemaObject {
    XSDTypeDefinition arrayType;

    public SOAPArrayDefinition(XSDTypeDefinition type, XSDTypeDefinition arrayType, String namespacePrefix, XSDSchema schema) {
        super(namespacePrefix, type, schema);
        this.arrayType = arrayType;
        this.doesNotHaveUniqueName = false;
        this.schema = schema;
    }

    public SchemaObject copy(ISchemaModelCopyTraversalContext ctx) {
        return new SOAPArrayDefinition(this.type, this.arrayType, this.getNamespacePrefix(), this.schema);
    }

    public String getSimpleName() {
        String uniqueName;
        String elemName = this.type.getName();
        if (this.doesNotHaveUniqueName) {
            String typeName = this.type.getAliasName();
            uniqueName = elemName + '(' + typeName + ')';
        } else {
            uniqueName = elemName;
        }
        return uniqueName;
    }

    public XSDTypeDefinition getType() {
        return this.arrayType;
    }

    public String getElementTypeNamespace() {
        return this.type.getTargetNamespace();
    }

    public String getName() {
        return "/*";
    }

    public String getNamespace() {
        return this.type.getTargetNamespace();
    }

    public RootElement getRootRepresentation() {
        return new RootElementImpl(this.getKey(), this.getSimpleName(), this.getNamespace(), true);
    }

    public String getCatalog() {
        return null;
    }

    public int getMinOccurs() {
        return 0;
    }

    public int getMaxOccurs() {
        return -1;
    }

    public SchemaObjectKey getKey() {
        return new TypeDefinitionKey(this.type);
    }

    public XSDSchema getSchema() {
        return this.schema;
    }

    public boolean hasComplexTypeDefinition() {
        return this.arrayType instanceof XSDComplexTypeDefinition;
    }

    public boolean hasSimpleTypeDefinition() {
        return this.arrayType instanceof XSDSimpleTypeDefinition;
    }

    public List getAttributeList() {
        EList result = this.arrayType instanceof XSDComplexTypeDefinition ? ((XSDComplexTypeDefinition)this.arrayType).getAttributeUses() : new ArrayList();
        return result;
    }

    public XSDComplexTypeContent getContent() {
        XSDComplexTypeContent result = null;
        if (this.arrayType instanceof XSDComplexTypeDefinition) {
            result = ((XSDComplexTypeDefinition)this.arrayType).getContent();
        }
        return result;
    }

    public String toString() {
        return this.getName() + "(" + this.getNamespace() + ")";
    }

    public String getRelativeXpath() {
        return "";
    }

    public static boolean isSOAPArray(XSDTypeDefinition type) {
        boolean isSoapArray = false;
        if (type instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)type;
            isSoapArray = complexType.getBaseTypeDefinition().getURI().equals("http://schemas.xmlsoap.org/soap/encoding/#Array");
        }
        return isSoapArray;
    }

    public static XSDTypeDefinition getSOAPArrayType(XSDTypeDefinition type) {
        XSDComplexTypeDefinition complexType;
        XSDTypeDefinition soapArrayElement = null;
        if (type instanceof XSDComplexTypeDefinition && (complexType = (XSDComplexTypeDefinition)type).isSetDerivationMethod()) {
            soapArrayElement = SOAPArrayDefinition.getSOAPEncodingArrayItemType(complexType);
        }
        return soapArrayElement;
    }

    protected static XSDTypeDefinition getSOAPEncodingArrayItemType(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        if (xsdComplexTypeDefinition.getBaseTypeDefinition().getURI().equals("http://schemas.xmlsoap.org/soap/encoding/#Array")) {
            Iterator attributeContents = xsdComplexTypeDefinition.getAttributeContents().iterator();
            while (attributeContents.hasNext()) {
                String arrayType;
                int index;
                XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)attributeContents.next();
                Element attributeElement = xsdAttributeUse.getElement();
                if (attributeElement == null || !attributeElement.hasAttributeNS("http://schemas.xmlsoap.org/wsdl/", "arrayType") || (index = (arrayType = attributeElement.getAttributeNS("http://schemas.xmlsoap.org/wsdl/", "arrayType")).indexOf("[")) == -1) continue;
                String arrayTypeURI = XSDConstants.lookupQName((Element)attributeElement, (String)arrayType.substring(0, index));
                XSDTypeDefinition itemTypeDefinition = xsdAttributeUse.resolveTypeDefinitionURI(arrayTypeURI);
                return itemTypeDefinition;
            }
        }
        return null;
    }

    public List getAllModelColumns() {
        ArrayList<com.metamatrix.modeler.schema.tools.model.jdbc.Column> columns = new ArrayList<com.metamatrix.modeler.schema.tools.model.jdbc.Column>();
        Iterator iter = this.attributes.iterator();
        while (iter.hasNext()) {
            DataType datatype = this.getDataType();
            Column column = (Column)iter.next();
            com.metamatrix.modeler.schema.tools.model.jdbc.Column col = column.getColumnImplementation();
            col.setDataType(datatype);
            col.setMultipleValues(Column.MultipleValues.COMPLEX_SOAP_ARRAY_ELEMENT);
            columns.add(col);
        }
        return columns;
    }

    private DataType getDataType() {
        return new SoapDataTypeImpl(this.arrayType.getName(), this.arrayType.getTargetNamespace(), this.getSimpleName(), this.getNamespace());
    }
}

