/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.resolver.util;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.Transform;
import com.metamatrix.common.types.TransformationException;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.function.FunctionDescriptor;
import com.metamatrix.query.function.FunctionLibrary;
import com.metamatrix.query.function.FunctionLibraryManager;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.resolver.util.AccessPattern;
import com.metamatrix.query.resolver.util.ResolveGroupsVisitor;
import com.metamatrix.query.resolver.util.ResolverVisitor;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.symbol.AbstractCaseExpression;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.ScalarSubquery;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ResolverUtil {
    private ResolverUtil() {
    }

    public static String getCommonType(String[] typeNames) {
        int i;
        if (typeNames == null || typeNames.length == 0) {
            return null;
        }
        if (typeNames.length == 1) {
            return typeNames[0];
        }
        LinkedHashSet<String> commonConversions = new LinkedHashSet<String>();
        commonConversions.add(typeNames[0]);
        commonConversions.addAll(DataTypeManager.getImplicitConversions((String)typeNames[0]));
        for (i = 1; i < typeNames.length; ++i) {
            LinkedHashSet<String> conversions = new LinkedHashSet<String>(DataTypeManager.getImplicitConversions((String)typeNames[i]));
            conversions.add(typeNames[i]);
            commonConversions.retainAll(conversions);
        }
        if (commonConversions.isEmpty()) {
            return null;
        }
        for (i = 0; i < typeNames.length; ++i) {
            if (!commonConversions.contains(typeNames[i])) continue;
            return typeNames[i];
        }
        return (String)commonConversions.iterator().next();
    }

    public static boolean canImplicitlyConvert(String fromType, String toType) {
        if (fromType.equals(toType)) {
            return true;
        }
        return DataTypeManager.isImplicitConversion((String)fromType, (String)toType);
    }

    public static Expression convertExpression(Expression sourceExpression, String targetTypeName) throws QueryResolverException {
        return ResolverUtil.convertExpression(sourceExpression, DataTypeManager.getDataTypeName((Class)sourceExpression.getType()), targetTypeName);
    }

    public static Expression convertExpression(Expression sourceExpression, String sourceTypeName, String targetTypeName) throws QueryResolverException {
        if (sourceTypeName.equals(targetTypeName)) {
            return sourceExpression;
        }
        if (ResolverUtil.canImplicitlyConvert(sourceTypeName, targetTypeName) || sourceExpression instanceof Constant && ResolverUtil.canConvertConstant(sourceTypeName, targetTypeName, (Constant)sourceExpression)) {
            return ResolverUtil.getConversion(sourceExpression, sourceTypeName, targetTypeName);
        }
        throw new QueryResolverException("ERR.015.008.0041", QueryPlugin.Util.getString("ERR.015.008.0041", new Object[]{targetTypeName, sourceExpression, sourceTypeName}));
    }

    private static boolean canConvertConstant(String sourceTypeName, String targetTypeName, Constant constant) throws QueryResolverException {
        if (DataTypeManager.isTransformable((String)sourceTypeName, (String)targetTypeName)) {
            Constant reverse;
            Constant result = ResolverUtil.getProperlyTypedConstant(constant.getValue(), DataTypeManager.getDataTypeClass((String)targetTypeName));
            if ("string".equals(sourceTypeName)) {
                return true;
            }
            if (DataTypeManager.isTransformable((String)targetTypeName, (String)sourceTypeName) && constant.equals((Object)(reverse = ResolverUtil.getProperlyTypedConstant(result.getValue(), constant.getType())))) {
                return true;
            }
        }
        return false;
    }

    private static Expression getConversion(Expression sourceExpression, String sourceTypeName, String targetTypeName) {
        Class srcType = DataTypeManager.getDataTypeClass((String)sourceTypeName);
        FunctionLibrary library = FunctionLibraryManager.getFunctionLibrary();
        FunctionDescriptor fd = library.findFunction("convert", new Class[]{srcType, DataTypeManager.DefaultDataClasses.STRING});
        Function conversion = new Function(fd.getName(), new Expression[]{sourceExpression, new Constant((Object)targetTypeName)});
        conversion.setType(DataTypeManager.getDataTypeClass((String)targetTypeName));
        conversion.setFunctionDescriptor(fd);
        conversion.makeImplicit();
        return conversion;
    }

    public static void setTypeIfReference(Expression expression, Class targetType) throws QueryResolverException {
        if (expression.getType() == null) {
            if (expression instanceof Reference && targetType != null) {
                Constant dummy = new Constant(null, targetType);
                ((Reference)expression).setExpression((Expression)dummy);
            } else {
                throw new QueryResolverException("ERR.015.008.0026", QueryPlugin.Util.getString("ERR.015.008.0026", (Object)expression));
            }
        }
    }

    public static void resolveOrderBy(OrderBy orderBy, List fromClauseGroups, List knownElements, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, MetaMatrixComponentException {
        String[] knownShortNames = null;
        ArrayList<SingleElementSymbol> newElements = new ArrayList<SingleElementSymbol>();
        List elements = orderBy.getVariables();
        Iterator elementIter = elements.iterator();
        while (elementIter.hasNext()) {
            int elementOrder;
            Object knownSymbol;
            int i;
            ElementSymbol symbol = (ElementSymbol)elementIter.next();
            SingleElementSymbol matchedSymbol = null;
            String symbolName = symbol.getName();
            String groupPart = metadata.getGroupName(symbolName);
            String shortName = symbol.getShortName();
            if (fromClauseGroups.isEmpty() && groupPart != null && !shortName.equals(symbolName)) {
                throw new QueryResolverException("ERR.015.008.0043", QueryPlugin.Util.getString("ERR.015.008.0043", (Object)symbolName));
            }
            if (knownShortNames == null) {
                knownShortNames = new String[knownElements.size()];
                for (i = 0; i < knownElements.size(); ++i) {
                    knownSymbol = (SingleElementSymbol)knownElements.get(i);
                    if (knownSymbol instanceof ExpressionSymbol) continue;
                    String name = knownSymbol.getShortName();
                    if (knownSymbol instanceof ElementSymbol && knownSymbol.getShortName().equalsIgnoreCase(knownSymbol.getName())) {
                        name = metadata.getShortElementName(metadata.getFullName(((ElementSymbol)knownSymbol).getMetadataID()));
                    }
                    knownShortNames[i] = name;
                }
            }
            for (i = 0; i < knownShortNames.length; ++i) {
                if (!shortName.equalsIgnoreCase(knownShortNames[i])) continue;
                if (groupPart != null && (knownSymbol = knownElements.get(i)) instanceof ElementSymbol) {
                    ElementSymbol knownElement = (ElementSymbol)knownSymbol;
                    GroupSymbol group = knownElement.getGroupSymbol();
                    if (!ResolverUtil.nameMatchesGroup(groupPart.toUpperCase(), group.getCanonicalName())) continue;
                }
                if (matchedSymbol != null) {
                    throw new QueryResolverException("ERR.015.008.0042", QueryPlugin.Util.getString("ERR.015.008.0042", (Object)symbolName));
                }
                matchedSymbol = (SingleElementSymbol)knownElements.get(i);
            }
            if (matchedSymbol == null && StringUtil.isDigits((String)symbolName) && (elementOrder = Integer.valueOf(symbolName).intValue()) <= knownElements.size() && elementOrder > 0) {
                matchedSymbol = (SingleElementSymbol)knownElements.get(elementOrder - 1);
            }
            if (matchedSymbol == null) {
                try {
                    ResolverVisitor.resolveLanguageObject((LanguageObject)symbol, (Collection)fromClauseGroups, (QueryMetadataInterface)metadata);
                }
                catch (QueryResolverException e) {
                    throw new QueryResolverException((Throwable)e, "ERR.015.008.0043", QueryPlugin.Util.getString("ERR.015.008.0043", (Object)symbol.getName()));
                }
                matchedSymbol = ResolverUtil.findMatchingElementByID(symbol, knownElements);
            }
            newElements.add(matchedSymbol);
            symbol.setMetadataID((Object)new TempMetadataID(symbol.getName(), matchedSymbol.getType()));
            symbol.setType(matchedSymbol.getType());
        }
        orderBy.setResolvedVariables(newElements);
    }

    private static SingleElementSymbol findMatchingElementByID(ElementSymbol symbol, List knownElements) throws QueryResolverException {
        Object elementID = symbol.getMetadataID();
        if (elementID == null) {
            throw new QueryResolverException("ERR.015.008.0043", QueryPlugin.Util.getString("ERR.015.008.0043", (Object)symbol.getName()));
        }
        Object groupID = symbol.getGroupSymbol().getMetadataID();
        for (int i = 0; i < knownElements.size(); ++i) {
            Object knownGroupID;
            ElementSymbol knownElement;
            Object knownElementID;
            Object knownSymbol = knownElements.get(i);
            if (knownSymbol instanceof AliasSymbol) {
                knownSymbol = ((AliasSymbol)knownSymbol).getSymbol();
            }
            if (!(knownSymbol instanceof ElementSymbol) || !elementID.equals(knownElementID = (knownElement = (ElementSymbol)knownSymbol).getMetadataID()) || !groupID.equals(knownGroupID = knownElement.getGroupSymbol().getMetadataID())) continue;
            return knownElement;
        }
        throw new QueryResolverException("ERR.015.008.0043", QueryPlugin.Util.getString("ERR.015.008.0043", (Object)symbol.getName()));
    }

    public static Expression getDefault(ElementSymbol symbol, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException, QueryResolverException {
        Object mid = symbol.getMetadataID();
        Class type = symbol.getType();
        String name = symbol.getCanonicalName();
        Object defaultValue = metadata.getDefaultValue(mid);
        if (defaultValue == null && !metadata.elementSupports(mid, 4)) {
            throw new QueryResolverException(QueryPlugin.Util.getString("ResolverUtil.required_param", (Object)name));
        }
        return ResolverUtil.getProperlyTypedConstant(defaultValue, type);
    }

    /*
     * WARNING - void declaration
     */
    private static Constant getProperlyTypedConstant(Object defaultValue, Class parameterType) throws QueryResolverException {
        void var3_3;
        Object newValue;
        if (defaultValue == null) {
            return new Constant(null, parameterType);
        }
        Transform transform = DataTypeManager.getTransform(defaultValue.getClass(), (Class)parameterType);
        if (transform == null) {
            newValue = defaultValue;
        } else {
            try {
                newValue = transform.transform(defaultValue);
            }
            catch (TransformationException e) {
                throw new QueryResolverException((Throwable)e, QueryPlugin.Util.getString("ExecResolver.param_default_value_type", defaultValue, defaultValue.getClass(), (Object)parameterType));
            }
        }
        return new Constant((Object)var3_3, parameterType);
    }

    public static List resolveElementsInGroup(GroupSymbol group, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        if (group.getResolvedElements() == null) {
            List elementIDs = metadata.getElementIDsInGroupID(group.getMetadataID());
            if (elementIDs == null) {
                throw new QueryResolverException("ERR.015.008.0044", QueryPlugin.Util.getString("ERR.015.008.0044", (Object)group));
            }
            group.setResolvedElements(ResolverUtil.resolveElements(group, metadata, elementIDs));
        }
        return group.getResolvedElements();
    }

    public static List resolveElements(GroupSymbol group, QueryMetadataInterface metadata, List elementIDs) throws MetaMatrixComponentException, QueryMetadataException {
        boolean groupIsAliased;
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        Iterator elementIter = elementIDs.iterator();
        boolean bl = groupIsAliased = group.getDefinition() != null;
        while (elementIter.hasNext()) {
            String elementName;
            Object elementID = elementIter.next();
            String fullName = elementName = metadata.getFullName(elementID);
            if (groupIsAliased) {
                String shortName = metadata.getShortElementName(elementName);
                fullName = metadata.getFullElementName(group.getName(), shortName);
            }
            ElementSymbol element = new ElementSymbol(fullName);
            element.setGroupSymbol(group);
            element.setMetadataID(elementID);
            element.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(element.getMetadataID())));
            elements.add(element);
        }
        return elements;
    }

    public static List getAccessPatternElementsInGroups(QueryMetadataInterface metadata, Collection groups, boolean flatten) throws MetaMatrixComponentException, QueryMetadataException {
        ArrayList<AccessPattern> accessPatterns = null;
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            GroupSymbol group = (GroupSymbol)i.next();
            Collection accessPatternIDs = metadata.getAccessPatternsInGroup(group.getMetadataID());
            if (accessPatternIDs == null || accessPatternIDs.size() <= 0) continue;
            Iterator j = accessPatternIDs.iterator();
            if (accessPatterns == null) {
                accessPatterns = new ArrayList<AccessPattern>();
            }
            while (j.hasNext()) {
                List elements = metadata.getElementIDsInAccessPattern(j.next());
                elements = ResolverUtil.resolveElements(group, metadata, elements);
                if (flatten) {
                    accessPatterns.addAll(elements);
                    continue;
                }
                accessPatterns.add(new AccessPattern((Collection)elements));
            }
        }
        return accessPatterns;
    }

    public static void resolveLimit(Limit limit) throws QueryResolverException {
        if (limit.getOffset() != null) {
            ResolverUtil.setTypeIfReference(limit.getOffset(), DataTypeManager.DefaultDataClasses.INTEGER);
        }
        ResolverUtil.setTypeIfReference(limit.getRowLimit(), DataTypeManager.DefaultDataClasses.INTEGER);
    }

    public static List getElementSybmolsFromGroups(Set groups, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        Iterator groupsIterator = groups.iterator();
        HashSet elementSymbols = new HashSet();
        while (groupsIterator.hasNext()) {
            GroupSymbol group = (GroupSymbol)groupsIterator.next();
            elementSymbols.addAll(ResolverUtil.resolveElementsInGroup(group, metadata));
        }
        return new ArrayList(elementSymbols);
    }

    public static void resolveImplicitTempGroup(TempMetadataAdapter metadata, GroupSymbol symbol, List symbols) throws MetaMatrixComponentException, QueryResolverException {
        if (symbol.isImplicitTempGroupSymbol()) {
            if (metadata.getMetadataStore().getTempElementElementIDs(symbol.getCanonicalName()) == null) {
                ResolverUtil.addTempTable(metadata, symbol, symbols);
            }
            ResolveGroupsVisitor.resolveGroups((LanguageObject)symbol, (QueryMetadataInterface)metadata);
        }
    }

    public static void addTempTable(TempMetadataAdapter metadata, GroupSymbol symbol, List symbols) throws QueryResolverException {
        HashSet<String> names = new HashSet<String>();
        Iterator i = symbols.iterator();
        while (i.hasNext()) {
            SingleElementSymbol ses = (SingleElementSymbol)i.next();
            if (names.add(ses.getShortCanonicalName())) continue;
            throw new QueryResolverException(QueryPlugin.Util.getString("ResolverUtil.duplicateName", (Object)symbol, (Object)ses));
        }
        ResolverUtil.resolveNullLiterals(symbols);
        TempMetadataStore store = metadata.getMetadataStore();
        store.addTempGroup(symbol.getName(), symbols, false, true);
    }

    public static void resolveNullLiterals(List symbols) {
        for (int i = 0; i < symbols.size(); ++i) {
            ElementSymbol elementSymbol;
            Class elementType;
            SingleElementSymbol symbol;
            SelectSymbol selectSymbol = (SelectSymbol)symbols.get(i);
            if (!(selectSymbol instanceof SingleElementSymbol) || !DataTypeManager.DefaultDataClasses.NULL.equals((symbol = (SingleElementSymbol)selectSymbol).getType())) continue;
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
            }
            Class replacement = DataTypeManager.DefaultDataClasses.STRING;
            if (symbol instanceof ExpressionSymbol && !(symbol instanceof AggregateSymbol)) {
                ExpressionSymbol exprSymbol = (ExpressionSymbol)symbol;
                Expression expr = exprSymbol.getExpression();
                if (expr instanceof Constant) {
                    exprSymbol.setExpression((Expression)new Constant(null, replacement));
                    continue;
                }
                if (expr instanceof AbstractCaseExpression) {
                    ((AbstractCaseExpression)expr).setType(replacement);
                    continue;
                }
                if (!(expr instanceof ScalarSubquery)) continue;
                ((ScalarSubquery)expr).setType(replacement);
                continue;
            }
            if (!(symbol instanceof ElementSymbol) || (elementType = (elementSymbol = (ElementSymbol)symbol).getType()) == null || !elementType.equals(DataTypeManager.DefaultDataClasses.NULL)) continue;
            elementSymbol.setType(replacement);
        }
    }

    public static List findMatchingGroups(String groupContext, Collection groups, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException {
        if (groups == null) {
            return null;
        }
        LinkedList matchedGroups = new LinkedList();
        if (groupContext == null) {
            matchedGroups.addAll(groups);
        } else {
            Iterator iter = groups.iterator();
            while (iter.hasNext()) {
                String actualVdbName;
                String fullName;
                GroupSymbol group = (GroupSymbol)iter.next();
                if (!(ResolverUtil.nameMatchesGroup(groupContext, matchedGroups, group, fullName = group.getCanonicalName()) ? groupContext.length() == fullName.length() : !(group.getMetadataID() instanceof TempMetadataID) && (actualVdbName = metadata.getVirtualDatabaseName()) != null && ResolverUtil.nameMatchesGroup(groupContext, matchedGroups, group, fullName = actualVdbName.toUpperCase() + "." + fullName) && groupContext.length() == fullName.length())) continue;
                return matchedGroups;
            }
        }
        return matchedGroups;
    }

    private static boolean nameMatchesGroup(String groupContext, String fullName) {
        int matchIndex;
        return fullName.endsWith(groupContext) && ((matchIndex = fullName.length() - groupContext.length()) == 0 || fullName.charAt(matchIndex - 1) == '.');
    }

    private static boolean nameMatchesGroup(String groupContext, LinkedList matchedGroups, GroupSymbol group, String fullName) {
        if (ResolverUtil.nameMatchesGroup(groupContext, fullName)) {
            matchedGroups.add(group);
            return true;
        }
        return false;
    }

    public static Function getConversion(String srcTypeName, String tgtTypeName, Expression expression) {
        Class srcType = DataTypeManager.getDataTypeClass((String)srcTypeName);
        FunctionLibrary library = FunctionLibraryManager.getFunctionLibrary();
        FunctionDescriptor fd = library.findFunction("convert", new Class[]{srcType, DataTypeManager.DefaultDataClasses.STRING});
        Function conversion = new Function(fd.getName(), new Expression[]{expression, new Constant((Object)tgtTypeName)});
        conversion.setType(DataTypeManager.getDataTypeClass((String)tgtTypeName));
        conversion.setFunctionDescriptor(fd);
        conversion.makeImplicit();
        return conversion;
    }

    public static boolean autoConvertCheck(String type1, String type2) {
        boolean autoConvert = false;
        if (type1.equals("integer")) {
            if (type2.equals("short") || type2.equals("byte")) {
                autoConvert = true;
            }
        } else if (type1.equals("double") && type2.equals("float")) {
            autoConvert = true;
        }
        return autoConvert;
    }

    public static void setTypeToHintIfReference(Expression expression, Class alternateType) throws QueryResolverException {
        if (expression.getType() == null && expression instanceof Reference) {
            Reference ref = (Reference)expression;
            if (ref.getTypeHint() != null) {
                ResolverUtil.setType(ref, ref.getTypeHint());
            } else if (alternateType != null) {
                ResolverUtil.setType(ref, alternateType);
            } else {
                throw new QueryResolverException("ERR.015.008.0026", QueryPlugin.Util.getString("ERR.015.008.0026", (Object)expression));
            }
        }
    }

    public static void setType(Reference ref, Class type) {
        Constant dummy = new Constant(null, type);
        ref.setExpression((Expression)dummy);
    }
}

