/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseClob;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.util.UtilDataConversions;
import com.metamatrix.util.UtilDebug;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class BaseClobInputStream
extends InputStream {
    private static String footprint = "$Revision:   3.3.1.0  $";
    private long currentPosition;
    private long dataLength;
    private BaseImplClob implClob;
    private BaseClob clob;
    BaseExceptions exceptions;
    public boolean closeImplClobOnClose;

    public BaseClobInputStream(BaseClob baseClob, BaseImplClob baseImplClob, BaseExceptions baseExceptions) throws SQLException {
        UtilDebug.assert((String)"Must supplay a BaseImplClob derivative", (baseImplClob != null ? 1 : 0) != 0);
        UtilDebug.assert((String)"Must supply an exception generator", (baseExceptions != null ? 1 : 0) != 0);
        this.clob = baseClob;
        this.currentPosition = 0L;
        this.implClob = baseImplClob;
        this.exceptions = baseExceptions;
        this.dataLength = baseImplClob.getLength();
    }

    public int read() throws IOException {
        char[] cArray = new char[1];
        if (this.currentPosition >= this.dataLength) {
            return -1;
        }
        try {
            int n;
            int n2 = this.implClob.readData(cArray, 0, this.currentPosition + 1L, 1);
            if (n2 == 0) {
                n = -1;
            } else {
                n = cArray[0];
                ++this.currentPosition;
            }
            return n;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.currentPosition >= this.dataLength) {
            return -1;
        }
        long l = this.dataLength - this.currentPosition;
        if (l < Integer.MAX_VALUE && n2 > (n3 = new Long(l).intValue())) {
            n2 = n3;
        }
        try {
            long l2 = this.currentPosition + 1L;
            char[] cArray = new char[n2];
            int n4 = this.implClob.readData(cArray, 0, l2, n2);
            UtilDataConversions.UCS2CharArrayToAsciiByteArray((char[])cArray, (int)0, (byte[])byArray, (int)n, (int)n4);
            this.currentPosition += (long)n4;
            return n4;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public void close() throws IOException {
        try {
            if (this.closeImplClobOnClose) {
                this.implClob.close();
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }
}

