/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.tns;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.oracle.tns.TnsAddress;
import com.metamatrix.jdbc.oracle.tns.TnsCID;
import com.metamatrix.jdbc.oracle.tns.TnsConnectData;
import com.metamatrix.jdbc.oracle.tns.TnsDescription;
import com.metamatrix.jdbc.oracle.tns.TnsValueInfo;
import com.metamatrix.util.UtilDebug;
import java.sql.SQLException;
import java.util.ArrayList;

public class TnsConnectDescriptor {
    private static String footprint = "$Revision:   1.1.2.0  $";
    private TnsAddress m_address;
    private TnsConnectData m_connectData;

    public TnsConnectDescriptor(BaseExceptions baseExceptions) throws SQLException {
        this.m_address = new TnsAddress(null, null);
        this.m_connectData = new TnsConnectData(null, null, null, baseExceptions);
    }

    public TnsConnectDescriptor(String string, String string2, String string3, String string4, String string5, BaseExceptions baseExceptions) throws SQLException {
        this.m_address = new TnsAddress(string, string2);
        this.m_connectData = new TnsConnectData(string3, string4, string5, baseExceptions);
    }

    public TnsConnectDescriptor(TnsConnectDescriptor tnsConnectDescriptor, String string) {
        this.m_connectData = tnsConnectDescriptor.getConnectData();
        TnsValueInfo tnsValueInfo = new TnsValueInfo(TnsValueInfo.StripParens(string));
        if (tnsValueInfo.Equals("ADDRESS")) {
            this.m_address = new TnsAddress(tnsValueInfo);
        } else if (tnsValueInfo.Equals("DESCRIPTION")) {
            TnsDescription tnsDescription = new TnsDescription(tnsValueInfo);
            ArrayList arrayList = tnsDescription.getAddressList();
            UtilDebug.assert((String)"Only one address expected in DESCRIPTION", (arrayList.size() == 1 ? 1 : 0) != 0);
            this.m_address = (TnsAddress)arrayList.get(0);
        } else {
            UtilDebug.assert((String)"Unexpected redirect connect string", (boolean)false);
        }
    }

    TnsConnectDescriptor(TnsAddress tnsAddress, TnsConnectData tnsConnectData) {
        this.m_address = tnsAddress;
        this.m_connectData = tnsConnectData;
    }

    public TnsAddress getAddress() {
        return this.m_address;
    }

    public TnsConnectData getConnectData() {
        return this.m_connectData;
    }

    public String getConnectString(TnsCID tnsCID) {
        return "(DESCRIPTION=" + this.m_address + this.m_connectData + tnsCID + ")";
    }
}

