/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentStream;
import iaik.pkcs.pkcs7.EncryptedContentInfoStream;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.pkcs.pkcs7.SignedDataStream;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.pkcs.pkcs7.d;
import iaik.utils.CryptoUtils;
import iaik.utils.EOFListener;
import iaik.utils.NotifyEOFInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SignedAndEnvelopedDataStream
extends SignedDataStream
implements d,
EOFListener,
ContentStream {
    static /* synthetic */ Class d;
    SecretKey a;
    EncryptedContentInfoStream c;
    RecipientInfo[] b;

    public void verify(PublicKey publicKey, int n2) throws SignatureException {
        if (n2 < 0 || n2 >= this.signer_infos.size()) {
            throw new SignatureException("SignerInfo does not exist. Wrong index.");
        }
        SignerInfo signerInfo = (SignerInfo)this.signer_infos.elementAt(n2);
        ASN1Type[] aSN1TypeArray = signerInfo.getAuthenticatedAttributes();
        try {
            Object object;
            byte[] byArray;
            AlgorithmID algorithmID = signerInfo.getDigestAlgorithm();
            byte[] byArray2 = this.getMessageDigest(algorithmID);
            if (aSN1TypeArray != null) {
                byArray = this.getSignedDigest(n2);
                if (!CryptoUtils.equalsBlock(byArray2, byArray)) {
                    throw new SignatureException("Signature verification error!");
                }
                object = algorithmID.getMessageDigestInstance();
                byArray2 = ((MessageDigest)object).digest(DerCoder.encode(ASN.createSetOf(aSN1TypeArray)));
            }
            object = this.c.getContentEncryptionAlgorithm();
            IvParameterSpec ivParameterSpec = new IvParameterSpec((byte[])((AlgorithmID)object).getParameter().getValue());
            Cipher cipher = ((AlgorithmID)object).getCipherInstance();
            cipher.init(2, (Key)this.a, ivParameterSpec, null);
            signerInfo.e = cipher.doFinal(signerInfo.e);
            byArray = signerInfo.getDigest(publicKey);
            if (!CryptoUtils.equalsBlock(byArray2, byArray)) {
                throw new SignatureException("Signature verification error!");
            }
        }
        catch (Exception exception) {
            throw new SignatureException("Error verifying the signature: " + exception.getMessage());
        }
    }

    public String toString(boolean bl) {
        int n2;
        AlgorithmID[] algorithmIDArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version + "\n");
        if (this.b.length > 0) {
            int n3 = 0;
            while (n3 < this.b.length) {
                stringBuffer.append("\nRecipientInfo " + (n3 + 1) + ":{\n");
                stringBuffer.append(this.b[n3].toString());
                stringBuffer.append("\n}");
                ++n3;
            }
        }
        if ((algorithmIDArray = ((SignedDataStream)this).a.a()).length > 0) {
            stringBuffer.append("digestAlgorithms: ");
            n2 = 0;
            while (n2 < algorithmIDArray.length) {
                stringBuffer.append(String.valueOf(algorithmIDArray[n2].getName()) + ",");
                ++n2;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nEncryptedContentInfo: {\n");
        stringBuffer.append(String.valueOf(this.c.toString()) + "}");
        stringBuffer.append("\n\n");
        if (this.certificates != null) {
            stringBuffer.append("certificates: " + this.certificates.length + "\n");
        }
        if (this.crls != null) {
            stringBuffer.append("crls: " + this.crls.length + "\n");
        }
        if (bl) {
            n2 = 1;
            Enumeration enumeration = this.signer_infos.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("signerInfo " + n2 + ": {\n");
                stringBuffer.append(String.valueOf(((SignerInfo)enumeration.nextElement()).toString(true)) + "}");
                ++n2;
            }
        } else {
            stringBuffer.append("signerInfos: " + this.signer_infos.size() + "\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        int n3 = 0;
        while (n3 < this.b.length) {
            this.b[n3].encryptKey(this.a);
            ++n3;
        }
        if (this.signer_infos == null) {
            throw new PKCSException("No SignerInfo specified!");
        }
        if (this.mode == 1) {
            try {
                this.input_stream = ((SignedDataStream)this).a.a(this.input_stream, true);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PKCSException("No implementation for hash algorithm: " + noSuchAlgorithmException.getMessage());
            }
        }
        this.c.b = this.input_stream;
        this.c.f = n2;
        SEQUENCE sEQUENCE = new SEQUENCE(true);
        try {
            ASN1Object aSN1Object;
            sEQUENCE.addComponent(new INTEGER(this.version));
            sEQUENCE.addComponent(ASN.createSetOf(this.b));
            sEQUENCE.addComponent(ASN.createSetOf(((SignedDataStream)this).a.a()));
            sEQUENCE.addComponent(this.c.toASN1Object());
            if (this.certificates != null) {
                aSN1Object = ASN.createSetOf(this.certificates);
                sEQUENCE.addComponent(new CON_SPEC(0, aSN1Object, true));
            }
            if (this.crls != null) {
                aSN1Object = ASN.createSetOf(this.crls);
                sEQUENCE.addComponent(new CON_SPEC(1, aSN1Object, true));
            }
            sEQUENCE.addComponent(ASN.createSetOf(this.signer_infos));
        }
        catch (CodingException codingException) {
            throw new PKCSException(codingException.toString());
        }
        return sEQUENCE;
    }

    public ASN1Object toASN1Object() throws PKCSException {
        return this.toASN1Object(-1);
    }

    public void setupCipher(PrivateKey privateKey, int n2) throws InvalidKeyException, NoSuchAlgorithmException, PKCSException {
        this.a = this.b[n2].decryptKey(privateKey);
        this.c.setupCipher(this.a);
        this.input_stream = this.c.getInputStream();
        this.input_stream = ((SignedDataStream)this).a.a(this.input_stream, true);
        this.input_stream = new NotifyEOFInputStream(this.input_stream);
        ((NotifyEOFInputStream)this.input_stream).addEOFListener(this);
    }

    public void setRecipientInfos(RecipientInfo[] recipientInfoArray) {
        this.b = recipientInfoArray;
    }

    public RecipientInfo[] getRecipientInfos() {
        return this.b;
    }

    public EncryptedContentInfoStream getEncryptedContentInfo() {
        return this.c;
    }

    public ObjectID getContentType() {
        return ObjectID.pkcs7_signedAndEnvelopedData;
    }

    public void decode(InputStream inputStream) throws PKCSParsingException, IOException {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        this.this_object = ((DerInputStream)inputStream).readSequence();
        this.version = this.this_object.readInteger().intValue();
        try {
            this.b = (RecipientInfo[])ASN.parseSequenceOf(DerCoder.decode(this.this_object), d != null ? d : (d = SignedDataStream.a("iaik.pkcs.pkcs7.RecipientInfo")));
            ((SignedDataStream)this).a.a((AlgorithmID[])ASN.parseSequenceOf(DerCoder.decode(this.this_object), SignedDataStream.c != null ? SignedDataStream.c : (SignedDataStream.c = SignedDataStream.a("iaik.asn1.structures.AlgorithmID"))));
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException("Error parsing recipient infos!");
        }
        this.c = new EncryptedContentInfoStream(this.this_object);
        this.content_type = this.c.getContentType();
        if (!this.c.hasContent()) {
            this.notifyEOF();
            return;
        }
    }

    public void addRecipientInfo(RecipientInfo recipientInfo) {
        if (recipientInfo == null) {
            return;
        }
        if (this.b == null) {
            this.b = new RecipientInfo[]{recipientInfo};
            return;
        }
        RecipientInfo[] recipientInfoArray = new RecipientInfo[this.b.length + 1];
        System.arraycopy(this.b, 0, recipientInfoArray, 0, this.b.length);
        recipientInfoArray[this.b.length] = recipientInfo;
        this.b = recipientInfoArray;
    }

    public SignedAndEnvelopedDataStream(InputStream inputStream, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        this();
        this.input_stream = inputStream;
        this.c = new EncryptedContentInfoStream(ObjectID.pkcs7_data, this.input_stream);
        this.a = this.c.setupCipher(algorithmID);
    }

    public SignedAndEnvelopedDataStream(InputStream inputStream) throws IOException, PKCSParsingException {
        this.decode(inputStream);
    }

    protected SignedAndEnvelopedDataStream() {
        this.version = 1;
    }
}

