/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.util;

import com.metamatrix.sequelink.util.UtilMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderToUnicodeStream
extends InputStream {
    private Reader r;
    boolean isClosed = false;
    boolean hibyte = true;
    boolean markHibyte = false;
    int i;

    public ReaderToUnicodeStream(Reader reader) {
        this.r = reader;
    }

    public int available() throws IOException {
        this.ensureOpen();
        return this.hibyte ? 0 : 1;
    }

    public synchronized void close() throws IOException {
        this.isClosed = true;
        this.r.close();
    }

    public synchronized void mark(int n) {
        this.markHibyte = this.hibyte;
        try {
            this.r.mark((n + 1) / 2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean markSupported() {
        return this.r.markSupported();
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (this.hibyte) {
            this.i = this.r.read();
            if (this.i == -1) {
                return -1;
            }
            this.hibyte = false;
            return this.i >> 8 & 0xFF;
        }
        this.hibyte = true;
        return this.i & 0xFF;
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        this.r.reset();
        this.hibyte = true;
        if (!this.markHibyte) {
            this.read();
            this.hibyte = false;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException(UtilMessage.Gen.getPrefixedMessage("err.stream.closed"));
        }
    }
}

