/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase.tds;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSCommunication;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSRequest;
import com.metamatrix.util.UtilByteOrderedDataReader;
import com.metamatrix.util.UtilByteOrderedDataWriter;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSecurityContext;
import com.metamatrix.util.UtilSecurityContextCreator;
import com.metamatrix.util.UtilSnoopIndirection;
import java.net.Socket;
import java.sql.SQLException;
import org.ietf.jgss.Oid;

public class SybaseTDSLoginRequest
extends SybaseTDSRequest {
    private static String footprint = "$Revision:   3.23.1.1  $";
    boolean usingKerberos = false;
    private String username;
    private String password;
    private String authenticationMethod;
    private byte[] sspiToken;
    private byte[] capabilityRequest = null;
    private byte[] capabilityResponse = null;
    public int majorServerVersion;
    public int minorServerVersion;
    UtilSecurityContext securityContext;
    public BaseExceptions exceptions;

    public SybaseTDSLoginRequest(SybaseTDSCommunication sybaseTDSCommunication, UtilByteOrderedDataReader utilByteOrderedDataReader, UtilByteOrderedDataWriter utilByteOrderedDataWriter, String string, String string2, String string3, String string4, BaseExceptions baseExceptions) throws SQLException {
        super(sybaseTDSCommunication, utilByteOrderedDataReader, utilByteOrderedDataWriter, 2);
        this.username = string;
        this.password = string2;
        this.authenticationMethod = string3;
        this.exceptions = baseExceptions;
        try {
            this.securityContext = this.createSecurityContext(string3, string4);
        }
        catch (SQLException sQLException) {
            throw this.exceptions.getException((Exception)sQLException);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void submitRequest() throws SQLException {
        try {
            this.clearReplyChannel();
            this.comm.setMessageType(this.messageType);
            this.setupLoginRecord();
            this.setupCapabilitiesToken();
            if (this.securityContext != null) {
                this.setupTDSMessage();
            }
            this.writer.send();
            this.reader.receive();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    private void setupTDSMessage() throws UtilException {
        this.sspiToken = this.securityContext.getSecurityToken(null);
        Oid oid = null;
        try {
            oid = new Oid("1.2.840.113554.1.2.2");
            this.writer.writeInt8(101);
            this.writer.writeInt8(3);
            this.writer.writeInt8(1);
            this.writer.writeInt16(11);
            this.writer.writeInt8(-20);
            int n = 3 + oid.toString().length() + this.sspiToken.length + 1;
            this.writer.writeInt16(50);
            this.writer.writeInt16(5);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt32(0);
            this.writer.writeInt8(38);
            this.writer.writeInt8(4);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt32(0);
            this.writer.writeInt8(38);
            this.writer.writeInt8(4);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt32(0);
            this.writer.writeInt8(37);
            this.writer.writeInt8(255);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt32(0);
            this.writer.writeInt8(-31);
            this.writer.writeInt32(Integer.MAX_VALUE);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt32(0);
            this.writer.writeInt8(38);
            this.writer.writeInt8(4);
            this.writer.writeInt8(0);
            this.writer.writeInt8(-41);
            this.writer.writeInt8(4);
            this.writer.writeInt32(50);
            this.writer.writeInt8(4);
            this.writer.writeInt32(1);
            byte[] byArray = new byte[]{6, 10, 43, 6, 1, 4, 1, -121, 1, 4, 6, 6};
            this.writer.writeInt8(byArray.length);
            this.writer.writeBytes(byArray);
            this.writer.writeInt32(this.sspiToken.length);
            this.writer.writeBytes(this.sspiToken);
            this.writer.writeInt8(4);
            this.writer.writeInt32(2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setupLoginRecord() throws UtilException {
        int n = 0;
        String string = "";
        this.writer.writeString(string);
        this.writer.writeFillerBytes((byte)0, 30 - string.length());
        this.writer.writeInt8(string.length());
        if (this.comm.debugWireProtocol) {
            UtilSnoopIndirection.doNotLogBytesInSendStream((Socket)this.comm.socket, (int)this.comm.bufferedConsumer.getPosition(), (int)62, (String)"User Name & Password Omitted Here");
        }
        n = this.writer.writeString(this.username);
        this.writer.writeFillerBytes((byte)0, 30 - n);
        this.writer.writeInt8(this.username.length());
        n = this.writer.writeString(this.password);
        this.writer.writeFillerBytes((byte)0, 30 - n);
        this.writer.writeInt8(this.password.length());
        String string2 = "0000016a";
        n = this.writer.writeString(string2);
        this.writer.writeFillerBytes((byte)0, 30 - n);
        this.writer.writeInt8(string2.length());
        this.writer.writeInt8(2);
        this.writer.writeInt8(0);
        this.writer.writeInt8(6);
        this.writer.writeInt8(4);
        this.writer.writeInt8(8);
        this.writer.writeInt8(1);
        this.writer.writeInt8(0);
        this.writer.writeInt8(0);
        this.writer.writeInt8(0);
        this.writer.writeFillerBytes((byte)0, 4);
        this.writer.writeFillerBytes((byte)0, 3);
        String string3 = "";
        this.writer.writeString(string3);
        this.writer.writeFillerBytes((byte)0, 30 - string3.length());
        this.writer.writeInt8(string3.length());
        String string4 = "";
        this.writer.writeString(string4);
        this.writer.writeFillerBytes((byte)0, 30 - string4.length());
        this.writer.writeInt8(string4.length());
        this.writer.writeFillerBytes((byte)0, 255);
        this.writer.writeInt8(0);
        byte[] byArray = new byte[]{5, 1, 0, 0};
        this.writer.writeBytes(byArray, 0, 4);
        String string5 = "JDBC";
        n = this.writer.writeString(string5);
        this.writer.writeFillerBytes((byte)0, 10 - n);
        this.writer.writeInt8(string5.length());
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        this.writer.writeBytes(byArray);
        this.writer.writeInt8(0);
        this.writer.writeInt8(12);
        this.writer.writeInt8(16);
        this.writer.writeFillerBytes((byte)0, 30);
        this.writer.writeInt8(0);
        this.writer.writeInt8(1);
        this.writer.writeFillerBytes((byte)0, 2);
        if (this.usingKerberos) {
            this.writer.writeInt8(16);
        } else {
            this.writer.writeInt8(0);
        }
        this.writer.writeInt8(0);
        this.writer.writeInt8(1);
        this.writer.writeFillerBytes((byte)0, 6);
        this.writer.writeFillerBytes((byte)0, 2);
        this.writer.writeFillerBytes((byte)0, 30);
        this.writer.writeInt8(0);
        this.writer.writeInt8(0);
        String string6 = "512";
        if (this.comm.packetSize > 0) {
            string6 = new Integer(this.comm.packetSize).toString();
        }
        n = this.writer.writeString(string6);
        this.writer.writeFillerBytes((byte)0, 6 - n);
        this.writer.writeInt8(string6.length());
        this.writer.writeFillerBytes((byte)0, 4);
    }

    private void setupCapabilitiesToken() throws UtilException {
        this.writer.writeInt8(-30);
        this.capabilityRequest = new byte[11];
        this.writer.writeInt16(13);
        this.writer.writeInt8(1);
        this.writer.writeInt8(11);
        this.setCapabilitiesBit(39, true);
        this.setCapabilitiesBit(40, true);
        this.setCapabilitiesBit(37, true);
        this.setCapabilitiesBit(36, true);
        this.setCapabilitiesBit(33, true);
        this.setCapabilitiesBit(34, true);
        this.setCapabilitiesBit(35, true);
        this.setCapabilitiesBit(24, true);
        this.setCapabilitiesBit(27, true);
        this.setCapabilitiesBit(19, true);
        this.setCapabilitiesBit(18, true);
        this.setCapabilitiesBit(71, true);
        this.setCapabilitiesBit(72, true);
        this.setCapabilitiesBit(13, true);
        this.setCapabilitiesBit(66, true);
        this.setCapabilitiesBit(4, true);
        this.setCapabilitiesBit(9, true);
        this.setCapabilitiesBit(59, true);
        this.setCapabilitiesBit(80, true);
        this.setCapabilitiesBit(61, true);
        this.setCapabilitiesBit(62, true);
        this.setCapabilitiesBit(63, true);
        this.setCapabilitiesBit(64, true);
        this.setCapabilitiesBit(51, true);
        this.setCapabilitiesBit(83, true);
        if (this.comm.packetSize == 0) {
            this.setCapabilitiesBit(79, true);
        }
        this.writer.writeBytes(this.capabilityRequest);
    }

    void doLoginSecurityNegotiation(BaseWarnings baseWarnings) throws SQLException {
        try {
            int n;
            byte by = (byte)this.reader.readUnsignedInt8();
            if (by != 101) {
                String[] stringArray = new String[]{"Token " + this.getNameForTokenType(by) + " not expected."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            short s = this.reader.readUnsignedInt8();
            short s2 = this.reader.readUnsignedInt8();
            int n2 = this.reader.readUnsignedInt16();
            if (n2 != 11) {
                String[] stringArray = new String[]{"Type " + n2 + " not supported."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            if (s2 != 1) {
                String[] stringArray = new String[]{"No parameters in TDS_MSG token."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            by = (byte)this.reader.readUnsignedInt8();
            if (by != -20) {
                String[] stringArray = new String[]{"Token " + this.getNameForTokenType(by) + " not expected."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            short s3 = this.reader.readInt16();
            int n3 = this.reader.readInt16();
            if (n3 != 5) {
                String[] stringArray = new String[]{n3 + " is an unexpected number of parameters."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            for (n = 0; n < n3; ++n) {
                this.reader.readInt8();
                this.reader.readInt8();
                this.reader.readInt32();
                if (this.reader.readInt8() == -31) {
                    this.reader.readInt32();
                } else {
                    this.reader.readInt8();
                }
                this.reader.readInt8();
            }
            by = (byte)this.reader.readUnsignedInt8();
            if (by != -41) {
                String[] stringArray = new String[]{"Token " + this.getNameForTokenType(by) + " not expected."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            this.reader.readInt8();
            n = this.reader.readInt32();
            this.reader.readInt8();
            int n4 = this.reader.readInt32();
            byte[] byArray = new byte[this.reader.readInt8()];
            this.reader.readBytes(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[this.reader.readInt32()];
            this.reader.readBytes(byArray2, 0, byArray2.length);
            boolean bl = true;
            if (bl) {
                this.sspiToken = this.securityContext.getSecurityToken(byArray2);
            }
            this.reader.readInt8();
            int n5 = this.reader.readInt32();
            if (this.reader.readInt8() == -3) {
                this.reader.readAndDiscardBytes(8);
            }
            this.clearReplyChannel();
            this.writer.writeInt8(101);
            this.writer.writeInt8(3);
            this.writer.writeInt8(1);
            this.writer.writeInt16(11);
            this.writer.writeInt8(-20);
            this.writer.writeInt16(50);
            this.writer.writeInt16(5);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt32(0);
            this.writer.writeInt8(38);
            this.writer.writeInt8(4);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt32(0);
            this.writer.writeInt8(38);
            this.writer.writeInt8(4);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt32(0);
            this.writer.writeInt8(37);
            this.writer.writeInt8(255);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt32(0);
            this.writer.writeInt8(-31);
            this.writer.writeInt32(Integer.MAX_VALUE);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt32(0);
            this.writer.writeInt8(38);
            this.writer.writeInt8(4);
            this.writer.writeInt8(0);
            this.writer.writeInt8(-41);
            this.writer.writeInt8(4);
            this.writer.writeInt32(50);
            this.writer.writeInt8(4);
            this.writer.writeInt32(1);
            this.writer.writeInt8(byArray.length);
            this.writer.writeBytes(byArray);
            this.writer.writeInt32(0);
            this.writer.writeInt8(4);
            if (bl) {
                this.writer.writeInt32(2);
            } else {
                this.writer.writeInt32(1);
            }
            this.writer.send();
            this.reader.receive();
            this.processReply(baseWarnings);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    void doLoginNegotiation(BaseWarnings baseWarnings) throws SQLException {
        try {
            byte by = (byte)this.reader.readUnsignedInt8();
            if (by != 101) {
                String[] stringArray = new String[]{"Token " + this.getNameForTokenType(by) + " not expected."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            short s = this.reader.readUnsignedInt8();
            short s2 = this.reader.readUnsignedInt8();
            int n = this.reader.readUnsignedInt16();
            if (n != 12) {
                String[] stringArray = new String[]{"Type " + n + " not supported."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            if (s2 != 1) {
                String[] stringArray = new String[]{"No parameters in TDS_MSG token."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            by = (byte)this.reader.readUnsignedInt8();
            if (by != -20) {
                String[] stringArray = new String[]{"Token " + this.getNameForTokenType(by) + " not expected."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            short s3 = this.reader.readInt16();
            short s4 = this.reader.readInt16();
            if (s4 != 1) {
                String[] stringArray = new String[]{s4 + " is an unexpected number of parameters."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            byte[] byArray = new byte[s3 - 2];
            this.reader.readBytes(byArray, 0, s3 - 2);
            int n2 = 6 + byArray[0];
            if (byArray[n2] != 37) {
                String[] stringArray = new String[]{"Parameter type is not TDS_VARBINARY."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            by = (byte)this.reader.readUnsignedInt8();
            if (by != -41) {
                String[] stringArray = new String[]{"Token " + this.getNameForTokenType(by) + " not expected."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            byte by2 = this.reader.readInt8();
            byte[] byArray2 = new byte[by2];
            this.reader.readBytes(byArray2, 0, (int)by2);
            by = (byte)this.reader.readUnsignedInt8();
            if (by != -3) {
                String[] stringArray = new String[]{"Token " + this.getNameForTokenType(by) + " not expected."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            this.reader.readAndDiscardBytes(8);
            this.clearReplyChannel();
            this.comm.setMessageType(15);
            this.writer.writeInt8(101);
            this.writer.writeInt8((int)s);
            this.writer.writeInt8((int)s2);
            this.writer.writeInt16(n);
            this.writer.writeInt8(-20);
            this.writer.writeInt16((int)s3);
            this.writer.writeInt16((int)s4);
            this.writer.writeBytes(byArray, 0, s3 - 2);
            this.writer.writeInt8(-41);
            this.writer.writeInt8((int)by2);
            this.writer.writeBytes(byArray2, 0, (int)by2);
            this.writer.send();
            this.reader.receive();
            this.processReply(baseWarnings);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processReplyToken(byte by, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (by) {
                case -3: 
                case -2: 
                case -1: {
                    int n = this.reader.readUnsignedInt16();
                    int n2 = this.reader.readUnsignedInt16();
                    int n3 = this.reader.readInt32();
                    if ((n & 2) != 0) {
                        throw this.comm.exceptions.getException(7003);
                    }
                    break;
                }
                case -30: {
                    short s;
                    short s2;
                    int n = this.reader.readUnsignedInt16();
                    if (n > 0) {
                        s2 = this.reader.readUnsignedInt8();
                        s = this.reader.readUnsignedInt8();
                        if (s2 == 1) {
                            this.reader.readBytes(this.capabilityRequest, 0, (int)s);
                        } else {
                            this.reader.readBytes(this.capabilityResponse, 0, (int)s);
                        }
                        n -= 2 + s;
                    }
                    if (n > 0) {
                        s2 = this.reader.readUnsignedInt8();
                        s = this.reader.readUnsignedInt8();
                        if (s2 == 1) {
                            this.reader.readBytes(this.capabilityRequest, 0, (int)s);
                            break;
                        }
                        this.reader.readBytes(this.capabilityResponse, 0, (int)s);
                    }
                    break;
                }
                case -83: {
                    int n = this.reader.readUnsignedInt16();
                    byte by2 = this.reader.readInt8();
                    if ((by2 & 0x7F) == 6) {
                        try {
                            this.reader.readAndDiscardBytes(4);
                            this.reader.readAndDiscardBytes(this.reader.readInt8() + 4);
                            super.processReplyToken(this.reader.readInt8(), baseWarnings);
                        }
                        catch (SQLException sQLException) {
                            if (sQLException.getErrorCode() == 4002) {
                                this.exception = this.comm.exceptions.getException(7029);
                            }
                            this.exception = this.comm.exceptions.getException(sQLException, 0, 7029);
                            return (boolean)this.exception;
                        }
                        finally {
                            throw this.exception;
                        }
                    }
                    byte[] byArray = new byte[4];
                    this.reader.readBytes(byArray, 0, 4);
                    String string = this.reader.readString((int)this.reader.readInt8());
                    this.majorServerVersion = this.reader.readInt8();
                    this.minorServerVersion = this.reader.readInt8();
                    this.reader.readInt16();
                    if (by2 == 7) {
                        this.doLoginNegotiation(baseWarnings);
                    }
                    if (by2 == -121) {
                        this.doLoginSecurityNegotiation(baseWarnings);
                    }
                    break;
                }
                default: {
                    super.processReplyToken(by, baseWarnings);
                    break;
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
        return true;
    }

    protected void setCapabilitiesBit(int n, boolean bl) {
        byte by;
        byte[] byArray;
        int n2;
        if (bl) {
            n2 = 11 - n / 8 - 1;
            byArray = this.capabilityRequest;
        } else {
            n2 = 8 - n / 8 - 1;
            byArray = this.capabilityResponse;
        }
        int n3 = n % 8;
        byArray[n2] = by = (byte)(byArray[n2] | 1 << n3);
    }

    public boolean getCapabilitiesBit(int n, boolean bl) {
        byte[] byArray;
        int n2;
        if (bl) {
            n2 = 11 - n / 8 - 1;
            byArray = this.capabilityRequest;
        } else {
            n2 = 8 - n / 8 - 1;
            byArray = this.capabilityResponse;
        }
        int n3 = n % 8;
        byte by = byArray[n2];
        byte by2 = (byte)(1 << n3);
        return (by & by2) != 0;
    }

    private UtilSecurityContext createSecurityContext(String string, String string2) throws UtilException, SQLException {
        if (string2 == null || string2.equalsIgnoreCase("")) {
            string2 = this.comm.connection.getConnectProperties().get("servername");
        }
        if (string.equalsIgnoreCase("NTLM")) {
            throw this.exceptions.getException(7028);
        }
        if (string.equalsIgnoreCase("Kerberos")) {
            this.usingKerberos = true;
            this.username = "";
            return UtilSecurityContextCreator.createType4SecurityContext((String)string2);
        }
        if (this.username != null && this.username.length() > 0) {
            return null;
        }
        throw this.exceptions.getException(7027);
    }
}

