/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink.parameters;

import com.metamatrix.jdbc.sequelink.parameters.SequeLinkParameter;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.sequelink.ctxt.stmt.StatementContext;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.sequelink.ssp.SspOutputStream;
import com.metamatrix.slutil.UtilException;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;

public class SequeLinkTimestampParameter
extends SequeLinkParameter {
    public SequeLinkTimestampParameter(StatementContext statementContext, int n, int n2, BaseExceptions baseExceptions) throws SQLException {
        super(statementContext, n, 93, 0, n2, baseExceptions);
        this.baseDataType = 13;
    }

    protected void setBindInfo() {
        this.sqlnkType = 10;
        this.sqlnkSize = 11;
    }

    protected void convertDataIn() throws SQLException {
        Timestamp timestamp = this.bdIn.getTimestamp(this.exceptions);
        this.bdIn.setTimestamp(timestamp);
    }

    protected void writeToStream(SspOutputStream sspOutputStream) throws IOException, UtilException {
        Timestamp timestamp = this.bdIn.getTimestampNoConvert();
        sspOutputStream.writeSSPInt16(timestamp.getYear() + 1900);
        sspOutputStream.writeSSPInt8(timestamp.getMonth() + 1);
        sspOutputStream.writeSSPInt8(timestamp.getDate());
        sspOutputStream.writeSSPInt8(timestamp.getHours());
        sspOutputStream.writeSSPInt8(timestamp.getMinutes());
        sspOutputStream.writeSSPInt8(timestamp.getSeconds());
        sspOutputStream.writeSSPFullInt32(timestamp.getNanos());
    }

    protected void readFromStream(SspInputStream sspInputStream) throws IOException, UtilException {
        this.bdOut.setTimestamp(new Timestamp(sspInputStream.readSSPInt16() - 1900, sspInputStream.readSSPInt8() - 1, sspInputStream.readSSPInt8(), sspInputStream.readSSPInt8(), sspInputStream.readSSPInt8(), sspInputStream.readSSPInt8(), sspInputStream.readSSPFullInt32()));
    }
}

