/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseImplDatabaseMetaData;
import com.metamatrix.jdbc.base.BaseResultSetFilterDescriptor;
import com.metamatrix.jdbc.base.BaseResultSetSortDescriptor;
import com.metamatrix.jdbc.base.BaseTableTypes;
import com.metamatrix.jdbc.base.BaseTypeInfo;
import com.metamatrix.jdbc.base.BaseTypeInfos;
import com.metamatrix.jdbc.sqlserver.SQLServerImplConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSExecuteRequest;
import com.metamatrix.util.UtilDebug;
import java.sql.SQLException;

public final class SQLServerImplDatabaseMetaData
extends BaseImplDatabaseMetaData {
    private static String footprint = "$Revision:   3.43.1.0  $";
    BaseConnectionProperties connectionProps;
    public static final int DBMS_NAME = 1;
    public static final int DBMS_VER = 2;
    public static final int OWNER_TERM = 10;
    public static final int TABLE_TERM = 11;
    public static final int MAX_OWNER_NAME_LENGTH = 12;
    public static final int TABLE_LENGTH = 13;
    public static final int MAX_QUAL_LENGTH = 14;
    public static final int COLUMN_LENGTH = 15;
    public static final int IDENTIFIER_CASE = 16;
    public static final int TX_ISOLATION = 17;
    public static final int COLLATION_SEQ = 18;
    public static final int SAVEPOINT_SUPPORT = 19;
    public static final int MULTI_RESULT_SETS = 20;
    public static final int ACCESSIBLE_TABLES = 22;
    public static final int USERID_LENGTH = 100;
    public static final int QUALIFIER_TERM = 101;
    public static final int NAMED_TRANSACTIONS = 102;
    public static final int SPROC_AS_LANGUAGE = 103;
    public static final int ACCESSIBLE_SPROC = 104;
    public static final int MAX_INDEX_COLS = 105;
    public static final int RENAME_TABLE = 106;
    public static final int RENAME_COLUMN = 107;
    public static final int DROP_COLUMN = 108;
    public static final int INCREASE_COLUMN_LENGTH = 109;
    public static final int DDL_IN_TRANSACTION = 110;
    public static final int DESCENDING_INDEXES = 111;
    public static final int SP_RENAME = 112;
    public static final int REMOTE_SPROC = 113;
    public static final int SYS_SPROC_VERSION = 500;
    static final Integer IntegerZero = new Integer(0);
    private static final String[] typesForTDS_07000000 = new String[]{"bit", "tinyint", "tinyint identity", "image", "varbinary", "binary", "timestamp", "text", "ntext", "char", "nchar", "uniqueidentifier", "numeric", "numeric() identity", "decimal", "money", "smallmoney", "decimal() identity", "int", "int identity", "smallint", "smallint identity", "float", "real", "varchar", "nvarchar", "sysname", "datetime", "smalldatetime"};
    private static final String[] typesForTDS_07010000_2000 = new String[]{"bit", "tinyint", "tinyint identity", "bigint", "bigint identity", "image", "varbinary", "binary", "timestamp", "text", "ntext", "char", "nchar", "uniqueidentifier", "numeric", "numeric() identity", "decimal", "money", "smallmoney", "decimal() identity", "int", "int identity", "smallint", "smallint identity", "float", "real", "varchar", "nvarchar", "sysname", "sql_variant", "datetime", "smalldatetime"};
    private static final String[] typesForTDS_07010000_2005 = new String[]{"bit", "tinyint", "tinyint identity", "bigint", "bigint identity", "varbinary(max)", "image", "varbinary", "binary", "timestamp", "varchar(max)", "nvarchar(max)", "text", "ntext", "xml", "char", "nchar", "uniqueidentifier", "numeric", "numeric() identity", "decimal", "money", "smallmoney", "decimal() identity", "int", "int identity", "smallint", "smallint identity", "float", "real", "varchar", "nvarchar", "sysname", "sql_variant", "datetime", "smalldatetime"};
    private static final String[] typesForTDS_72090002_2005_xmlAsBinary = new String[]{"bit", "tinyint", "tinyint identity", "bigint", "bigint identity", "varbinary(max)", "image", "xml", "varbinary", "binary", "timestamp", "varchar(max)", "nvarchar(max)", "text", "ntext", "char", "nchar", "uniqueidentifier", "numeric", "numeric() identity", "decimal", "money", "smallmoney", "decimal() identity", "int", "int identity", "smallint", "smallint identity", "float", "real", "varchar", "nvarchar", "sysname", "sql_variant", "datetime", "smalldatetime"};

    public SQLServerImplDatabaseMetaData(BaseConnectionProperties baseConnectionProperties) throws SQLException {
        this.connectionProps = baseConnectionProperties;
    }

    public void setup(BaseConnection baseConnection) throws SQLException {
        super.setup(baseConnection);
        SQLServerImplConnection sQLServerImplConnection = (SQLServerImplConnection)this.getImplConnection();
        this.isReadOnly = Boolean.FALSE;
        this.nullsAreSortedHigh = Boolean.FALSE;
        this.nullsAreSortedLow = Boolean.TRUE;
        this.nullsAreSortedAtStart = Boolean.FALSE;
        this.nullsAreSortedAtEnd = Boolean.FALSE;
        this.nullPlusNonNullIsNull = Boolean.TRUE;
        this.storesUpperCaseIdentifiers = Boolean.FALSE;
        this.storesLowerCaseIdentifiers = Boolean.FALSE;
        this.storesUpperCaseQuotedIdentifiers = Boolean.FALSE;
        this.storesLowerCaseQuotedIdentifiers = Boolean.FALSE;
        this.identifierQuoteString = "\"";
        this.SQLKeywords = "backup,break,browse,bulk,checkpoint,clustered,compute,contains,containstable,database,dbcc,deny,disk,distributed,dummy,dump,errlvl,exit,file,fillfactor,freetext,freetexttable,function,holdlock,identity_insert,identitycol,if,index,kill,lineno,load,nocheck,nonclustered,off,offsets,opendatasource,openquery,openrowset,openxml,over,percent,plan,print,proc,raiserror,readtext,reconfigure,replication,restore,return,rowcount,rowguidcol,rule,save,setuser,shutdown,statistics,textsize,top,tran,trigger,truncate,tsequal,updatetext,use,waitfor,while,writetext";
        this.numericFunctions = "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,radians,rand,round,sign,sin,sqrt,tan,truncate";
        this.stringFunctions = "ascii,char,concat,difference,insert,lcase,left,length,locate,ltrim,repeat,replace,right,rtrim,soundex,space,substring,ucase";
        this.systemFunctions = "database,ifnull,user";
        this.timeDateFunctions = "curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,extract,hour,minute,month,monthname,now,quarter,second,timestampadd,timestampdiff,week,year";
        this.searchStringEscape = "\\";
        this.supportsAlterTableWithAddColumn = Boolean.TRUE;
        this.supportsColumnAliasing = Boolean.TRUE;
        this.supportsTableCorrelationNames = Boolean.TRUE;
        this.supportsDifferentTableCorrelationNames = Boolean.FALSE;
        this.supportsExpressionsInOrderBy = Boolean.TRUE;
        this.supportsOrderByUnrelated = Boolean.TRUE;
        this.supportsGroupBy = Boolean.TRUE;
        this.supportsGroupByUnrelated = Boolean.TRUE;
        this.supportsGroupByBeyondSelect = Boolean.TRUE;
        this.supportsLikeEscapeClause = Boolean.TRUE;
        this.supportsMultipleOpenResults = Boolean.TRUE;
        this.supportsMultipleTransactions = Boolean.TRUE;
        this.supportsTransactionIsolationLevelReadCommited = Boolean.TRUE;
        this.supportsTransactionIsolationLevelReadUncommited = Boolean.TRUE;
        this.supportsTransactionIsolationLevelRepeatableRead = Boolean.TRUE;
        this.supportsTransactionIsolationLevelSerializable = Boolean.TRUE;
        this.supportsNonNullableColumns = Boolean.TRUE;
        this.supportsMinimumSQLGrammar = Boolean.TRUE;
        this.supportsCoreSQLGrammar = Boolean.TRUE;
        this.supportsExtendedSQLGrammar = Boolean.FALSE;
        this.supportsANSI92EntryLevelSQL = Boolean.TRUE;
        this.supportsANSI92IntermediateSQL = Boolean.FALSE;
        this.supportsANSI92FullSQL = Boolean.FALSE;
        this.supportsOuterJoins = Boolean.TRUE;
        this.supportsFullOuterJoins = Boolean.TRUE;
        this.supportsLimitedOuterJoins = Boolean.TRUE;
        this.procedureTerm = "stored procedure";
        this.isCatalogAtStart = Boolean.TRUE;
        this.catalogSeparator = ".";
        this.supportsSchemasInDataManipulation = Boolean.TRUE;
        this.supportsSchemasInProcedureCalls = Boolean.TRUE;
        this.supportsSchemasInTableDefinitions = Boolean.TRUE;
        this.supportsSchemasInIndexDefinitions = Boolean.TRUE;
        this.supportsSchemasInPrivilegeDefinitions = Boolean.TRUE;
        this.supportsCatalogsInDataManipulation = Boolean.TRUE;
        this.supportsCatalogsInProcedureCalls = Boolean.TRUE;
        this.supportsCatalogsInTableDefinitions = Boolean.TRUE;
        this.supportsCatalogsInIndexDefinitions = Boolean.TRUE;
        this.supportsCatalogsInPrivilegeDefinitions = Boolean.FALSE;
        this.supportsPositionedDelete = Boolean.FALSE;
        this.supportsPositionedUpdate = Boolean.FALSE;
        this.supportsSelectForUpdate = Boolean.FALSE;
        this.supportsStoredProcedures = Boolean.TRUE;
        this.supportsSubqueriesInComparisons = Boolean.TRUE;
        this.supportsSubqueriesInExists = Boolean.TRUE;
        this.supportsSubqueriesInIns = Boolean.TRUE;
        this.supportsSubqueriesInQuantifieds = Boolean.TRUE;
        this.supportsCorrelatedSubqueries = Boolean.TRUE;
        this.supportsUnion = Boolean.TRUE;
        this.supportsUnionAll = Boolean.TRUE;
        this.supportsOpenCursorsAcrossCommit = Boolean.FALSE;
        this.supportsOpenCursorsAcrossRollback = Boolean.FALSE;
        this.supportsGetGeneratedKeys = Boolean.TRUE;
        this.supportsNamedParameters = Boolean.TRUE;
        this.maxBinaryLiteralLength = IntegerZero;
        this.maxCharLiteralLength = IntegerZero;
        if (sQLServerImplConnection.conn.getDatabaseMajorVersion() >= 8) {
            this.maxColumnsInGroupBy = new Integer(0);
            this.maxColumnsInOrderBy = new Integer(0);
        } else {
            this.maxColumnsInGroupBy = new Integer(16);
            this.maxColumnsInOrderBy = new Integer(16);
        }
        this.maxColumnsInSelect = new Integer(4096);
        this.maxColumnsInTable = new Integer(1024);
        this.maxConnections = IntegerZero;
        this.extraNameCharacters = "$#@";
        this.maxProcedureNameLength = new Integer(128);
        this.maxCursorNameLength = new Integer(128);
        this.maxStatementLength = IntegerZero;
        this.maxIndexLength = new Integer(900);
        this.maxStatements = IntegerZero;
        this.maxTablesInSelect = new Integer(32);
        this.supportsTransactions = Boolean.TRUE;
        if (((SQLServerImplConnection)this.getImplConnection()).useServerSideUpdatableCursors) {
            this.supportsResultSetTypeScrollInsensitive = Boolean.TRUE;
            this.ownUpdatesAreVisibleScrollInsensitive = Boolean.FALSE;
            this.ownDeletesAreVisibleScrollInsensitive = Boolean.FALSE;
            this.ownInsertsAreVisibleScrollInsensitive = Boolean.FALSE;
            this.othersUpdatesAreVisibleScrollInsensitive = Boolean.FALSE;
            this.othersDeletesAreVisibleScrollInsensitive = Boolean.FALSE;
            this.othersInsertsAreVisibleScrollInsensitive = Boolean.FALSE;
            this.updatesAreDetectedScrollInsensitive = Boolean.FALSE;
            this.deletesAreDetectedScrollInsensitive = Boolean.FALSE;
            this.insertsAreDetectedScrollInsensitive = Boolean.FALSE;
            this.supportsResultSetTypeScrollSensitive = Boolean.TRUE;
            this.ownUpdatesAreVisibleScrollSensitive = Boolean.TRUE;
            this.ownDeletesAreVisibleScrollSensitive = Boolean.TRUE;
            this.ownInsertsAreVisibleScrollSensitive = Boolean.TRUE;
            this.othersUpdatesAreVisibleScrollSensitive = Boolean.TRUE;
            this.othersDeletesAreVisibleScrollSensitive = Boolean.TRUE;
            this.othersInsertsAreVisibleScrollSensitive = Boolean.FALSE;
            this.updatesAreDetectedScrollSensitive = Boolean.FALSE;
            this.deletesAreDetectedScrollSensitive = Boolean.TRUE;
            this.insertsAreDetectedScrollSensitive = Boolean.FALSE;
            this.ownUpdatesAreVisibleForwardOnly = Boolean.TRUE;
            this.ownDeletesAreVisibleForwardOnly = Boolean.TRUE;
            this.ownInsertsAreVisibleForwardOnly = Boolean.TRUE;
            this.othersUpdatesAreVisibleForwardOnly = Boolean.TRUE;
            this.othersDeletesAreVisibleForwardOnly = Boolean.TRUE;
            this.othersInsertsAreVisibleForwardOnly = Boolean.TRUE;
            this.updatesAreDetectedForwardOnly = Boolean.FALSE;
            this.deletesAreDetectedForwardOnly = Boolean.TRUE;
            this.insertsAreDetectedForwardOnly = Boolean.FALSE;
        } else {
            this.supportsResultSetTypeScrollInsensitive = Boolean.TRUE;
            this.ownUpdatesAreVisibleScrollInsensitive = Boolean.FALSE;
            this.ownDeletesAreVisibleScrollInsensitive = Boolean.FALSE;
            this.ownInsertsAreVisibleScrollInsensitive = Boolean.FALSE;
            this.othersUpdatesAreVisibleScrollInsensitive = Boolean.FALSE;
            this.othersDeletesAreVisibleScrollInsensitive = Boolean.FALSE;
            this.othersInsertsAreVisibleScrollInsensitive = Boolean.FALSE;
            this.updatesAreDetectedScrollInsensitive = Boolean.FALSE;
            this.deletesAreDetectedScrollInsensitive = Boolean.FALSE;
            this.insertsAreDetectedScrollInsensitive = Boolean.FALSE;
            this.supportsResultSetTypeScrollSensitive = Boolean.TRUE;
            this.ownUpdatesAreVisibleScrollSensitive = Boolean.FALSE;
            this.ownDeletesAreVisibleScrollSensitive = Boolean.FALSE;
            this.ownInsertsAreVisibleScrollSensitive = Boolean.FALSE;
            this.othersUpdatesAreVisibleScrollSensitive = Boolean.TRUE;
            this.othersDeletesAreVisibleScrollSensitive = Boolean.TRUE;
            this.othersInsertsAreVisibleScrollSensitive = Boolean.FALSE;
            this.updatesAreDetectedScrollSensitive = Boolean.FALSE;
            this.deletesAreDetectedScrollSensitive = Boolean.TRUE;
            this.insertsAreDetectedScrollSensitive = Boolean.FALSE;
            this.ownUpdatesAreVisibleForwardOnly = Boolean.FALSE;
            this.ownDeletesAreVisibleForwardOnly = Boolean.FALSE;
            this.ownInsertsAreVisibleForwardOnly = Boolean.FALSE;
            this.othersUpdatesAreVisibleForwardOnly = Boolean.TRUE;
            this.othersDeletesAreVisibleForwardOnly = Boolean.TRUE;
            this.othersInsertsAreVisibleForwardOnly = Boolean.TRUE;
            this.updatesAreDetectedForwardOnly = Boolean.FALSE;
            this.deletesAreDetectedForwardOnly = Boolean.FALSE;
            this.insertsAreDetectedForwardOnly = Boolean.FALSE;
        }
        this.supportsBatchUpdates = Boolean.TRUE;
        this.usesLocalFiles = Boolean.FALSE;
        this.usesLocalFilePerTable = Boolean.FALSE;
        this.supportsIntegrityEnhancementFacility = Boolean.FALSE;
        this.supportsOpenStatementsAcrossCommit = Boolean.TRUE;
        this.supportsOpenStatementsAcrossRollback = Boolean.TRUE;
        this.dataDefinitionCausesTransactionCommit = Boolean.FALSE;
        this.dataDefinitionIgnoredInTransactions = Boolean.FALSE;
        this.doesMaxRowSizeIncludeBlobs = Boolean.FALSE;
        this.maxRowSize = new Integer(8060);
        this.supportsConvert = Boolean.TRUE;
        this.supportsSavepoints = Boolean.TRUE;
    }

    void processServerInfo() throws SQLException {
        SQLServerImplConnection sQLServerImplConnection = (SQLServerImplConnection)this.getImplConnection();
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(sQLServerImplConnection.conn, sQLServerImplConnection.reader, sQLServerImplConnection.writer);
        tDSExecuteRequest.setSQL("sp_server_info");
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(1, null);
        block19: while (tDSExecuteRequest.getRow(null)) {
            tDSExecuteRequest.getColumnDataForRow(3, 10);
            int n = tDSExecuteRequest.getColumn((int)1).data.getIntegerNoConvert();
            String string = tDSExecuteRequest.getColumn((int)3).data.getStringNoConvert();
            switch (n) {
                case 1: {
                    this.databaseProductName = string;
                    continue block19;
                }
                case 2: {
                    this.databaseProductVersion = string;
                    continue block19;
                }
                case 10: {
                    this.schemaTerm = string;
                    continue block19;
                }
                case 12: {
                    this.maxSchemaNameLength = new Integer(string);
                    continue block19;
                }
                case 13: {
                    this.maxTableNameLength = new Integer(string);
                    continue block19;
                }
                case 14: {
                    this.maxCatalogNameLength = new Integer(string);
                    continue block19;
                }
                case 15: {
                    this.maxColumnNameLength = new Integer(string);
                    continue block19;
                }
                case 16: {
                    if (sQLServerImplConnection.conn.getTDSVersion() != 1) continue block19;
                    if (string.compareTo("MIXED") == 0) {
                        this.storesMixedCaseIdentifiers = Boolean.TRUE;
                        this.supportsMixedCaseIdentifiers = Boolean.FALSE;
                        this.storesMixedCaseQuotedIdentifiers = Boolean.TRUE;
                        this.supportsMixedCaseQuotedIdentifiers = Boolean.FALSE;
                        continue block19;
                    }
                    if (string.compareTo("SENSITIVE") != 0) continue block19;
                    this.storesMixedCaseIdentifiers = Boolean.FALSE;
                    this.supportsMixedCaseIdentifiers = Boolean.TRUE;
                    this.storesMixedCaseQuotedIdentifiers = Boolean.FALSE;
                    this.supportsMixedCaseQuotedIdentifiers = Boolean.TRUE;
                    continue block19;
                }
                case 20: {
                    if (string.compareTo("Y") == 0) {
                        this.supportsMultipleResultSets = Boolean.TRUE;
                        continue block19;
                    }
                    this.supportsMultipleResultSets = Boolean.FALSE;
                    continue block19;
                }
                case 101: {
                    this.catalogTerm = string;
                    continue block19;
                }
                case 105: {
                    this.maxColumnsInIndex = new Integer(string);
                    continue block19;
                }
                case 17: {
                    this.defaultTransactionIsolation = new Integer(string);
                    continue block19;
                }
                case 22: {
                    if (string.compareTo("Y") == 0) {
                        this.allTablesAreSelectable = Boolean.TRUE;
                        continue block19;
                    }
                    this.allTablesAreSelectable = Boolean.FALSE;
                    continue block19;
                }
                case 100: {
                    this.maxUserNameLength = new Integer(string);
                    continue block19;
                }
                case 104: {
                    if (string.compareTo("Y") == 0) {
                        this.allProceduresAreCallable = Boolean.TRUE;
                        continue block19;
                    }
                    this.allProceduresAreCallable = Boolean.FALSE;
                    continue block19;
                }
                case 108: {
                    if (string.compareTo("Y") == 0) {
                        this.supportsAlterTableWithDropColumn = Boolean.TRUE;
                        continue block19;
                    }
                    this.supportsAlterTableWithDropColumn = Boolean.FALSE;
                    continue block19;
                }
                case 110: {
                    if (string.compareTo("Y") == 0) {
                        this.supportsDataDefinitionAndDataManipulationTransactions = Boolean.TRUE;
                        this.supportsDataManipulationTransactionsOnly = Boolean.FALSE;
                        continue block19;
                    }
                    this.supportsDataDefinitionAndDataManipulationTransactions = Boolean.FALSE;
                    this.supportsDataManipulationTransactionsOnly = Boolean.TRUE;
                    continue block19;
                }
            }
        }
        tDSExecuteRequest.discardReplyBytes();
        if (sQLServerImplConnection.conn.getTDSVersion() > 1) {
            tDSExecuteRequest.setSQL("select convert(sysname,DatabasePropertyEx(db_name(),'Collation'))");
            tDSExecuteRequest.submitRequest(null);
            tDSExecuteRequest.processReply(1, null);
            tDSExecuteRequest.getRow(null);
            tDSExecuteRequest.getColumnDataForRow(1, 10);
            String string = tDSExecuteRequest.getColumn((int)1).data.getStringNoConvert();
            tDSExecuteRequest.discardReplyBytes();
            if (string.lastIndexOf("_CI") > 0) {
                this.storesMixedCaseIdentifiers = Boolean.TRUE;
                this.supportsMixedCaseIdentifiers = Boolean.FALSE;
                this.storesMixedCaseQuotedIdentifiers = Boolean.TRUE;
                this.supportsMixedCaseQuotedIdentifiers = Boolean.FALSE;
            } else {
                this.storesMixedCaseIdentifiers = Boolean.FALSE;
                this.supportsMixedCaseIdentifiers = Boolean.TRUE;
                this.storesMixedCaseQuotedIdentifiers = Boolean.FALSE;
                this.supportsMixedCaseQuotedIdentifiers = Boolean.TRUE;
            }
        }
        this.databaseMajorVersion = new Integer(sQLServerImplConnection.conn.getDatabaseMajorVersion());
        this.databaseMinorVersion = new Integer(sQLServerImplConnection.conn.getDatabaseMinorVersion());
    }

    void getDatabaseCursorHoldability() throws SQLException {
        SQLServerImplConnection sQLServerImplConnection = (SQLServerImplConnection)this.getImplConnection();
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(sQLServerImplConnection.conn, sQLServerImplConnection.reader, sQLServerImplConnection.writer);
        if (sQLServerImplConnection.getTDSVersion() == 1) {
            tDSExecuteRequest.setSQL("SELECT DATABASEPROPERTY(DB_NAME(), 'IsCloseCursorsOnCommitEnabled')");
        } else {
            tDSExecuteRequest.setSQL("SELECT DATABASEPROPERTYEX(DB_NAME(), 'IsCloseCursorsOnCommitEnabled')");
        }
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(1, null);
        tDSExecuteRequest.getRow(null);
        tDSExecuteRequest.getColumnDataForRow(1, 4);
        if (tDSExecuteRequest.getColumn((int)1).data.isNull) {
            throw this.exceptions.getException(7011);
        }
        int n = tDSExecuteRequest.getColumn((int)1).data.getIntegerNoConvert();
        this.resultSetHoldability = n == 1 ? new Integer(2) : new Integer(1);
        tDSExecuteRequest.discardReplyBytes();
    }

    public void initializeNonResultSetMetaData(int n) throws SQLException {
        if (n == 101) {
            return;
        }
        if (n == 151) {
            this.getDatabaseCursorHoldability();
            return;
        }
        this.processServerInfo();
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        if (n == n2) {
            return true;
        }
        switch (n) {
            case -3: 
            case -2: {
                if (n2 != 6 && n2 != 7 && n2 != -1) break;
                return false;
            }
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 91: 
            case 92: 
            case 93: {
                if (n2 != -4 && n2 != -1) break;
                return false;
            }
            case -1: {
                if (n2 == 1 || n2 == 12) break;
                return false;
            }
            case -4: {
                if (n2 == -2 || n2 == -3) break;
                return false;
            }
            case 0: 
            case 1: 
            case 12: {
                break;
            }
            case 8: 
            case 1111: {
                return false;
            }
        }
        return true;
    }

    public String getResultSetSQL(int n, BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) throws SQLException {
        String string = null;
        String string2 = ", ";
        switch (n) {
            case 1: {
                String string3 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string4 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string5 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String[] stringArray = (String[])baseResultSetFilterDescriptor.getRestriction(4);
                string = this.createCatalogQualifier(string3) + "sp_tables " + this.formatRestriction(string5, true) + string2 + this.formatRestriction(string4, true) + string2 + this.formatRestriction(string3, false) + string2;
                if (stringArray == null) {
                    string = string + "null";
                } else {
                    string = string + "\"";
                    for (int i = 0; i < stringArray.length; ++i) {
                        string = string + "'" + stringArray[i] + "'";
                        if (i == stringArray.length - 1) continue;
                        string = string + ",";
                    }
                    string = string + "\"";
                }
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 2: {
                String string6 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string7 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string8 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String string9 = (String)baseResultSetFilterDescriptor.getRestriction(4);
                string = this.createCatalogQualifier(string6) + "sp_columns " + this.formatRestriction(string8, true) + string2 + this.formatRestriction(string7, true) + string2 + this.formatRestriction(string6, false) + string2 + this.formatRestriction(string9, true) + string2 + "@ODBCVer = 3";
                break;
            }
            case 5: {
                String string10 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string11 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string12 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                string = this.createCatalogQualifier(string10) + "sp_stored_procedures " + this.formatRestriction(string12, true) + string2 + this.formatRestriction(string11, true) + string2 + this.formatRestriction(string10, false);
                break;
            }
            case 6: {
                String string13 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string14 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string15 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String string16 = (String)baseResultSetFilterDescriptor.getRestriction(4);
                string = this.createCatalogQualifier(string13) + "sp_sproc_columns " + this.formatRestriction(string15, true) + string2 + this.formatRestriction(string14, true) + string2 + this.formatRestriction(string13, false) + string2 + this.formatRestriction(string16, true) + string2 + "@ODBCVer = 3";
                break;
            }
            case 16: {
                String string17 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string18 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string19 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                string = this.createCatalogQualifier(string17) + "sp_table_privileges " + this.formatRestriction(string19, true) + string2 + this.formatRestriction(string18, true) + string2 + this.formatRestriction(string17, false);
                break;
            }
            case 9: {
                String string20 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string21 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string22 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String string23 = (String)baseResultSetFilterDescriptor.getRestriction(4);
                string = this.createCatalogQualifier(string20) + "sp_column_privileges " + this.formatRestriction(string22, false) + string2 + this.formatRestriction(string21, false) + string2 + this.formatRestriction(string20, false) + string2 + this.formatRestriction(string23, true);
                break;
            }
            case 14: {
                String string24 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string25 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string26 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                string = this.createCatalogQualifier(string24) + "sp_pkeys " + this.formatRestriction(string26, false) + string2 + this.formatRestriction(string25, false) + string2 + this.formatRestriction(string24, false);
                break;
            }
            case 11: {
                String string27 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string28 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string29 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                string = this.createCatalogQualifier(string27) + "sp_fkeys " + this.formatRestriction(string29, false) + string2 + this.formatRestriction(string28, false) + string2 + this.formatRestriction(string27, false) + string2 + "null, null, null";
                break;
            }
            case 12: {
                String string30 = (String)baseResultSetFilterDescriptor.getRestriction(5);
                String string31 = (String)baseResultSetFilterDescriptor.getRestriction(6);
                String string32 = (String)baseResultSetFilterDescriptor.getRestriction(7);
                string = this.createCatalogQualifier(string30) + "sp_fkeys null, null, null, " + this.formatRestriction(string32, false) + string2 + this.formatRestriction(string31, false) + string2 + this.formatRestriction(string30, false);
                break;
            }
            case 10: {
                String string33 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string34 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string35 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String string36 = (String)baseResultSetFilterDescriptor.getRestriction(5);
                String string37 = (String)baseResultSetFilterDescriptor.getRestriction(6);
                String string38 = (String)baseResultSetFilterDescriptor.getRestriction(7);
                string = this.createCatalogQualifier(string33) + "sp_fkeys " + this.formatRestriction(string35, false) + string2 + this.formatRestriction(string34, false) + string2 + this.formatRestriction(string33, false) + string2 + this.formatRestriction(string38, false) + string2 + this.formatRestriction(string37, false) + string2 + this.formatRestriction(string36, false);
                break;
            }
            case 13: {
                String string39 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string40 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string41 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                Boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(4);
                Boolean bl2 = (Boolean)baseResultSetFilterDescriptor.getRestriction(14);
                string = this.createCatalogQualifier(string39) + "sp_statistics " + this.formatRestriction(string41, false) + string2 + this.formatRestriction(string40, false) + string2 + this.formatRestriction(string39, false) + string2 + "N'%'" + string2 + (bl != false ? "N'Y'" : "N'N'") + string2 + (bl2 != false ? "N'Q'" : "N'E'");
                break;
            }
            case 7: {
                String string42 = (String)baseResultSetFilterDescriptor.getRestriction(9);
                String string43 = (String)baseResultSetFilterDescriptor.getRestriction(10);
                String string44 = (String)baseResultSetFilterDescriptor.getRestriction(11);
                Integer n2 = (Integer)baseResultSetFilterDescriptor.getRestriction(1);
                Boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(12);
                string = this.createCatalogQualifier(string42) + "sp_special_columns " + this.formatRestriction(string44, false) + string2 + this.formatRestriction(string43, false) + string2 + this.formatRestriction(string42, false) + string2 + "@col_type = N'R'" + string2;
                if (n2 != null) {
                    if (n2 == 0) {
                        string = string + "@scope = N'C'" + string2;
                    } else if (n2 == 1) {
                        string = string + "@scope = N'T'" + string2;
                    } else if (n2 == 2) {
                        string = string + "@scope = N'T'" + string2;
                    }
                }
                string = bl != null && bl != false ? string + "@nullable = N'U'" + string2 : string + "@nullable = N'O'" + string2;
                string = string + "@ODBCVer = 3";
                break;
            }
            case 18: {
                String string45 = (String)baseResultSetFilterDescriptor.getRestriction(9);
                String string46 = (String)baseResultSetFilterDescriptor.getRestriction(10);
                String string47 = (String)baseResultSetFilterDescriptor.getRestriction(11);
                string = this.createCatalogQualifier(string45) + "sp_special_columns " + this.formatRestriction(string47, false) + string2 + this.formatRestriction(string46, false) + string2 + this.formatRestriction(string45, false) + string2 + "N'V'" + string2 + "@ODBCVer = 3";
                break;
            }
            case 15: {
                string = "sp_tables '', '%', '', null";
                break;
            }
            case 8: {
                string = "sp_tables '', '', '%'";
            }
        }
        if (baseResultSetFilterDescriptor != null) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
        }
        return string;
    }

    public BaseTableTypes getTableTypes() {
        BaseTableTypes baseTableTypes = new BaseTableTypes();
        baseTableTypes.add("SYSTEM TABLE");
        baseTableTypes.add("TABLE");
        baseTableTypes.add("VIEW");
        return baseTableTypes;
    }

    public BaseTypeInfos getTypeInfo() throws SQLException {
        String[] stringArray;
        SQLServerImplConnection sQLServerImplConnection = (SQLServerImplConnection)this.getImplConnection();
        if (sQLServerImplConnection.conn.getTDSVersion() == 1) {
            stringArray = typesForTDS_07000000;
        } else {
            TDSConnection cfr_ignored_0 = sQLServerImplConnection.conn;
            stringArray = sQLServerImplConnection.conn.getDatabaseMajorVersion() == 9 ? (sQLServerImplConnection.xmlDescribeTypeIsChar ? typesForTDS_07010000_2005 : typesForTDS_72090002_2005_xmlAsBinary) : typesForTDS_07010000_2000;
        }
        BaseTypeInfos baseTypeInfos = new BaseTypeInfos();
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(sQLServerImplConnection.conn, sQLServerImplConnection.reader, sQLServerImplConnection.writer);
        tDSExecuteRequest.setSQL("sp_datatype_info @ODBCVer=3");
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(1, null);
        while (tDSExecuteRequest.getRow(null)) {
            BaseTypeInfo baseTypeInfo;
            tDSExecuteRequest.getColumnDataForRow(18, 4);
            String string = tDSExecuteRequest.getColumn((int)1).data.getStringNoConvert();
            if (this.isUserDefinedType(stringArray, string)) continue;
            BaseTypeInfo baseTypeInfo2 = new BaseTypeInfo();
            baseTypeInfo2.typeName = string;
            short s = tDSExecuteRequest.getColumn((int)2).data.getShort(this.exceptions);
            s = SQLServerImplDatabaseMetaData.mapODBCTypeToJDBCType(s);
            baseTypeInfo2.dataType = new Short(s);
            baseTypeInfo2.maxPrecision = (Integer)tDSExecuteRequest.getColumn((int)3).data.getObject();
            baseTypeInfo2.literalPrefix = tDSExecuteRequest.getColumn((int)4).data.getStringNoConvert();
            baseTypeInfo2.literalSuffix = tDSExecuteRequest.getColumn((int)5).data.getStringNoConvert();
            baseTypeInfo2.createParams = tDSExecuteRequest.getColumn((int)6).data.getStringNoConvert();
            baseTypeInfo2.nullable = new Short(tDSExecuteRequest.getColumn((int)7).data.getShort(this.exceptions));
            baseTypeInfo2.caseSensitive = tDSExecuteRequest.getColumn((int)8).data.isNull ? null : (tDSExecuteRequest.getColumn((int)8).data.getIntegerNoConvert() == 0 ? Boolean.FALSE : Boolean.TRUE);
            baseTypeInfo2.searchable = new Short(tDSExecuteRequest.getColumn((int)9).data.getShort(this.exceptions));
            baseTypeInfo2.unsignedAttribute = tDSExecuteRequest.getColumn((int)10).data.isNull ? null : (tDSExecuteRequest.getColumn((int)10).data.getIntegerNoConvert() == 0 ? Boolean.FALSE : Boolean.TRUE);
            baseTypeInfo2.fixedPrecScale = tDSExecuteRequest.getColumn((int)11).data.isNull ? null : (tDSExecuteRequest.getColumn((int)11).data.getIntegerNoConvert() == 0 ? Boolean.FALSE : Boolean.TRUE);
            baseTypeInfo2.autoIncrement = tDSExecuteRequest.getColumn((int)12).data.isNull ? null : (tDSExecuteRequest.getColumn((int)12).data.getIntegerNoConvert() == 0 ? Boolean.FALSE : Boolean.TRUE);
            baseTypeInfo2.localTypeName = tDSExecuteRequest.getColumn((int)13).data.getStringNoConvert();
            baseTypeInfo2.minimumScale = tDSExecuteRequest.getColumn((int)14).data.isNull ? null : new Short(tDSExecuteRequest.getColumn((int)14).data.getShort(this.exceptions));
            baseTypeInfo2.maximumScale = tDSExecuteRequest.getColumn((int)15).data.isNull ? null : new Short(tDSExecuteRequest.getColumn((int)15).data.getShort(this.exceptions));
            baseTypeInfo2.numPrecRadix = (Integer)tDSExecuteRequest.getColumn((int)18).data.getObject();
            if (baseTypeInfo2.typeName.equals("xml")) {
                if (((SQLServerImplConnection)this.getImplConnection()).xmlDescribeTypeIsChar) {
                    baseTypeInfo2.dataType = new Short(-1);
                } else {
                    baseTypeInfo2.dataType = new Short(-4);
                    baseTypeInfo2.maxPrecision = new Integer(Integer.MAX_VALUE);
                    baseTypeInfo2.literalPrefix = "0x";
                    baseTypeInfo2.literalSuffix = null;
                    baseTypeInfo2.caseSensitive = Boolean.FALSE;
                }
            }
            baseTypeInfos.add(baseTypeInfo2);
            if (stringArray != typesForTDS_07010000_2005 && stringArray != typesForTDS_72090002_2005_xmlAsBinary) continue;
            if (baseTypeInfo2.localTypeName.equals("ntext")) {
                baseTypeInfo = BaseTypeInfo.copy((BaseTypeInfo)baseTypeInfo2);
                baseTypeInfo.typeName = "nvarchar(max)";
                baseTypeInfo.localTypeName = "nvarchar(max)";
                baseTypeInfos.add(baseTypeInfo);
                continue;
            }
            if (baseTypeInfo2.localTypeName.equals("text")) {
                baseTypeInfo = BaseTypeInfo.copy((BaseTypeInfo)baseTypeInfo2);
                baseTypeInfo.typeName = "varchar(max)";
                baseTypeInfo.localTypeName = "varchar(max)";
                baseTypeInfos.add(baseTypeInfo);
                continue;
            }
            if (!baseTypeInfo2.localTypeName.equals("image")) continue;
            baseTypeInfo = BaseTypeInfo.copy((BaseTypeInfo)baseTypeInfo2);
            baseTypeInfo.typeName = "varbinary(max)";
            baseTypeInfo.localTypeName = "varbinary(max)";
            baseTypeInfos.add(baseTypeInfo);
        }
        tDSExecuteRequest.discardReplyBytes();
        this.sortTypeInfo(stringArray, baseTypeInfos);
        return baseTypeInfos;
    }

    private boolean isUserDefinedType(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public static short mapODBCTypeToJDBCType(short s) {
        switch (s) {
            case -150: {
                s = (short)12;
                break;
            }
            case -11: {
                s = 1;
                break;
            }
            case -10: {
                s = (short)-1;
                break;
            }
            case -9: {
                s = (short)12;
                break;
            }
            case -8: {
                s = 1;
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 93: {
                break;
            }
            case 0: 
            case 8: 
            case 91: 
            case 92: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                UtilDebug.assert((String)"Unexpected support for JDBC data type.", (boolean)false);
                break;
            }
            default: {
                s = (short)1111;
            }
        }
        return s;
    }

    private void sortTypeInfo(String[] stringArray, BaseTypeInfos baseTypeInfos) {
        boolean bl;
        int n = baseTypeInfos.count();
        UtilDebug.assert((String)"Unexpected type info obtained from the server.", (n == stringArray.length ? 1 : 0) != 0);
        for (int i = 0; i < n && (bl = true); ++i) {
            bl = false;
            for (int j = i; j < n; ++j) {
                Object object = baseTypeInfos.get(j);
                if (!stringArray[i].equals(object.typeName) || i == j) continue;
                object = baseTypeInfos.set(i, object);
                baseTypeInfos.set(j, object);
                bl = true;
            }
        }
    }

    private String createCatalogQualifier(String string) throws SQLException {
        String string2 = "";
        if (string != null) {
            string2 = string;
            string2 = string2 + "..";
        }
        return string2;
    }

    private String formatRestriction(String string, boolean bl) throws SQLException {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl2 = false;
        boolean bl3 = false;
        if (n >= 2) {
            if (string.charAt(0) == '[' && string.charAt(n - 1) == ']') {
                bl2 = true;
            }
            if (string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
                bl3 = true;
            }
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!bl2 && !bl3 && c == '\'') {
                stringBuffer.append("''");
                continue;
            }
            if (bl && c == '\\' && i != n - 1) {
                char c2 = string.charAt(i + 1);
                if (c2 == '_' || c2 == '%') {
                    stringBuffer.append('[');
                    stringBuffer.append(c2);
                    stringBuffer.append(']');
                    if (bl2) {
                        stringBuffer.append("]");
                    }
                } else if (c2 == '\\') {
                    stringBuffer.append(c2);
                } else {
                    stringBuffer.append(c);
                    stringBuffer.append(c2);
                }
                ++i;
                continue;
            }
            stringBuffer.append(c);
        }
        if (bl2 || bl3) {
            return stringBuffer.toString();
        }
        return "N'" + stringBuffer.toString() + "'";
    }

    protected String getUserName() throws SQLException {
        SQLServerImplConnection sQLServerImplConnection = (SQLServerImplConnection)this.getImplConnection();
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(sQLServerImplConnection.conn, sQLServerImplConnection.reader, sQLServerImplConnection.writer);
        tDSExecuteRequest.setSQL("select user_name()");
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(1, null);
        tDSExecuteRequest.getRow(null);
        tDSExecuteRequest.getColumnDataForRow(1, 10);
        String string = tDSExecuteRequest.getColumn((int)1).data.getStringNoConvert();
        tDSExecuteRequest.discardReplyBytes();
        return string;
    }

    protected boolean stripDoubleQuotesFromValues() {
        return false;
    }
}

