/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseSQLToken;

public final class BaseSQLScanner {
    public static final int TOKEN_COMMA = 1;
    public static final int TOKEN_COMMENT = 2;
    public static final int TOKEN_COMPARE_OP = 3;
    public static final int TOKEN_DELIMITED_ID = 4;
    public static final int TOKEN_DOT = 5;
    public static final int TOKEN_END_OF_SQL = 6;
    public static final int TOKEN_EQUAL = 7;
    public static final int TOKEN_HOOK = 8;
    public static final int TOKEN_ID_OR_KEYWORD = 9;
    public static final int TOKEN_LEFT_BRACE = 10;
    public static final int TOKEN_LEFT_PAREN = 11;
    public static final int TOKEN_RIGHT_BRACE = 12;
    public static final int TOKEN_RIGHT_PAREN = 13;
    public static final int TOKEN_STRING_LITERAL = 14;
    public static final int TOKEN_SEMICOLON = 15;
    public static final int TOKEN_UNKNOWN = 16;
    public static final int TOKEN_WHITESPACE = 17;
    public static final int TOKEN_COLON = 18;
    private static final int STATE_START = 1;
    private static final int STATE_MAYBE_C_CPP_COMMENT = 2;
    private static final int STATE_C_COMMENT = 3;
    private static final int STATE_MAYBE_END_OF_C_COMMENT = 4;
    private static final int STATE_MAYBE_SQL_COMMENT = 5;
    private static final int STATE_REST_OF_LINE_COMMENT = 6;
    private static final int STATE_ID_OR_KEYWORD = 7;
    private static final int STATE_DELIMITED_ID = 8;
    private static final int STATE_MAYBE_END_OF_DELMITED_ID = 9;
    private static final int STATE_STRING_LITERAL = 10;
    private static final int STATE_MAYBE_END_OF_STRING_LITERAL = 11;
    private static final int STATE_WHITESPACE = 12;
    private static final int STATE_UNKNOWN = 13;
    private static final int STATE_BUILDING_WRAPPER = 14;
    private static final int STATE_WRAPPER_CONTENTS = 15;
    private static final int STATE_COMPARE_OP = 16;
    private static final boolean[] invalidIdentifierChars = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false};
    private String sql;
    private int sqlLength;
    private static final int END_OF_TEXT = -1;
    private char stringLiteralDelimitor;
    private char[] delimitedIdentifierDelimitorsBegin;
    private char[] delimitedIdentifierDelimitorsEnd;
    private int currentDelimitedIdenitifierIndex;
    private int nextChar;
    private int currentStateID;
    private BaseSQLScannerState currentState;
    public int scanPosition = -1;
    private int lastTokenBeginPosition = -1;
    private int lastTokenEndPosition = -1;
    private BaseSQLToken nextToken;
    private BaseSQLToken cachedToken;
    private StringBuffer currentTokenValue = new StringBuffer(32);
    private BaseSQLScannerState stateStart;
    private BaseSQLScannerState stateCompareOp;
    private BaseSQLScannerState stateMaybeCOrCPPComment;
    private BaseSQLScannerState stateCComment;
    private BaseSQLScannerState stateMaybeEndOfCComment;
    private BaseSQLScannerState stateMaybeSQLComment;
    private BaseSQLScannerState stateRestOfLineComment;
    private BaseSQLScannerState stateIDOrKeyword;
    private BaseSQLScannerState stateDelimitedID;
    private BaseSQLScannerState stateMaybeEndOfDelimitedID;
    private BaseSQLScannerState stateStringLiteral;
    private BaseSQLScannerState stateMaybeEndOfStringLiteral;
    private BaseSQLScannerState stateWhiteSpace;
    private BaseSQLScannerState stateUnknown;
    private BaseSQLBuildingWrapperKeywordState stateBuildingWrapperKeyword;
    private BaseSQLScannerState stateAddingWrapperContents;

    public void setup(String string, char c, char c2) {
        this.sql = string;
        this.sqlLength = string.length();
        this.stringLiteralDelimitor = c;
        this.delimitedIdentifierDelimitorsBegin = new char[2];
        this.delimitedIdentifierDelimitorsEnd = new char[2];
        this.delimitedIdentifierDelimitorsBegin[0] = c2;
        this.delimitedIdentifierDelimitorsEnd[0] = c2;
        this.delimitedIdentifierDelimitorsBegin[1] = 91;
        this.delimitedIdentifierDelimitorsEnd[1] = 93;
        this.nextToken = null;
    }

    public String getSQL() {
        return this.sql;
    }

    public BaseSQLToken getNextToken() {
        if (this.nextToken != null && this.lastTokenBeginPosition == this.scanPosition) {
            this.scanPosition = this.lastTokenEndPosition;
            return this.nextToken;
        }
        this.lastTokenBeginPosition = this.scanPosition;
        this.nextToken = null;
        this.setNextState(1);
        while (this.nextToken == null) {
            ++this.scanPosition;
            this.nextChar = this.scanPosition < this.sqlLength ? (int)this.sql.charAt(this.scanPosition) : -1;
            this.currentState.processNextChar();
            this.lastTokenEndPosition = this.scanPosition;
        }
        return this.nextToken;
    }

    private boolean isDelimitedIdentifierBegin(int n) {
        boolean bl = false;
        if (n == this.delimitedIdentifierDelimitorsBegin[0]) {
            this.currentDelimitedIdenitifierIndex = 0;
            bl = true;
        } else if (n == this.delimitedIdentifierDelimitorsBegin[1]) {
            this.currentDelimitedIdenitifierIndex = 1;
            bl = true;
        }
        return bl;
    }

    private boolean isDelimitedIdentifierEnd(int n) {
        boolean bl = false;
        if (this.currentDelimitedIdenitifierIndex == 0 && n == this.delimitedIdentifierDelimitorsEnd[0]) {
            bl = true;
        } else if (this.currentDelimitedIdenitifierIndex == 1 && n == this.delimitedIdentifierDelimitorsEnd[1]) {
            bl = true;
        }
        return bl;
    }

    private void setNextState(int n) {
        switch (n) {
            case 1: {
                if (this.stateStart == null) {
                    this.stateStart = new BaseSQLScannerStartState();
                }
                this.currentState = this.stateStart;
                break;
            }
            case 16: {
                if (this.stateCompareOp == null) {
                    this.stateCompareOp = new BaseSQLScannerCompareOpState();
                }
                this.currentState = this.stateCompareOp;
                break;
            }
            case 2: {
                if (this.stateMaybeCOrCPPComment == null) {
                    this.stateMaybeCOrCPPComment = new BaseSQLScannerMaybeCOrCPPCommentState();
                }
                this.currentState = this.stateMaybeCOrCPPComment;
                break;
            }
            case 3: {
                if (this.stateCComment == null) {
                    this.stateCComment = new BaseSQLScannerCCommentState();
                }
                this.currentState = this.stateCComment;
                break;
            }
            case 4: {
                if (this.stateMaybeEndOfCComment == null) {
                    this.stateMaybeEndOfCComment = new BaseSQLScannerMaybeEndOfCCommentState();
                }
                this.currentState = this.stateMaybeEndOfCComment;
                break;
            }
            case 5: {
                if (this.stateMaybeSQLComment == null) {
                    this.stateMaybeSQLComment = new BaseSQLScannerMaybeSQLCommentState();
                }
                this.currentState = this.stateMaybeSQLComment;
                break;
            }
            case 6: {
                if (this.stateRestOfLineComment == null) {
                    this.stateRestOfLineComment = new BaseSQLScannerRestOfLineCommentState();
                }
                this.currentState = this.stateRestOfLineComment;
                break;
            }
            case 7: {
                if (this.stateIDOrKeyword == null) {
                    this.stateIDOrKeyword = new BaseSQLScannerIDOrKeywordState();
                }
                this.currentState = this.stateIDOrKeyword;
                break;
            }
            case 8: {
                if (this.stateDelimitedID == null) {
                    this.stateDelimitedID = new BaseSQLScannerDelimitedIDState();
                }
                this.currentState = this.stateDelimitedID;
                break;
            }
            case 9: {
                if (this.stateMaybeEndOfDelimitedID == null) {
                    this.stateMaybeEndOfDelimitedID = new BaseSQLScannerMaybeEndOfDelimitedIDState();
                }
                this.currentState = this.stateMaybeEndOfDelimitedID;
                break;
            }
            case 10: {
                if (this.stateStringLiteral == null) {
                    this.stateStringLiteral = new BaseSQLScannerStringLiteralState();
                }
                this.currentState = this.stateStringLiteral;
                break;
            }
            case 11: {
                if (this.stateMaybeEndOfStringLiteral == null) {
                    this.stateMaybeEndOfStringLiteral = new BaseSQLScannerMaybeEndOfStringLiteralState();
                }
                this.currentState = this.stateMaybeEndOfStringLiteral;
                break;
            }
            case 12: {
                if (this.stateWhiteSpace == null) {
                    this.stateWhiteSpace = new BaseSQLWhiteSpaceState();
                }
                this.currentState = this.stateWhiteSpace;
                break;
            }
            case 13: {
                if (this.stateUnknown == null) {
                    this.stateUnknown = new BaseSQLScannerUnknownState();
                }
                this.currentState = this.stateUnknown;
                break;
            }
            case 14: {
                if (this.stateBuildingWrapperKeyword == null) {
                    this.stateBuildingWrapperKeyword = new BaseSQLBuildingWrapperKeywordState();
                }
                this.stateBuildingWrapperKeyword.initialize();
                this.currentState = this.stateBuildingWrapperKeyword;
                break;
            }
            case 15: {
                if (this.stateAddingWrapperContents == null) {
                    this.stateAddingWrapperContents = new BaseSQLAddingWrapperContentsState();
                }
                this.currentState = this.stateAddingWrapperContents;
            }
        }
    }

    static boolean isValidFirstCharForIdentifierOrKeyword(int n) {
        return BaseSQLScanner.isValidCharForIdentifierOrKeyword(n) && (n < 48 || n > 57);
    }

    static boolean isValidCharForIdentifierOrKeyword(int n) {
        return n != -1 && (n >= invalidIdentifierChars.length || !invalidIdentifierChars[n]) && !BaseSQLScanner.isWhiteSpace(n);
    }

    static boolean isWhiteSpace(int n) {
        return n <= 32 && n != -1;
    }

    private boolean isNonCommentRelatedSpecialCharacter(int n) {
        return n == 63 || n == 40 || n == 41 || n == 123 || n == 125 || n == 44 || n == 46 || n == 61 || n == 62 || n == 60 || n == 59;
    }

    private void setEndOfToken(int n) {
        if (this.cachedToken == null) {
            this.cachedToken = new BaseSQLToken();
        }
        this.nextToken = this.cachedToken;
        this.nextToken.type = n;
        this.nextToken.value = this.currentTokenValue.toString();
        this.currentTokenValue.setLength(0);
    }

    private class BaseSQLAddingWrapperContentsState
    extends BaseSQLScannerState {
        private BaseSQLAddingWrapperContentsState() {
        }

        void processNextChar() {
            if (BaseSQLScanner.this.nextChar == -1) {
                BaseSQLScanner.this.setEndOfToken(9);
            } else {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
            }
        }
    }

    private class BaseSQLBuildingWrapperKeywordState
    extends BaseSQLScannerState {
        private int subState;
        private int markedPosition;
        private boolean atLeastOneNumericWasFound;

        private BaseSQLBuildingWrapperKeywordState() {
        }

        void initialize() {
            this.subState = 0;
            this.atLeastOneNumericWasFound = false;
            this.markedPosition = -1;
        }

        void processNextChar() {
            boolean bl = false;
            switch (this.subState) {
                case 0: {
                    this.markedPosition = BaseSQLScanner.this.scanPosition;
                    if (BaseSQLScanner.this.nextChar != 114) break;
                    bl = true;
                    break;
                }
                case 1: {
                    if (BaseSQLScanner.this.nextChar != 97) break;
                    bl = true;
                    break;
                }
                case 2: 
                case 3: {
                    if (BaseSQLScanner.this.nextChar != 112) break;
                    bl = true;
                    break;
                }
                case 4: {
                    if (BaseSQLScanner.this.nextChar != 101) break;
                    bl = true;
                    break;
                }
                case 5: {
                    if (BaseSQLScanner.this.nextChar != 100) break;
                    bl = true;
                    break;
                }
                case 6: {
                    if (BaseSQLScanner.this.nextChar != 32) break;
                    bl = true;
                    break;
                }
                case 7: {
                    if (BaseSQLScanner.this.nextChar == 10 || BaseSQLScanner.this.nextChar == 13) {
                        bl = true;
                    }
                    if (BaseSQLScanner.this.nextChar != 13) break;
                    --this.subState;
                    break;
                }
                case 8: {
                    if (BaseSQLScanner.this.nextChar >= 48 && BaseSQLScanner.this.nextChar <= 57) {
                        bl = true;
                        --this.subState;
                        this.atLeastOneNumericWasFound = true;
                        break;
                    }
                    if (!this.atLeastOneNumericWasFound) break;
                    ++this.subState;
                }
                case 9: {
                    if (BaseSQLScanner.this.nextChar == 10 || BaseSQLScanner.this.nextChar == 13) {
                        bl = true;
                    }
                    if (BaseSQLScanner.this.nextChar == 13) {
                        --this.subState;
                        break;
                    }
                    if (BaseSQLScanner.this.nextChar != 10) break;
                    BaseSQLScanner.this.setNextState(15);
                }
            }
            if (bl) {
                ++this.subState;
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
            } else {
                BaseSQLScanner.this.scanPosition = this.markedPosition - 1;
                BaseSQLScanner.this.currentTokenValue.delete(1, BaseSQLScanner.this.currentTokenValue.length());
                BaseSQLScanner.this.setNextState(7);
            }
        }
    }

    private class BaseSQLWhiteSpaceState
    extends BaseSQLScannerState {
        private BaseSQLWhiteSpaceState() {
        }

        void processNextChar() {
            if (BaseSQLScanner.isWhiteSpace(BaseSQLScanner.this.nextChar)) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
            } else {
                --BaseSQLScanner.this.scanPosition;
                BaseSQLScanner.this.setEndOfToken(17);
            }
        }
    }

    private class BaseSQLScannerUnknownState
    extends BaseSQLScannerState {
        private BaseSQLScannerUnknownState() {
        }

        void processNextChar() {
            if (BaseSQLScanner.this.isNonCommentRelatedSpecialCharacter(BaseSQLScanner.this.nextChar) || BaseSQLScanner.this.nextChar == BaseSQLScanner.this.stringLiteralDelimitor || BaseSQLScanner.this.isDelimitedIdentifierBegin(BaseSQLScanner.this.nextChar) || BaseSQLScanner.isValidFirstCharForIdentifierOrKeyword(BaseSQLScanner.this.nextChar) || BaseSQLScanner.isWhiteSpace(BaseSQLScanner.this.nextChar)) {
                --BaseSQLScanner.this.scanPosition;
                BaseSQLScanner.this.setEndOfToken(16);
            } else if (BaseSQLScanner.this.nextChar == -1) {
                BaseSQLScanner.this.setEndOfToken(16);
            } else {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
            }
        }
    }

    private class BaseSQLScannerMaybeEndOfStringLiteralState
    extends BaseSQLScannerState {
        private BaseSQLScannerMaybeEndOfStringLiteralState() {
        }

        void processNextChar() {
            if (BaseSQLScanner.this.nextChar == BaseSQLScanner.this.stringLiteralDelimitor) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(10);
            } else if (BaseSQLScanner.this.nextChar == -1) {
                BaseSQLScanner.this.setEndOfToken(14);
            } else {
                --BaseSQLScanner.this.scanPosition;
                BaseSQLScanner.this.setEndOfToken(14);
            }
        }
    }

    private class BaseSQLScannerStringLiteralState
    extends BaseSQLScannerState {
        private BaseSQLScannerStringLiteralState() {
        }

        void processNextChar() {
            if (BaseSQLScanner.this.nextChar == BaseSQLScanner.this.stringLiteralDelimitor) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(11);
            } else if (BaseSQLScanner.this.nextChar == -1) {
                BaseSQLScanner.this.setEndOfToken(16);
            } else {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
            }
        }
    }

    private class BaseSQLScannerMaybeEndOfDelimitedIDState
    extends BaseSQLScannerState {
        private BaseSQLScannerMaybeEndOfDelimitedIDState() {
        }

        void processNextChar() {
            if (BaseSQLScanner.this.isDelimitedIdentifierEnd(BaseSQLScanner.this.nextChar)) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(8);
            } else if (BaseSQLScanner.this.nextChar == -1) {
                BaseSQLScanner.this.setEndOfToken(4);
            } else {
                --BaseSQLScanner.this.scanPosition;
                BaseSQLScanner.this.setEndOfToken(4);
            }
        }
    }

    private class BaseSQLScannerDelimitedIDState
    extends BaseSQLScannerState {
        private BaseSQLScannerDelimitedIDState() {
        }

        void processNextChar() {
            if (BaseSQLScanner.this.isDelimitedIdentifierEnd(BaseSQLScanner.this.nextChar)) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(9);
            } else if (BaseSQLScanner.this.nextChar == -1) {
                BaseSQLScanner.this.setEndOfToken(16);
            } else {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
            }
        }
    }

    private class BaseSQLScannerIDOrKeywordState
    extends BaseSQLScannerState {
        private BaseSQLScannerIDOrKeywordState() {
        }

        void processNextChar() {
            if (BaseSQLScanner.isValidCharForIdentifierOrKeyword(BaseSQLScanner.this.nextChar)) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
            } else if (BaseSQLScanner.this.nextChar == -1) {
                BaseSQLScanner.this.setEndOfToken(9);
            } else {
                --BaseSQLScanner.this.scanPosition;
                BaseSQLScanner.this.setEndOfToken(9);
            }
        }
    }

    private class BaseSQLScannerRestOfLineCommentState
    extends BaseSQLScannerState {
        private BaseSQLScannerRestOfLineCommentState() {
        }

        void processNextChar() {
            if (BaseSQLScanner.this.nextChar == 10) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setEndOfToken(2);
            } else if (BaseSQLScanner.this.nextChar == -1) {
                BaseSQLScanner.this.setEndOfToken(2);
            } else {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
            }
        }
    }

    private class BaseSQLScannerMaybeSQLCommentState
    extends BaseSQLScannerState {
        private BaseSQLScannerMaybeSQLCommentState() {
        }

        void processNextChar() {
            if (BaseSQLScanner.this.isNonCommentRelatedSpecialCharacter(BaseSQLScanner.this.nextChar) || BaseSQLScanner.this.nextChar == BaseSQLScanner.this.stringLiteralDelimitor || BaseSQLScanner.this.isDelimitedIdentifierBegin(BaseSQLScanner.this.nextChar) || BaseSQLScanner.isValidFirstCharForIdentifierOrKeyword(BaseSQLScanner.this.nextChar) || BaseSQLScanner.isWhiteSpace(BaseSQLScanner.this.nextChar)) {
                --BaseSQLScanner.this.scanPosition;
                BaseSQLScanner.this.setEndOfToken(16);
            } else if (BaseSQLScanner.this.nextChar == -1) {
                BaseSQLScanner.this.setEndOfToken(16);
            } else if (BaseSQLScanner.this.nextChar == 45) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(6);
            } else {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(13);
            }
        }
    }

    private class BaseSQLScannerMaybeEndOfCCommentState
    extends BaseSQLScannerState {
        private BaseSQLScannerMaybeEndOfCCommentState() {
        }

        void processNextChar() {
            if (BaseSQLScanner.this.nextChar == 47) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setEndOfToken(2);
            } else if (BaseSQLScanner.this.nextChar == -1) {
                BaseSQLScanner.this.setEndOfToken(16);
            } else {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(3);
            }
        }
    }

    private class BaseSQLScannerCCommentState
    extends BaseSQLScannerState {
        private BaseSQLScannerCCommentState() {
        }

        void processNextChar() {
            if (BaseSQLScanner.this.nextChar == 42) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(4);
            } else if (BaseSQLScanner.this.nextChar == -1) {
                BaseSQLScanner.this.setEndOfToken(16);
            } else {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
            }
        }
    }

    private class BaseSQLScannerMaybeCOrCPPCommentState
    extends BaseSQLScannerState {
        private BaseSQLScannerMaybeCOrCPPCommentState() {
        }

        void processNextChar() {
            if (BaseSQLScanner.this.isNonCommentRelatedSpecialCharacter(BaseSQLScanner.this.nextChar) || BaseSQLScanner.this.nextChar == BaseSQLScanner.this.stringLiteralDelimitor || BaseSQLScanner.this.isDelimitedIdentifierBegin(BaseSQLScanner.this.nextChar) || BaseSQLScanner.isValidFirstCharForIdentifierOrKeyword(BaseSQLScanner.this.nextChar) || BaseSQLScanner.isWhiteSpace(BaseSQLScanner.this.nextChar)) {
                --BaseSQLScanner.this.scanPosition;
                BaseSQLScanner.this.setEndOfToken(16);
            } else if (BaseSQLScanner.this.nextChar == -1) {
                BaseSQLScanner.this.setEndOfToken(16);
            } else if (BaseSQLScanner.this.nextChar == 42) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(3);
            } else if (BaseSQLScanner.this.nextChar == 47) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(6);
            } else {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(13);
            }
        }
    }

    private class BaseSQLScannerCompareOpState
    extends BaseSQLScannerState {
        private BaseSQLScannerCompareOpState() {
        }

        void processNextChar() {
            if (BaseSQLScanner.this.nextChar == 60 || BaseSQLScanner.this.nextChar == 62 || BaseSQLScanner.this.nextChar == 61) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
            } else {
                --BaseSQLScanner.this.scanPosition;
            }
            BaseSQLScanner.this.setEndOfToken(3);
        }
    }

    private class BaseSQLScannerStartState
    extends BaseSQLScannerState {
        private BaseSQLScannerStartState() {
        }

        void processNextChar() {
            if (BaseSQLScanner.this.nextChar == 119) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(14);
            } else if (BaseSQLScanner.isValidFirstCharForIdentifierOrKeyword(BaseSQLScanner.this.nextChar)) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(7);
            } else if (BaseSQLScanner.isWhiteSpace(BaseSQLScanner.this.nextChar)) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(12);
            } else if (BaseSQLScanner.this.nextChar == 63) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setEndOfToken(8);
            } else if (BaseSQLScanner.this.nextChar == 40) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setEndOfToken(11);
            } else if (BaseSQLScanner.this.nextChar == 41) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setEndOfToken(13);
            } else if (BaseSQLScanner.this.nextChar == 123) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setEndOfToken(10);
            } else if (BaseSQLScanner.this.nextChar == 125) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setEndOfToken(12);
            } else if (BaseSQLScanner.this.nextChar == 44) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setEndOfToken(1);
            } else if (BaseSQLScanner.this.nextChar == 46) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setEndOfToken(5);
            } else if (BaseSQLScanner.this.nextChar == 58) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setEndOfToken(18);
            } else if (BaseSQLScanner.this.nextChar == 59) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setEndOfToken(15);
            } else if (BaseSQLScanner.this.nextChar == -1) {
                BaseSQLScanner.this.setEndOfToken(6);
            } else if (BaseSQLScanner.this.nextChar == 60) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(16);
            } else if (BaseSQLScanner.this.nextChar == 62) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(16);
            } else if (BaseSQLScanner.this.nextChar == 61) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setEndOfToken(7);
            } else if (BaseSQLScanner.this.nextChar == 47) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(2);
            } else if (BaseSQLScanner.this.nextChar == 45) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(5);
            } else if (BaseSQLScanner.this.nextChar == BaseSQLScanner.this.stringLiteralDelimitor) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(10);
            } else if (BaseSQLScanner.this.isDelimitedIdentifierBegin(BaseSQLScanner.this.nextChar)) {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(8);
            } else {
                BaseSQLScanner.this.currentTokenValue.append((char)BaseSQLScanner.this.nextChar);
                BaseSQLScanner.this.setNextState(13);
            }
        }
    }

    private abstract class BaseSQLScannerState {
        private BaseSQLScannerState() {
        }

        abstract void processNextChar();
    }
}

