/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.TTIFUNDataPacket;
import com.metamatrix.util.UtilException;
import java.net.InetAddress;
import java.sql.SQLException;

public class TTIFUN_OAUTHENTICATE
extends TTIFUNDataPacket {
    private static String footprint = "$Revision:   1.16.1.0  $";
    private String userName;
    private byte[] encryptedPassword;
    private String localhost;
    private String progName;
    private byte[] encryptionKey;
    private boolean wireCSmatchesOracleCS;
    private int loginMode;
    private boolean supportLinks;
    private String m_sessionId = null;
    private String m_serialNum = null;
    public static int LOGINMODE_REAUTHENTICATE = 1024;
    public static int LOGINMODE_SYSDBA = 32;
    public static int LOGINMODE_SYSOPER = 64;

    public TTIFUN_OAUTHENTICATE(String string, boolean bl, boolean bl2, int n) {
        this.TTCCode = 3;
        this.FUNCode = n == LOGINMODE_REAUTHENTICATE ? 115 : (string == null || string.length() <= 0 ? 115 : 118);
        this.loginMode = n | 1;
        this.supportLinks = bl2;
        this.userName = string;
        try {
            this.localhost = InetAddress.getLocalHost().toString();
        }
        catch (Exception exception) {
            this.localhost = "unknownclient";
        }
        this.progName = "JDBC Connect Client";
        this.wireCSmatchesOracleCS = bl;
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public void setSessionId(String string) {
        this.m_sessionId = string;
    }

    public String getSerialNum() {
        return this.m_serialNum;
    }

    public void setSerialNum(String string) {
        this.m_serialNum = string;
    }

    public void setEncryptedPassword(byte[] byArray) {
        this.encryptedPassword = byArray == null ? new byte[0] : byArray;
    }

    public byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    public void streamOut(OracleDataConsumer oracleDataConsumer) throws UtilException {
        byte[] byArray = null;
        if (this.userName != null) {
            byArray = oracleDataConsumer.getTransliterator().encode(this.userName);
        }
        oracleDataConsumer.writeByte((byte)1);
        oracleDataConsumer.writeB4(byArray.length);
        oracleDataConsumer.writeB4(this.loginMode);
        oracleDataConsumer.writeByte((byte)1);
        if ((this.loginMode & LOGINMODE_REAUTHENTICATE) != 0) {
            if (this.supportLinks) {
                oracleDataConsumer.writeB4(2);
            } else {
                oracleDataConsumer.writeB4(4);
            }
            oracleDataConsumer.writeByte((byte)1);
            oracleDataConsumer.writeByte((byte)1);
            if (this.wireCSmatchesOracleCS) {
                oracleDataConsumer.writeBytes(byArray, 0, byArray.length);
            } else {
                oracleDataConsumer.writeCLR(byArray, 0, byArray.length);
            }
            byte[] byArray2 = null;
            byArray2 = oracleDataConsumer.getTransliterator().encode("AUTH_SESSION_ID");
            oracleDataConsumer.writeB4(byArray2.length);
            oracleDataConsumer.writeCLR(byArray2, 0, byArray2.length);
            byArray2 = oracleDataConsumer.getTransliterator().encode(this.m_sessionId);
            oracleDataConsumer.writeB4(byArray2.length);
            oracleDataConsumer.writeCLR(byArray2, 0, byArray2.length);
            oracleDataConsumer.writeB4(0);
            byArray2 = oracleDataConsumer.getTransliterator().encode("AUTH_SERIAL_NUM");
            oracleDataConsumer.writeB4(byArray2.length);
            oracleDataConsumer.writeCLR(byArray2, 0, byArray2.length);
            byArray2 = oracleDataConsumer.getTransliterator().encode(this.m_serialNum);
            oracleDataConsumer.writeB4(byArray2.length);
            oracleDataConsumer.writeCLR(byArray2, 0, byArray2.length);
            oracleDataConsumer.writeB4(0);
            if (!this.supportLinks) {
                this.writeNameKeys(oracleDataConsumer);
            }
        } else if (this.encryptionKey != null) {
            if (this.supportLinks) {
                oracleDataConsumer.writeB4(1);
            } else {
                oracleDataConsumer.writeB4(3);
            }
            oracleDataConsumer.writeByte((byte)1);
            oracleDataConsumer.writeByte((byte)1);
            if (this.wireCSmatchesOracleCS) {
                oracleDataConsumer.writeBytes(byArray, 0, byArray.length);
            } else {
                oracleDataConsumer.writeCLR(byArray, 0, byArray.length);
            }
            byte[] byArray3 = oracleDataConsumer.getTransliterator().encode("AUTH_PASSWORD");
            oracleDataConsumer.writeB4(byArray3.length);
            oracleDataConsumer.writeCLR(byArray3, 0, byArray3.length);
            oracleDataConsumer.writeB4(this.encryptedPassword.length);
            oracleDataConsumer.writeCLR(this.encryptedPassword, 0, this.encryptedPassword.length);
            oracleDataConsumer.writeB4(0);
            if (!this.supportLinks) {
                this.writeNameKeys(oracleDataConsumer);
            }
        } else {
            oracleDataConsumer.writeB4(2);
            oracleDataConsumer.writeByte((byte)1);
            oracleDataConsumer.writeByte((byte)1);
            if (this.wireCSmatchesOracleCS) {
                oracleDataConsumer.writeBytes(byArray, 0, byArray.length);
            } else if (byArray.length > 0) {
                oracleDataConsumer.writeCLR(byArray, 0, byArray.length);
            }
            byte[] byArray4 = oracleDataConsumer.getTransliterator().encode("AUTH_PROGRAM_NM");
            oracleDataConsumer.writeB4(byArray4.length);
            oracleDataConsumer.writeCLR(byArray4, 0, byArray4.length);
            byte[] byArray5 = oracleDataConsumer.getTransliterator().encode(this.progName);
            oracleDataConsumer.writeB4(byArray5.length);
            oracleDataConsumer.writeCLR(byArray5, 0, byArray5.length);
            oracleDataConsumer.writeB4(0);
            byte[] byArray6 = oracleDataConsumer.getTransliterator().encode("AUTH_MACHINE");
            oracleDataConsumer.writeB4(byArray6.length);
            oracleDataConsumer.writeCLR(byArray6, 0, byArray6.length);
            byte[] byArray7 = oracleDataConsumer.getTransliterator().encode(this.localhost);
            oracleDataConsumer.writeB4(byArray7.length);
            oracleDataConsumer.writeCLR(byArray7, 0, byArray7.length);
            oracleDataConsumer.writeB4(0);
        }
    }

    public void streamIn(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        short s = oracleDataProvider.readB2();
        byte[][] byArrayArray = new byte[s][];
        byte[][] byArrayArray2 = new byte[s][];
        this.readKeyValuePairs(oracleDataProvider, byArrayArray, byArrayArray2, s);
        if (this.FUNCode == 118) {
            String string = oracleDataProvider.getTransliterator().decode(byArrayArray[0], 0, byArrayArray[0].length);
            if (string.equalsIgnoreCase("AUTH_SESSKEY")) {
                this.encryptionKey = byArrayArray2[0];
                this.FUNCode = 115;
                this.loginMode |= 0x101;
            }
        } else {
            for (int i = 0; i < byArrayArray.length; ++i) {
                String string = oracleDataProvider.getTransliterator().decode(byArrayArray[i], 0, byArrayArray[i].length);
                if (string.equalsIgnoreCase("AUTH_SESSION_ID")) {
                    this.m_sessionId = new String(byArrayArray2[i]);
                    continue;
                }
                if (!string.equalsIgnoreCase("AUTH_SERIAL_NUM")) continue;
                this.m_serialNum = new String(byArrayArray2[i]);
            }
        }
    }

    void writeNameKeys(OracleDataConsumer oracleDataConsumer) throws UtilException {
        byte[] byArray = oracleDataConsumer.getTransliterator().encode("AUTH_INTERNALNAME_");
        byArray[byArray.length - 1] = 0;
        oracleDataConsumer.writeB4(byArray.length);
        oracleDataConsumer.writeCLR(byArray, 0, byArray.length);
        byte[] byArray2 = oracleDataConsumer.getTransliterator().encode("jdbc_ttc_impl");
        oracleDataConsumer.writeB4(byArray2.length);
        oracleDataConsumer.writeCLR(byArray2, 0, byArray2.length);
        oracleDataConsumer.writeB4(0);
        byte[] byArray3 = oracleDataConsumer.getTransliterator().encode("AUTH_EXTERNALNAME_");
        byArray3[byArray3.length - 1] = 0;
        oracleDataConsumer.writeB4(byArray3.length);
        oracleDataConsumer.writeCLR(byArray3, 0, byArray3.length);
        byte[] byArray4 = oracleDataConsumer.getTransliterator().encode("jdbc_1");
        oracleDataConsumer.writeB4(byArray4.length);
        oracleDataConsumer.writeCLR(byArray4, 0, byArray4.length);
        oracleDataConsumer.writeB4(0);
    }

    void readKeyValuePairs(OracleDataProvider oracleDataProvider, byte[][] byArray, byte[][] byArray2, int n) throws UtilException, SQLException {
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = oracleDataProvider.readB4();
            if (n3 > 0) {
                byArray[i] = oracleDataProvider.readCLR(n3);
            }
            if ((n2 = oracleDataProvider.readB4()) > 0) {
                byArray2[i] = oracleDataProvider.readCLR(n2);
            }
            oracleDataProvider.readB4();
        }
    }
}

