/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.informix;

import com.metamatrix.jdbc.base.BaseBlob;
import com.metamatrix.jdbc.base.BaseCharacterStreamWrapper;
import com.metamatrix.jdbc.base.BaseClob;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseInputStreamWrapper;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.informix.InformixColumn;
import com.metamatrix.jdbc.informix.InformixImplBlob;
import com.metamatrix.jdbc.informix.InformixImplClob;
import com.metamatrix.jdbc.informix.InformixLobOutputStream;
import com.metamatrix.jdbc.informix.InformixLongOutputStream;
import com.metamatrix.jdbc.informix.sqli.InformixSQLICommunication;
import com.metamatrix.jdbc.informix.sqli.InformixSQLIDefine;
import com.metamatrix.jdbc.informix.sqli.InformixSQLIRequest;
import com.metamatrix.jdbc.informix.sqli.InformixSQLISmartLob;
import com.metamatrix.util.UtilByteOrderedDataReader;
import com.metamatrix.util.UtilByteOrderedDataWriter;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;

public class InformixParameter {
    private static String footprint = "$Revision:   3.18.1.1  $";
    BaseExceptions exceptions;
    BaseWarnings warnings;
    private BaseParameter inParameter;
    private BaseParameter outParameter;
    private boolean isInput;
    private boolean isOutput;
    private boolean hasProcReturnParam = false;
    private int sqlType;
    private int nativeType;
    private int nativeSubType;
    private int dataType;
    private int indicator;
    private int precision;

    static int getPrecision(int n) {
        switch (n) {
            case 1: {
                return InformixSQLIDefine.PREC_MAKE(5, 0);
            }
            case 2: {
                return InformixSQLIDefine.PREC_MAKE(10, 0);
            }
            case 17: {
                return InformixSQLIDefine.PREC_MAKE(19, 0);
            }
        }
        return 0;
    }

    static short mapSQLTypeToInformixType(int n, int n2) {
        int n3 = 0;
        switch (n) {
            case 1: 
            case 12: {
                n3 = 0;
                break;
            }
            case -1: {
                n3 = 12;
                break;
            }
            case 2: 
            case 3: {
                n3 = 5;
                break;
            }
            case -7: {
                n3 = 45;
                break;
            }
            case -6: 
            case 5: {
                n3 = 1;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
            case -5: {
                n3 = 17;
                break;
            }
            case 7: {
                if (n2 < 9020) {
                    n3 = 5;
                    break;
                }
                n3 = 4;
                break;
            }
            case 6: 
            case 8: {
                if (n2 < 9020) {
                    n3 = 5;
                    break;
                }
                n3 = 3;
                break;
            }
            case -3: 
            case -2: {
                n3 = 0;
                break;
            }
            case -4: {
                n3 = 11;
                break;
            }
            case 91: {
                n3 = 7;
                break;
            }
            case 92: 
            case 93: {
                n3 = 10;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        return (short)n3;
    }

    public static InformixParameter[] prepareParamData(BaseParameters baseParameters, BaseColumns baseColumns, int n, int n2, boolean bl, BaseExceptions baseExceptions, BaseWarnings baseWarnings) throws SQLException {
        int n3 = baseParameters.count();
        InformixParameter[] informixParameterArray = new InformixParameter[n3];
        block9: for (int i = 0; i < n3; ++i) {
            InformixParameter informixParameter;
            informixParameterArray[i] = informixParameter = new InformixParameter();
            informixParameter.inParameter = baseParameters.get(i + 1, 1);
            informixParameter.outParameter = baseParameters.get(i + 1, 2);
            informixParameter.isInput = informixParameter.inParameter != null;
            boolean bl2 = informixParameter.isOutput = informixParameter.outParameter != null;
            if (informixParameter.isInput) {
                informixParameter.sqlType = informixParameter.inParameter.sqlType;
                informixParameter.nativeType = InformixParameter.mapSQLTypeToInformixType(informixParameter.sqlType, n2);
                informixParameter.dataType = informixParameter.inParameter.getType();
                informixParameter.indicator = informixParameter.inParameter.isNull() ? -1 : 0;
                informixParameter.precision = InformixParameter.getPrecision(informixParameter.nativeType);
                informixParameter.exceptions = baseExceptions;
                informixParameter.warnings = baseWarnings;
            } else {
                informixParameter.sqlType = informixParameter.outParameter.sqlType;
                informixParameter.nativeType = InformixParameter.mapSQLTypeToInformixType(informixParameter.sqlType, n2);
                informixParameter.dataType = informixParameter.outParameter.getType();
                informixParameter.indicator = -1;
                informixParameter.precision = InformixParameter.getPrecision(informixParameter.nativeType);
                informixParameter.exceptions = baseExceptions;
                informixParameter.warnings = baseWarnings;
            }
            if (baseColumns == null || baseColumns.count(0) <= i || n != 6 && n != 33 && n != 4 && !bl) continue;
            InformixColumn informixColumn = (InformixColumn)baseColumns.get(i + 1);
            switch (informixColumn.nativeType) {
                case 0: 
                case 12: 
                case 13: 
                case 15: 
                case 16: {
                    informixParameter.nativeType = informixColumn.nativeType;
                    continue block9;
                }
                case 11: {
                    informixParameter.nativeType = informixColumn.nativeType;
                    continue block9;
                }
                case 44: {
                    informixParameter.nativeType = informixColumn.nativeType;
                    informixParameter.nativeSubType = informixColumn.extId;
                    continue block9;
                }
                case 8: {
                    informixParameter.nativeType = 8;
                    continue block9;
                }
                case 5: {
                    informixParameter.nativeType = 5;
                    continue block9;
                }
                case 43: {
                    informixParameter.nativeType = 0;
                    continue block9;
                }
                case 45: {
                    continue block9;
                }
                default: {
                    int n4 = informixParameter.isInput ? informixParameter.inParameter.getType() : informixParameter.outParameter.getType();
                    if (n4 != 9) continue block9;
                    informixParameter.nativeType = informixColumn.nativeType;
                }
            }
        }
        return informixParameterArray;
    }

    public static void writeLobs(InformixParameter[] informixParameterArray, InformixSQLICommunication informixSQLICommunication) throws UtilException, SQLException {
        UtilByteOrderedDataWriter utilByteOrderedDataWriter = informixSQLICommunication.getWriter();
        UtilByteOrderedDataReader utilByteOrderedDataReader = informixSQLICommunication.getReader();
        InformixSQLISmartLob informixSQLISmartLob = informixSQLICommunication.getSmartLob();
        BaseExceptions baseExceptions = informixSQLICommunication.exceptions;
        BaseWarnings baseWarnings = informixSQLICommunication.warnings;
        try {
            InformixSQLIRequest informixSQLIRequest = new InformixSQLIRequest(informixSQLICommunication, null);
            int n = informixParameterArray.length;
            for (int i = 0; i < n; ++i) {
                if (informixParameterArray[i].indicator == -1 || informixParameterArray[i].nativeType != 44) continue;
                if (informixParameterArray[i].nativeSubType == 10) {
                    informixParameterArray[i].writeBlob(informixSQLICommunication, informixSQLIRequest);
                    continue;
                }
                if (informixParameterArray[i].nativeSubType != 11) continue;
                informixParameterArray[i].writeClob(informixSQLICommunication, informixSQLIRequest);
            }
        }
        catch (IOException iOException) {
            baseExceptions.getException((Exception)iOException);
        }
    }

    public void writeClob(InformixSQLICommunication informixSQLICommunication, InformixSQLIRequest informixSQLIRequest) throws UtilException, SQLException, IOException {
        String string;
        int n;
        UtilByteOrderedDataWriter utilByteOrderedDataWriter = informixSQLICommunication.getWriter();
        UtilByteOrderedDataReader utilByteOrderedDataReader = informixSQLICommunication.getReader();
        InformixSQLISmartLob informixSQLISmartLob = informixSQLICommunication.getSmartLob();
        BaseExceptions baseExceptions = informixSQLICommunication.exceptions;
        BaseWarnings baseWarnings = informixSQLICommunication.warnings;
        byte[] byArray = new byte[72];
        int n2 = InformixSQLISmartLob.lobCreate(informixSQLISmartLob, informixSQLIRequest, byArray);
        Closeable closeable = null;
        switch (this.dataType) {
            case 15: {
                closeable = this.inParameter.getASCIIStream(-1, (BaseConnection)informixSQLICommunication.getImplConnection().connection, baseExceptions);
                n = (int)((BaseInputStreamWrapper)closeable).determineLength();
                break;
            }
            case 18: {
                closeable = this.inParameter.getCharacterStreamReader(-1, (BaseConnection)informixSQLICommunication.getImplConnection().connection, baseExceptions);
                n = (int)((BaseCharacterStreamWrapper)closeable).determineLength();
                break;
            }
            default: {
                string = this.inParameter.getString(-1, baseExceptions);
                n = string.length();
                closeable = new StringReader(string);
            }
        }
        if (n > 0) {
            string = utilByteOrderedDataWriter.getTransliterator();
            if (closeable instanceof Reader) {
                Reader reader = (Reader)closeable;
                if (!string.isFixedBytesPerChar()) {
                    int n3;
                    UtilPagedTempBuffer utilPagedTempBuffer = new UtilPagedTempBuffer();
                    string.encode(reader, n, utilPagedTempBuffer.getOutputStream());
                    InputStream inputStream = utilPagedTempBuffer.getInputStream();
                    InformixLobOutputStream informixLobOutputStream = new InformixLobOutputStream(n2, utilByteOrderedDataWriter, n);
                    byte[] byArray2 = new byte[32000];
                    while ((n3 = inputStream.read(byArray2, 0, 32000)) >= 0) {
                        informixLobOutputStream.write(byArray2, 0, n3);
                    }
                    informixLobOutputStream.close();
                    utilPagedTempBuffer.truncate();
                } else {
                    int n4 = n * string.getMaxBytesPerChar();
                    InformixLobOutputStream informixLobOutputStream = new InformixLobOutputStream(n2, utilByteOrderedDataWriter, n4);
                    string.encode(reader, n4, (OutputStream)informixLobOutputStream);
                    informixLobOutputStream.close();
                }
            } else {
                Closeable closeable2 = closeable;
                InformixLobOutputStream informixLobOutputStream = new InformixLobOutputStream(n2, utilByteOrderedDataWriter, n);
                try {
                    int n5;
                    byte[] byArray3 = new byte[32000];
                    for (int i = n; i > 0; i -= n5) {
                        n5 = Math.min(i, byArray3.length);
                        int n6 = ((InputStream)closeable2).read(byArray3, 0, n5);
                        if (n6 < n5) {
                            throw new UtilException(1002);
                        }
                        informixLobOutputStream.write(byArray3, 0, n5);
                    }
                    informixLobOutputStream.close();
                }
                catch (IOException iOException) {
                    throw baseExceptions.getException((Exception)iOException);
                }
            }
            informixSQLIRequest.writePacket(12);
            informixSQLIRequest.submitRequest();
            informixSQLIRequest.processReply();
            utilByteOrderedDataReader.readAndDiscardBytes(6);
            informixSQLIRequest.processReply();
        }
        InformixSQLISmartLob.lobClose(informixSQLISmartLob, informixSQLIRequest, n2);
        this.inParameter.setData(20, (Object)new InformixImplClob(informixSQLICommunication, byArray));
        this.dataType = 20;
    }

    public void writeBlob(InformixSQLICommunication informixSQLICommunication, InformixSQLIRequest informixSQLIRequest) throws UtilException, SQLException, IOException {
        Object object;
        int n;
        InputStream inputStream;
        UtilByteOrderedDataWriter utilByteOrderedDataWriter = informixSQLICommunication.getWriter();
        UtilByteOrderedDataReader utilByteOrderedDataReader = informixSQLICommunication.getReader();
        InformixSQLISmartLob informixSQLISmartLob = informixSQLICommunication.getSmartLob();
        BaseExceptions baseExceptions = informixSQLICommunication.exceptions;
        BaseWarnings baseWarnings = informixSQLICommunication.warnings;
        byte[] byArray = new byte[72];
        int n2 = InformixSQLISmartLob.lobCreate(informixSQLISmartLob, informixSQLIRequest, byArray);
        switch (this.dataType) {
            case 14: {
                inputStream = this.inParameter.getBinaryStream(-1, (BaseConnection)informixSQLICommunication.getImplConnection().connection, baseExceptions);
                n = (int)((BaseInputStreamWrapper)inputStream).determineLength();
                break;
            }
            case 19: {
                return;
            }
            default: {
                object = this.inParameter.getBytes(-1, baseExceptions);
                inputStream = new ByteArrayInputStream((byte[])object);
                n = ((byte[])object).length;
            }
        }
        if (n > 0) {
            int n3;
            object = new InformixLobOutputStream(n2, utilByteOrderedDataWriter, n);
            byte[] byArray2 = new byte[32000];
            while ((n3 = inputStream.read(byArray2, 0, 32000)) >= 0) {
                ((InformixLobOutputStream)object).write(byArray2, 0, n3);
            }
            ((InformixLobOutputStream)object).close();
            informixSQLIRequest.writePacket(12);
            informixSQLIRequest.submitRequest();
            informixSQLIRequest.processReply();
            utilByteOrderedDataReader.readAndDiscardBytes(6);
            informixSQLIRequest.processReply();
        }
        InformixSQLISmartLob.lobClose(informixSQLISmartLob, informixSQLIRequest, n2);
        this.inParameter.setData(19, (Object)new InformixImplBlob(informixSQLICommunication, byArray));
        this.dataType = 19;
    }

    public static void writeAllParameters(InformixParameter[] informixParameterArray, InformixSQLICommunication informixSQLICommunication) throws UtilException, SQLException {
        int n;
        int n2 = informixSQLICommunication.getImplConnection().versionNumber;
        UtilByteOrderedDataWriter utilByteOrderedDataWriter = informixSQLICommunication.getWriter();
        BaseExceptions baseExceptions = informixSQLICommunication.exceptions;
        BaseWarnings baseWarnings = informixSQLICommunication.warnings;
        ArrayList<InformixParameter> arrayList = new ArrayList<InformixParameter>();
        int n3 = informixParameterArray.length;
        utilByteOrderedDataWriter.writeInt16(n3);
        for (n = 0; n < n3; ++n) {
            informixParameterArray[n].write(utilByteOrderedDataWriter, n2);
            if (informixParameterArray[n].nativeType != 12 && informixParameterArray[n].nativeType != 11 || informixParameterArray[n].indicator == -1) continue;
            arrayList.add(informixParameterArray[n]);
        }
        n = arrayList.size();
        if (n == 0) {
            return;
        }
        utilByteOrderedDataWriter.writeInt16(41);
        utilByteOrderedDataWriter.writeInt16(n);
        for (int i = 0; i < n; ++i) {
            ((InformixParameter)arrayList.get(i)).writeLongData(utilByteOrderedDataWriter);
        }
        utilByteOrderedDataWriter.writeInt16(39);
        utilByteOrderedDataWriter.writeInt16(0);
    }

    private void writeLongData(UtilByteOrderedDataWriter utilByteOrderedDataWriter) throws UtilException, SQLException {
        try {
            if (this.inParameter.isNull()) {
                return;
            }
            InformixLongOutputStream informixLongOutputStream = new InformixLongOutputStream(utilByteOrderedDataWriter);
            if (this.nativeType == 12) {
                switch (this.dataType) {
                    case 15: {
                        BaseInputStreamWrapper baseInputStreamWrapper = (BaseInputStreamWrapper)this.inParameter.getASCIIStream(-1, null, this.exceptions);
                        utilByteOrderedDataWriter.getTransliterator().encode((InputStream)baseInputStreamWrapper, (int)baseInputStreamWrapper.determineLength(), (OutputStream)informixLongOutputStream);
                        break;
                    }
                    case 18: {
                        Reader reader = this.inParameter.getCharacterStreamReader(-1, null, this.exceptions);
                        utilByteOrderedDataWriter.getTransliterator().encode(reader, (int)((BaseCharacterStreamWrapper)reader).determineLength(), (OutputStream)informixLongOutputStream);
                        break;
                    }
                    default: {
                        String string = this.inParameter.getString(-1, this.exceptions);
                        utilByteOrderedDataWriter.getTransliterator().encode((Reader)new StringReader(string), string.length(), (OutputStream)informixLongOutputStream);
                        break;
                    }
                }
            } else if (this.nativeType == 11) {
                int n;
                Object object = null;
                switch (this.dataType) {
                    case 14: {
                        object = (BaseInputStreamWrapper)this.inParameter.getBinaryStream(-1, null, this.exceptions);
                        break;
                    }
                    default: {
                        object = new ByteArrayInputStream(this.inParameter.getBytes(-1, this.exceptions));
                    }
                }
                byte[] byArray = new byte[32000];
                while ((n = ((InputStream)object).read(byArray, 0, 32000)) >= 0) {
                    informixLongOutputStream.write(byArray, 0, n);
                }
            }
            informixLongOutputStream.close();
        }
        catch (IOException iOException) {
            throw this.exceptions.getException((Exception)iOException);
        }
    }

    private void writeDecimal(UtilByteOrderedDataWriter utilByteOrderedDataWriter, BigDecimal bigDecimal, int n) throws UtilException, SQLException {
        int n2;
        StringBuffer stringBuffer;
        boolean bl;
        int n3 = bigDecimal.signum();
        int n4 = bigDecimal.scale();
        BigInteger bigInteger = bigDecimal.unscaledValue().abs();
        int n5 = bigInteger.toString().length();
        if (n3 == -1) {
            bigInteger = bigInteger.add(BigInteger.valueOf(-1L));
        }
        boolean bl2 = bl = (stringBuffer = new StringBuffer(bigInteger.toString())).length() < n5;
        if (n5 > n) {
            stringBuffer.setLength(bl ? n - 1 : n);
            n4 -= n5 - n;
            n5 = n;
        }
        if (bl) {
            stringBuffer.insert(0, '0');
        }
        if ((n2 = n5 - n4) % 2 != 0) {
            ++n2;
            stringBuffer.insert(0, '0');
            ++n5;
        }
        if (n5 % 2 == 1) {
            if (n3 < 0) {
                stringBuffer.append('9');
            } else {
                stringBuffer.append('0');
            }
            ++n5;
        }
        n2 /= 2;
        n2 += 64;
        if (n3 == -1) {
            n2 ^= 0x7F;
        }
        if (n3 == 1) {
            n2 |= 0x80;
        }
        int n6 = n5 / 2;
        utilByteOrderedDataWriter.writeInt16(n6 + 1);
        utilByteOrderedDataWriter.writeInt8(n2);
        int n7 = 0;
        for (int i = 0; i < n6; ++i) {
            n7 = (stringBuffer.charAt(i * 2) - 48) * 10 + (stringBuffer.charAt(i * 2 + 1) - 48);
            if (n3 == -1) {
                n7 = 99 - n7;
            }
            utilByteOrderedDataWriter.writeInt8(n7);
        }
        if (n6 % 2 == 0) {
            utilByteOrderedDataWriter.writeInt8(0);
        }
    }

    private void write(UtilByteOrderedDataWriter utilByteOrderedDataWriter, int n) throws UtilException, SQLException {
        utilByteOrderedDataWriter.writeInt16(this.nativeType);
        if (this.nativeType == 45) {
            utilByteOrderedDataWriter.writeStringWithLength16("informix");
            utilByteOrderedDataWriter.writeStringWithLength16("boolean\u0000");
        } else if (this.nativeType == 44) {
            utilByteOrderedDataWriter.writeStringWithLength16("informix");
            if (this.nativeSubType == 11) {
                utilByteOrderedDataWriter.writeStringWithLength16("clob");
            } else {
                utilByteOrderedDataWriter.writeStringWithLength16("blob");
            }
            this.precision = 72;
        }
        utilByteOrderedDataWriter.writeInt16(this.indicator);
        if (this.indicator == -1) {
            utilByteOrderedDataWriter.writeInt16(0);
            return;
        }
        if (this.nativeType == 10) {
            if (this.inParameter.getType() == 12 || this.inParameter.getType() == 10 && this.inParameter.sqlType == 92) {
                this.precision = InformixSQLIDefine.PREC_MAKE(6, 106);
            }
            if (this.inParameter.getType() == 13 || this.inParameter.getType() == 10 && this.inParameter.sqlType == 93) {
                this.precision = InformixSQLIDefine.PREC_MAKE(19, 15);
            }
        }
        utilByteOrderedDataWriter.writeInt16(this.precision);
        switch (this.nativeType) {
            case 11: 
            case 12: {
                utilByteOrderedDataWriter.writeFillerBytes((byte)0, 56);
                break;
            }
            case 44: {
                if (this.dataType == 20) {
                    if (this.inParameter.getObject() instanceof InformixImplClob) {
                        utilByteOrderedDataWriter.writeBytes(((InformixImplClob)((Object)this.inParameter.getObject())).getLocator(), 0, 72);
                    } else {
                        utilByteOrderedDataWriter.writeInt32(72);
                        utilByteOrderedDataWriter.writeBytes(((InformixImplClob)((BaseClob)this.inParameter.getObject()).getNativeImplClob()).getLocator(), 0, 68);
                    }
                    utilByteOrderedDataWriter.writeInt32(0);
                    break;
                }
                if (this.dataType != 19) break;
                if (this.inParameter.getObject() instanceof InformixImplBlob) {
                    utilByteOrderedDataWriter.writeBytes(((InformixImplBlob)((Object)this.inParameter.getObject())).getLocator(), 0, 72);
                } else {
                    utilByteOrderedDataWriter.writeInt32(72);
                    utilByteOrderedDataWriter.writeBytes(((InformixImplBlob)((BaseBlob)this.inParameter.getObject()).getNativeImplBlob()).getLocator(), 0, 68);
                }
                utilByteOrderedDataWriter.writeInt32(0);
                break;
            }
            case 2: {
                utilByteOrderedDataWriter.writeInt32(this.inParameter.getInteger(this.exceptions));
                break;
            }
            case 1: {
                utilByteOrderedDataWriter.writeInt16((int)this.inParameter.getShort(this.exceptions));
                break;
            }
            case 17: {
                long l = this.inParameter.getLong(this.exceptions);
                if (l > 0L) {
                    utilByteOrderedDataWriter.writeInt16(1);
                } else {
                    utilByteOrderedDataWriter.writeInt16(-1);
                    l = 0L - l;
                }
                utilByteOrderedDataWriter.writeInt32((int)(l & 0xFFFFFFFFL));
                utilByteOrderedDataWriter.writeInt32((int)(l >> 32));
                break;
            }
            case 45: {
                utilByteOrderedDataWriter.writeInt32(1);
                utilByteOrderedDataWriter.writeInt8(this.inParameter.getBoolean(this.exceptions) ? 1 : 0);
                utilByteOrderedDataWriter.writeInt8(0);
                break;
            }
            case 0: 
            case 13: 
            case 15: 
            case 16: {
                int n2 = utilByteOrderedDataWriter.writeStringWithLength16(this.inParameter.getString(-1, this.exceptions));
                if (n2 % 2 != 1) break;
                utilByteOrderedDataWriter.writeInt8(0);
                break;
            }
            case 4: {
                if (n >= 9020) {
                    utilByteOrderedDataWriter.writeIEEE32BitFloat(this.inParameter.getFloat(this.exceptions));
                    break;
                }
            }
            case 3: {
                if (n >= 9020) {
                    utilByteOrderedDataWriter.writeIEEE64BitDouble(this.inParameter.getDouble(this.exceptions));
                    break;
                }
            }
            case 5: 
            case 8: {
                this.writeDecimal(utilByteOrderedDataWriter, this.inParameter.getBigDecimal(this.exceptions), 36);
                break;
            }
            case 7: {
                Date date = this.inParameter.getDate(this.exceptions);
                long l = date.getTime();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                l += (long)calendar.get(15);
                int n3 = (int)((l += (long)calendar.get(16)) / 86400000L) + 25568;
                utilByteOrderedDataWriter.writeInt32(n3);
                break;
            }
            case 10: {
                if (this.inParameter.getType() == 12 || this.inParameter.getType() == 10 && this.inParameter.sqlType == 92) {
                    Time time = this.inParameter.getTime(this.exceptions);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(time);
                    int n4 = 3;
                    int n5 = 195;
                    utilByteOrderedDataWriter.writeInt16(n4 + 1);
                    utilByteOrderedDataWriter.writeInt8(n5);
                    for (int i = 0; i < n4; ++i) {
                        switch (n5) {
                            case 199: {
                                utilByteOrderedDataWriter.writeInt8(19);
                                break;
                            }
                            case 198: {
                                utilByteOrderedDataWriter.writeInt8(70);
                                break;
                            }
                            case 197: {
                                utilByteOrderedDataWriter.writeInt8(1);
                                break;
                            }
                            case 196: {
                                utilByteOrderedDataWriter.writeInt8(1);
                                break;
                            }
                            case 195: {
                                utilByteOrderedDataWriter.writeInt8(calendar.get(11));
                                break;
                            }
                            case 194: {
                                utilByteOrderedDataWriter.writeInt8(calendar.get(12));
                                break;
                            }
                            case 193: {
                                utilByteOrderedDataWriter.writeInt8(calendar.get(13));
                                break;
                            }
                            case 190: 
                            case 191: 
                            case 192: {
                                utilByteOrderedDataWriter.writeInt8(0);
                            }
                        }
                        --n5;
                    }
                    break;
                }
                BaseTimestamp baseTimestamp = this.inParameter.getTimestamp(this.exceptions);
                int n6 = 10;
                int n7 = 199;
                utilByteOrderedDataWriter.writeInt16(n6 + 1);
                utilByteOrderedDataWriter.writeInt8(n7);
                for (int i = 0; i < n6; ++i) {
                    switch (n7) {
                        case 199: {
                            utilByteOrderedDataWriter.writeInt8(baseTimestamp.getYear() / 100);
                            break;
                        }
                        case 198: {
                            utilByteOrderedDataWriter.writeInt8(baseTimestamp.getYear() % 100);
                            break;
                        }
                        case 197: {
                            utilByteOrderedDataWriter.writeInt8(baseTimestamp.getMonth() + 1);
                            break;
                        }
                        case 196: {
                            utilByteOrderedDataWriter.writeInt8(baseTimestamp.getDate());
                            break;
                        }
                        case 195: {
                            utilByteOrderedDataWriter.writeInt8(baseTimestamp.getHours());
                            break;
                        }
                        case 194: {
                            utilByteOrderedDataWriter.writeInt8(baseTimestamp.getMinutes());
                            break;
                        }
                        case 193: {
                            utilByteOrderedDataWriter.writeInt8(baseTimestamp.getSeconds());
                            break;
                        }
                        case 192: {
                            utilByteOrderedDataWriter.writeInt8(baseTimestamp.getNanos() / 10000000 % 100);
                            break;
                        }
                        case 191: {
                            utilByteOrderedDataWriter.writeInt8(baseTimestamp.getNanos() / 100000 % 100);
                            break;
                        }
                        case 190: {
                            utilByteOrderedDataWriter.writeInt8(baseTimestamp.getNanos() / 1000 % 100);
                        }
                    }
                    --n7;
                }
                if (n6 % 2 != 0) break;
                utilByteOrderedDataWriter.writeInt8(0);
            }
        }
    }
}

