/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.slutil;

import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilResource;
import com.metamatrix.slutil.UtilResourceLocator;
import com.metamatrix.slutil.UtilTransliterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.security.PrivilegedActionException;
import java.util.HashMap;

public class UtilTransliteratorUsingICUTable
extends UtilTransliterator {
    private int[] unicodeToCharsetMapping;
    private int[] primaryCharsetToUnicodeMapping;
    private int[][] secondaryCharsetToUnicodeMapping;
    protected byte[] tempBytesCache;
    private int[] rl;
    private static final int CHUNK = 256;
    private static HashMap CachedConversionTables;
    private String tableName;
    private InputStream _in;

    public UtilTransliteratorUsingICUTable(String string) throws UtilException {
        ConversionTable conversionTable;
        this.tableName = string;
        if (CachedConversionTables == null) {
            CachedConversionTables = new HashMap();
        }
        if ((conversionTable = (ConversionTable)CachedConversionTables.get(string)) != null) {
            this.loadCachedConversionTable(conversionTable);
        } else {
            InputStream inputStream = null;
            UtilResource utilResource = new UtilResource(new UtilResourceLocator().getClass(), string);
            try {
                inputStream = utilResource.getAsStream();
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new UtilException(1005, string);
            }
            if (inputStream == null) {
                throw new UtilException(1005, string);
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            this.constructConversionTables(new BufferedReader(inputStreamReader));
            this.cacheConversionTables(string);
        }
        this.setCacheSize(256);
    }

    public static UtilTransliteratorUsingICUTable GetIfLoaded(String string) throws UtilException {
        if (CachedConversionTables == null) {
            return null;
        }
        if (CachedConversionTables.get(string) == null) {
            return null;
        }
        return new UtilTransliteratorUsingICUTable(string);
    }

    private void constructConversionTables(BufferedReader bufferedReader) throws UtilException {
        try {
            int n2;
            this.unicodeToCharsetMapping = new int[65536];
            for (n2 = 0; n2 < 65536; ++n2) {
                this.unicodeToCharsetMapping[n2] = 63;
            }
            this.primaryCharsetToUnicodeMapping = new int[256];
            for (n2 = 0; n2 < 256; ++n2) {
                this.primaryCharsetToUnicodeMapping[n2] = 63;
            }
            this.secondaryCharsetToUnicodeMapping = new int[256][];
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.charAt(0) != '<' || string.charAt(1) != 'U' || string.charAt(6) != '>') {
                    throw new UtilException(1034, this.tableName);
                }
                String string2 = string.substring(2, 6);
                n2 = Integer.parseInt(string2, 16);
                int n3 = string.indexOf(92, 6);
                if (n3 == -1 || string.charAt(n3 + 1) != 'x') {
                    throw new UtilException(1034, this.tableName);
                }
                int n4 = Integer.parseInt(string.substring(n3 + 2, n3 + 4), 16);
                int n5 = string.indexOf(92, n3 + 4);
                int n6 = string.indexOf(124, n5 == -1 ? n3 + 4 : n5 + 4);
                int n7 = Integer.parseInt(string.substring(n6 + 1, n6 + 2));
                if (n5 == -1) {
                    this.unicodeToCharsetMapping[n2] = n4;
                    if (n7 == 0) {
                        this.primaryCharsetToUnicodeMapping[n4] = n2;
                    }
                } else {
                    if (string.charAt(n5 + 1) != 'x') {
                        throw new UtilException(1034, this.tableName);
                    }
                    int n8 = Integer.parseInt(string.substring(n5 + 2, n5 + 4), 16);
                    this.unicodeToCharsetMapping[n2] = n4 << 8 | n8;
                    this.primaryCharsetToUnicodeMapping[n4] = -1;
                    if (n7 == 0) {
                        if (this.secondaryCharsetToUnicodeMapping[n4] == null) {
                            this.secondaryCharsetToUnicodeMapping[n4] = new int[256];
                            for (int i2 = 0; i2 < 256; ++i2) {
                                this.secondaryCharsetToUnicodeMapping[n4][i2] = 63;
                            }
                        }
                        this.secondaryCharsetToUnicodeMapping[n4][n8] = n2;
                    }
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            throw new UtilException(1008, this.tableName);
        }
    }

    private void cacheConversionTables(Object object) {
        ConversionTable conversionTable = new ConversionTable();
        conversionTable.unicodeToCharsetMapping = this.unicodeToCharsetMapping;
        conversionTable.primaryCharsetToUnicodeMapping = this.primaryCharsetToUnicodeMapping;
        conversionTable.secondaryCharsetToUnicodeMapping = this.secondaryCharsetToUnicodeMapping;
        CachedConversionTables.put(object, conversionTable);
    }

    private void loadCachedConversionTable(ConversionTable conversionTable) {
        this.unicodeToCharsetMapping = conversionTable.unicodeToCharsetMapping;
        this.primaryCharsetToUnicodeMapping = conversionTable.primaryCharsetToUnicodeMapping;
        this.secondaryCharsetToUnicodeMapping = conversionTable.secondaryCharsetToUnicodeMapping;
    }

    public boolean isFixedBytesPerChar() {
        return false;
    }

    public int getMaxBytesPerChar() {
        return 2;
    }

    public int getMaxCharsPerByte() {
        return 1;
    }

    private int _encode(char[] cArray, int n2, byte[] byArray) throws UtilException {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            int n4 = this.unicodeToCharsetMapping[c2];
            if (n4 > 255) {
                byArray[n3++] = (byte)(n4 >> 8 & 0xFF);
                byArray[n3++] = (byte)(n4 & 0xFF);
                continue;
            }
            byArray[n3++] = (byte)n4;
        }
        return n3;
    }

    public byte[] encode(String string) throws UtilException {
        if (this.rl == null) {
            this.rl = new int[1];
        }
        byte[] byArray = this.encode(string, this.rl);
        int n2 = this.rl[0];
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n2 = string.length();
        int n3 = n2 * this.getMaxBytesPerChar();
        byte[] byArray = this.bytesCache.length >= n3 ? this.bytesCache : new byte[n3];
        char[] cArray = this.charsCache.length >= n2 ? this.charsCache : new char[n2];
        string.getChars(0, n2, cArray, 0);
        nArray[0] = this._encode(cArray, n2, byArray);
        return byArray;
    }

    public void encode(InputStream inputStream, int n2, OutputStream outputStream) throws UtilException {
        if (this.bytesCache.length < 256) {
            this.bytesCache = new byte[256];
        }
        if (this.tempBytesCache == null || this.tempBytesCache.length < 256) {
            this.tempBytesCache = new byte[256 * this.getMaxBytesPerChar()];
        }
        try {
            while (n2 > 0) {
                int n3 = Math.min(n2, 256);
                int n4 = inputStream.read(this.bytesCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                int n5 = 0;
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n6 = this.bytesCache[i2] & 0xFF;
                    int n7 = this.unicodeToCharsetMapping[n6];
                    if (n7 > 255) {
                        this.tempBytesCache[n5++] = (byte)(n7 >> 8 & 0xFF);
                        this.tempBytesCache[n5++] = (byte)(n7 & 0xFF);
                        continue;
                    }
                    this.tempBytesCache[n5++] = (byte)n7;
                }
                outputStream.write(this.tempBytesCache, 0, n5);
                n2 -= n4;
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n2, OutputStream outputStream) throws UtilException {
        if (this.bytesCache.length < 256) {
            this.bytesCache = new byte[256];
        }
        if (this.charsCache.length < 256) {
            this.charsCache = new char[256];
        }
        try {
            while (n2 > 0) {
                int n3 = Math.min(n2, 256);
                int n4 = reader.read(this.charsCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                int n5 = this._encode(this.charsCache, n4, this.bytesCache);
                outputStream.write(this.bytesCache, 0, n5);
                n2 -= n4;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    private int _decode(byte[] byArray, int n2, int n3, char[] cArray) throws UtilException {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = byArray[n5 + n2] & 0xFF;
            ++n5;
            if (this.secondaryCharsetToUnicodeMapping[n6] != null) {
                if (n5 >= n3) {
                    throw UtilException.createTransliterationFailedException("invalid encoded data");
                }
                int n7 = byArray[n5 + n2] & 0xFF;
                cArray[n4++] = (char)this.secondaryCharsetToUnicodeMapping[n6][n7];
                ++n5;
                continue;
            }
            cArray[n4++] = (char)this.primaryCharsetToUnicodeMapping[n6];
        }
        return n4;
    }

    public String decode(byte[] byArray, int n2, int n3) throws UtilException {
        int n4 = n3 * 1;
        char[] cArray = this.charsCache.length >= n4 ? this.charsCache : new char[n4];
        int n5 = this._decode(byArray, n2, n3, cArray);
        return new String(cArray, 0, n5);
    }

    public int decode(byte[] byArray, int n2, int n3, char[] cArray) throws UtilException {
        return this._decode(byArray, n2, n3, cArray);
    }

    public String decode(byte[] byArray, int n2, int n3, int n4) throws UtilException {
        char[] cArray = n3 > this.charsCache.length ? new char[n3] : this.charsCache;
        n3 = this._decode(byArray, n2, n3, cArray);
        if (cArray.length < n4) {
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, 0, cArray2, 0, n3);
            cArray = cArray2;
        }
        for (int i2 = n3; i2 < n4; ++i2) {
            cArray[i2] = 32;
        }
        return new String(cArray, 0, n4);
    }

    public synchronized Reader decodeAsReader(InputStream inputStream) throws UtilException {
        this._in = inputStream;
        return new Reader(){
            private InputStream in;
            private int length;
            private byte[] cache;
            {
                this.in = UtilTransliteratorUsingICUTable.this._in;
            }

            public int read() throws IOException {
                int n2 = this.in.read();
                if (n2 == -1) {
                    return -1;
                }
                if (UtilTransliteratorUsingICUTable.this.secondaryCharsetToUnicodeMapping[n2 &= 0xFF] != null) {
                    int n3 = this.in.read() & 0xFF;
                    return UtilTransliteratorUsingICUTable.this.secondaryCharsetToUnicodeMapping[n2][n3];
                }
                return UtilTransliteratorUsingICUTable.this.primaryCharsetToUnicodeMapping[n2];
            }

            public int read(char[] cArray, int n2, int n3) throws IOException {
                int n4;
                if (this.cache == null || this.cache.length < n3) {
                    this.cache = new byte[n3];
                }
                if ((n4 = this.in.read(this.cache, 0, n3)) <= 0) {
                    return n4;
                }
                int n5 = 0;
                try {
                    n5 = UtilTransliteratorUsingICUTable.this._decode(this.cache, n2, n4, cArray);
                }
                catch (UtilException utilException) {
                    return -1;
                }
                return n5;
            }

            public void close() throws IOException {
                this.in.close();
            }
        };
    }

    private class ConversionTable {
        int[] unicodeToCharsetMapping;
        int[] primaryCharsetToUnicodeMapping;
        int[][] secondaryCharsetToUnicodeMapping;

        private ConversionTable() {
        }
    }
}

