/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.ocsp.CertID;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;

public class ResponderID {
    boolean c;
    byte[] b;
    Name a;

    public String toString() {
        if (this.c) {
            return "byName: " + this.a;
        }
        return "byKey: " + Util.toString(this.b);
    }

    public ASN1Object toASN1Object() {
        if (this.c) {
            return new CON_SPEC(1, this.a.toASN1Object());
        }
        return new CON_SPEC(2, new OCTET_STRING(this.b));
    }

    public boolean isResponderIdFor(X509Certificate x509Certificate) throws NoSuchAlgorithmException {
        if (this.c) {
            return this.a.equals((Name)x509Certificate.getSubjectDN());
        }
        try {
            return CryptoUtils.equalsBlock(this.b, CertID.calculateIssuerKeyHash(x509Certificate.getPublicKey(), AlgorithmID.sha1));
        }
        catch (CodingException codingException) {
            throw new InternalErrorException("Cannot calculate keyHash. Invalid key encoding: " + codingException.getMessage());
        }
    }

    public int hashCode() {
        if (this.c) {
            return this.a.hashCode();
        }
        return Util.calculateHashCode(this.b);
    }

    public Name getName() {
        return this.a;
    }

    public byte[] getKeyHash() {
        return this.b;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ResponderID)) {
            return false;
        }
        ResponderID responderID = (ResponderID)object;
        if (this.c != responderID.c) {
            return false;
        }
        if (this.c) {
            return this.a.equals(responderID.a);
        }
        return CryptoUtils.equalsBlock(this.b, responderID.b);
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        int n2 = aSN1Object.getAsnType().getTag();
        switch (n2) {
            case 1: {
                this.a = new Name((ASN1Object)aSN1Object.getValue());
                this.c = true;
                return;
            }
            case 2: {
                this.b = (byte[])((ASN1Object)aSN1Object.getValue()).getValue();
                this.c = false;
                return;
            }
        }
        throw new CodingException("Invalid ASN.1 tag in ResponderID choice: " + n2);
    }

    public boolean byName() {
        return this.c;
    }

    public ResponderID(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Cannot create ResponderID from a null object");
        }
        this.b = byArray;
        this.c = false;
    }

    public ResponderID(PublicKey publicKey) throws NoSuchAlgorithmException {
        try {
            this.b = CertID.calculateIssuerKeyHash(publicKey, AlgorithmID.sha1);
        }
        catch (CodingException codingException) {
            throw new IllegalArgumentException("Cannot create ResponderID. Invalid key encoding format: " + codingException.getMessage());
        }
        this.c = false;
    }

    public ResponderID(Name name) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot create ResponderID from a null object");
        }
        this.a = name;
        this.c = true;
    }

    public ResponderID(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }
}

