/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink.parameters;

import com.metamatrix.jdbc.sequelink.parameters.SequeLinkParameter;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.sequelink.ctxt.stmt.StatementContext;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.sequelink.ssp.SspOutputStream;
import com.metamatrix.slutil.UtilException;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Time;

public class SequeLinkTimeParameter
extends SequeLinkParameter {
    public SequeLinkTimeParameter(StatementContext statementContext, int n, int n2, BaseExceptions baseExceptions) throws SQLException {
        super(statementContext, n, 92, 0, n2, baseExceptions);
        this.baseDataType = 12;
    }

    protected void setBindInfo() {
        this.sqlnkType = 8;
        this.sqlnkSize = 3;
    }

    protected void convertDataIn() throws SQLException {
        Time time = this.bdIn.getTime(this.exceptions);
        this.bdIn.setTime(time);
    }

    protected void writeToStream(SspOutputStream sspOutputStream) throws IOException, UtilException {
        Time time = this.bdIn.getTimeNoConvert();
        sspOutputStream.writeSSPInt8(time.getHours());
        sspOutputStream.writeSSPInt8(time.getMinutes());
        sspOutputStream.writeSSPInt8(time.getSeconds());
    }

    protected void readFromStream(SspInputStream sspInputStream) throws IOException, UtilException {
        this.bdOut.setTime(new Time(sspInputStream.readSSPInt8(), sspInputStream.readSSPInt8(), sspInputStream.readSSPInt8()));
    }
}

