/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.util;

import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.query.eval.SecurityFunctionEvaluator;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Stack;

public class CommandContext
implements Serializable,
Cloneable {
    private Object processorID;
    private String connectionID;
    private TupleSourceID tupleSourceID;
    private int outputBatchSize = 2000;
    private int processorBatchSize = 2000;
    private int connectorBatchSize = 2000;
    private String userName;
    private Serializable trustedPayload;
    private Serializable commandPayload;
    private String vdbName;
    private String vdbVersion;
    private Properties environmentProperties;
    private boolean processDebug;
    private boolean collectNodeStatistics;
    private int streamingBatchSize;
    private Random random = null;
    private Stack recursionStack = null;
    private boolean optimisticTransaction = false;
    private transient Object multiSourcePlanModifier;
    private transient SecurityFunctionEvaluator securityFunctionEvaluator;
    private List preparedBatchUpdateValues;
    private transient Object tempTableStore;

    public CommandContext(Object processorID, String connectionID, TupleSourceID tupleSourceID, int outputBatchSize, String userName, Serializable trustedPayload, Serializable commandPayload, String vdbName, String vdbVersion, Properties envProperties, boolean processDebug, boolean collectNodeStatistics) {
        this.setProcessorID(processorID);
        this.setConnectionID(connectionID);
        this.setTupleSourceID(tupleSourceID);
        this.setOutputBatchSize(outputBatchSize);
        this.setUserName(userName);
        this.setTrustedPayload(trustedPayload);
        this.setCommandPayload(commandPayload);
        this.setVdbName(vdbName);
        this.setVdbVersion(vdbVersion);
        this.setEnvironmentProperties(envProperties);
        this.setProcessDebug(processDebug);
        this.setCollectNodeStatistics(collectNodeStatistics);
    }

    public CommandContext(Object processorID, String connectionID, TupleSourceID tupleSourceID, int outputBatchSize, String userName, Serializable trustedPayLoad, String vdbName, String vdbVersion) {
        this(processorID, connectionID, tupleSourceID, outputBatchSize, userName, trustedPayLoad, null, vdbName, vdbVersion, null, false, false);
    }

    protected CommandContext(CommandContext context) {
        this.setConnectionID(context.connectionID);
        this.setOutputBatchSize(context.outputBatchSize);
        this.setProcessorID(context.processorID);
        this.setTupleSourceID(null);
        this.setUserName(context.userName);
        this.setTrustedPayload(context.trustedPayload);
        this.setCommandPayload(context.commandPayload);
        this.setVdbName(context.vdbName);
        this.setVdbVersion(context.vdbVersion);
        this.setEnvironmentProperties(PropertiesUtils.clone((Properties)context.environmentProperties));
        this.setProcessDebug(context.processDebug);
        this.setProcessorBatchSize(context.processorBatchSize);
        this.setConnectorBatchSize(context.connectorBatchSize);
        this.setRandom(context.random);
        if (context.recursionStack != null) {
            this.recursionStack = (Stack)context.recursionStack.clone();
        }
        this.setOptimisticTransaction(context.isOptimisticTransaction());
        this.setMultiSourcePlanModifier(context.getMultiSourcePlanModifier());
        this.setSecurityFunctionEvaluator(context.getSecurityFunctionEvaluator());
    }

    public CommandContext() {
    }

    public int getOutputBatchSize() {
        return this.outputBatchSize;
    }

    public Object getProcessorID() {
        return this.processorID;
    }

    public TupleSourceID getTupleSourceID() {
        return this.tupleSourceID;
    }

    public boolean getProcessDebug() {
        return this.processDebug;
    }

    public void setProcessDebug(boolean processDebug) {
        this.processDebug = processDebug;
    }

    public void setOutputBatchSize(int i) {
        this.outputBatchSize = i;
    }

    public void setProcessorID(Object object) {
        ArgCheck.isNotNull((Object)object);
        this.processorID = object;
    }

    public void setTupleSourceID(TupleSourceID sourceID) {
        this.tupleSourceID = sourceID;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof CommandContext) {
            return this.processorID.equals(((CommandContext)obj).getProcessorID());
        }
        return false;
    }

    public int hashCode() {
        return this.processorID.hashCode();
    }

    public Object clone() {
        CommandContext clonedContext = new CommandContext(this);
        clonedContext.preparedBatchUpdateValues = this.preparedBatchUpdateValues;
        return clonedContext;
    }

    public String toString() {
        return "CommandContext: " + this.processorID;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public Serializable getTrustedPayload() {
        return this.trustedPayload;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getVdbName() {
        return this.vdbName;
    }

    public String getVdbVersion() {
        return this.vdbVersion;
    }

    public void setConnectionID(String connectionID) {
        this.connectionID = connectionID;
    }

    public void setTrustedPayload(Serializable trustedPayLoad) {
        this.trustedPayload = trustedPayLoad;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setVdbName(String vdbName) {
        this.vdbName = vdbName;
    }

    public void setVdbVersion(String vdbVersion) {
        this.vdbVersion = vdbVersion;
    }

    public Properties getEnvironmentProperties() {
        return this.environmentProperties;
    }

    public void setEnvironmentProperties(Properties properties) {
        this.environmentProperties = properties;
    }

    public Serializable getCommandPayload() {
        return this.commandPayload;
    }

    public void setCommandPayload(Serializable commandPayload) {
        this.commandPayload = commandPayload;
    }

    public void setCollectNodeStatistics(boolean collectNodeStatistics) {
        this.collectNodeStatistics = collectNodeStatistics;
    }

    public boolean getCollectNodeStatistics() {
        return this.collectNodeStatistics;
    }

    public int getStreamingBatchSize() {
        return this.streamingBatchSize;
    }

    public void setStreamingBatchSize(int streamingBatchSize) {
        this.streamingBatchSize = streamingBatchSize;
    }

    public int getConnectorBatchSize() {
        return this.connectorBatchSize;
    }

    public void setConnectorBatchSize(int connectorBatchSize) {
        this.connectorBatchSize = connectorBatchSize;
    }

    public int getProcessorBatchSize() {
        return this.processorBatchSize;
    }

    public void setProcessorBatchSize(int processorBatchSize) {
        this.processorBatchSize = processorBatchSize;
    }

    public double getNextRand() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random.nextDouble();
    }

    public double getNextRand(long seed) {
        if (this.random == null) {
            this.random = new Random();
        }
        this.random.setSeed(seed);
        return this.random.nextDouble();
    }

    void setRandom(Random random) {
        this.random = random;
    }

    public boolean pushCall(String value) {
        if (this.recursionStack == null) {
            this.recursionStack = new Stack();
        }
        boolean result = this.recursionStack.contains(value);
        this.recursionStack.push(value);
        return result;
    }

    public void popCall() {
        if (this.recursionStack != null) {
            this.recursionStack.pop();
        }
    }

    public void setOptimisticTransaction(boolean optimisticTransaction) {
        this.optimisticTransaction = optimisticTransaction;
    }

    public boolean isOptimisticTransaction() {
        return this.optimisticTransaction;
    }

    public Object getMultiSourcePlanModifier() {
        return this.multiSourcePlanModifier;
    }

    public void setMultiSourcePlanModifier(Object multiSourcePlanModifier) {
        this.multiSourcePlanModifier = multiSourcePlanModifier;
    }

    public SecurityFunctionEvaluator getSecurityFunctionEvaluator() {
        return this.securityFunctionEvaluator;
    }

    public void setSecurityFunctionEvaluator(SecurityFunctionEvaluator securityFunctionEvaluator) {
        this.securityFunctionEvaluator = securityFunctionEvaluator;
    }

    public List getPreparedBatchUpdateValues() {
        return this.preparedBatchUpdateValues;
    }

    public void setPreparedBatchUpdateValues(List preparedBatchUpdateValues) {
        this.preparedBatchUpdateValues = preparedBatchUpdateValues;
    }

    public Object getTempTableStore() {
        return this.tempTableStore;
    }

    public void setTempTableStore(Object tempTableStore) {
        this.tempTableStore = tempTableStore;
    }
}

