/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseParameter;
import com.metamatrix.jdbc.slbase.BaseParameterInfo;
import java.sql.SQLException;

public class BaseParameters {
    private BaseExceptions exceptions;
    BaseParameterInfo[] parameterMetaData;
    private BaseParameter[] parametersIn;
    private BaseParameter[] parametersOut;
    boolean outputParamRegistered = false;

    public BaseParameters(int n, BaseExceptions baseExceptions) {
        this.parametersIn = new BaseParameter[n];
        this.parametersOut = new BaseParameter[n];
        this.exceptions = baseExceptions;
    }

    public BaseParameters(BaseParameters baseParameters, BaseExceptions baseExceptions) {
        this.parametersIn = new BaseParameter[baseParameters.parametersIn.length];
        this.parametersOut = new BaseParameter[baseParameters.parametersOut.length];
        this.exceptions = baseExceptions;
        this.parameterMetaData = baseParameters.parameterMetaData;
        for (int i = 0; i < this.parametersIn.length; ++i) {
            if (baseParameters.parametersIn[i] != null) {
                this.parametersIn[i] = new BaseParameter(baseParameters.parametersIn[i]);
            }
            if (baseParameters.parametersOut[i] == null) continue;
            this.parametersOut[i] = new BaseParameter(baseParameters.parametersOut[i]);
            this.outputParamRegistered = true;
        }
    }

    public void set(int n, int n2, BaseParameter baseParameter) throws SQLException {
        try {
            if (n2 == 1) {
                this.parametersIn[n - 1] = baseParameter;
            } else if (n2 == 2) {
                this.parametersOut[n - 1] = baseParameter;
                this.outputParamRegistered = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameter getParameter(int n) throws SQLException {
        try {
            BaseParameter baseParameter = this.parametersIn[n - 1];
            if (baseParameter == null) {
                this.parametersIn[n - 1] = baseParameter = new BaseParameter();
            }
            return baseParameter;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public void clearInput() {
        int n = this.count();
        for (int i = 0; i < n; ++i) {
            if (this.parametersIn[i] == null) continue;
            this.parametersIn[i].setNull(0);
        }
    }

    public void clearOutput() {
        int n = this.count();
        for (int i = 0; i < n; ++i) {
            if (this.parametersOut[i] == null) continue;
            this.parametersOut[i].setNull(0);
        }
    }

    public int count() {
        return this.parametersIn.length;
    }

    protected boolean anyOutputParamsRegistered() {
        return this.outputParamRegistered;
    }

    public BaseParameter get(int n, int n2) throws SQLException {
        try {
            Object var3_3 = null;
            if (n2 == 1) {
                return this.parametersIn[n - 1];
            }
            if (n2 == 2) {
                return this.parametersOut[n - 1];
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameter getInput(int n) {
        return this.parametersIn[n - 1];
    }

    public BaseParameter getOutput(int n) {
        return this.parametersOut[n - 1];
    }

    boolean isValidOrdinal(int n) {
        return n > 0 && n <= this.count();
    }

    protected boolean haveMinimalBindings() {
        boolean bl = true;
        int n = this.count();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.parametersIn[i] != null && this.parametersIn[i].getType() != 0) {
                ++n2;
                continue;
            }
            if (this.parametersOut[i] == null) continue;
            ++n3;
        }
        if (n2 + n3 < n) {
            bl = false;
        }
        return bl;
    }

    public void setParameterInfo(int n, BaseParameterInfo baseParameterInfo) {
        if (this.parameterMetaData == null) {
            this.parameterMetaData = new BaseParameterInfo[this.count()];
        }
        this.parameterMetaData[n] = baseParameterInfo;
    }

    public BaseParameterInfo getParameterInfoOrNull(int n) throws SQLException {
        try {
            if (this.parameterMetaData == null || n > this.parameterMetaData.length - 1 || this.parameterMetaData[n] == null) {
                return null;
            }
            return this.parameterMetaData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameterInfo getParameterInfo(int n) throws SQLException {
        try {
            if (this.parameterMetaData == null || n > this.parameterMetaData.length - 1 || this.parameterMetaData[n] == null) {
                throw this.exceptions.getException(6088);
            }
            return this.parameterMetaData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }
}

