/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseData;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilTransliterator;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class BaseParameter
extends BaseData {
    public static final int DIR_IN = 1;
    public static final int DIR_OUT = 2;
    public static final int DIR_INOUT = 4;
    public static final int TYPE_UNSPECIFIED = Integer.MAX_VALUE;
    public int sqlType = Integer.MAX_VALUE;
    public int scale = -1;
    public int nativeType;
    public Calendar cal;
    public UtilTransliterator transliterator;
    public String transliteratorCharSet;

    public BaseParameter() {
    }

    public BaseParameter(BaseParameter baseParameter) {
        super.populate(baseParameter);
        this.sqlType = baseParameter.sqlType;
        this.scale = baseParameter.scale;
        this.cal = baseParameter.cal;
    }

    public BaseParameter(int n2, int n3, Object object) {
        super(n3, object);
        this.sqlType = n2;
    }

    public BaseParameter(int n2, int n3, Object object, int n4) {
        super(n3, object);
        this.sqlType = n2;
        this.scale = n4;
    }

    public BaseParameter(int n2, int n3, Object object, Calendar calendar) {
        super(n3, object);
        this.sqlType = n2;
        this.cal = calendar;
    }

    public Time getTime(BaseExceptions baseExceptions) throws SQLException {
        if (this.getType() == 12 && !this.isNull()) {
            if (this.sqlType == 93 || this.sqlType == 92) {
                Time time = (Time)this.getObject();
                return new Time(time.getHours(), time.getMinutes(), time.getSeconds());
            }
            if (this.sqlType == 91) {
                this.unsupportedConversion(baseExceptions);
            }
        }
        return super.getTime(baseExceptions);
    }

    public Date getDate(BaseExceptions baseExceptions) throws SQLException {
        if (this.getType() == 11 && !this.isNull()) {
            if (this.sqlType == 93 || this.sqlType == 91) {
                Date date = (Date)this.getObject();
                return new Date(date.getYear(), date.getMonth(), date.getDate());
            }
            if (this.sqlType == 92) {
                this.unsupportedConversion(baseExceptions);
            }
        }
        return super.getDate(baseExceptions);
    }

    public Timestamp getTimestamp(BaseExceptions baseExceptions) throws SQLException {
        if (this.getType() == 13 && !this.isNull()) {
            if (this.sqlType == 91) {
                Timestamp timestamp = (Timestamp)this.getObject();
                return new Timestamp(timestamp.getYear(), timestamp.getMonth(), timestamp.getDate(), 0, 0, 0, 0);
            }
            if (this.sqlType == 92) {
                Timestamp timestamp = (Timestamp)this.getObject();
                return new Timestamp(70, 0, 1, timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds(), timestamp.getNanos());
            }
        }
        return super.getTimestamp(baseExceptions);
    }

    public UtilTransliterator getTransliterator() {
        UtilTransliterator utilTransliterator = null;
        if (this.transliterator != null) {
            utilTransliterator = this.transliterator;
        } else if (this.transliteratorCharSet != null) {
            try {
                utilTransliterator = UtilTransliterator.GetNewTransliterator(this.transliteratorCharSet);
            }
            catch (UtilException utilException) {
                // empty catch block
            }
        }
        return utilTransliterator;
    }
}

