/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.util;

import java.io.Serializable;

public class SHA
implements Cloneable,
Serializable {
    private int[] state;
    private long count;
    private byte[] buffer;
    static final byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private transient byte[] byteArray = new byte[1];
    private transient int[] W = new int[80];

    public SHA() {
        this.state = new int[5];
        this.buffer = new byte[64];
        this.engineReset();
    }

    public void engineReset() {
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.state[4] = -1009589776;
        SHA.zeroBlock(this.buffer);
        this.count = 0L;
    }

    public Object clone() {
        SHA sHA = new SHA();
        SHA.copyBlock(this.buffer, 0, sHA.buffer, 0, 64);
        sHA.count = this.count;
        SHA.copyBlock(this.state, 0, sHA.state, 0, 5);
        return sHA;
    }

    public void engineUpdate(byte by) {
        this.byteArray[0] = by;
        this.engineUpdate(this.byteArray, 0, 1);
    }

    public void engineUpdate(byte[] byArray, int n2, int n3) {
        int n4 = (int)(this.count & 0x3FL);
        this.count += (long)n3;
        if (n4 != 0) {
            int n5 = 64 - n4;
            if (n5 <= n3) {
                SHA.copyBlock(byArray, n2, this.buffer, n4, n5);
                this.updateInternal(this.buffer, 0);
                n3 -= n5;
                n2 += n5;
            } else {
                SHA.copyBlock(byArray, n2, this.buffer, n4, n3);
                n3 = 0;
            }
            if (n3 == 0) {
                return;
            }
        }
        while (n3 >= 64) {
            this.updateInternal(byArray, n2);
            n2 += 64;
            n3 -= 64;
        }
        if (n3 > 0) {
            SHA.copyBlock(byArray, n2, this.buffer, 0, n3);
        }
    }

    public byte[] engineDigest() {
        int n2;
        byte[] byArray = new byte[8];
        long l2 = this.count << 3;
        for (n2 = 0; n2 < 8; ++n2) {
            byArray[7 - n2] = (byte)(l2 >>> n2 * 8);
        }
        n2 = (int)(this.count & 0x3FL);
        int n3 = n2 < 56 ? 56 - n2 : 120 - n2;
        this.engineUpdate(padding, 0, n3);
        this.engineUpdate(byArray, 0, 8);
        byte[] byArray2 = new byte[20];
        int n4 = 0;
        for (int i2 = 0; i2 < 20; i2 += 4) {
            byArray2[i2] = (byte)(this.state[n4] >> 24);
            byArray2[i2 + 1] = (byte)(this.state[n4] >> 16);
            byArray2[i2 + 2] = (byte)(this.state[n4] >> 8);
            byArray2[i2 + 3] = (byte)this.state[n4];
            ++n4;
        }
        this.engineReset();
        return byArray2;
    }

    private final void updateInternal(byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = n2;
        while (n3 < 16) {
            this.W[n3] = byArray[n4 + 3] & 0xFF | (byArray[n4 + 2] & 0xFF) << 8 | (byArray[n4 + 1] & 0xFF) << 16 | byArray[n4] << 24;
            ++n3;
            n4 += 4;
        }
        int n5 = this.W[0];
        int n6 = this.W[1];
        int n7 = this.W[2];
        int n8 = this.W[3];
        int n9 = this.W[4];
        int n10 = this.W[5];
        int n11 = this.W[6];
        int n12 = this.W[7];
        int n13 = this.W[8];
        int n14 = this.W[9];
        int n15 = this.W[10];
        int n16 = this.W[11];
        int n17 = this.W[12];
        int n18 = this.W[13];
        int n19 = this.W[14];
        int n20 = this.W[15];
        n3 = 16;
        while (n3 < 80) {
            n5 ^= n18 ^ n13 ^ n7;
            this.W[n3++] = n5 = n5 << 1 | n5 >>> 31;
            n6 ^= n19 ^ n14 ^ n8;
            this.W[n3++] = n6 = n6 << 1 | n6 >>> 31;
            n7 ^= n20 ^ n15 ^ n9;
            this.W[n3++] = n7 = n7 << 1 | n7 >>> 31;
            n8 ^= n5 ^ n16 ^ n10;
            this.W[n3++] = n8 = n8 << 1 | n8 >>> 31;
            n9 ^= n6 ^ n17 ^ n11;
            this.W[n3++] = n9 = n9 << 1 | n9 >>> 31;
            n10 ^= n7 ^ n18 ^ n12;
            this.W[n3++] = n10 = n10 << 1 | n10 >>> 31;
            n11 ^= n8 ^ n19 ^ n13;
            this.W[n3++] = n11 = n11 << 1 | n11 >>> 31;
            n12 ^= n9 ^ n20 ^ n14;
            this.W[n3++] = n12 = n12 << 1 | n12 >>> 31;
            n13 ^= n10 ^ n5 ^ n15;
            this.W[n3++] = n13 = n13 << 1 | n13 >>> 31;
            n14 ^= n11 ^ n6 ^ n16;
            this.W[n3++] = n14 = n14 << 1 | n14 >>> 31;
            n15 ^= n12 ^ n7 ^ n17;
            this.W[n3++] = n15 = n15 << 1 | n15 >>> 31;
            n16 ^= n13 ^ n8 ^ n18;
            this.W[n3++] = n16 = n16 << 1 | n16 >>> 31;
            n17 ^= n14 ^ n9 ^ n19;
            this.W[n3++] = n17 = n17 << 1 | n17 >>> 31;
            n18 ^= n15 ^ n10 ^ n20;
            this.W[n3++] = n18 = n18 << 1 | n18 >>> 31;
            n19 ^= n16 ^ n11 ^ n5;
            this.W[n3++] = n19 = n19 << 1 | n19 >>> 31;
            n20 ^= n17 ^ n12 ^ n6;
            this.W[n3++] = n20 = n20 << 1 | n20 >>> 31;
        }
        int n21 = this.state[0];
        int n22 = this.state[1];
        int n23 = this.state[2];
        int n24 = this.state[3];
        int n25 = this.state[4];
        for (n3 = 0; n3 < 18; n3 += 6) {
            n4 = (n21 << 5 | n21 >>> 27) + (n22 & n23 | ~n22 & n24) + n25 + this.W[n3] + 1518500249;
            n22 = n22 << 30 | n22 >>> 2;
            n25 = (n4 << 5 | n4 >>> 27) + (n21 & n22 | ~n21 & n23) + n24 + this.W[n3 + 1] + 1518500249;
            n21 = n21 << 30 | n21 >>> 2;
            n24 = (n25 << 5 | n25 >>> 27) + (n4 & n21 | ~n4 & n22) + n23 + this.W[n3 + 2] + 1518500249;
            n4 = n4 << 30 | n4 >>> 2;
            n23 = (n24 << 5 | n24 >>> 27) + (n25 & n4 | ~n25 & n21) + n22 + this.W[n3 + 3] + 1518500249;
            n25 = n25 << 30 | n25 >>> 2;
            n22 = (n23 << 5 | n23 >>> 27) + (n24 & n25 | ~n24 & n4) + n21 + this.W[n3 + 4] + 1518500249;
            n24 = n24 << 30 | n24 >>> 2;
            n21 = (n22 << 5 | n22 >>> 27) + (n23 & n24 | ~n23 & n25) + n4 + this.W[n3 + 5] + 1518500249;
            n23 = n23 << 30 | n23 >>> 2;
        }
        n4 = (n21 << 5 | n21 >>> 27) + (n22 & n23 | ~n22 & n24) + n25 + this.W[18] + 1518500249;
        n22 = n22 << 30 | n22 >>> 2;
        n25 = (n4 << 5 | n4 >>> 27) + (n21 & n22 | ~n21 & n23) + n24 + this.W[19] + 1518500249;
        n24 = n22;
        n22 = n4;
        n4 = n25;
        n25 = n23;
        n23 = n21 << 30 | n21 >>> 2;
        n21 = n4;
        for (n3 = 20; n3 < 38; n3 += 6) {
            n4 = (n21 << 5 | n21 >>> 27) + (n22 ^ n23 ^ n24) + n25 + this.W[n3] + 1859775393;
            n22 = n22 << 30 | n22 >>> 2;
            n25 = (n4 << 5 | n4 >>> 27) + (n21 ^ n22 ^ n23) + n24 + this.W[n3 + 1] + 1859775393;
            n21 = n21 << 30 | n21 >>> 2;
            n24 = (n25 << 5 | n25 >>> 27) + (n4 ^ n21 ^ n22) + n23 + this.W[n3 + 2] + 1859775393;
            n4 = n4 << 30 | n4 >>> 2;
            n23 = (n24 << 5 | n24 >>> 27) + (n25 ^ n4 ^ n21) + n22 + this.W[n3 + 3] + 1859775393;
            n25 = n25 << 30 | n25 >>> 2;
            n22 = (n23 << 5 | n23 >>> 27) + (n24 ^ n25 ^ n4) + n21 + this.W[n3 + 4] + 1859775393;
            n24 = n24 << 30 | n24 >>> 2;
            n21 = (n22 << 5 | n22 >>> 27) + (n23 ^ n24 ^ n25) + n4 + this.W[n3 + 5] + 1859775393;
            n23 = n23 << 30 | n23 >>> 2;
        }
        n4 = (n21 << 5 | n21 >>> 27) + (n22 ^ n23 ^ n24) + n25 + this.W[38] + 1859775393;
        n25 = n24;
        n24 = n23;
        n23 = n22 << 30 | n22 >>> 2;
        n22 = n21;
        n21 = n4;
        n4 = (n21 << 5 | n21 >>> 27) + (n22 ^ n23 ^ n24) + n25 + this.W[39] + 1859775393;
        n25 = n24;
        n24 = n23;
        n23 = n22 << 30 | n22 >>> 2;
        n22 = n21;
        n21 = n4;
        for (n3 = 40; n3 < 58; n3 += 6) {
            n4 = (n21 << 5 | n21 >>> 27) + (n22 & n23 | n22 & n24 | n23 & n24) + n25 + this.W[n3] + -1894007588;
            n22 = n22 << 30 | n22 >>> 2;
            n25 = (n4 << 5 | n4 >>> 27) + (n21 & n22 | n21 & n23 | n22 & n23) + n24 + this.W[n3 + 1] + -1894007588;
            n21 = n21 << 30 | n21 >>> 2;
            n24 = (n25 << 5 | n25 >>> 27) + (n4 & n21 | n4 & n22 | n21 & n22) + n23 + this.W[n3 + 2] + -1894007588;
            n4 = n4 << 30 | n4 >>> 2;
            n23 = (n24 << 5 | n24 >>> 27) + (n25 & n4 | n25 & n21 | n4 & n21) + n22 + this.W[n3 + 3] + -1894007588;
            n25 = n25 << 30 | n25 >>> 2;
            n22 = (n23 << 5 | n23 >>> 27) + (n24 & n25 | n24 & n4 | n25 & n4) + n21 + this.W[n3 + 4] + -1894007588;
            n24 = n24 << 30 | n24 >>> 2;
            n21 = (n22 << 5 | n22 >>> 27) + (n23 & n24 | n23 & n25 | n24 & n25) + n4 + this.W[n3 + 5] + -1894007588;
            n23 = n23 << 30 | n23 >>> 2;
        }
        n4 = (n21 << 5 | n21 >>> 27) + (n22 & n23 | n22 & n24 | n23 & n24) + n25 + this.W[58] + -1894007588;
        n25 = n24;
        n24 = n23;
        n23 = n22 << 30 | n22 >>> 2;
        n22 = n21;
        n21 = n4;
        n4 = (n21 << 5 | n21 >>> 27) + (n22 & n23 | n22 & n24 | n23 & n24) + n25 + this.W[59] + -1894007588;
        n25 = n24;
        n24 = n23;
        n23 = n22 << 30 | n22 >>> 2;
        n22 = n21;
        n21 = n4;
        for (n3 = 60; n3 < 78; n3 += 6) {
            n4 = (n21 << 5 | n21 >>> 27) + (n22 ^ n23 ^ n24) + n25 + this.W[n3] + -899497514;
            n22 = n22 << 30 | n22 >>> 2;
            n25 = (n4 << 5 | n4 >>> 27) + (n21 ^ n22 ^ n23) + n24 + this.W[n3 + 1] + -899497514;
            n21 = n21 << 30 | n21 >>> 2;
            n24 = (n25 << 5 | n25 >>> 27) + (n4 ^ n21 ^ n22) + n23 + this.W[n3 + 2] + -899497514;
            n4 = n4 << 30 | n4 >>> 2;
            n23 = (n24 << 5 | n24 >>> 27) + (n25 ^ n4 ^ n21) + n22 + this.W[n3 + 3] + -899497514;
            n25 = n25 << 30 | n25 >>> 2;
            n22 = (n23 << 5 | n23 >>> 27) + (n24 ^ n25 ^ n4) + n21 + this.W[n3 + 4] + -899497514;
            n24 = n24 << 30 | n24 >>> 2;
            n21 = (n22 << 5 | n22 >>> 27) + (n23 ^ n24 ^ n25) + n4 + this.W[n3 + 5] + -899497514;
            n23 = n23 << 30 | n23 >>> 2;
        }
        n4 = (n21 << 5 | n21 >>> 27) + (n22 ^ n23 ^ n24) + n25 + this.W[78] + -899497514;
        n25 = n24;
        n24 = n23;
        n23 = n22 << 30 | n22 >>> 2;
        n22 = n21;
        n21 = n4;
        n4 = (n21 << 5 | n21 >>> 27) + (n22 ^ n23 ^ n24) + n25 + this.W[79] + -899497514;
        n25 = n24;
        n24 = n23;
        n23 = n22 << 30 | n22 >>> 2;
        n22 = n21;
        n21 = n4;
        this.state[0] = this.state[0] + n21;
        this.state[1] = this.state[1] + n22;
        this.state[2] = this.state[2] + n23;
        this.state[3] = this.state[3] + n24;
        this.state[4] = this.state[4] + n25;
    }

    public static void zeroBlock(byte[] byArray, int n2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            byArray[i2] = 0;
        }
    }

    public static void zeroBlock(int[] nArray, int n2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            nArray[i2] = 0;
        }
    }

    public static void zeroBlock(byte[] byArray) {
        SHA.zeroBlock(byArray, 0, byArray.length);
    }

    public static void zeroBlock(int[] nArray) {
        SHA.zeroBlock(nArray, 0, nArray.length);
    }

    public static void copyBlock(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray2[n3 + i2] = byArray[n2 + i2];
        }
    }

    public static void copyBlock(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[i2] = byArray[i2];
        }
    }

    public static void copyBlock(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray2[n3 + i2] = nArray[n2 + i2];
        }
    }

    public static void copyBlock(int[] nArray, int[] nArray2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = nArray[i2];
        }
    }
}

