/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink.columns;

import com.metamatrix.jdbc.sequelink.columns.SequeLinkColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkColumnDescribe;
import com.metamatrix.jdbc.sequelink.utilities.ObjectArray;
import com.metamatrix.jdbc.slbase.BaseData;
import com.metamatrix.sequelink.ctxt.stmt.StatementContext;
import com.metamatrix.sequelink.ssp.DiagnosticList;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.slutil.UtilException;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class SequeLinkBigintColumn
extends SequeLinkColumn {
    private ObjectArray array = new ObjectArray();

    public SequeLinkBigintColumn(StatementContext statementContext, SequeLinkColumnDescribe sequeLinkColumnDescribe, int n) throws SQLException {
        super(statementContext, sequeLinkColumnDescribe, n, 5);
    }

    protected void setBindInfo() {
        this.sqlnkType = 11;
        this.sqlnkSize = this.precision;
    }

    protected void readDataFromStream(SspInputStream sspInputStream) throws IOException, UtilException {
        this.array.add(sspInputStream.readSSPBcdType(0));
    }

    protected void readNull() {
        this.array.add(null);
    }

    public BaseData getData(int n, int n2, DiagnosticList diagnosticList) throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)this.array.get(n2);
        if (bigDecimal == null) {
            this.myBaseData.setNull(this.baseDataType);
        } else {
            switch (n) {
                case 5: {
                    this.myBaseData.setLong(bigDecimal.longValue());
                    break;
                }
                case 10: {
                    this.myBaseData.setString(bigDecimal.toString());
                    break;
                }
                case 8: {
                    this.myBaseData.setBigDecimal(bigDecimal);
                    break;
                }
                default: {
                    this.myBaseData.setLong(bigDecimal.longValue());
                }
            }
        }
        return this.myBaseData;
    }

    public void clearData() {
        this.array.reset();
    }
}

