/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseColumn;
import com.metamatrix.jdbc.slbase.BaseData;
import com.metamatrix.jdbc.slbase.BaseImplResultSetService;
import com.metamatrix.jdbc.slbase.BaseResultSetSortDescriptor;
import com.metamatrix.slutil.UtilTempFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;

public final class BaseImplResultSetClientSideSorter
extends BaseImplResultSetService {
    private File rowPositionFileHandle;
    private RandomAccessFile rowPositionFile;
    boolean haveSortedRows = false;
    BaseResultSetSortDescriptor sortDescriptor;
    private BaseData[] sortedRow;
    private BaseData[] nextRowToBeSorted;

    public void postSetupInitialize() throws SQLException {
        this.setupTempFile();
        super.postSetupInitialize();
    }

    public void setSortCriteria(BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        this.sortDescriptor = baseResultSetSortDescriptor;
    }

    private void setupTempFile() throws SQLException {
        try {
            this.rowPositionFileHandle = UtilTempFile.createTempFile("srt_");
            this.rowPositionFile = new RandomAccessFile(this.rowPositionFileHandle, "rw");
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6038);
        }
    }

    public void close() throws SQLException {
        super.close();
        try {
            this.rowPositionFile.close();
            this.rowPositionFileHandle.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getColumnAccess() {
        return 2;
    }

    public void setFetchSize(int n2) {
    }

    public boolean fetchAtPosition(int n2) throws SQLException {
        if (!this.haveSortedRows) {
            this.initializeRows();
            this.fetchAndSortRows();
        }
        if (n2 > this.maxCursorPosition) {
            return false;
        }
        this.getSortedFromSubResultSet(n2, false);
        return true;
    }

    private void fetchAndSortRows() throws SQLException {
        boolean bl;
        int n2 = 1;
        do {
            if (!(bl = this.subImplResultSet.fetchAtPosition(n2))) continue;
            this.getCurrentFromSubResultSet(this.nextRowToBeSorted, false);
            this.insertSubResultSetRowIntoSortList(n2);
            ++n2;
        } while (bl);
        this.haveSortedRows = true;
        this.maxCursorPosition = n2 - 1;
    }

    private void insertSubResultSetRowIntoSortList(int n2) throws SQLException {
        try {
            int n3;
            int n4;
            int n5 = 0;
            boolean bl = true;
            if (n2 != 1) {
                int n6;
                n4 = 1;
                n3 = n2;
                int n7 = (n4 + n3) / 2;
                boolean bl2 = false;
                do {
                    n6 = n7;
                    this.getSortedFromSubResultSet(n7, true);
                    bl = this.compareCurrentRows();
                    if (bl) {
                        n4 = n7;
                        bl2 = true;
                        continue;
                    }
                    n3 = n7;
                    bl2 = false;
                } while (n6 != (n7 = (n4 + n3) / 2));
                n5 = n7 - 1 + (bl2 ? 1 : 0);
            }
            n4 = n2;
            n3 = 0;
            while (n5 < n2) {
                if (n5 != n2 - 1) {
                    this.rowPositionFile.seek(n5 * 4);
                    n3 = this.rowPositionFile.readInt();
                }
                this.rowPositionFile.seek(n5 * 4);
                this.rowPositionFile.writeInt(n4);
                n4 = n3;
                ++n5;
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6043);
        }
    }

    private void getSortedFromSubResultSet(int n2, boolean bl) throws SQLException {
        try {
            this.rowPositionFile.seek((n2 - 1) * 4);
            n2 = this.rowPositionFile.readInt();
            this.subImplResultSet.fetchAtPosition(n2);
            this.getCurrentFromSubResultSet(this.sortedRow, bl);
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6038);
        }
    }

    private void getCurrentFromSubResultSet(BaseData[] baseDataArray, boolean bl) throws SQLException {
        if (bl) {
            int n2 = this.sortDescriptor.getSortCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = this.sortDescriptor.getSortColumnOrdinal(i2);
                BaseData baseData = this.subImplResultSet.getData(n3, this.columns.get((int)n3).baseDataType);
                baseDataArray[n3 - 1].populate(baseData);
            }
        } else {
            int n4 = this.columns.count(1);
            for (int i3 = 1; i3 <= n4; ++i3) {
                BaseData baseData = this.subImplResultSet.getData(i3, this.columns.get((int)i3).baseDataType);
                baseDataArray[i3 - 1].populate(baseData);
            }
        }
    }

    private boolean compareCurrentRows() throws SQLException {
        int n2 = 0;
        for (int i2 = 0; i2 < this.sortDescriptor.getSortCount() && n2 == 0; ++i2) {
            int n3 = this.sortDescriptor.getSortColumnOrdinal(i2);
            n2 = BaseData.compare(this.nextRowToBeSorted[n3 - 1], this.sortedRow[n3 - 1], BaseData.mapJDBCTypeToJavaObjectType(this.columns.get((int)n3).type), this.implStatement.implConnection.exceptions);
        }
        return n2 >= 0;
    }

    private void initializeRows() {
        int n2 = this.columns.count(1);
        this.sortedRow = new BaseData[n2];
        this.nextRowToBeSorted = new BaseData[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            BaseColumn baseColumn = this.columns.get(i2 + 1);
            this.sortedRow[i2] = new BaseData();
            this.nextRowToBeSorted[i2] = new BaseData();
        }
    }

    public BaseData getData(int n2, int n3) throws SQLException {
        return this.sortedRow[n2 - 1];
    }
}

