/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.ui.reconciler;

import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelObjectUtilities;
import com.metamatrix.modeler.transformation.ui.UiConstants;
import com.metamatrix.modeler.transformation.ui.UiPlugin;
import com.metamatrix.modeler.transformation.ui.reconciler.Binding;
import com.metamatrix.modeler.transformation.ui.reconciler.BindingList;
import com.metamatrix.modeler.transformation.ui.reconciler.BindingsTablePanel;
import com.metamatrix.modeler.transformation.ui.reconciler.IBindingListViewer;
import com.metamatrix.modeler.transformation.ui.reconciler.ISqlListViewer;
import com.metamatrix.modeler.transformation.ui.reconciler.QueryReconcilerHelper;
import com.metamatrix.modeler.transformation.ui.reconciler.ReconcilerDialog;
import com.metamatrix.modeler.transformation.ui.reconciler.ReconcilerObject;
import com.metamatrix.modeler.transformation.ui.reconciler.SqlList;
import com.metamatrix.modeler.transformation.ui.reconciler.SqlTablePanel;
import com.metamatrix.query.internal.ui.builder.ExpressionBuilder;
import com.metamatrix.query.internal.ui.builder.util.ElementViewerFactory;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.ui.sqleditor.SqlDisplayPanel;
import com.metamatrix.ui.graphics.GlobalUiFontManager;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.widget.Label;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ReconcilerPanel
extends SashForm
implements ISelectionChangedListener,
SelectionListener {
    private static final int BUTTON_GRID_STYLE = 320;
    private final String BIND_BUTTON_TEXT = UiConstants.Util.getString("ReconcilerPanel.bindButton.text");
    private final String UNBIND_BUTTON_TEXT = UiConstants.Util.getString("ReconcilerPanel.unbindButton.text");
    private final String NEW_ATTR_BUTTON_TEXT = UiConstants.Util.getString("ReconcilerPanel.newAttrButton.text");
    private final String SET_TO_NULL_BUTTON_TEXT = UiConstants.Util.getString("ReconcilerPanel.setToNullButton.text");
    private final String SET_TO_EXPRESSION_BUTTON_TOOLTIP = UiConstants.Util.getString("ReconcilerPanel.setToExpressionButton.toolTip");
    private final String SHOW_SQL_CHECKBOX_TEXT = UiConstants.Util.getString("ReconcilerPanel.showSqlCheckbox.text");
    private final String QUERY_SCOPE_TEXT = UiConstants.Util.getString("ReconcilerPanel.queryScope.text");
    private final String UNION_SCOPE_TEXT = UiConstants.Util.getString("ReconcilerPanel.unionScope.text");
    private final String UNION_SEGMENT_SCOPE_TEXT = UiConstants.Util.getString("ReconcilerPanel.unionSegmentScope.text");
    private final String DIALOG_STATUS_TITLE = UiConstants.Util.getString("ReconcilerPanel.statusTitle");
    private final String EXPRESSION = "expr";
    private QueryReconcilerHelper reconcilerHelper;
    private ReconcilerObject reconcilerObject;
    private boolean isUnion = false;
    private List builderGroups = new ArrayList();
    private Composite controlsPanel;
    private BindingsTablePanel bindingsPanel;
    private SqlTablePanel sqlListPanel;
    private boolean sqlShowing = true;
    private SqlDisplayPanel sqlDisplay;
    private ReconcilerDialog reconcilerDialog = null;
    private SashForm topSplitter;
    private Button showSqlCheckbox;
    private Button bindButton;
    private Button unbindButton;
    private Button newAttrButton;
    private Button nullButton;
    private Button expressionButton;
    private boolean isReadOnly = false;
    private Font fNewBoldFont;
    static /* synthetic */ Class class$java$lang$String;

    public ReconcilerPanel(Composite parent, ReconcilerDialog dialog, Object transformationObj, boolean isUnion, int unionQuerySegment, List builderGroups) {
        super(parent, 512);
        if (transformationObj instanceof SqlTransformationMappingRoot) {
            this.reconcilerHelper = new QueryReconcilerHelper((SqlTransformationMappingRoot)transformationObj, unionQuerySegment);
            this.reconcilerObject = this.reconcilerHelper.getReconcilerObject();
        }
        if (transformationObj instanceof EObject) {
            this.isReadOnly = ModelObjectUtilities.isReadOnly((EObject)((EObject)transformationObj));
        }
        this.isUnion = isUnion;
        this.reconcilerDialog = dialog;
        this.builderGroups.addAll(builderGroups);
        this.init();
    }

    private void init() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        this.setLayoutData(gridData);
        this.createControlsPanel();
        this.createSqlDisplayPanel();
        int[] wts = new int[]{4, 1};
        this.setWeights(wts);
        if (this.reconcilerObject != null) {
            BindingList bList = this.reconcilerObject.getBindingList();
            SqlList sList = this.reconcilerObject.getSqlList();
            this.bindingsPanel.setBindingList(bList);
            this.sqlListPanel.setSqlList(sList);
            this.sqlListPanel.setAvailableSymbolNames(this.reconcilerObject.getAvailableElementSymbols());
            bList.addChangeListener((IBindingListViewer)new BindingChangeHandler());
            sList.addChangeListener((ISqlListViewer)new SqlChangeHandler());
        }
        this.bindingsPanel.selectFirstUnbound();
        this.sqlListPanel.selectIndex(0);
        this.setButtonStates();
        String sql = this.reconcilerObject.getModifiedSql();
        this.setSqlDisplay(sql);
        this.reconcilerDialog.setTitle(this.DIALOG_STATUS_TITLE);
        this.updateMessageArea();
        this.bindingsPanel.setTargetLocked(this.reconcilerObject.isTargetLocked());
        this.bindingsPanel.setButtonStates();
        this.bindingsPanel.updateRowColors();
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        boolean showSql = prefStore.getBoolean("transformation.ui.preference.showSqlDisplay");
        this.showSqlCheckbox.setSelection(showSql);
        this.showSqlArea(showSql);
        this.showSqlCheckbox.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.bindingsPanel.addTableSelectionListener((ISelectionChangedListener)this);
        this.sqlListPanel.addTableSelectionListener((ISelectionChangedListener)this);
        this.bindingsPanel.addTargetLockedCheckboxListener((SelectionListener)this);
        this.updateSqlAndMessageDisplay();
    }

    private void createControlsPanel() {
        this.topSplitter = new SashForm((Composite)this, 256);
        this.createBindingTablePanel(this.topSplitter);
        this.controlsPanel = new Composite((Composite)this.topSplitter, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.controlsPanel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.controlsPanel.setLayoutData((Object)gridData);
        this.createBindButtonPanel();
        this.sqlListPanel = new SqlTablePanel(this.controlsPanel, this.isReadOnly);
        this.topSplitter.setWeights(new int[]{60, 40});
    }

    private void createBindingTablePanel(SashForm splitter) {
        boolean isPrimary = this.reconcilerHelper.isPrimarySelectClause();
        Composite panel = new Composite((Composite)splitter, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        panel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        panel.setLayoutData((Object)gridData);
        Label lblSecondaryMessage = null;
        lblSecondaryMessage = this.isUnion ? (isPrimary ? WidgetFactory.createLabel((Composite)panel, (String)this.UNION_SCOPE_TEXT) : WidgetFactory.createLabel((Composite)panel, (String)this.UNION_SEGMENT_SCOPE_TEXT)) : WidgetFactory.createLabel((Composite)panel, (String)this.QUERY_SCOPE_TEXT);
        if (!isPrimary) {
            lblSecondaryMessage.setFont(this.getBoldFont(lblSecondaryMessage.getFont()));
        }
        this.bindingsPanel = new BindingsTablePanel(panel, this.isReadOnly);
        this.showSqlCheckbox = WidgetFactory.createCheckBox((Composite)panel, (String)this.SHOW_SQL_CHECKBOX_TEXT);
    }

    private Font getBoldFont(Font f) {
        if (this.fNewBoldFont == null) {
            FontData data = f.getFontData()[0];
            data.setStyle(1);
            this.fNewBoldFont = GlobalUiFontManager.getFont((FontData)data);
        }
        return this.fNewBoldFont;
    }

    private void updateMessageArea() {
        String message = this.reconcilerObject.getStatus();
        int statusType = this.reconcilerObject.getStatusType();
        if (statusType == 0 && this.reconcilerObject.hasValidModifications()) {
            message = message + "  Press OK to accept changes.";
        }
        this.reconcilerDialog.setMessage(message, statusType);
    }

    private void createBindButtonPanel() {
        Composite bindButtonPanel = new Composite(this.controlsPanel, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        bindButtonPanel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.verticalAlignment = 2;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        bindButtonPanel.setLayoutData((Object)gridData);
        this.bindButton = WidgetFactory.createButton((Composite)bindButtonPanel, (String)this.BIND_BUTTON_TEXT, (int)320);
        this.bindButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.unbindButton = WidgetFactory.createButton((Composite)bindButtonPanel, (String)this.UNBIND_BUTTON_TEXT, (int)320);
        this.unbindButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.newAttrButton = WidgetFactory.createButton((Composite)bindButtonPanel, (String)this.NEW_ATTR_BUTTON_TEXT, (int)320);
        this.newAttrButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.nullButton = WidgetFactory.createButton((Composite)bindButtonPanel, (String)this.SET_TO_NULL_BUTTON_TEXT, (int)320);
        this.nullButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.expressionButton = WidgetFactory.createButton((Composite)bindButtonPanel, null, (int)320);
        this.expressionButton.setImage(UiPlugin.getDefault().getImage("icons/full/cview20/launch_expression_builder.gif"));
        this.expressionButton.setToolTipText(this.SET_TO_EXPRESSION_BUTTON_TOOLTIP);
        this.expressionButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createSqlDisplayPanel() {
        this.sqlDisplay = new SqlDisplayPanel((Composite)this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.sqlDisplay.setLayoutData((Object)gridData);
        if (this.reconcilerObject != null) {
            this.setSqlDisplay(this.reconcilerObject.getModifiedSql());
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object source = event.getSource();
        if (source.equals(this.bindingsPanel.getTableViewer())) {
            this.bindingsPanel.setButtonStates();
        } else if (source.equals(this.sqlListPanel.getTableViewer())) {
            this.sqlListPanel.setButtonStates();
            this.bindingsPanel.setButtonStates();
        }
        this.setButtonStates();
    }

    public void widgetSelected(SelectionEvent event) {
        boolean isLocked = this.bindingsPanel.isTargetLocked();
        this.reconcilerHelper.setTargetLocked(isLocked);
        this.setButtonStates();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void showSqlArea(boolean show) {
        if (show != this.sqlShowing) {
            if (show) {
                this.setMaximizedControl(null);
            } else {
                this.setMaximizedControl((Control)this.topSplitter);
            }
            this.sqlShowing = !this.sqlShowing;
        }
    }

    public boolean isSqlAreaVisible() {
        return this.sqlShowing;
    }

    private void setSqlDisplay(String sqlString) {
        if (sqlString != null) {
            this.sqlDisplay.setText(sqlString);
        } else {
            this.sqlDisplay.setText("");
        }
    }

    private void setButtonStates() {
        List selectedBindings = this.bindingsPanel.getSelectedBindings();
        List selectedSymbols = this.sqlListPanel.getSelectedSymbols();
        if (!this.isReadOnly) {
            this.bindButton.setEnabled(this.reconcilerObject.shouldEnableBind(selectedBindings, selectedSymbols));
            this.unbindButton.setEnabled(this.reconcilerObject.shouldEnableUnbind(selectedBindings));
            this.newAttrButton.setEnabled(true);
            this.nullButton.setEnabled(!selectedBindings.isEmpty());
            this.expressionButton.setEnabled(!selectedBindings.isEmpty());
        } else {
            this.bindButton.setEnabled(false);
            this.unbindButton.setEnabled(false);
            this.newAttrButton.setEnabled(false);
            this.nullButton.setEnabled(false);
            this.expressionButton.setEnabled(false);
        }
    }

    private void bindButtonPressed() {
        List selectedBindings = this.bindingsPanel.getSelectedBindings();
        List selectedSymbols = this.sqlListPanel.getSelectedSymbols();
        Binding lastSelectedBinding = this.getLastBinding(selectedBindings);
        int lastSelectedIndex = this.getLastSymbolIndex();
        this.reconcilerObject.bind(selectedBindings, selectedSymbols);
        String sql = this.reconcilerObject.getModifiedSql();
        this.setSqlDisplay(sql);
        this.updateMessageArea();
        this.bindingsPanel.selectNextUnbound(lastSelectedBinding);
        this.sqlListPanel.selectIndex(lastSelectedIndex);
        this.bindingsPanel.updateRowColors();
        this.sqlListPanel.setButtonStates();
    }

    private void unbindButtonPressed() {
        List selectedBindings = this.bindingsPanel.getSelectedBindings();
        Binding lastSelection = this.getLastBinding(selectedBindings);
        this.reconcilerObject.unbind(selectedBindings);
        String sql = this.reconcilerObject.getModifiedSql();
        this.setSqlDisplay(sql);
        this.updateMessageArea();
        this.bindingsPanel.selectNextBound(lastSelection);
        this.bindingsPanel.updateRowColors();
        this.sqlListPanel.setButtonStates();
    }

    private void newAttributeButtonPressed() {
        List selectedSqlList = this.sqlListPanel.getSelectedSymbols();
        this.reconcilerObject.createNewBindings(selectedSqlList);
        String sql = this.reconcilerObject.getModifiedSql();
        this.setSqlDisplay(sql);
        this.updateMessageArea();
        this.bindingsPanel.updateRowColors();
    }

    private Binding getLastBinding(List bindings) {
        Binding last = null;
        if (bindings.size() > 0) {
            last = (Binding)bindings.get(bindings.size() - 1);
        }
        return last;
    }

    private int getLastSymbolIndex() {
        SqlList sqlList = this.sqlListPanel.getSqlList();
        int indexOfLast = 0;
        if (sqlList.size() > 0) {
            SingleElementSymbol symbol = sqlList.getSymbolAt(sqlList.size() - 1);
            indexOfLast = sqlList.indexOf(symbol);
        }
        return indexOfLast;
    }

    public boolean hasValidModifications() {
        return this.reconcilerObject.hasValidModifications();
    }

    public void applyAllModifications(int uIndex, Object txnSource) {
        this.reconcilerHelper.applyAllModifications(uIndex, txnSource);
    }

    public String getModifiedSql() {
        return this.reconcilerObject.getModifiedSql();
    }

    private void toggleSqlButtonPressed() {
        boolean isCurrentlyVisible = this.isSqlAreaVisible();
        this.showSqlArea(!isCurrentlyVisible);
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        prefStore.setValue("transformation.ui.preference.showSqlDisplay", !isCurrentlyVisible);
        UiPlugin.getDefault().savePluginPreferences();
    }

    private void updateSqlAndMessageDisplay() {
        this.reconcilerObject.updateCommandFromBindings();
        String sql = this.reconcilerObject.getModifiedSql();
        this.setSqlDisplay(sql);
        this.updateMessageArea();
    }

    private void setToNullButtonPressed() {
        if (this.reconcilerObject != null) {
            List selectedBindings = this.bindingsPanel.getSelectedBindings();
            this.reconcilerObject.unbind(this.bindingsPanel.getSelectedBindings());
            ArrayList<ExpressionSymbol> symbolsList = new ArrayList<ExpressionSymbol>(selectedBindings.size());
            for (int i = 0; i < selectedBindings.size(); ++i) {
                Constant nullConstant = new Constant(null, class$java$lang$String == null ? ReconcilerPanel.class$("java.lang.String") : class$java$lang$String);
                ExpressionSymbol nullExpression = new ExpressionSymbol("expr", (Expression)nullConstant);
                symbolsList.add(nullExpression);
            }
            this.reconcilerObject.bind(selectedBindings, symbolsList);
            this.bindingsPanel.updateRowColors();
        }
        this.bindingsPanel.getBindingList().refresh(true);
        this.setButtonStates();
    }

    private Shell getCurrentShell() {
        return UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private void expressionButtonPressed() {
        if (this.reconcilerObject != null) {
            if (!this.builderGroups.isEmpty()) {
                ElementViewerFactory.setViewerInput((Object)this.builderGroups);
            }
            ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getCurrentShell());
            expressionBuilder.create();
            List selBindings = this.bindingsPanel.getSelectedBindings();
            Expression startingLO = null;
            if (selBindings.size() == 1) {
                SingleElementSymbol expSymbol = null;
                SingleElementSymbol symbol = ((Binding)selBindings.get(0)).getCurrentSymbol();
                if (symbol instanceof AliasSymbol) {
                    expSymbol = ((AliasSymbol)symbol).getSymbol();
                    if (expSymbol instanceof ExpressionSymbol) {
                        startingLO = ((ExpressionSymbol)expSymbol).getExpression();
                    }
                } else if (symbol instanceof ExpressionSymbol) {
                    startingLO = ((ExpressionSymbol)symbol).getExpression();
                }
            }
            expressionBuilder.setLanguageObject(startingLO);
            int status = expressionBuilder.open();
            if (status == 0) {
                LanguageObject langObj = expressionBuilder.getLanguageObject();
                List selectedBindings = this.bindingsPanel.getSelectedBindings();
                this.reconcilerObject.unbind(this.bindingsPanel.getSelectedBindings());
                ArrayList<ExpressionSymbol> symbolsList = new ArrayList<ExpressionSymbol>(1);
                if (langObj instanceof Expression) {
                    ExpressionSymbol newExpression = new ExpressionSymbol("expr", (Expression)langObj);
                    symbolsList.add(newExpression);
                    this.reconcilerObject.bind(selectedBindings, symbolsList);
                    this.bindingsPanel.getBindingList().refresh(true);
                    this.bindingsPanel.updateRowColors();
                    this.setButtonStates();
                }
            }
        }
    }

    public void dispose() {
        if (this.fNewBoldFont != null && !this.fNewBoldFont.isDisposed()) {
            this.fNewBoldFont.dispose();
        }
        super.dispose();
    }

    public void preDispose() {
        if (this.hasValidModifications()) {
            this.sqlListPanel.preDispose(!this.isUnion);
        }
    }

    static /* synthetic */ void access$000(ReconcilerPanel x0) {
        x0.toggleSqlButtonPressed();
    }

    static /* synthetic */ void access$100(ReconcilerPanel x0) {
        x0.bindButtonPressed();
    }

    static /* synthetic */ void access$200(ReconcilerPanel x0) {
        x0.unbindButtonPressed();
    }

    static /* synthetic */ void access$300(ReconcilerPanel x0) {
        x0.newAttributeButtonPressed();
    }

    static /* synthetic */ void access$400(ReconcilerPanel x0) {
        x0.setToNullButtonPressed();
    }

    static /* synthetic */ void access$500(ReconcilerPanel x0) {
        x0.expressionButtonPressed();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SqlChangeHandler
    implements ISqlListViewer {
        SqlChangeHandler() {
        }

        public void addSymbol(SingleElementSymbol symbol) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        public void insertSymbol(SingleElementSymbol symbol, int index) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        public void addSymbols(Object[] symbols) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        public void removeSymbol(SingleElementSymbol symbol) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        public void removeSymbols(Object[] symbols) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        public void updateSymbol(SingleElementSymbol symbol) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        public void refresh(boolean updateLabels) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }
    }

    class BindingChangeHandler
    implements IBindingListViewer {
        BindingChangeHandler() {
        }

        public void addBinding(Binding binding) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        public void insertBinding(Binding binding, int index) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        public void addBindings(Object[] bindings) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        public void removeBinding(Binding binding) {
            SingleElementSymbol sqlSymbol = binding.getCurrentSymbol();
            if (sqlSymbol != null && sqlSymbol instanceof SingleElementSymbol) {
                SingleElementSymbol seSymbol = sqlSymbol;
                ReconcilerPanel.this.sqlListPanel.addSymbol(seSymbol);
            }
            ReconcilerPanel.this.sqlListPanel.selectIndex(0);
        }

        public void removeBindings(Object[] bindings) {
            for (int i = 0; i < bindings.length; ++i) {
                Binding binding = (Binding)bindings[i];
                SingleElementSymbol sqlSymbol = binding.getCurrentSymbol();
                if (sqlSymbol == null || !(sqlSymbol instanceof SingleElementSymbol)) continue;
                SingleElementSymbol seSymbol = sqlSymbol;
                ReconcilerPanel.this.sqlListPanel.addSymbol(seSymbol);
            }
            ReconcilerPanel.this.sqlListPanel.selectIndex(0);
        }

        public void updateBinding(Binding binding) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        public void refresh(boolean updateLabels) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }
    }
}

