/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.sybase;

import com.metamatrix.jdbcx.base.BaseXid;
import javax.transaction.xa.Xid;

public class SybaseXid
extends BaseXid {
    private static String footprint = "$Revision:   3.2.4.0  $";
    static final String codeMap = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ@#";
    String rmName = "ddtek-jdbc";
    String encoded;

    public SybaseXid(int n, byte[] byArray, byte[] byArray2) {
        super(n, byArray, byArray2);
        this.encode();
    }

    SybaseXid(int n, byte[] byArray, byte[] byArray2, String string) {
        super(n, byArray, byArray2);
        this.rmName = string;
        this.encode();
    }

    SybaseXid(Xid xid) {
        this.formatId = xid.getFormatId();
        this.gtrid = xid.getGlobalTransactionId();
        this.bqual = xid.getBranchQualifier();
        if (xid instanceof SybaseXid) {
            this.rmName = ((SybaseXid)xid).getResourceManagerName();
        }
        this.encode();
    }

    SybaseXid(String string) {
        this.encoded = string;
        int n = string.indexOf("_");
        int n2 = string.indexOf("_", n + 1);
        int n3 = string.indexOf(":", n2);
        this.formatId = Integer.parseInt(string.substring(0, n), 16);
        this.gtrid = SybaseXid.byteDecode(string.substring(n + 1, n2));
        if (n3 == -1) {
            this.bqual = SybaseXid.byteDecode(string.substring(n2 + 1));
        } else {
            this.bqual = SybaseXid.byteDecode(string.substring(n2 + 1, n3));
            this.rmName = string.substring(n3 + 1);
        }
    }

    void encode() {
        this.encoded = SybaseXid.hexConvert(this.formatId, 4) + "_" + SybaseXid.byteEncode(this.gtrid) + "_" + SybaseXid.byteEncode(this.bqual);
    }

    String getResourceManagerName() {
        return this.rmName;
    }

    String getEncodedString() {
        return this.encoded;
    }

    private static final byte[] byteDecode(String string) {
        int n;
        int n2;
        int n3;
        char[] cArray = string.toCharArray();
        int n4 = cArray.length * 3 / 4;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        for (n3 = 0; n3 < cArray.length - 3; n3 += 4) {
            n2 = codeMap.indexOf(cArray[n3]) << 2;
            n = (codeMap.indexOf(cArray[n3 + 1]) & 0x30) >> 4;
            byArray[n5++] = (byte)(n2 | n);
            n2 = (codeMap.indexOf(cArray[n3 + 1]) & 0xF) << 4;
            n = (codeMap.indexOf(cArray[n3 + 2]) & 0x3E) >> 2;
            byArray[n5++] = (byte)(n2 | n);
            n2 = (codeMap.indexOf(cArray[n3 + 2]) & 3) << 6;
            n = codeMap.indexOf(cArray[n3 + 3]) & 0x3F;
            byArray[n5++] = (byte)(n2 | n);
        }
        switch (cArray.length - n3) {
            case 3: {
                n2 = (codeMap.indexOf(cArray[n3]) & 0x3F) << 2;
                n = (codeMap.indexOf(cArray[n3 + 1]) & 0x30) >> 4;
                byArray[n5++] = (byte)(n2 | n);
                n2 = (codeMap.indexOf(cArray[n3 + 1]) & 0xF) << 4;
                n = (codeMap.indexOf(cArray[n3 + 2]) & 0x3E) >> 2;
                byArray[n5] = (byte)(n2 | n);
                break;
            }
            case 2: {
                int n6 = (codeMap.indexOf(cArray[n3]) & 0x3F) << 2;
                int n7 = (codeMap.indexOf(cArray[n3 + 1]) & 0x30) >> 4;
                byArray[n5] = (byte)(n6 | n7);
                break;
            }
            case 0: {
                --n5;
            }
        }
        return byArray;
    }

    private static final String byteEncode(byte[] byArray) {
        int n;
        int n2;
        int n3 = byArray.length * 4 / 3 + (byArray.length % 3 != 0 ? 1 : 0);
        char[] cArray = new char[n3];
        int n4 = 0;
        for (n2 = 0; n2 < byArray.length - 2; n2 += 3) {
            n = byArray[n2] >> 2 & 0x3F;
            cArray[n4++] = codeMap.charAt(n);
            n = (byArray[n2] << 4 | byArray[n2 + 1] >> 4 & 0xF) & 0x3F;
            cArray[n4++] = codeMap.charAt(n);
            n = (byArray[n2 + 1] << 2 | byArray[n2 + 2] >> 6 & 3) & 0x3F;
            cArray[n4++] = codeMap.charAt(n);
            n = byArray[n2 + 2] & 0x3F;
            cArray[n4++] = codeMap.charAt(n);
        }
        switch (byArray.length - n2) {
            case 2: {
                n = byArray[n2] >> 2 & 0x3F;
                cArray[n4++] = codeMap.charAt(n);
                n = (byArray[n2] << 4 | byArray[n2 + 1] >> 4 & 0xF) & 0x3F;
                cArray[n4++] = codeMap.charAt(n);
                n = byArray[n2 + 1] << 2 & 0x3F;
                cArray[n4] = codeMap.charAt(n);
                break;
            }
            case 1: {
                int n5 = byArray[n2] >> 2 & 0x3F;
                cArray[n4++] = codeMap.charAt(n5);
                n5 = byArray[n2] << 4 & 0x3F;
                cArray[n4] = codeMap.charAt(n5);
                break;
            }
            case 0: {
                --n4;
            }
        }
        return new String(cArray);
    }

    private static final String hexConvert(int n, int n2) {
        String string = "FFFFFFFFFFFFFFFF";
        String string2 = Integer.toHexString(n).toUpperCase();
        int n3 = n2 * 2 - string2.length();
        if (n3 < 0) {
            if (string2.regionMatches(0, string, 0, -n3)) {
                string2 = string2.substring(-n3, string2.length());
            } else {
                throw new IllegalArgumentException("The value translates to more than the specified number of digits");
            }
        }
        while (n3-- > 0) {
            string2 = "0" + string2;
        }
        return string2;
    }
}

