/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.util;

import com.metamatrix.sequelink.Message;
import com.metamatrix.sequelink.util.Port;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class InputDialog {
    private static final String RESOURCE_NAME = "com.metamatrix.sequelink.util.util";
    private static final String OK_LABEL = "btn.OK";
    private static final String CANCEL_LABEL = "btn.CANCEL";
    private static final Dimension SIZE = new Dimension(350, 150);
    private Frame frame = new Frame();
    private Button okButton = new Button();
    private Button cancelButton = new Button();
    private Label messageLabel = new Label();
    private TextField inputField = new TextField();
    private String inputText;
    private Port port;

    public InputDialog(Port port, String string, String string2, boolean bl) {
        this(port, string, string2);
        if (bl) {
            this.inputField.setEchoChar('*');
        }
    }

    public InputDialog(Port port, String string, String string2) {
        this.port = port;
        this.frame.setTitle(string);
        this.frame.setLayout(new GridBagLayout());
        Dimension dimension = this.frame.getToolkit().getScreenSize();
        this.frame.setLocation((dimension.width - InputDialog.SIZE.width) / 2, (dimension.height - InputDialog.SIZE.height) / 2);
        this.frame.setBackground(SystemColor.control);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                InputDialog.this.port.send(null);
            }
        });
        this.messageLabel.setText(string2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.frame.add((Component)this.messageLabel, gridBagConstraints);
        this.inputField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputDialog.this.port.send(InputDialog.this.inputField.getText());
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.frame.add((Component)this.inputField, gridBagConstraints);
        Panel panel = new Panel(new GridLayout(1, 2, 10, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.frame.add((Component)panel, gridBagConstraints);
        this.okButton.setLabel(new Message(RESOURCE_NAME).getMessage(OK_LABEL));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputDialog.this.port.send(InputDialog.this.inputField.getText());
            }
        });
        panel.add(this.okButton);
        this.cancelButton.setLabel(new Message(RESOURCE_NAME).getMessage(CANCEL_LABEL));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputDialog.this.port.send(null);
            }
        });
        panel.add(this.cancelButton);
        this.frame.setSize(SIZE);
        this.frame.setVisible(true);
    }

    public void destroy() {
        this.frame.dispose();
    }
}

