/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle;

import com.metamatrix.jdbc.base.BaseCharacterStreamWrapper;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseImplResultSetAutoGeneratedKeys;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.base.BaseInputStreamWrapper;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.jdbc.oracle.OracleColumn;
import com.metamatrix.jdbc.oracle.OracleImplBlob;
import com.metamatrix.jdbc.oracle.OracleImplClob;
import com.metamatrix.jdbc.oracle.OracleImplConnection;
import com.metamatrix.jdbc.oracle.OracleImplResultset;
import com.metamatrix.jdbc.oracle.OracleInternalParameter;
import com.metamatrix.jdbc.oracle.OracleInternalParameterSet;
import com.metamatrix.jdbc.oracle.OracleVNU;
import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.OracleNet8Communication;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTDAPacket;
import com.metamatrix.jdbc.oracle.net8.TTIDCBDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIFUNDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OALL7;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OALL8;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OALL_BASE;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OCANCEL;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_ODNY;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OLOBOPS;
import com.metamatrix.jdbc.oracle.net8.TTIIOVDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIOERDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIRXDDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIRXHDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTISCVDataPacket;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilVectorUnsynced;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.SQLException;

public class OracleImplStatement
extends BaseImplStatement {
    private static String footprint = "$Revision:   3.139.1.7  $";
    public OracleNet8Communication comm;
    public SQLException myException;
    public OracleImplConnection implConn;
    private short m_cursorID;
    private boolean isFirstExecute;
    private short currentCursorId;
    private int m_currentRefCursorParamIndex;
    int CurrentResultsetIndex;
    private int rowsAffected;
    private int currentResult;
    private int[] lastBatchAffectedRowcounts = null;
    private boolean executeAsNativeBatch;
    private int SQLStmtType;
    private TTIFUN_OALL_BASE m_ttifunall;
    private TTIFUN_OALL7 m_OAll7;
    private TTIFUN_OALL8 m_OAll8;
    private TTISCVDataPacket sentColumnsVector = new TTISCVDataPacket();
    BaseParameters savedProcParams = null;
    boolean stmtContainsWhereClause = false;
    private boolean[] lastRowReturnedByDatabase;
    private boolean defineIsRequired = true;
    private int[] rowsInBuffer;
    private int[] currentRowInBuffer;
    private int resultSetType;
    private int resultSetConcurrency;
    private boolean[] CursorVarsDefined;
    private boolean[] AllRowsFetched;
    private TTIOERDataPacket gTTIoer;
    private int arrayfetchsize = 0;
    private TTIFUN_OALL_BASE[] oAllFetch;
    private TTIRXHDataPacket fetchheader;
    private TTIRXDDataPacket[] fetchrows;
    private int FetchcolCount;
    private boolean isPreparedPreparedStatement = false;
    public BaseColumn[][] CurrentRSDescriptions;
    public int[] m_computedNumRowsToFetch;
    private OracleImplResultset m_currentImplResultSet = null;
    private String lastExecutedSQL;
    private String rememberedNativeSQL = null;
    int TotalNrResultsets;
    private BaseParameters bParams;
    private static byte[] nullValue = new byte[0];
    private static final int SQLTYPE_REF_CURSOR = -999;
    private int[] RememberedColumnTypes;
    private String[] RememberedColumnNames;
    String[] updateCols = null;
    boolean[] paramMayBeForLOBColumn = null;
    BaseColumns autogencolsdescription = null;
    BaseData[][] autogeneratedKeyArray = null;
    int numOrgParamsForGeneratedKeys;
    BaseParameters revisedParamsForGeneratedkeys = null;
    boolean isPLSQLBlock = false;
    protected OracleNet8NSPTDAPacket NSPTDAPacket;
    private byte[][] tempLOBLocatorCollection = null;
    private int numTempLOBs = 0;
    private OracleInternalParameterSet[] m_internalParamSets = null;
    private OracleInternalParameterSet m_orgParamBindInfo = null;
    private OracleInternalParameterSet m_requiredParamBindInfo = null;
    private int actualNumStoredProcParams = -1;
    private boolean isSelect;
    private boolean isDDLStatement;
    private boolean isUpdate;
    private boolean isStatementSuitableForReexecution;
    private storedProcParamInfo[] m_storedProcedureParamInfo = null;
    private TTIRXDDataPacket TTIRXDDataPacketForParams;
    private TTIFUN_OCANCEL reusablettifuncancel;
    byte[][][] cachedRows = null;
    int[][] cachedLens = null;

    public int getActualNumStoredProcParams() {
        if (this.actualNumStoredProcParams == -1) {
            this.actualNumStoredProcParams = 0;
            if (this.bParams != null) {
                for (int i = 1; i <= this.bParams.count(); ++i) {
                    try {
                        if (this.bParams.parametersIn[i - 1] == null && this.bParams.parametersOut[i - 1] == null) continue;
                        ++this.actualNumStoredProcParams;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return this.actualNumStoredProcParams;
    }

    public OracleImplStatement(int n, int n2, OracleNet8Communication oracleNet8Communication, OracleImplConnection oracleImplConnection) throws SQLException {
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.isPreparedPreparedStatement = false;
        this.comm = oracleNet8Communication;
        this.implConn = oracleImplConnection;
        this.CursorVarsDefined = new boolean[1];
        this.CursorVarsDefined[0] = false;
        this.AllRowsFetched = new boolean[1];
        this.AllRowsFetched[0] = false;
        this.m_currentRefCursorParamIndex = -1;
        this.CurrentResultsetIndex = 0;
        this.TotalNrResultsets = 0;
        this.fetchrows = new TTIRXDDataPacket[1];
        this.bParams = null;
        this.NSPTDAPacket = this.implConn.NSPTDAPacket;
        this.gTTIoer = new TTIOERDataPacket(this.implConn);
        this.m_ttifunall = null;
        this.TTIRXDDataPacketForParams = null;
        this.m_OAll8 = new TTIFUN_OALL8(this.implConn);
        if (this.implConn.useOAll7) {
            this.oAllFetch = new TTIFUN_OALL7[1];
            this.m_OAll7 = new TTIFUN_OALL7(this.implConn);
            this.m_ttifunall = this.m_OAll7;
        } else {
            this.oAllFetch = new TTIFUN_OALL8[1];
            this.m_ttifunall = this.m_OAll8;
        }
        this.m_cursorID = 0;
    }

    public void processCancelResponse() throws SQLException {
        try {
            OracleDataProvider oracleDataProvider = this.NSPTDAPacket.reader;
            oracleDataProvider.receive();
            if (oracleDataProvider.getNSPacketType() != 12) {
                oracleDataProvider.readByte();
                oracleDataProvider.readByte();
                this.processReply(this.m_ttifunall);
                oracleDataProvider.receivePacket();
            }
            this.NSPTDAPacket.CheckAndProcessMarkerPacket(new OracleDataConsumer(this.comm));
            this.NSPTDAPacket.receiveReply();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public BaseColumns describeAutoGeneratedKeyColumns() throws SQLException {
        if (this.autogencolsdescription == null) {
            OracleColumn oracleColumn = new OracleColumn(104, "ROWID", 18, 18, 18, 0, 0, 0, 0, this.implConn, this.comm.transliterator);
            this.autogencolsdescription = new BaseColumns();
            this.autogencolsdescription.add((BaseColumn)oracleColumn);
        }
        return this.autogencolsdescription;
    }

    public BaseImplResultSet getAutoGeneratedKeyResultSet() throws SQLException {
        if (this.autoGeneratedKeysRequested) {
            if (this.autogeneratedKeyArray == null) {
                this.autogeneratedKeyArray = new BaseData[1][1];
                this.autogeneratedKeyArray[0][0] = new BaseData((Object)this.gTTIoer.getRowIdString(), (BaseConnection)this.implConn.connection);
            } else {
                this.autogeneratedKeyArray[0][0].setString(this.gTTIoer.getRowIdString());
            }
        } else if (this.requestedKeyColumns != null) {
            this.autogeneratedKeyArray = new BaseData[1][this.requestedKeyColumns.length];
            for (int i = 1; i <= this.requestedKeyColumns.length; ++i) {
                this.autogeneratedKeyArray[0][i - 1] = this.bParams.get(this.numOrgParamsForGeneratedKeys + i, 2);
            }
        }
        return new BaseImplResultSetAutoGeneratedKeys(this.autogeneratedKeyArray);
    }

    public void reset() throws SQLException {
        if (!this.isStatementSuitableForReexecution) {
            this.isPreparedPreparedStatement = false;
        }
    }

    public void setSQL(BaseSQL baseSQL) throws SQLException {
        super.setSQL(baseSQL);
        this.updateCols = null;
        this.paramMayBeForLOBColumn = null;
        this.isPreparedPreparedStatement = false;
        this.rememberedNativeSQL = null;
        this.defineIsRequired = this.implConn.useOAll7;
        this.stmtContainsWhereClause = baseSQL.hasWhereClause();
        this.isFirstExecute = true;
        this.SQLStmtType = baseSQL.getType();
        String string = baseSQL.getVerb().toUpperCase();
        this.isSelect = this.SQLStmtType == 1 || string.equalsIgnoreCase("WITH");
        this.isStatementSuitableForReexecution = this.SQLStmtType == 4 || this.SQLStmtType == 5 || this.SQLStmtType == 6 || this.isSelect;
        if (string.startsWith("ALTER")) {
            this.implConn.alterStatementHasBeenIssued = true;
            this.isDDLStatement = true;
        } else {
            this.isDDLStatement = string.startsWith("DROP") || string.startsWith("GRANT") || string.startsWith("REVOKE") || string.startsWith("CREATE");
        }
        this.isUpdate = baseSQL.getFormatted().toUpperCase().trim().endsWith("UPDATE");
    }

    public String getRowIdColumnName() {
        return "ROWID";
    }

    private OracleImplBlob createTempBlob(BaseParameter baseParameter, byte[] byArray) throws SQLException {
        OracleImplBlob oracleImplBlob = new OracleImplBlob(this, baseParameter, byArray);
        this.tempLOBLocatorCollection[this.numTempLOBs++] = oracleImplBlob.bloblocator;
        return oracleImplBlob;
    }

    private OracleImplClob createTempClob(BaseParameter baseParameter, int n, boolean bl, String string, byte[] byArray) throws SQLException {
        OracleImplClob oracleImplClob = new OracleImplClob(this, baseParameter, n, bl, string, byArray);
        this.tempLOBLocatorCollection[this.numTempLOBs++] = oracleImplClob.cloblocator;
        return oracleImplClob;
    }

    public void cancel() throws SQLException {
        try {
            this.NSPTDAPacket.SendBreakMarkerPacket();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    private int processReply(TTIFUNDataPacket tTIFUNDataPacket) throws SQLException {
        boolean bl = false;
        block10: while (!bl) {
            int n = this.NSPTDAPacket.getNextTTCCode();
            switch (n) {
                case 9: {
                    if (this.implConn.oracleServerVersion >= 1000000000L) {
                        try {
                            int n2 = this.NSPTDAPacket.reader.readB4();
                        }
                        catch (UtilException utilException) {
                            throw this.implConn.exceptions.getException(7002, "08001");
                        }
                    }
                }
                case -1: {
                    bl = true;
                    continue block10;
                }
                case 4: {
                    this.NSPTDAPacket.getNextNextTTISubpacket(this.gTTIoer);
                    if (this.m_cursorID == 0 && this.gTTIoer.getCursorID() != 0) {
                        this.m_cursorID = this.gTTIoer.getCursorID();
                    }
                    bl = true;
                    continue block10;
                }
                case 8: {
                    this.NSPTDAPacket.getNextNextTTISubpacket(tTIFUNDataPacket);
                    if (this.m_cursorID != 0 || this.m_ttifunall.getCursorID() == 0) continue block10;
                    this.m_cursorID = this.m_ttifunall.getCursorID();
                    continue block10;
                }
                case 11: {
                    TTIIOVDataPacket tTIIOVDataPacket = new TTIIOVDataPacket(this.TTIRXDDataPacketForParams);
                    this.NSPTDAPacket.getNextNextTTISubpacket(tTIIOVDataPacket);
                    continue block10;
                }
                case 6: 
                case 7: 
                case 16: 
                case 19: 
                case 21: {
                    return n;
                }
            }
            throw this.implConn.exceptions.getException(7002, "08001");
        }
        return 0;
    }

    public int[] getBatchRowsAffectedCount() {
        if (this.lastBatchAffectedRowcounts == null) {
            return new int[0];
        }
        return this.lastBatchAffectedRowcounts;
    }

    public BaseImplResultSet getNextResultSet() throws SQLException {
        OracleImplResultset oracleImplResultset;
        this.m_currentImplResultSet = oracleImplResultset = new OracleImplResultset(this.implConn.connection);
        this.m_currentImplResultSet.m_fetchSizeSetting = this.fetchSize;
        oracleImplResultset.initialize(this.currentCursorId, this.CurrentResultsetIndex);
        return oracleImplResultset;
    }

    public void setupNextResultSet(BaseImplResultSet baseImplResultSet) throws SQLException {
        ((OracleImplResultset)baseImplResultSet).initialize(this.currentCursorId, this.CurrentResultsetIndex);
        this.m_currentImplResultSet = (OracleImplResultset)baseImplResultSet;
        this.m_currentImplResultSet.m_fetchSizeSetting = this.fetchSize;
    }

    public OracleInternalParameter findNextRefCursorParam(short[] sArray) throws SQLException {
        if (this.m_currentRefCursorParamIndex >= 0) {
            for (int i = this.m_currentRefCursorParamIndex + 1; i <= this.bParams.count(); ++i) {
                BaseParameter baseParameter = this.bParams.parametersOut[i - 1];
                if (baseParameter == null || baseParameter.sqlType != -999) continue;
                ++this.CurrentResultsetIndex;
                int n = 0;
                for (int j = 0; j < this.m_internalParamSets[0].getNumParams(); ++j) {
                    OracleInternalParameter oracleInternalParameter = this.m_internalParamSets[0].paramSet[j];
                    if ((oracleInternalParameter.m_direction & 0x10) == 0 || oracleInternalParameter.m_nativeBindType != 102) continue;
                    if (n == this.CurrentResultsetIndex) {
                        sArray[0] = baseParameter.getShort(this.comm.exceptions);
                        this.m_currentRefCursorParamIndex = i;
                        return oracleInternalParameter;
                    }
                    ++n;
                }
            }
        }
        return null;
    }

    public int getNextResultType() throws SQLException {
        int n = this.currentResult;
        this.currentResult = 1;
        short[] sArray = new short[1];
        OracleInternalParameter oracleInternalParameter = this.findNextRefCursorParam(sArray);
        if (oracleInternalParameter != null) {
            this.CurrentRSDescriptions[this.CurrentResultsetIndex] = oracleInternalParameter.m_columnDescriptions;
            this.CursorVarsDefined[this.CurrentResultsetIndex] = false;
            this.AllRowsFetched[this.CurrentResultsetIndex] = false;
            this.rowsInBuffer[this.CurrentResultsetIndex] = 0;
            this.m_computedNumRowsToFetch[this.CurrentResultsetIndex] = 0;
            this.rowsAffected = 0;
            this.currentCursorId = sArray[0];
            if (!this.implConn.useOAll7) {
                this.sentColumnsVector.setNumColumns(oracleInternalParameter.m_columnDescriptions.length);
            }
            n = 2;
        }
        if (n == 1) {
            this.CursorVarsDefined[0] = false;
            this.AllRowsFetched[0] = false;
        }
        return n;
    }

    public void closeAllRefCursors() throws SQLException {
        short[] sArray = new short[1];
        OracleInternalParameter oracleInternalParameter = this.findNextRefCursorParam(sArray);
        while (oracleInternalParameter != null) {
            this.implConn.closeCursor(sArray[0]);
            oracleInternalParameter = this.findNextRefCursorParam(sArray);
        }
    }

    private int convertNativeTypeNameToNativeDataType(String string) {
        if (string.equalsIgnoreCase("CLOB")) {
            return 112;
        }
        if (string.equalsIgnoreCase("BLOB")) {
            return 113;
        }
        if (string.equalsIgnoreCase("LONG")) {
            return 8;
        }
        if (string.equalsIgnoreCase("LONG RAW")) {
            return 24;
        }
        return 1;
    }

    private void obtainStoredProcedureParamInfo(String string, String string2, String string3, String string4) throws UtilException, SQLException {
        int n;
        String string5 = string3 + "." + string2 + "." + string4;
        String string6 = null;
        if (string == null) {
            string6 = "SELECT UNIQUE POSITION, ARGUMENT_NAME, DATA_TYPE, IN_OUT, OVERLOAD FROM SYS.ALL_ARGUMENTS WHERE DATA_LEVEL=0 ";
            if (string3 != null) {
                string6 = string6 + "AND PACKAGE_NAME = '" + string3 + "' ";
            }
            if (string2 != null) {
                string6 = string6 + "AND OWNER = '" + string2 + "' ";
            }
            string6 = string6 + " AND OBJECT_NAME = '" + string4 + "' ORDER BY POSITION DESC";
        } else {
            string6 = "SELECT UNIQUE POSITION, ARGUMENT_NAME, DATA_TYPE, IN_OUT, OVERLOAD FROM SYS.ALL_ARGUMENTS WHERE OBJECT_ID = " + string + " AND OBJECT_NAME = '" + string4 + "' AND DATA_LEVEL=0 ORDER BY POSITION DESC";
        }
        if (this.NSPTDAPacket == null) {
            this.NSPTDAPacket = new OracleNet8NSPTDAPacket(this.comm);
        }
        BaseColumn[] baseColumnArray = null;
        TTIRXDDataPacket tTIRXDDataPacket = null;
        TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this.implConn);
        tTIFUN_OALL8.setOptions(32865);
        tTIFUN_OALL8.setCommandText(string6);
        tTIFUN_OALL8.setParameters(null);
        tTIFUN_OALL8.setCursorID(this.implConn.getCursorID());
        tTIFUN_OALL8.setArraySize(1000);
        tTIFUN_OALL8.setIsSelect(true);
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        int n2 = this.implConn.processReply(tTIFUN_OALL8);
        if (n2 != 16) {
            this.m_storedProcedureParamInfo = null;
        }
        TTIDCBDataPacket tTIDCBDataPacket = new TTIDCBDataPacket(this.implConn);
        this.NSPTDAPacket.getNextNextTTISubpacket(tTIDCBDataPacket);
        baseColumnArray = tTIDCBDataPacket.getColumns();
        n2 = this.implConn.processReply(tTIFUN_OALL8);
        if (n2 != 6) {
            this.m_storedProcedureParamInfo = null;
            return;
        }
        if (this.fetchheader == null) {
            this.fetchheader = new TTIRXHDataPacket();
        }
        this.NSPTDAPacket.getNextNextTTISubpacket(this.fetchheader);
        OracleColumn oracleColumn = (OracleColumn)baseColumnArray[0];
        OracleColumn oracleColumn2 = (OracleColumn)baseColumnArray[1];
        OracleColumn oracleColumn3 = (OracleColumn)baseColumnArray[2];
        OracleColumn oracleColumn4 = (OracleColumn)baseColumnArray[3];
        OracleColumn oracleColumn5 = (OracleColumn)baseColumnArray[4];
        tTIRXDDataPacket = new TTIRXDDataPacket(this.implConn, false, baseColumnArray);
        byte[] byArray = null;
        this.implConn.processReply(this.oAllFetch[0]);
        tTIRXDDataPacket.m_sentMask = byArray;
        this.NSPTDAPacket.getNextNextTTISubpacket(tTIRXDDataPacket);
        int n3 = -1;
        boolean bl = true;
        while (bl) {
            n = (int)OracleVNU.convertVNUToLong(oracleColumn.data, oracleColumn.data.length, this.comm.exceptions);
            if (n3 == -1) {
                n3 = n;
                this.m_storedProcedureParamInfo = new storedProcParamInfo[n3 + 1];
            }
            this.m_storedProcedureParamInfo[n] = new storedProcParamInfo();
            this.m_storedProcedureParamInfo[n].name = this.comm.transliterator.decode(oracleColumn2.data, 0, oracleColumn2.data.length);
            this.m_storedProcedureParamInfo[n].nativeTypeName = this.comm.transliterator.decode(oracleColumn3.data, 0, oracleColumn3.data.length);
            this.m_storedProcedureParamInfo[n].nativeType = this.convertNativeTypeNameToNativeDataType(this.m_storedProcedureParamInfo[n].nativeTypeName);
            this.m_storedProcedureParamInfo[n].direction = this.comm.transliterator.decode(oracleColumn4.data, 0, oracleColumn4.data.length);
            this.m_storedProcedureParamInfo[n].overload = this.comm.transliterator.decode(oracleColumn5.data, 0, oracleColumn5.data.length);
            n2 = this.NSPTDAPacket.getNextTTCCode();
            if (n2 == 21) {
                this.sentColumnsVector.setNumColumns(baseColumnArray.length);
                this.NSPTDAPacket.getNextNextTTISubpacket(this.sentColumnsVector);
                byArray = this.sentColumnsVector.getSentMask();
                n2 = this.implConn.processReply(this.oAllFetch[0]);
            } else if (n2 == 6) {
                this.NSPTDAPacket.getNextNextTTISubpacket(this.fetchheader);
                n2 = this.NSPTDAPacket.getNextTTCCode();
                byArray = this.fetchheader.getSentMask();
            }
            if (n2 == 7) {
                tTIRXDDataPacket.m_sentMask = byArray;
                this.NSPTDAPacket.getNextNextTTISubpacket(tTIRXDDataPacket);
                continue;
            }
            bl = false;
        }
        int n4 = n = this.m_storedProcedureParamInfo[0] != null ? 1 : 0;
        if (n != 0) {
            int n5 = this.m_storedProcedureParamInfo.length;
            this.RememberedColumnTypes = new int[n5];
            for (int i = 0; i < n5; ++i) {
                this.RememberedColumnTypes[i] = this.m_storedProcedureParamInfo[i].nativeType;
            }
        } else {
            int n6 = this.m_storedProcedureParamInfo.length - 1;
            this.RememberedColumnTypes = new int[n6];
            for (int i = 0; i < n6; ++i) {
                this.RememberedColumnTypes[i] = this.m_storedProcedureParamInfo[i + 1].nativeType;
            }
        }
    }

    private BaseParameters massageProcParams(BaseParameters baseParameters, boolean[] blArray, boolean[] blArray2) {
        try {
            if (this.m_storedProcedureParamInfo == null) {
                return baseParameters;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 1;
            UtilVectorUnsynced utilVectorUnsynced = null;
            this.TotalNrResultsets = 0;
            int n4 = this.m_storedProcedureParamInfo.length;
            BaseParameters baseParameters2 = new BaseParameters(n4, this.comm.exceptions, (BaseConnection)this.implConn.connection);
            utilVectorUnsynced = new UtilVectorUnsynced(n4);
            this.sql.getFirstTopLevelParenExpListCount(utilVectorUnsynced);
            for (int i = 0; i < n4; ++i) {
                storedProcParamInfo storedProcParamInfo2 = this.m_storedProcedureParamInfo[i];
                if (storedProcParamInfo2 == null) continue;
                boolean bl = false;
                if (storedProcParamInfo2.overload != null && storedProcParamInfo2.overload.length() > 0) {
                    return baseParameters;
                }
                boolean bl2 = storedProcParamInfo2.direction.indexOf("IN") >= 0;
                boolean bl3 = storedProcParamInfo2.direction.indexOf("OUT") >= 0;
                boolean bl4 = storedProcParamInfo2.nativeTypeName.equalsIgnoreCase("REF CURSOR");
                if (bl3 && i == 0) {
                    if (blArray[0]) {
                        baseParameters2.set(n3, 2, baseParameters.parametersOut[n2]);
                        ++n2;
                    } else {
                        if (bl4) {
                            blArray2[0] = true;
                            ++this.TotalNrResultsets;
                            baseParameters2.set(n3, 2, new BaseParameter(-999, 10, null, (BaseConnection)this.implConn.connection));
                            if (i > 0) {
                                baseParameters2.set(n3, 1, new BaseParameter(-999, 10, null, (BaseConnection)this.implConn.connection));
                            }
                        } else {
                            baseParameters2.set(n3, 2, new BaseParameter(1, 10, null, (BaseConnection)this.implConn.connection));
                        }
                        bl = true;
                    }
                    ++n3;
                    blArray[0] = true;
                    continue;
                }
                if (bl4) {
                    blArray2[0] = true;
                    ++this.TotalNrResultsets;
                    baseParameters2.set(n3, 2, new BaseParameter(-999, 10, null, (BaseConnection)this.implConn.connection));
                    if (i > 0) {
                        baseParameters2.set(n3, 1, new BaseParameter(-999, 10, null, (BaseConnection)this.implConn.connection));
                    }
                } else if (!bl) {
                    int n5;
                    String string = ":";
                    UtilVectorUnsynced utilVectorUnsynced2 = this.sql.getFirstTopLevelParenExpListElement(utilVectorUnsynced, n);
                    ++n;
                    if (utilVectorUnsynced2 == null) continue;
                    string = ((String)utilVectorUnsynced2.firstElement()).trim();
                    String string2 = null;
                    for (int j = 1; j < utilVectorUnsynced2.size(); ++j) {
                        string2 = ((String)utilVectorUnsynced2.elementAt(j)).trim();
                        if (string2.length() <= 0) continue;
                        string = string + string2;
                    }
                    if (string.charAt(0) == 'N' && string.charAt(1) == '\'' && string.charAt(string.length() - 1) == '\'') {
                        string = string.substring(2, string.length() - 1);
                    }
                    if (string.compareTo("''") != 0) {
                        n5 = string.indexOf(39);
                        while (n5 != -1 && n5 < string.length() - 1) {
                            if (string.charAt(n5 + 1) == '\'') {
                                string = string.substring(0, n5) + string.substring(n5 + 1);
                            }
                            n5 = string.indexOf(39, n5 + 1);
                        }
                    }
                    if (string.equalsIgnoreCase("null")) {
                        baseParameters2.set(n3, 1, new BaseParameter(12, 1, null, (BaseConnection)this.implConn.connection));
                        blArray2[0] = true;
                    } else if (string.charAt(0) == ':') {
                        if (baseParameters != null) {
                            n5 = 0;
                            BaseParameter baseParameter = baseParameters.parametersIn[n2];
                            BaseParameter baseParameter2 = baseParameters.parametersOut[n2];
                            if (baseParameter != null && bl2) {
                                n5 = baseParameter.sqlType;
                                if (storedProcParamInfo2.nativeTypeName.compareTo("CLOB") == 0) {
                                    baseParameter.nativeType = baseParameter.sqlType;
                                    baseParameter.sqlType = 2005;
                                    blArray2[0] = true;
                                } else if (storedProcParamInfo2.nativeTypeName.compareTo("BLOB") == 0) {
                                    baseParameter.nativeType = baseParameter.sqlType;
                                    baseParameter.sqlType = 2004;
                                    blArray2[0] = true;
                                }
                                baseParameters2.set(n3, 1, baseParameter);
                            } else if (baseParameter == null && bl2) {
                                baseParameter = new BaseParameter(n5, 0, null, (BaseConnection)this.implConn.connection);
                                baseParameters2.set(n3, 1, baseParameter);
                            }
                            if (baseParameter2 != null && bl3) {
                                if (storedProcParamInfo2.nativeTypeName.compareTo("CLOB") == 0) {
                                    baseParameter2.nativeType = baseParameter2.sqlType;
                                    baseParameter2.sqlType = 2005;
                                    blArray2[0] = true;
                                } else if (storedProcParamInfo2.nativeTypeName.compareTo("BLOB") == 0) {
                                    baseParameter2.nativeType = baseParameter2.sqlType;
                                    baseParameter2.sqlType = 2004;
                                    blArray2[0] = true;
                                }
                                baseParameters2.set(n3, 2, baseParameter2);
                            } else if (baseParameter2 == null && bl3) {
                                baseParameter2 = new BaseParameter(bl2 ? n5 : 1, 0, null, (BaseConnection)this.implConn.connection);
                                baseParameters2.set(n3, 2, baseParameter2);
                            }
                            ++n2;
                        }
                    } else {
                        if (string.charAt(0) == '\'') {
                            string = string.substring(1, string.length() - 1);
                        }
                        baseParameters2.set(n3, 1, new BaseParameter(12, 10, (Object)string, (BaseConnection)this.implConn.connection));
                        blArray2[0] = true;
                    }
                }
                ++n3;
            }
            return baseParameters2;
        }
        catch (Exception exception) {
            return baseParameters;
        }
    }

    public int getNextRowsAffectedCount() throws SQLException {
        return this.rowsAffected;
    }

    public boolean supportsBatchParameters() {
        return true;
    }

    private String massageQualifier(String string) {
        if (string == null) {
            return string;
        }
        string = string.trim();
        boolean bl = false;
        if (string.charAt(0) == '\"') {
            string = string.substring(1, string.length());
            bl = true;
        }
        if (string.charAt(string.length() - 1) == '\"') {
            string = string.substring(0, string.length() - 1);
            bl = true;
        }
        if (bl) {
            return string;
        }
        return string.toUpperCase();
    }

    private String getProcObjectId(String string) throws SQLException {
        if (this.NSPTDAPacket == null) {
            this.NSPTDAPacket = new OracleNet8NSPTDAPacket(this.comm);
        }
        TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this.implConn);
        tTIFUN_OALL8.setCommandText("begin dbms_utility.name_resolve(:v1,:v2,:v3,:v4,:v5,:v6,:v7,:v8);end;");
        tTIFUN_OALL8.setOptions(1065);
        tTIFUN_OALL8.setCursorID(this.implConn.getCursorID());
        if (this.m_internalParamSets == null) {
            this.m_internalParamSets = new OracleInternalParameterSet[1];
            this.m_internalParamSets[0] = new OracleInternalParameterSet();
        }
        OracleInternalParameterSet oracleInternalParameterSet = this.m_internalParamSets[0];
        oracleInternalParameterSet.reset();
        OracleInternalParameter oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, 2 * string.length(), 0, 0, this.comm.transliterator);
        byte[] byArray = null;
        try {
            byArray = this.comm.transliterator.encode(string);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
        oracleInternalParameter.m_nativeDataIn = byArray;
        oracleInternalParameter.m_nativeDataInLength = byArray.length;
        oracleInternalParameter.m_direction = 32;
        oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(6, 0, 0, 16, 0, 0, this.comm.transliterator);
        byte[] byArray2 = new byte[22];
        int n = OracleVNU.convertIntToVNU(byArray2, 1);
        oracleInternalParameter.m_nativeDataIn = byArray2;
        oracleInternalParameter.m_nativeDataInLength = n;
        oracleInternalParameter.m_direction = 32;
        oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, 32, 0, 0, this.comm.transliterator);
        oracleInternalParameter.m_direction = 16;
        oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, 32, 0, 0, this.comm.transliterator);
        oracleInternalParameter.m_direction = 16;
        oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, 32, 0, 0, this.comm.transliterator);
        oracleInternalParameter.m_direction = 16;
        oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, 32, 0, 0, this.comm.transliterator);
        oracleInternalParameter.m_direction = 16;
        oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, 32, 0, 0, this.comm.transliterator);
        oracleInternalParameter.m_direction = 16;
        oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, 16, 0, 0, this.comm.transliterator);
        oracleInternalParameter.m_direction = 16;
        tTIFUN_OALL8.setParameters(oracleInternalParameterSet);
        tTIFUN_OALL8.setCursorID(this.implConn.getCursorID());
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
        TTIRXDDataPacket tTIRXDDataPacket = new TTIRXDDataPacket(this.implConn, false, oracleInternalParameterSet);
        this.NSPTDAPacket.appendTTISubPacket(tTIRXDDataPacket);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implConn);
        this.implConn.processReply(null, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        this.NSPTDAPacket.getNextNextTTISubpacket(tTIRXDDataPacket);
        oracleInternalParameter = oracleInternalParameterSet.paramSet[7];
        String string2 = null;
        try {
            BaseExceptions baseExceptions = this.comm.exceptions;
            string2 = this.comm.transliterator.decode(oracleInternalParameter.getSingleOutputValue(baseExceptions), 0, oracleInternalParameter.getSingleOutputValueLength(baseExceptions));
        }
        catch (UtilException utilException) {
            // empty catch block
        }
        return string2;
    }

    public void executeBatch() throws SQLException, BatchUpdateException {
        if (this.isSelect) {
            throw this.comm.exceptions.getException(6053);
        }
        this.execute();
    }

    private void freeLobs() throws SQLException {
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implConn.NSPTDAPacket;
        for (int i = 0; i < this.numTempLOBs; ++i) {
            byte[] byArray = this.tempLOBLocatorCollection[i];
            TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(273, byArray, this.implConn);
            oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
            oracleNet8NSPTDAPacket.sendRequest();
            oracleNet8NSPTDAPacket.receiveReply();
            TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implConn);
            this.processReply(tTIFUN_OLOBOPS);
        }
        this.numTempLOBs = 0;
    }

    private String createReturningClauseForGeneratedKeys() {
        String string = " RETURNING ";
        String string2 = " INTO ";
        for (int i = 1; i <= this.requestedKeyColumns.length; ++i) {
            if (i != 1) {
                string = string + ", ";
                string2 = string2 + ", ";
            }
            string = string + this.requestedKeyColumns[i - 1];
            string2 = string2 + ":RC" + i;
        }
        return string + string2;
    }

    public void execute() throws SQLException {
        int n;
        int n2;
        if (this.numTempLOBs > 0) {
            this.freeLobs();
        }
        if (this.m_cursorID == 0) {
            this.m_cursorID = this.implConn.getOpenCursor();
            if (this.m_cursorID == 0 && this.implConn.useOAll7) {
                this.m_cursorID = this.implConn.allocateCursor();
            }
        }
        this.closeAllRefCursors();
        this.bParams = null;
        this.TotalNrResultsets = 1;
        this.m_currentRefCursorParamIndex = -1;
        this.CurrentResultsetIndex = 0;
        String string = null;
        this.isPLSQLBlock = false;
        boolean bl = this.outputParametersWereSpecified();
        if (this.parameterSets != null) {
            this.bParams = (BaseParameters)this.parameterSets.elementAt(0);
        }
        this.m_ttifunall = this.implConn.useOAll7 ? this.m_OAll7 : this.m_OAll8;
        if (this.SQLStmtType == 3) {
            int n3;
            int n4;
            this.m_ttifunall = this.m_OAll8;
            this.actualNumStoredProcParams = -1;
            String string2 = this.sql.getOriginal();
            int n5 = n2 = this.lastExecutedSQL != null && this.rememberedNativeSQL != null && this.lastExecutedSQL.compareToIgnoreCase(string2) == 0 ? 1 : 0;
            if (n2 != 0) {
                string = this.rememberedNativeSQL;
                this.bParams = (BaseParameters)this.parameterSets.elementAt(0);
                for (n = 1; n <= this.bParams.count(); ++n) {
                    BaseParameter baseParameter;
                    n4 = this.savedProcParams.parametersOut[n - 1] != null ? 1 : 0;
                    n3 = this.savedProcParams.parametersIn[n - 1] != null ? 1 : 0;
                    BaseParameter baseParameter2 = this.bParams.parametersIn[n - 1];
                    if (baseParameter2 != null && n3 == 0) {
                        this.bParams.set(n, 1, null);
                    }
                    if ((baseParameter = this.bParams.parametersOut[n - 1]) == null && n4 != 0) {
                        this.bParams.set(n, 2, this.savedProcParams.parametersOut[n - 1]);
                    }
                    if (baseParameter == null || n4 != 0) continue;
                    this.bParams.set(n, 2, null);
                }
            } else {
                int n6;
                int n7;
                this.savedProcParams = null;
                n = string2.length();
                n4 = string2.indexOf("=");
                n3 = string2.toUpperCase().indexOf("CALL");
                boolean bl2 = n4 > 0 && n4 < n3;
                boolean bl3 = false;
                for (n7 = n3 + 5; string2.charAt(n7) == ' ' && n7 < n; ++n7) {
                }
                int n8 = n7;
                int n9 = string2.indexOf("(", n7);
                n8 = n9 == -1 ? ((n6 = string2.indexOf("}", n7)) == -1 ? n : n6) : n9;
                String string3 = string2.substring(n7, n8).trim();
                String string4 = null;
                String string5 = null;
                String string6 = null;
                int n10 = -1;
                int n11 = -1;
                n11 = string3.indexOf(46);
                if (n11 > 0) {
                    n10 = string3.lastIndexOf(46);
                    if (n10 == n11) {
                        string4 = string3.substring(0, n11);
                        string6 = string3.substring(n11 + 1);
                    } else {
                        string5 = string3.substring(0, n11);
                        string4 = string3.substring(n11 + 1, n10);
                        string6 = string3.substring(n10 + 1);
                    }
                } else {
                    string6 = string3;
                }
                string4 = this.massageQualifier(string4);
                string5 = this.massageQualifier(string5);
                string6 = this.massageQualifier(string6);
                int n12 = this.bParams == null ? 0 : this.bParams.count();
                boolean[] blArray = new boolean[]{false};
                if (string4 == null || string4.compareToIgnoreCase("JAVA_XA") != 0) {
                    boolean[] blArray2 = new boolean[]{bl2};
                    if (this.m_storedProcedureParamInfo == null) {
                        try {
                            String string7 = this.getProcObjectId(string3);
                            this.obtainStoredProcedureParamInfo(string7, string5, string4, string6);
                        }
                        catch (UtilException utilException) {
                            utilException.printStackTrace();
                        }
                    }
                    if (this.implConn.refCursorSupport) {
                        this.bParams = this.savedProcParams = this.massageProcParams(this.bParams, blArray2, blArray);
                    } else {
                        blArray[0] = true;
                    }
                    if (this.parameterSets != null && this.parameterSets.size() > 1) {
                        for (int i = 1; i <= this.bParams.count(); ++i) {
                            BaseParameter baseParameter = this.bParams.parametersIn[i - 1];
                            if (baseParameter == null || baseParameter.sqlType != -999) continue;
                            throw this.comm.exceptions.getException(6053);
                        }
                    }
                    bl2 = blArray2[0];
                }
                boolean bl4 = false;
                if (this.bParams != null) {
                    int n13 = this.getActualNumStoredProcParams();
                    string = "BEGIN " + (bl2 ? ":RETVAL := " : "") + string3 + " (";
                    int n14 = n13 - (bl2 ? 1 : 0);
                    for (int i = 0; i < n14; ++i) {
                        string = string + " :V" + (i + 1);
                        if (i >= n14 - 1) continue;
                        string = string + ", ";
                    }
                    string = string + "); END;";
                } else {
                    string = this.sql.getFormatted();
                }
                this.rememberedNativeSQL = blArray[0] ? null : string;
            }
            this.isPLSQLBlock = true;
        } else {
            if (this.rememberedNativeSQL != null) {
                string = this.rememberedNativeSQL;
            } else {
                this.rememberedNativeSQL = string = this.sql.getFormatted();
            }
            if (!this.autoGeneratedKeysRequested && this.requestedKeyColumns != null) {
                int n15;
                if (this.isFirstExecute) {
                    string = string + this.createReturningClauseForGeneratedKeys();
                    this.isPreparedPreparedStatement = false;
                    this.numOrgParamsForGeneratedKeys = this.bParams == null ? 0 : this.bParams.count();
                    this.revisedParamsForGeneratedkeys = new BaseParameters(this.numOrgParamsForGeneratedKeys + this.requestedKeyColumns.length, this.comm.exceptions, (BaseConnection)this.implConn.connection);
                    for (n15 = 1; n15 <= this.requestedKeyColumns.length; ++n15) {
                        BaseParameter baseParameter = new BaseParameter(this.requestedKeyColumnDescriptions.get((int)n15).type, 0, null, (BaseConnection)this.implConn.connection);
                        this.revisedParamsForGeneratedkeys.set(this.numOrgParamsForGeneratedKeys + n15, 2, baseParameter);
                    }
                    this.m_orgParamBindInfo = null;
                }
                if (this.numOrgParamsForGeneratedKeys > 0) {
                    for (n15 = 1; n15 <= this.numOrgParamsForGeneratedKeys; ++n15) {
                        this.revisedParamsForGeneratedkeys.set(n15, 1, this.bParams.getInput(n15));
                        this.revisedParamsForGeneratedkeys.set(n15, 2, this.bParams.getOutput(n15));
                    }
                }
                this.bParams = this.revisedParamsForGeneratedkeys;
                bl = true;
            }
            if (string.trim().endsWith(";")) {
                this.isPLSQLBlock = true;
                this.isPreparedPreparedStatement = false;
                this.m_ttifunall = this.m_OAll8;
            } else if (bl) {
                this.m_ttifunall = this.m_OAll8;
            }
        }
        this.rowsAffected = -1;
        this.m_ttifunall.reset(this.m_cursorID);
        this.m_ttifunall.setCommandText(string);
        this.m_ttifunall.setIsSelect(this.SQLStmtType == 1);
        int n16 = 32;
        if (this.SQLStmtType == 3 || this.isPLSQLBlock) {
            this.m_ttifunall.setIsStoredProcCall(true);
        } else if (!this.isPreparedPreparedStatement) {
            n16 += 32768;
        }
        if (this.databaseMetaDataResultSet == 12) {
            String string8;
            BaseParameter[] baseParameterArray = new BaseParameter[4];
            n = 0;
            String string9 = (String)this.filterDescriptor.getRestriction(7);
            if (string9 != null) {
                baseParameterArray[n++] = new BaseParameter(1, 10, (Object)string9, (BaseConnection)this.implConn.connection);
            }
            if ((string8 = (String)this.filterDescriptor.getRestriction(6)) != null) {
                baseParameterArray[n++] = new BaseParameter(1, 10, (Object)string8, (BaseConnection)this.implConn.connection);
            }
            if (this.implConn.returnSynonyms) {
                baseParameterArray[n++] = new BaseParameter(1, 10, (Object)(string9 == null ? "" : string9), (BaseConnection)this.implConn.connection);
                baseParameterArray[n++] = new BaseParameter(1, 10, (Object)(string8 == null ? "" : string8), (BaseConnection)this.implConn.connection);
            }
            BaseParameters baseParameters = new BaseParameters(n, this.comm.exceptions, (BaseConnection)this.implConn.connection);
            for (int i = 1; i <= n; ++i) {
                baseParameters.set(i, 1, baseParameterArray[i - 1]);
            }
            this.filterDescriptor.removeAllRestrictions();
            this.bParams = baseParameters;
        }
        this.executeAsNativeBatch = false;
        if (this.bParams == null || this.bParams.count() == 0) {
            this.m_ttifunall.setParameters(null);
            if (this.m_internalParamSets != null) {
                this.m_internalParamSets[0].reset();
            }
        } else {
            if (this.tempLOBLocatorCollection == null || this.tempLOBLocatorCollection.length < this.bParams.count()) {
                n2 = this.bParams.count() * (this.parameterSets == null ? 1 : this.parameterSets.size());
                this.tempLOBLocatorCollection = new byte[n2][];
            }
            if (this.updateCols == null) {
                n2 = this.bParams.count();
                this.updateCols = new String[n2];
                this.paramMayBeForLOBColumn = new boolean[n2];
                for (n = 0; n < n2; ++n) {
                    this.paramMayBeForLOBColumn[n] = true;
                }
            }
            OracleInternalParameterSet oracleInternalParameterSet = this.createInternalParameterSet(this.bParams, this.m_internalParamSets == null ? null : this.m_internalParamSets[0]);
            if (this.parameterSets != null && this.parameterSets.size() > 1) {
                if (this.m_internalParamSets == null) {
                    this.m_internalParamSets = new OracleInternalParameterSet[this.parameterSets.size()];
                } else if (this.parameterSets.size() > this.m_internalParamSets.length) {
                    OracleInternalParameterSet[] oracleInternalParameterSetArray = new OracleInternalParameterSet[this.parameterSets.size()];
                    for (int i = 0; i < this.m_internalParamSets.length; ++i) {
                        oracleInternalParameterSetArray[i] = this.m_internalParamSets[i];
                    }
                    this.m_internalParamSets = oracleInternalParameterSetArray;
                }
                this.m_internalParamSets[0] = oracleInternalParameterSet;
                for (n = 1; n < this.parameterSets.size(); ++n) {
                    this.m_internalParamSets[n] = this.createInternalParameterSet((BaseParameters)this.parameterSets.get(n), this.m_internalParamSets[n]);
                }
                if (this.paramTypesMatchForAllParamSets()) {
                    this.m_ttifunall.setArraySize(this.SQLStmtType == 1 && !this.implConn.useOAll7 ? 0 : this.parameterSets.size());
                    this.executeAsNativeBatch = true;
                }
            } else {
                if (this.m_internalParamSets == null) {
                    this.m_internalParamSets = new OracleInternalParameterSet[1];
                }
                this.m_internalParamSets[0] = oracleInternalParameterSet;
            }
            n = this.parameterSets == null ? 1 : this.parameterSets.size();
            this.formulateParamBindInfo(this.m_internalParamSets, n);
            if (oracleInternalParameterSet.getNumParams() > 0 && (this.isFirstExecute || this.bindTypesOrMaxLensHaveChanged(this.m_requiredParamBindInfo))) {
                this.m_ttifunall.setParameters(this.m_requiredParamBindInfo);
                n16 |= 8;
                this.rememberBindTypes(this.m_requiredParamBindInfo);
                if (this.TTIRXDDataPacketForParams == null) {
                    this.TTIRXDDataPacketForParams = new TTIRXDDataPacket(this.implConn, this.m_ttifunall == this.m_OAll7, (OracleInternalParameterSet)null);
                    this.TTIRXDDataPacketForParams.setBaseExceptions(this.comm.exceptions);
                }
                if (this.SQLStmtType != 3) {
                    this.TTIRXDDataPacketForParams.setParameterBindings(this.m_orgParamBindInfo);
                }
            } else {
                this.m_ttifunall.setParameters(null);
            }
        }
        if (!this.isPreparedPreparedStatement && this.isFirstExecute || this.isDDLStatement || (n16 & 8) != 0 && this.implConn.oracleServerVersion < 902000000L) {
            n16 |= 1;
            if (this.isSelect && this.implConn.useOAll7) {
                this.defineIsRequired = true;
            }
            if (this.sql.getOriginal() != this.lastExecutedSQL && this.currentCursorId != 0) {
                this.CurrentRSDescriptions = null;
                this.m_computedNumRowsToFetch = null;
            } else if (this.implConn.oracleServerVersion >= 900000000L) {
                n2 = 0;
                try {
                    n2 = this.comm.socket.getSoTimeout();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n2 != 0) {
                    this.CurrentRSDescriptions = null;
                    this.m_computedNumRowsToFetch = null;
                }
            }
        }
        if ((this.isPLSQLBlock || bl) && (this.parameterSets == null || this.parameterSets.size() <= 1)) {
            n16 += 1024;
        }
        this.m_ttifunall.setOptions(n16);
        n2 = 0;
        if (this.isSelect) {
            if (this.CurrentRSDescriptions != null && this.CurrentRSDescriptions[0] != null) {
                n2 = 1;
            } else {
                this.m_ttifunall.setArraySize(this.implConn.useOAll7 ? 1 : 0);
            }
        }
        if (n2 == 0) {
            this.NSPTDAPacket.appendTTISubPacket(this.m_ttifunall);
        }
        this.lastExecutedSQL = this.sql.getOriginal();
        if (this.CurrentRSDescriptions == null || this.CurrentRSDescriptions.length < this.TotalNrResultsets) {
            this.CurrentRSDescriptions = new BaseColumn[this.TotalNrResultsets][];
        }
        if (this.m_computedNumRowsToFetch == null || this.m_computedNumRowsToFetch.length < this.TotalNrResultsets) {
            this.m_computedNumRowsToFetch = new int[this.TotalNrResultsets];
        }
        if (this.oAllFetch == null || this.oAllFetch.length < this.TotalNrResultsets) {
            this.oAllFetch = this.implConn.useOAll7 ? new TTIFUN_OALL7[this.TotalNrResultsets] : new TTIFUN_OALL8[this.TotalNrResultsets];
        }
        if (this.fetchrows == null || this.fetchrows.length < this.TotalNrResultsets) {
            this.fetchrows = new TTIRXDDataPacket[this.TotalNrResultsets];
        }
        if (this.rowsInBuffer == null || this.rowsInBuffer.length < this.TotalNrResultsets) {
            this.rowsInBuffer = new int[this.TotalNrResultsets];
        }
        if (this.CursorVarsDefined == null || this.CursorVarsDefined.length < this.TotalNrResultsets) {
            this.CursorVarsDefined = new boolean[this.TotalNrResultsets];
        }
        if (this.AllRowsFetched == null || this.AllRowsFetched.length < this.TotalNrResultsets) {
            this.AllRowsFetched = new boolean[this.TotalNrResultsets];
        } else {
            for (int i = 0; i < this.AllRowsFetched.length; ++i) {
                this.AllRowsFetched[i] = false;
            }
        }
        if (this.cachedRows == null || this.cachedRows.length < this.TotalNrResultsets) {
            this.cachedRows = new byte[this.TotalNrResultsets][][];
            this.cachedLens = new int[this.TotalNrResultsets][];
        }
        if (this.currentRowInBuffer == null || this.cachedRows.length < this.TotalNrResultsets) {
            this.currentRowInBuffer = new int[this.TotalNrResultsets];
        } else {
            for (int i = 0; i < this.currentRowInBuffer.length; ++i) {
                this.currentRowInBuffer[i] = 0;
            }
        }
        if (this.lastRowReturnedByDatabase == null || this.lastRowReturnedByDatabase.length < this.TotalNrResultsets) {
            this.lastRowReturnedByDatabase = new boolean[this.TotalNrResultsets];
        } else {
            for (int i = 0; i < this.lastRowReturnedByDatabase.length; ++i) {
                this.lastRowReturnedByDatabase[i] = false;
            }
        }
        if (n2 != 0) {
            this.currentCursorId = this.m_cursorID;
            this.currentResult = 2;
            this.CursorVarsDefined[0] = false;
            this.m_currentRefCursorParamIndex = -1;
            this.TotalNrResultsets = 1;
            this.CurrentResultsetIndex = 0;
            this.AllRowsFetched[0] = false;
            this.rowsInBuffer[0] = 0;
            this.rowsAffected = 0;
            this.lastRowReturnedByDatabase[0] = false;
            this.fetchNext2(true, 0, this.m_ttifunall);
            this.isFirstExecute = false;
            return;
        }
        if (this.m_internalParamSets != null && this.m_internalParamSets[0].getNumParams() > 0) {
            this.appendParameterdata(this.NSPTDAPacket);
        }
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.gTTIoer.retCode = 0;
        int n17 = this.processReply(this.m_ttifunall);
        while (n17 == 19) {
            this.NSPTDAPacket.SendFOBPacket();
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            n17 = this.processReply(this.m_ttifunall);
        }
        if (this.gTTIoer.retCode != 0) {
            int n18;
            this.m_cursorID = this.gTTIoer.getCursorID();
            if (this.gTTIoer.retCode == 932) {
                this.isPreparedPreparedStatement = false;
                this.isFirstExecute = true;
            }
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            if (this.parameterSets != null && (n18 = this.parameterSets.size()) > 1) {
                int[] nArray = new int[n18];
                for (int i = 0; i < n18; ++i) {
                    nArray[i] = -3;
                }
                throw new BatchUpdateException(this.gTTIoer.errMsg, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode, nArray);
            }
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
            throw this.myException;
        }
        while (n17 == 16) {
            TTIDCBDataPacket tTIDCBDataPacket = new TTIDCBDataPacket(this.implConn);
            this.NSPTDAPacket.getNextNextTTISubpacket(tTIDCBDataPacket);
            this.CurrentRSDescriptions[this.CurrentResultsetIndex] = tTIDCBDataPacket.getColumns();
            this.m_computedNumRowsToFetch[this.CurrentResultsetIndex] = 0;
            this.sentColumnsVector.setNumColumns(this.CurrentRSDescriptions[this.CurrentResultsetIndex].length);
            n17 = this.processReply(this.m_ttifunall);
        }
        this.isFirstExecute = false;
        if (this.SQLStmtType == 3) {
            if (n17 == 7 && this.bParams != null) {
                TTIRXDDataPacket tTIRXDDataPacket = new TTIRXDDataPacket(this.implConn, false, this.m_internalParamSets[0]);
                tTIRXDDataPacket.isPLSQLBlock = true;
                tTIRXDDataPacket.setBaseExceptions(this.comm.exceptions);
                this.NSPTDAPacket.getNextNextTTISubpacket(tTIRXDDataPacket);
                try {
                    this.convertAndPropagateOutputParams(this.m_internalParamSets[0], this.bParams);
                }
                catch (UtilException utilException) {
                    this.comm.exceptions.getException((Exception)((Object)utilException));
                }
                n17 = this.processReply(this.m_ttifunall);
            }
            this.CurrentResultsetIndex = -1;
            this.m_currentRefCursorParamIndex = this.bParams != null ? 0 : -1;
            this.rowsAffected = this.gTTIoer.curRowNumber;
            this.currentResult = this.rowsAffected >= 0 ? 3 : 1;
            this.m_ttifunall = this.implConn.useOAll7 ? this.m_OAll7 : this.m_OAll8;
        } else if (this.isSelect) {
            if (n2 == 0) {
                this.currentCursorId = this.m_cursorID;
                this.currentResult = 2;
                this.CursorVarsDefined[0] = false;
                this.m_currentRefCursorParamIndex = -1;
                this.TotalNrResultsets = 1;
                this.CurrentResultsetIndex = 0;
                this.AllRowsFetched[0] = false;
                this.rowsInBuffer[0] = 0;
                this.rowsAffected = 0;
                this.lastRowReturnedByDatabase[0] = false;
                this.m_ttifunall.setOptions(0);
                this.m_ttifunall.setParameters(null);
                this.fetchNext2(true, 0, null);
            }
        } else {
            if (n17 == 7 && bl) {
                TTIRXDDataPacket tTIRXDDataPacket = new TTIRXDDataPacket(this.implConn, false, this.m_internalParamSets[0]);
                tTIRXDDataPacket.isPLSQLBlock = this.isPLSQLBlock;
                this.NSPTDAPacket.getNextNextTTISubpacket(tTIRXDDataPacket);
                try {
                    this.convertAndPropagateOutputParams(this.m_internalParamSets[0], this.bParams);
                }
                catch (UtilException utilException) {
                    this.comm.exceptions.getException((Exception)((Object)utilException));
                }
                n17 = this.processReply(this.m_ttifunall);
            }
            this.rowsAffected = this.gTTIoer.curRowNumber;
            if (this.parameterSets != null) {
                int n19 = this.parameterSets.size();
                this.lastBatchAffectedRowcounts = new int[n19];
                for (int i = 0; i < n19; ++i) {
                    this.lastBatchAffectedRowcounts[i] = -2;
                }
            }
            this.currentResult = this.rowsAffected >= 0 ? 3 : 1;
        }
    }

    private boolean outputParametersWereSpecified() {
        boolean bl = false;
        if (this.parameterSets != null) {
            BaseParameters baseParameters = (BaseParameters)this.parameterSets.get(0);
            int n = baseParameters.count();
            for (int i = 1; i <= n && !bl; ++i) {
                bl = baseParameters.parametersOut[i - 1] != null;
            }
        }
        return bl;
    }

    private void appendParameterdata(OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket) throws SQLException {
        int n;
        if (this.m_internalParamSets == null || this.m_internalParamSets[0].isEmpty()) {
            return;
        }
        int n2 = n = this.parameterSets == null ? 1 : this.parameterSets.size();
        if (n == 1 || this.executeAsNativeBatch) {
            for (int i = 0; i < n; ++i) {
                int n3 = this.m_internalParamSets[i].getNumParams();
                if (n3 <= 0) continue;
                this.TTIRXDDataPacketForParams.setParameters(this.m_internalParamSets[i]);
                oracleNet8NSPTDAPacket.appendTTISubPacket(this.TTIRXDDataPacketForParams);
            }
        } else {
            this.m_ttifunall.addToOptions(8);
            this.TTIRXDDataPacketForParams.setParameters(this.m_internalParamSets[0]);
            oracleNet8NSPTDAPacket.appendTTISubPacket(this.TTIRXDDataPacketForParams);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            this.gTTIoer.retCode = 0;
            int n4 = this.processReply(this.m_ttifunall);
            if (this.implConn.oracleServerVersion < 902000000L) {
                this.m_ttifunall.addToOptions(1);
            }
            for (int i = 1; i < n; ++i) {
                this.m_ttifunall.setParameters(this.m_internalParamSets[i]);
                this.NSPTDAPacket.appendTTISubPacket(this.m_ttifunall);
                this.TTIRXDDataPacketForParams.setParameters(this.m_internalParamSets[i]);
                oracleNet8NSPTDAPacket.appendTTISubPacket(this.TTIRXDDataPacketForParams);
                if (i != n - 1) {
                    this.NSPTDAPacket.sendRequest();
                    this.NSPTDAPacket.receiveReply();
                    this.gTTIoer.retCode = 0;
                    n4 = this.processReply(this.m_ttifunall);
                    continue;
                }
                this.rememberBindTypes(this.m_internalParamSets[i]);
            }
        }
    }

    public void prepare() throws SQLException {
        int n = this.sql.getParameterCount();
        this.CurrentRSDescriptions = null;
        this.m_computedNumRowsToFetch = null;
        this.RememberedColumnTypes = null;
        this.RememberedColumnNames = null;
        for (int i = 0; i < n; ++i) {
            this.sql.setParameter(i, ":v" + i);
        }
        if (!this.isStatementSuitableForReexecution) {
            return;
        }
        if (this.implConn.describeAtPrepare) {
            String string;
            if (this.m_cursorID == 0) {
                this.m_cursorID = this.implConn.getOpenCursor();
                if (this.m_cursorID == 0 && this.implConn.useOAll7) {
                    this.m_cursorID = this.implConn.allocateCursor();
                }
            }
            if ((string = this.sql.getFormatted()).trim().endsWith(";")) {
                this.m_ttifunall.setOptions(1);
            } else {
                this.m_ttifunall.setOptions(32769);
            }
            this.m_ttifunall.setCommandText(string);
            this.m_ttifunall.setCursorID(this.m_cursorID);
            this.m_ttifunall.setArraySize(0);
            this.m_ttifunall.setIsSelect(false);
            this.NSPTDAPacket.appendTTISubPacket(this.m_ttifunall);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            this.gTTIoer.retCode = 0;
            this.processReply(this.m_ttifunall);
            if (this.gTTIoer.retCode != 0) {
                this.m_cursorID = this.gTTIoer.getCursorID();
                String[] stringArray = new String[]{this.gTTIoer.errMsg};
                this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
                this.implConn.closeCursor(this.m_cursorID);
                this.m_cursorID = 0;
                throw this.myException;
            }
            this.isPreparedPreparedStatement = true;
            this.currentCursorId = this.m_cursorID;
        }
    }

    void closeResultset() throws SQLException {
        this.closeResultset(this.currentCursorId, this.CurrentResultsetIndex);
    }

    public BaseSQL getSQL() {
        return this.sql;
    }

    void closeResultset(short s, int n) throws SQLException {
        block8: {
            block7: {
                if (!this.lastRowReturnedByDatabase[n]) break block7;
                if (this.SQLStmtType != 3) break block8;
            }
            if (this.reusablettifuncancel == null) {
                this.reusablettifuncancel = new TTIFUN_OCANCEL(s);
            } else {
                this.reusablettifuncancel.reset(s);
            }
            this.NSPTDAPacket.appendTTISubPacket(this.reusablettifuncancel);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            this.gTTIoer.retCode = 0;
            this.processReply(this.reusablettifuncancel);
            if (this.gTTIoer.retCode != 0) {
                String[] stringArray = new String[]{this.gTTIoer.errMsg};
                this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
                throw this.myException;
            }
            if (s != this.m_cursorID && s != 0) {
                this.implConn.freeCursor(s);
                this.AllRowsFetched[n] = true;
                this.currentCursorId = 0;
            }
        }
    }

    boolean fetchNext2(boolean bl, int n, TTIFUN_OALL_BASE tTIFUN_OALL_BASE) throws SQLException {
        int n2;
        int[] nArray;
        Object object;
        int n3;
        boolean bl2 = true;
        int n4 = -1;
        if (this.AllRowsFetched[n]) {
            return false;
        }
        if (this.rowsInBuffer[n] == 0 && !this.lastRowReturnedByDatabase[n]) {
            this.fetchNext(true, n, tTIFUN_OALL_BASE);
            n3 = 0;
            boolean bl3 = this.AllRowsFetched[n];
            while (!bl3) {
                this.gTTIoer.isSelect = true;
                int n5 = this.processReply(this.oAllFetch[n]);
                this.gTTIoer.isSelect = false;
                if (this.gTTIoer.retCode == 1013) {
                    throw this.comm.exceptions.getException(6078);
                }
                if (this.gTTIoer.retCode == 1403) {
                    this.lastRowReturnedByDatabase[n] = true;
                    bl3 = true;
                }
                byte[] byArray = this.fetchheader.getSentMask();
                if (n5 == 21) {
                    this.NSPTDAPacket.getNextNextTTISubpacket(this.sentColumnsVector);
                    byArray = this.sentColumnsVector.getSentMask();
                    n5 = this.processReply(this.oAllFetch[n]);
                }
                if (n5 == 6) {
                    this.NSPTDAPacket.getNextNextTTISubpacket(this.fetchheader);
                    byArray = this.fetchheader.getSentMask();
                    n5 = this.processReply(this.oAllFetch[n]);
                }
                if (n5 != 7) {
                    this.rowsInBuffer[n] = n3;
                    bl2 = false;
                    bl3 = true;
                    continue;
                }
                if (this.fetchrows[n] == null) {
                    this.fetchrows[n] = new TTIRXDDataPacket(this.implConn, this.implConn.useOAll7, this.CurrentRSDescriptions[n]);
                } else {
                    this.fetchrows[n].reset(this.CurrentRSDescriptions[n]);
                }
                this.fetchrows[n].m_sentMask = byArray;
                object = this.cachedRows[n];
                nArray = this.cachedLens[n];
                if (n4 == -1) {
                    n4 = this.CurrentRSDescriptions[n].length;
                }
                int n6 = this.arrayfetchsize * n4;
                if (object == null) {
                    byte[][] byArrayArray = new byte[n6][];
                    object = byArrayArray;
                    this.cachedRows[n] = byArrayArray;
                } else if (((byte[][])object).length < n6) {
                    byte[][] byArrayArray = new byte[n6][];
                    for (int i = 0; i < ((byte[][])object).length; ++i) {
                        byArrayArray[i] = object[i];
                    }
                    object = byArrayArray;
                    this.cachedRows[n] = object;
                }
                if (nArray == null) {
                    nArray = new int[n6];
                    this.cachedLens[n] = nArray;
                } else if (nArray.length < n6) {
                    nArray = new int[n6];
                    this.cachedLens[n] = nArray;
                }
                n2 = n3 * n4;
                this.fetchrows[n].setCurrentRow((byte[][])object, nArray, n2);
                ++n3;
                this.NSPTDAPacket.getNextNextTTISubpacket(this.fetchrows[n]);
            }
            this.currentRowInBuffer[n] = 1;
            if (this.fetchrows[n] != null) {
                this.fetchrows[n].setCurrentRow(null, null, 0);
            }
        }
        if (bl) {
            return false;
        }
        if (this.rowsInBuffer[n] == 0) {
            this.AllRowsFetched[n] = true;
            return false;
        }
        if (n4 == -1) {
            n4 = this.CurrentRSDescriptions[n].length;
        }
        n2 = (this.currentRowInBuffer[n] - 1) * n4;
        object = this.cachedRows[n];
        nArray = this.cachedLens[n];
        for (n3 = 0; n3 < n4; ++n3) {
            OracleColumn oracleColumn = (OracleColumn)this.CurrentRSDescriptions[n][n3];
            oracleColumn.data = object[n2 + n3];
            oracleColumn.len = nArray[n2 + n3];
            oracleColumn.indicator = oracleColumn.data == null || oracleColumn.len <= 0 ? -1 : 0;
        }
        int n7 = n;
        this.currentRowInBuffer[n7] = this.currentRowInBuffer[n7] + 1;
        int n8 = n;
        this.rowsInBuffer[n8] = this.rowsInBuffer[n8] - 1;
        return true;
    }

    boolean fetchNext(boolean bl, int n, TTIFUN_OALL_BASE tTIFUN_OALL_BASE) throws SQLException {
        int n2;
        boolean bl2 = true;
        if (this.AllRowsFetched[n]) {
            return false;
        }
        if (this.rowsInBuffer[n] == 0) {
            int n3;
            int n4;
            int n5;
            if (this.CursorVarsDefined[n]) {
                this.oAllFetch[n].setOptions(32832);
            } else {
                this.lastRowReturnedByDatabase[n] = false;
                this.AllRowsFetched[n] = false;
                if (tTIFUN_OALL_BASE == null) {
                    if (this.implConn.useOAll7) {
                        this.oAllFetch[n] = new TTIFUN_OALL7(this.implConn);
                        this.oAllFetch[n].setOptions(80);
                        this.defineIsRequired = true;
                    } else {
                        this.oAllFetch[n] = new TTIFUN_OALL8(this.implConn);
                        this.oAllFetch[n].setOptions(64);
                    }
                    this.oAllFetch[n].setCursorID(this.currentCursorId);
                    this.oAllFetch[n].setIsSelect(true);
                } else {
                    if (this.defineIsRequired) {
                        tTIFUN_OALL_BASE.setOptions(tTIFUN_OALL_BASE.getOptions() | 0x10 | 0x40);
                    } else {
                        tTIFUN_OALL_BASE.setOptions(tTIFUN_OALL_BASE.getOptions() | 0x40);
                    }
                    this.oAllFetch[n] = tTIFUN_OALL_BASE;
                }
                if (this.fetchheader == null) {
                    this.fetchheader = new TTIRXHDataPacket();
                }
                if (this.CurrentRSDescriptions[n] == null) {
                    this.describeColumns(n);
                    this.sentColumnsVector.setNumColumns(this.CurrentRSDescriptions[n].length);
                }
                if (this.defineIsRequired) {
                    this.FetchcolCount = this.CurrentRSDescriptions[n].length;
                    this.oAllFetch[n].setDefineArraySize(this.FetchcolCount);
                    for (n5 = 0; n5 < this.FetchcolCount; ++n5) {
                        OracleColumn oracleColumn = (OracleColumn)this.CurrentRSDescriptions[n][n5];
                        if (!this.implConn.useOAll7) continue;
                        ((TTIFUN_OALL7)this.oAllFetch[n]).defineCol(n5 + 1, oracleColumn.OCINativeType, 0, oracleColumn.m_defineScale, oracleColumn.m_defineMaxLength, oracleColumn.charSetId, oracleColumn.charSetForm);
                    }
                    this.defineIsRequired = false;
                }
            }
            if (this.m_computedNumRowsToFetch[n] == 0) {
                this.FetchcolCount = this.CurrentRSDescriptions[n].length;
                int n6 = 0;
                n4 = 0;
                for (n3 = 0; n3 < this.FetchcolCount; ++n3) {
                    OracleColumn oracleColumn = (OracleColumn)this.CurrentRSDescriptions[n][n3];
                    n5 = oracleColumn.m_defineMaxLength;
                    if (oracleColumn.OCINativeType == 8 || oracleColumn.OCINativeType == 24) {
                        n4 = 1;
                        break;
                    }
                    if (this.isUpdate && (oracleColumn.OCINativeType == 112 || oracleColumn.OCINativeType == 113)) {
                        n4 = 1;
                        break;
                    }
                    n6 += n5;
                }
                if (n4 != 0) {
                    this.m_computedNumRowsToFetch[n] = -1;
                } else {
                    this.arrayfetchsize = 64000 / n6;
                    this.m_computedNumRowsToFetch[n] = this.arrayfetchsize = this.arrayfetchsize < 1 ? 1 : this.arrayfetchsize;
                }
            }
            if (this.m_computedNumRowsToFetch[n] == -1) {
                this.arrayfetchsize = 1;
            } else {
                n5 = this.maxRows;
                int n7 = 0;
                n4 = 0;
                if (this.m_currentImplResultSet == null) {
                    n7 = 0;
                    n4 = this.fetchSize;
                } else {
                    n7 = this.m_currentImplResultSet.getCurrentCursorPosition() - 1;
                    n4 = this.m_currentImplResultSet.m_fetchSizeSetting;
                }
                if (n5 > 0) {
                    n3 = n5 - n7;
                    if (n3 <= 0) {
                        n3 = 1;
                    }
                    this.arrayfetchsize = n4 > 0 ? Math.min(n4, n3) : Math.min(this.m_computedNumRowsToFetch[n], n3);
                } else {
                    this.arrayfetchsize = n4 > 0 ? n4 : this.m_computedNumRowsToFetch[n];
                }
                this.arrayfetchsize = this.arrayfetchsize > Short.MAX_VALUE ? Short.MAX_VALUE : this.arrayfetchsize;
            }
            this.oAllFetch[n].setArraySize(this.arrayfetchsize);
            this.NSPTDAPacket.appendTTISubPacket(this.oAllFetch[n]);
            if (tTIFUN_OALL_BASE != null) {
                this.appendParameterdata(this.NSPTDAPacket);
            }
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            this.gTTIoer.retCode = 0;
            n2 = this.processReply(this.oAllFetch[n]);
            if (this.gTTIoer.retCode == 1403) {
                this.oAllFetch[n] = null;
                this.fetchheader = null;
                this.AllRowsFetched[n] = true;
                this.gTTIoer.retCode = 0;
                this.lastRowReturnedByDatabase[n] = true;
            }
            if (this.gTTIoer.retCode != 0) {
                String[] stringArray = new String[]{this.gTTIoer.errMsg};
                this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
                throw this.myException;
            }
            this.CursorVarsDefined[n] = true;
            if (n2 == 16) {
                TTIDCBDataPacket tTIDCBDataPacket = new TTIDCBDataPacket(this.implConn);
                this.NSPTDAPacket.getNextNextTTISubpacket(tTIDCBDataPacket);
                this.CurrentRSDescriptions[n] = tTIDCBDataPacket.getColumns();
                this.m_computedNumRowsToFetch[n] = 0;
                n2 = this.processReply(this.oAllFetch[n]);
            }
            if (n2 != 6) {
                bl2 = false;
                this.rowsInBuffer[n] = 0;
                this.AllRowsFetched[n] = true;
                return false;
            }
            this.NSPTDAPacket.getNextNextTTISubpacket(this.fetchheader);
            this.rowsInBuffer[n] = this.fetchheader.CurrIterations;
        }
        if (bl) {
            return false;
        }
        n2 = this.processReply(this.oAllFetch[n]);
        if (this.gTTIoer.retCode == 1403) {
            this.lastRowReturnedByDatabase[n] = true;
        }
        if (n2 == 6) {
            this.NSPTDAPacket.getNextNextTTISubpacket(this.fetchheader);
            n2 = this.processReply(this.oAllFetch[n]);
        }
        if (n2 != 7) {
            this.rowsInBuffer[n] = 0;
            bl2 = false;
            this.AllRowsFetched[n] = true;
        } else {
            if (this.fetchrows[n] == null) {
                this.fetchrows[n] = new TTIRXDDataPacket(this.implConn, this.implConn.useOAll7, this.CurrentRSDescriptions[n]);
            } else {
                this.fetchrows[n].reset(this.CurrentRSDescriptions[n]);
            }
            this.NSPTDAPacket.getNextNextTTISubpacket(this.fetchrows[n]);
            int n8 = n;
            this.rowsInBuffer[n8] = this.rowsInBuffer[n8] - 1;
        }
        return bl2;
    }

    public void close() throws SQLException {
        if (this.numTempLOBs > 0) {
            this.freeLobs();
        }
        this.implConn.closeCursor(this.m_cursorID);
        this.closeAllRefCursors();
        this.m_cursorID = 0;
        this.isPreparedPreparedStatement = false;
        this.AllRowsFetched = null;
        this.oAllFetch = null;
        this.fetchheader = null;
        this.fetchrows = null;
    }

    public BaseColumns describeColumns(BaseColumns baseColumns) throws SQLException {
        BaseColumn[] baseColumnArray = this.describeColumns(this.CurrentResultsetIndex);
        this.sentColumnsVector.setNumColumns(baseColumnArray.length);
        if (this.databaseMetaDataResultSet != 0) {
            return baseColumns;
        }
        BaseColumns baseColumns2 = new BaseColumns();
        for (int i = 0; i < this.CurrentRSDescriptions[this.CurrentResultsetIndex].length; ++i) {
            baseColumns2.add(this.CurrentRSDescriptions[this.CurrentResultsetIndex][i]);
        }
        return baseColumns2;
    }

    public BaseColumn[] describeColumns(int n) throws SQLException {
        if (this.CurrentRSDescriptions == null) {
            this.CurrentRSDescriptions = new BaseColumn[n + 1][];
        }
        if (this.m_computedNumRowsToFetch == null) {
            this.m_computedNumRowsToFetch = new int[n + 1];
        }
        if (this.CurrentRSDescriptions[n] != null) {
            return this.CurrentRSDescriptions[n];
        }
        TTIFUN_ODNY tTIFUN_ODNY = this.isPreparedPreparedStatement || this.currentCursorId != 0 && !this.isFirstExecute ? new TTIFUN_ODNY(this.currentCursorId, this.implConn) : new TTIFUN_ODNY(this.sql.getFormatted(), this.implConn);
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_ODNY);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.gTTIoer.retCode = 0;
        this.processReply(tTIFUN_ODNY);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
            throw this.myException;
        }
        this.CurrentRSDescriptions[n] = tTIFUN_ODNY.getColumnDescriptions();
        this.m_computedNumRowsToFetch[n] = 0;
        return this.CurrentRSDescriptions[n];
    }

    private OracleInternalParameterSet createInternalParameterSet(BaseParameters baseParameters, OracleInternalParameterSet oracleInternalParameterSet) throws SQLException {
        try {
            if (oracleInternalParameterSet == null) {
                oracleInternalParameterSet = new OracleInternalParameterSet();
            } else {
                oracleInternalParameterSet.reset();
            }
            if (baseParameters == null) {
                return oracleInternalParameterSet;
            }
            int n = baseParameters.count();
            if (n == 0) {
                return oracleInternalParameterSet;
            }
            BaseParameter baseParameter = null;
            for (int i = 0; i < n; ++i) {
                BaseParameter baseParameter2;
                boolean bl = false;
                boolean bl2 = false;
                int n2 = 0;
                BaseParameter baseParameter3 = baseParameters.parametersIn[i];
                if (baseParameter3 != null) {
                    bl = true;
                    n2 = 32;
                }
                if ((baseParameter2 = baseParameters.parametersOut[i]) != null) {
                    bl2 = true;
                    n2 |= 0x10;
                }
                baseParameter = null;
                if (bl) {
                    baseParameter = baseParameter3;
                    if (bl2) {
                        baseParameter = baseParameter3;
                        baseParameter.sqlType = baseParameter2.sqlType;
                    }
                } else {
                    if (!bl2) continue;
                    baseParameter = baseParameter2;
                }
                if (baseParameter.scale < 0) {
                    baseParameter.scale = 0;
                }
                boolean bl3 = false;
                OracleInternalParameter oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
                oracleInternalParameter.m_direction = n2;
                boolean bl4 = false;
                switch (baseParameter.sqlType) {
                    case -10: 
                    case -9: 
                    case -8: {
                        bl3 = true;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        int n3;
                        int n4;
                        if (!(!bl2 && this.implConn.oracleServerVersion >= 902000000L || baseParameter.sqlType != 2005 && baseParameter.sqlType != -10)) {
                            oracleInternalParameter.m_nativeBindType = 112;
                            oracleInternalParameter.m_scale = 0;
                            oracleInternalParameter.m_maxlen = 86L;
                            oracleInternalParameter.m_precision = 0;
                            if (baseParameter.isNull) {
                                oracleInternalParameter.m_nativeDataInLength = 0;
                                break;
                            }
                            OracleImplClob oracleImplClob = this.createTempClob(baseParameter, bl3 ? this.implConn.originalReportedOraNCharset : this.implConn.originalReportedOraCharset, bl3, null, null);
                            baseParameter.setBytes(oracleImplClob.cloblocator);
                            oracleInternalParameter.m_nativeDataInLength = 86;
                            oracleInternalParameter.m_nativeDataIn = oracleImplClob.cloblocator;
                            break;
                        }
                        if (baseParameter.sqlType == -8 || baseParameter.sqlType == -9 || baseParameter.sqlType == -10) {
                            bl3 = true;
                            n4 = this.implConn.thresholdForTreatingCharParamsAsLongForNationalCharset;
                        } else {
                            n4 = this.implConn.thresholdForTreatingCharParamsAsLong;
                        }
                        oracleInternalParameter.m_nativeBindType = 1;
                        if (!bl2 && this.stmtContainsWhereClause && this.implConn.stringParamsMustMatchCharColumns) {
                            oracleInternalParameter.m_nativeBindType = 96;
                        }
                        oracleInternalParameter.m_maxlen = bl2 ? (!this.isPLSQLBlock && this.implConn.oracleServerVersion < 1000000000L ? 4000L : 32767L) : 1L;
                        if (baseParameter.isNull) {
                            oracleInternalParameter.m_nativeDataInLength = 0;
                        } else {
                            byte[] byArray = null;
                            n3 = 0;
                            String string = null;
                            long l = -1L;
                            switch (baseParameter.getType()) {
                                case 14: 
                                case 15: 
                                case 17: {
                                    BaseInputStreamWrapper baseInputStreamWrapper = (BaseInputStreamWrapper)baseParameter.getASCIIStreamNoConvert();
                                    l = baseInputStreamWrapper.length();
                                    if (l == -1L || l > (long)n4) break;
                                    string = baseParameter.getString(-1, this.comm.exceptions);
                                    break;
                                }
                                case 18: {
                                    BaseCharacterStreamWrapper baseCharacterStreamWrapper = (BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReaderNoConvert();
                                    l = baseCharacterStreamWrapper.length();
                                    if (l == -1L || l > (long)n4) break;
                                    string = baseParameter.getString(-1, this.comm.exceptions);
                                    break;
                                }
                                case 19: 
                                case 20: {
                                    break;
                                }
                                default: {
                                    string = baseParameter.getString(-1, this.comm.exceptions);
                                    l = string.length();
                                }
                            }
                            boolean bl5 = false;
                            if (string == null) {
                                bl5 = true;
                            } else if (string.length() == 0 && this.paramMayBeForLOBColumn[i]) {
                                bl5 = true;
                            } else if (string.length() <= n4) {
                                byArray = bl3 ? this.comm.transliteratorForNationalCharset.encode(string) : this.comm.transliterator.encode(string);
                                n3 = byArray.length;
                                if (n3 > n4) {
                                    bl5 = true;
                                }
                            } else {
                                bl5 = true;
                            }
                            if (bl5) {
                                this.createBindingForLongParam(i, baseParameter, byArray, string, l, oracleInternalParameter);
                                bl4 = true;
                            } else {
                                oracleInternalParameter.m_nativeDataIn = byArray;
                                oracleInternalParameter.m_nativeDataInLength = n3;
                                if ((long)oracleInternalParameter.m_nativeDataInLength > oracleInternalParameter.m_maxlen) {
                                    oracleInternalParameter.m_maxlen = oracleInternalParameter.m_nativeDataInLength;
                                }
                            }
                        }
                        oracleInternalParameter.m_precision = 0;
                        oracleInternalParameter.m_scale = 0;
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        if ((this.implConn.oracleServerVersion < 902000000L || bl2) && baseParameter.sqlType == 2004) {
                            oracleInternalParameter.m_nativeBindType = 113;
                            oracleInternalParameter.m_precision = 0;
                            oracleInternalParameter.m_scale = 0;
                            oracleInternalParameter.m_maxlen = 86L;
                            if (baseParameter.isNull) {
                                oracleInternalParameter.m_nativeDataInLength = 0;
                                break;
                            }
                            OracleImplBlob oracleImplBlob = this.createTempBlob(baseParameter, null);
                            baseParameter.setBytes(oracleImplBlob.bloblocator);
                            oracleInternalParameter.m_nativeDataInLength = 86;
                            oracleInternalParameter.m_nativeDataIn = oracleImplBlob.bloblocator;
                            break;
                        }
                        oracleInternalParameter.m_nativeBindType = 23;
                        oracleInternalParameter.m_maxlen = bl2 ? (!this.isPLSQLBlock && this.implConn.oracleServerVersion < 1000000000L ? 4000L : 32767L) : 4000L;
                        if (baseParameter.isNull) {
                            oracleInternalParameter.m_nativeDataInLength = 0;
                        } else {
                            long l = -1L;
                            byte[] byArray = null;
                            switch (baseParameter.getType()) {
                                case 14: 
                                case 15: 
                                case 17: {
                                    BaseInputStreamWrapper baseInputStreamWrapper = (BaseInputStreamWrapper)baseParameter.getASCIIStreamNoConvert();
                                    l = baseInputStreamWrapper.length();
                                    if (l == -1L || l > (long)this.implConn.thresholdForTreatingBinaryParamsAsLong) break;
                                    byArray = baseParameter.getBytes(-1, this.comm.exceptions);
                                    break;
                                }
                                case 18: {
                                    BaseCharacterStreamWrapper baseCharacterStreamWrapper = (BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReaderNoConvert();
                                    l = baseCharacterStreamWrapper.length();
                                    if (l == -1L || l > (long)this.implConn.thresholdForTreatingBinaryParamsAsLong) break;
                                    byArray = baseParameter.getBytes(-1, this.comm.exceptions);
                                    break;
                                }
                                case 19: 
                                case 20: {
                                    break;
                                }
                                default: {
                                    byArray = baseParameter.getBytes(-1, this.comm.exceptions);
                                    l = byArray.length;
                                }
                            }
                            if (byArray == null || byArray.length == 0 && this.paramMayBeForLOBColumn[i] || byArray.length > this.implConn.thresholdForTreatingBinaryParamsAsLong) {
                                this.createBindingForLongParam(i, baseParameter, byArray, null, l, oracleInternalParameter);
                                bl4 = true;
                            } else {
                                oracleInternalParameter.m_nativeDataIn = byArray;
                                oracleInternalParameter.m_nativeDataInLength = oracleInternalParameter.m_nativeDataIn.length;
                            }
                        }
                        oracleInternalParameter.m_precision = 0;
                        oracleInternalParameter.m_scale = 0;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        int n3;
                        if (this.implConn.getSendFloatParametersAsString()) {
                            oracleInternalParameter.m_nativeBindType = 1;
                            oracleInternalParameter.m_maxlen = this.implConn.thresholdForTreatingCharParamsAsLong;
                            if (baseParameter.isNull) {
                                oracleInternalParameter.m_nativeDataInLength = 0;
                            } else {
                                String string = baseParameter.getString(-1, this.comm.exceptions);
                                oracleInternalParameter.m_nativeDataIn = this.comm.transliterator.encode(string);
                                oracleInternalParameter.m_nativeDataInLength = oracleInternalParameter.m_nativeDataIn.length;
                            }
                            oracleInternalParameter.m_precision = 0;
                            oracleInternalParameter.m_scale = 0;
                            break;
                        }
                        if (this.implConn.oracleServerVersion < 1000000000L) {
                            oracleInternalParameter.m_nativeBindType = 6;
                            if (baseParameter.isNull) {
                                oracleInternalParameter.m_nativeDataInLength = 0;
                            } else {
                                String string = baseParameter.getType() == 9 ? (baseParameter.getBoolean(this.comm.exceptions) ? "1" : "0") : baseParameter.getString(-1, this.comm.exceptions);
                                oracleInternalParameter.setupNativeDataInBuffer(22);
                                oracleInternalParameter.m_nativeDataInLength = OracleVNU.convertStringToVNU(oracleInternalParameter.m_nativeDataIn, string, this.implConn, this.comm.exceptions);
                            }
                            oracleInternalParameter.m_maxlen = 22L;
                            oracleInternalParameter.m_precision = 0;
                            oracleInternalParameter.m_scale = 0;
                            break;
                        }
                        if (baseParameter.sqlType == 7) {
                            oracleInternalParameter.m_nativeBindType = 100;
                            if (baseParameter.isNull) {
                                oracleInternalParameter.m_nativeDataInLength = 0;
                            } else {
                                float f = baseParameter.getFloat(this.comm.exceptions);
                                n3 = Float.floatToIntBits(f);
                                n3 = n3 >= 0 ? (n3 |= Integer.MIN_VALUE) : (n3 ^= 0xFFFFFFFF);
                                oracleInternalParameter.setupNativeDataInBuffer(4);
                                oracleInternalParameter.m_nativeDataIn[0] = (byte)(n3 >> 24);
                                oracleInternalParameter.m_nativeDataIn[1] = (byte)(n3 >> 16);
                                oracleInternalParameter.m_nativeDataIn[2] = (byte)(n3 >> 8);
                                oracleInternalParameter.m_nativeDataIn[3] = (byte)n3;
                                oracleInternalParameter.m_nativeDataInLength = 4;
                            }
                            oracleInternalParameter.m_maxlen = 4L;
                            oracleInternalParameter.m_precision = 0;
                            oracleInternalParameter.m_scale = 0;
                            break;
                        }
                        oracleInternalParameter.m_nativeBindType = 101;
                        if (baseParameter.isNull) {
                            oracleInternalParameter.m_nativeDataInLength = 0;
                        } else {
                            double d = baseParameter.getDouble(this.comm.exceptions);
                            long l = Double.doubleToLongBits(d);
                            l = l >= 0L ? (l |= Long.MIN_VALUE) : (l ^= 0xFFFFFFFFFFFFFFFFL);
                            oracleInternalParameter.setupNativeDataInBuffer(8);
                            oracleInternalParameter.m_nativeDataIn[0] = (byte)(l >> 56);
                            oracleInternalParameter.m_nativeDataIn[1] = (byte)(l >> 48);
                            oracleInternalParameter.m_nativeDataIn[2] = (byte)(l >> 40);
                            oracleInternalParameter.m_nativeDataIn[3] = (byte)(l >> 32);
                            oracleInternalParameter.m_nativeDataIn[4] = (byte)(l >> 24);
                            oracleInternalParameter.m_nativeDataIn[5] = (byte)(l >> 16);
                            oracleInternalParameter.m_nativeDataIn[6] = (byte)(l >> 8);
                            oracleInternalParameter.m_nativeDataIn[7] = (byte)l;
                            oracleInternalParameter.m_nativeDataInLength = 8;
                        }
                        oracleInternalParameter.m_maxlen = 8L;
                        oracleInternalParameter.m_precision = 0;
                        oracleInternalParameter.m_scale = 0;
                        break;
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        oracleInternalParameter.m_nativeBindType = 6;
                        oracleInternalParameter.m_maxlen = 22L;
                        oracleInternalParameter.setupNativeDataInBuffer(22);
                        if (baseParameter.isNull) {
                            oracleInternalParameter.m_nativeDataInLength = 0;
                        } else if (baseParameter.type == 4) {
                            oracleInternalParameter.m_nativeDataInLength = OracleVNU.convertIntToVNU(oracleInternalParameter.m_nativeDataIn, baseParameter.intValue);
                        } else {
                            long l = baseParameter.getLong(this.comm.exceptions);
                            oracleInternalParameter.m_nativeDataInLength = OracleVNU.convertLongToVNU(oracleInternalParameter.m_nativeDataIn, l);
                        }
                        oracleInternalParameter.m_precision = 0;
                        oracleInternalParameter.m_scale = 0;
                        break;
                    }
                    case 2: 
                    case 3: {
                        oracleInternalParameter.m_nativeBindType = 6;
                        oracleInternalParameter.m_maxlen = 22L;
                        if (baseParameter.isNull) {
                            oracleInternalParameter.m_nativeDataInLength = 0;
                        } else {
                            BigDecimal bigDecimal = baseParameter.getBigDecimal(this.comm.exceptions);
                            oracleInternalParameter.setupNativeDataInBuffer(22);
                            oracleInternalParameter.m_nativeDataInLength = OracleVNU.convertBigDecimalToVNU(oracleInternalParameter.m_nativeDataIn, bigDecimal, this.implConn, this.comm.exceptions);
                        }
                        oracleInternalParameter.m_precision = 0;
                        oracleInternalParameter.m_scale = 0;
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        int n3;
                        if (baseParameter.sqlType == 93 && this.implConn.oracleServerVersion >= 900000000L) {
                            oracleInternalParameter.m_nativeBindType = 180;
                            oracleInternalParameter.m_maxlen = 11L;
                        } else {
                            oracleInternalParameter.m_nativeBindType = 12;
                            oracleInternalParameter.m_maxlen = 7L;
                        }
                        if (baseParameter.isNull) {
                            oracleInternalParameter.m_nativeDataInLength = 0;
                        } else {
                            oracleInternalParameter.m_nativeDataInLength = 7;
                            BaseTimestamp baseTimestamp = baseParameter.getTimestamp(this.comm.exceptions);
                            if (baseTimestamp.getYear() > 9999) {
                                String[] stringArray = new String[]{"Conversion error - Year in date/timestamp parameter is out of range"};
                                throw this.comm.exceptions.getException(6001, stringArray, "22008");
                            }
                            if (baseParameter.sqlType == 93 && baseTimestamp.getNanos() > 0 && this.implConn.oracleServerVersion >= 900000000L) {
                                oracleInternalParameter.m_nativeDataInLength = 11;
                            }
                            oracleInternalParameter.setupNativeDataInBuffer(11);
                            n3 = baseTimestamp.getYear();
                            oracleInternalParameter.m_nativeDataIn[0] = (byte)(n3 / 100 + 100);
                            oracleInternalParameter.m_nativeDataIn[1] = (byte)(n3 % 100 + 100);
                            oracleInternalParameter.m_nativeDataIn[2] = (byte)(baseTimestamp.getMonth() + 1);
                            oracleInternalParameter.m_nativeDataIn[3] = (byte)baseTimestamp.getDate();
                            oracleInternalParameter.m_nativeDataIn[4] = (byte)(baseTimestamp.getHours() + 1);
                            oracleInternalParameter.m_nativeDataIn[5] = (byte)(baseTimestamp.getMinutes() + 1);
                            oracleInternalParameter.m_nativeDataIn[6] = (byte)(baseTimestamp.getSeconds() + 1);
                            if (oracleInternalParameter.m_nativeDataInLength == 11) {
                                int n5 = baseTimestamp.getNanos();
                                oracleInternalParameter.m_nativeDataIn[7] = (byte)(n5 >> 24);
                                oracleInternalParameter.m_nativeDataIn[8] = (byte)(n5 >> 16 & 0xFF);
                                oracleInternalParameter.m_nativeDataIn[9] = (byte)(n5 >> 8 & 0xFF);
                                oracleInternalParameter.m_nativeDataIn[10] = (byte)(n5 & 0xFF);
                            }
                        }
                        oracleInternalParameter.m_precision = 0;
                        oracleInternalParameter.m_scale = 0;
                        break;
                    }
                    case -999: {
                        oracleInternalParameter.m_maxlen = 1L;
                        oracleInternalParameter.m_nativeBindType = 102;
                        oracleInternalParameter.m_precision = 0;
                        oracleInternalParameter.m_scale = 0;
                        oracleInternalParameter.setupNativeDataInBuffer(1);
                        oracleInternalParameter.m_nativeDataIn[0] = 0;
                        oracleInternalParameter.m_nativeDataInLength = 1;
                        break;
                    }
                    default: {
                        String[] stringArray = new String[]{"Unhandled sql type"};
                        throw this.comm.exceptions.getException(6001, stringArray);
                    }
                }
                if (bl4) continue;
                if (bl3) {
                    oracleInternalParameter.m_charSetId = this.implConn.originalReportedOraNCharset;
                    oracleInternalParameter.m_charSetForm = 2;
                    oracleInternalParameter.m_transliterator = this.comm.transliteratorForNationalCharset;
                    continue;
                }
                oracleInternalParameter.m_charSetId = 0;
                oracleInternalParameter.m_charSetForm = 0;
                oracleInternalParameter.m_transliterator = this.comm.transliterator;
            }
            return oracleInternalParameterSet;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    private short convertResultSet(byte[] byArray, int n) {
        if (n == 1) {
            return (short)(byArray[0] >= 0 ? byArray[0] : byArray[0] + 256);
        }
        short s = (short)(byArray[0] >= 0 ? byArray[0] : byArray[0] + 256);
        short s2 = (short)(byArray[1] >= 0 ? byArray[1] : byArray[1] + 256);
        return (short)(s * 256 + s2);
    }

    private float convertFloat(byte[] byArray) {
        int n = byArray[0];
        int n2 = byArray[1];
        int n3 = byArray[2];
        int n4 = byArray[3];
        if ((n & 0x80) != 0) {
            n &= 0x7F;
            n2 &= 0xFF;
            n3 &= 0xFF;
            n4 &= 0xFF;
        } else {
            n = ~n & 0xFF;
            n2 = ~n2 & 0xFF;
            n3 = ~n3 & 0xFF;
            n4 = ~n4 & 0xFF;
        }
        int n5 = n << 24 | n2 << 16 | n3 << 8 | n4;
        return Float.intBitsToFloat(n5);
    }

    private double convertDouble(byte[] byArray) {
        int n = byArray[0];
        int n2 = byArray[1];
        int n3 = byArray[2];
        int n4 = byArray[3];
        int n5 = byArray[4];
        int n6 = byArray[5];
        int n7 = byArray[6];
        int n8 = byArray[7];
        if ((n & 0x80) != 0) {
            n &= 0x7F;
            n2 &= 0xFF;
            n3 &= 0xFF;
            n4 &= 0xFF;
            n5 &= 0xFF;
            n6 &= 0xFF;
            n7 &= 0xFF;
            n8 &= 0xFF;
        } else {
            n = ~n & 0xFF;
            n2 = ~n2 & 0xFF;
            n3 = ~n3 & 0xFF;
            n4 = ~n4 & 0xFF;
            n5 = ~n5 & 0xFF;
            n6 = ~n6 & 0xFF;
            n7 = ~n7 & 0xFF;
            n8 = ~n8 & 0xFF;
        }
        int n9 = n << 24 | n2 << 16 | n3 << 8 | n4;
        int n10 = n5 << 24 | n6 << 16 | n7 << 8 | n8;
        long l = (long)n9 << 32 | (long)n10 & 0xFFFFFFFFL;
        return Double.longBitsToDouble(l);
    }

    private void convertAndPropagateOutputParams(OracleInternalParameterSet oracleInternalParameterSet, BaseParameters baseParameters) throws UtilException, SQLException {
        int n = 1;
        block17: for (int i = 0; i < oracleInternalParameterSet.getNumParams(); ++i) {
            OracleInternalParameter oracleInternalParameter = oracleInternalParameterSet.paramSet[i];
            if ((oracleInternalParameter.m_direction & 0x10) == 0) continue;
            if (!oracleInternalParameter.isActualOutputParam()) {
                oracleInternalParameter.nullifyOutputValue();
            }
            for (int j = n; j <= baseParameters.count(); ++j) {
                BaseParameter baseParameter = baseParameters.parametersOut[j - 1];
                byte[] byArray = null;
                int n2 = oracleInternalParameter.getNumOutputValues();
                boolean bl = false;
                if (baseParameter == null) continue;
                block0 : switch (oracleInternalParameter.m_nativeBindType) {
                    case 102: {
                        int n3;
                        Object[] objectArray;
                        if (n2 == 0) {
                            baseParameter.setNull(3);
                            break;
                        }
                        if (n2 > 1) {
                            objectArray = new Short[n2];
                            for (n3 = 0; n3 < n2; ++n3) {
                                int n4;
                                byArray = oracleInternalParameter.getOutputValue(n3, this.comm.exceptions);
                                objectArray[n3] = byArray == null ? null : ((n4 = oracleInternalParameter.getOutputValueLength(n3, this.comm.exceptions)) > 2 ? null : new Short(this.convertResultSet(byArray, n4)));
                            }
                            baseParameter.setArray(objectArray, 3);
                            break;
                        }
                        byArray = oracleInternalParameter.getSingleOutputValue(this.comm.exceptions);
                        int n5 = oracleInternalParameter.getOutputValueLength(0, this.comm.exceptions);
                        if (n5 > 2) {
                            baseParameter.setNull(3);
                            break;
                        }
                        baseParameter.setShort(this.convertResultSet(byArray, n5));
                        break;
                    }
                    case 12: {
                        if (n2 == 0) {
                            baseParameter.setNull(108);
                            break;
                        }
                        if (n2 > 1) {
                            baseParameter.setArray((Object[])oracleInternalParameter.getAllOutputValues(), 108);
                            break;
                        }
                        byArray = oracleInternalParameter.getSingleOutputValue(this.comm.exceptions);
                        baseParameter.setNativeBytes(byArray, 108);
                        break;
                    }
                    case 180: {
                        if (n2 == 0) {
                            baseParameter.setNull(109);
                            break;
                        }
                        if (n2 > 1) {
                            baseParameter.setArray((Object[])oracleInternalParameter.getAllOutputValues(), 109);
                            break;
                        }
                        byArray = oracleInternalParameter.getSingleOutputValue(this.comm.exceptions);
                        baseParameter.setNativeBytes(byArray, 109);
                        break;
                    }
                    case 23: 
                    case 24: {
                        if (n2 == 0) {
                            baseParameter.setNull(2);
                            break;
                        }
                        if (n2 > 1) {
                            baseParameter.setArray((Object[])oracleInternalParameter.getAllOutputValues(), 2);
                            break;
                        }
                        byArray = oracleInternalParameter.getSingleOutputValue(this.comm.exceptions);
                        baseParameter.setNativeBytes(byArray, 2);
                        break;
                    }
                    case 112: {
                        int n3;
                        Object[] objectArray;
                        if (baseParameter.sqlType == -10) {
                            bl = true;
                        }
                        if (n2 == 0) {
                            baseParameter.setNull(20);
                            break;
                        }
                        if (n2 > 1) {
                            objectArray = new OracleImplClob[n2];
                            for (n3 = 0; n3 < n2; ++n3) {
                                byArray = oracleInternalParameter.getOutputValue(n3, this.comm.exceptions);
                                objectArray[n3] = byArray == null ? null : new OracleImplClob(byArray, this, bl ? this.implConn.originalReportedOraNCharset : this.implConn.originalReportedOraCharset);
                            }
                            baseParameter.setArray(objectArray, 20);
                            break;
                        }
                        byArray = oracleInternalParameter.getSingleOutputValue(this.comm.exceptions);
                        baseParameter.setClob((BaseImplClob)new OracleImplClob(byArray, this, bl ? this.implConn.originalReportedOraNCharset : this.implConn.originalReportedOraCharset));
                        break;
                    }
                    case 113: {
                        int n3;
                        Object[] objectArray;
                        if (n2 == 0) {
                            baseParameter.setNull(19);
                            break;
                        }
                        if (n2 > 1) {
                            objectArray = new OracleImplBlob[n2];
                            for (n3 = 0; n3 < n2; ++n3) {
                                byArray = oracleInternalParameter.getOutputValue(n3, this.comm.exceptions);
                                objectArray[n3] = byArray == null ? null : new OracleImplBlob(byArray, this);
                            }
                            baseParameter.setArray(objectArray, 19);
                            break;
                        }
                        byArray = oracleInternalParameter.getSingleOutputValue(this.comm.exceptions);
                        baseParameter.setBlob((BaseImplBlob)new OracleImplBlob(byArray, this));
                        break;
                    }
                    case 6: {
                        int n3;
                        Object[] objectArray;
                        switch (baseParameter.sqlType) {
                            case 2: 
                            case 3: {
                                if (n2 == 0) {
                                    baseParameter.setData(8, null);
                                    break block0;
                                }
                                if (n2 > 1) {
                                    objectArray = new String[n2];
                                    for (n3 = 0; n3 < n2; ++n3) {
                                        byArray = oracleInternalParameter.getOutputValue(n3, this.comm.exceptions);
                                        objectArray[n3] = byArray == null ? null : OracleVNU.convertVNUToString(byArray, 0, oracleInternalParameter.getOutputValueLength(n3, this.comm.exceptions), baseParameter.scale, (OracleImplConnection)this.implConnection);
                                    }
                                    baseParameter.setArray(objectArray, 10);
                                    break block0;
                                }
                                byArray = oracleInternalParameter.getSingleOutputValue(this.comm.exceptions);
                                baseParameter.setData(10, (Object)OracleVNU.convertVNUToString(byArray, 0, oracleInternalParameter.getSingleOutputValueLength(this.comm.exceptions), baseParameter.scale, (OracleImplConnection)this.implConnection));
                                break block0;
                            }
                            case 6: 
                            case 7: 
                            case 8: {
                                if (n2 == 0) {
                                    baseParameter.setData(7, null);
                                    break block0;
                                }
                                if (n2 > 1) {
                                    objectArray = new Double[n2];
                                    for (n3 = 0; n3 < n2; ++n3) {
                                        byArray = oracleInternalParameter.getOutputValue(n3, this.comm.exceptions);
                                        objectArray[n3] = byArray == null ? null : new Double(OracleVNU.convertVNUToDouble(byArray, oracleInternalParameter.getOutputValueLength(n3, this.comm.exceptions)));
                                    }
                                    baseParameter.setArray(objectArray, 7);
                                    break block0;
                                }
                                byArray = oracleInternalParameter.getSingleOutputValue(this.comm.exceptions);
                                baseParameter.setDouble(OracleVNU.convertVNUToDouble(byArray, oracleInternalParameter.getSingleOutputValueLength(this.comm.exceptions)));
                                break block0;
                            }
                            case -7: 
                            case -6: 
                            case -5: 
                            case 4: 
                            case 5: {
                                if (n2 == 0) {
                                    baseParameter.setNull(4);
                                    break block0;
                                }
                                if (n2 > 1) {
                                    objectArray = new Long[n2];
                                    for (n3 = 0; n3 < n2; ++n3) {
                                        byArray = oracleInternalParameter.getOutputValue(n3, this.comm.exceptions);
                                        objectArray[n3] = byArray == null ? null : new Long(OracleVNU.convertVNUToLong(byArray, oracleInternalParameter.getOutputValueLength(n3, this.comm.exceptions), this.comm.exceptions));
                                    }
                                    baseParameter.setArray(objectArray, 5);
                                    break block0;
                                }
                                byArray = oracleInternalParameter.getSingleOutputValue(this.comm.exceptions);
                                baseParameter.setLong(OracleVNU.convertVNUToLong(byArray, oracleInternalParameter.getSingleOutputValueLength(this.comm.exceptions), this.comm.exceptions));
                                break block0;
                            }
                        }
                        objectArray = new String[]{"Unexpected sqlType"};
                        throw this.comm.exceptions.getException(6001, (String[])objectArray);
                    }
                    case 100: {
                        int n3;
                        Object[] objectArray;
                        if (n2 == 0) {
                            baseParameter.setData(6, null);
                            break;
                        }
                        if (n2 > 1) {
                            objectArray = new Float[n2];
                            for (n3 = 0; n3 < n2; ++n3) {
                                byArray = oracleInternalParameter.getOutputValue(n3, this.comm.exceptions);
                                objectArray[n3] = byArray == null ? null : new Float(this.convertFloat(byArray));
                            }
                            baseParameter.setArray(objectArray, 6);
                            break;
                        }
                        byArray = oracleInternalParameter.getSingleOutputValue(this.comm.exceptions);
                        baseParameter.setFloat(this.convertFloat(byArray));
                        break;
                    }
                    case 101: {
                        int n3;
                        Object[] objectArray;
                        if (n2 == 0) {
                            baseParameter.setData(7, null);
                            break;
                        }
                        if (n2 > 1) {
                            objectArray = new Double[n2];
                            for (n3 = 0; n3 < n2; ++n3) {
                                byArray = oracleInternalParameter.getOutputValue(n3, this.comm.exceptions);
                                objectArray[n3] = byArray == null ? null : new Double(this.convertDouble(byArray));
                            }
                            baseParameter.setArray(objectArray, 7);
                            break;
                        }
                        byArray = oracleInternalParameter.getSingleOutputValue(this.comm.exceptions);
                        baseParameter.setDouble(this.convertDouble(byArray));
                        break;
                    }
                    case 1: 
                    case 8: 
                    case 96: {
                        int n3;
                        Object[] objectArray;
                        if (baseParameter.sqlType == -8 || baseParameter.sqlType == -9) {
                            bl = true;
                        }
                        if (n2 == 0) {
                            baseParameter.setNull(10);
                            break;
                        }
                        if (n2 > 1) {
                            objectArray = new String[n2];
                            for (n3 = 0; n3 < n2; ++n3) {
                                byArray = oracleInternalParameter.getOutputValue(n3, this.comm.exceptions);
                                objectArray[n3] = byArray == null ? null : (bl ? this.comm.transliteratorForNationalCharset.decode(byArray, 0, oracleInternalParameter.getOutputValueLength(n3, this.comm.exceptions)) : this.comm.transliterator.decode(byArray, 0, oracleInternalParameter.getOutputValueLength(n3, this.comm.exceptions)));
                            }
                            baseParameter.setArray(objectArray, 10);
                            break;
                        }
                        byArray = oracleInternalParameter.getSingleOutputValue(this.comm.exceptions);
                        if (bl) {
                            baseParameter.setString(this.comm.transliteratorForNationalCharset.decode(byArray, 0, oracleInternalParameter.getSingleOutputValueLength(this.comm.exceptions)));
                            break;
                        }
                        baseParameter.setString(this.comm.transliterator.decode(byArray, 0, oracleInternalParameter.getSingleOutputValueLength(this.comm.exceptions)));
                        break;
                    }
                    default: {
                        Object[] objectArray = new String[]{"Unexpected native bind type"};
                        throw this.comm.exceptions.getException(6001, (String[])objectArray);
                    }
                }
                if (baseParameter.nativeType != 0) {
                    baseParameter.sqlType = baseParameter.nativeType;
                }
                n = j + 1;
                continue block17;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void createBindingForLongParam(int var1_1, BaseParameter var2_2, byte[] var3_3, String var4_4, long var5_5, OracleInternalParameter var7_6) throws UtilException, SQLException {
        block58: {
            block59: {
                var8_7 = 0;
                if (this.RememberedColumnTypes == null) {
                    var9_8 = this.sql.getUpdateTableSpecification();
                    if (var9_8 != null) {
                        var10_10 = "select * from " + var9_8 + " where 0=1";
                        var11_12 = new TTIFUN_ODNY(var10_10, this.implConn);
                        this.NSPTDAPacket.appendTTISubPacket(var11_12);
                        this.NSPTDAPacket.sendRequest();
                        this.NSPTDAPacket.receiveReply();
                        this.gTTIoer.retCode = 0;
                        this.processReply(var11_12);
                        if (this.gTTIoer.retCode == 0) {
                            var12_15 = var11_12.getColumnDescriptions();
                            var8_7 = var12_15.length;
                            this.RememberedColumnTypes = new int[var8_7];
                            this.RememberedColumnNames = new String[var8_7];
                            for (var13_18 = 0; var13_18 < var8_7; ++var13_18) {
                                var14_19 = (OracleColumn)var12_15[var13_18];
                                this.RememberedColumnNames[var13_18] = var14_19.name;
                                this.RememberedColumnTypes[var13_18] = var14_19.charSetForm == 2 ? -var14_19.OCINativeType : var14_19.OCINativeType;
                            }
                        }
                    }
                } else {
                    var8_7 = this.RememberedColumnTypes.length;
                }
                var9_9 = 0;
                if (var8_7 == 0) break block58;
                var10_10 = null;
                if (this.updateCols[var1_1] == null) {
                    this.updateCols[var1_1] = var10_10 = this.sql.getUpdateColumnSpecification(var1_1 + 1);
                } else {
                    var10_10 = this.updateCols[var1_1];
                }
                if (var10_10 != null) break block59;
                if (this.SQLStmtType != 3) break block58;
                var9_9 = this.RememberedColumnTypes[var1_1];
                break block58;
            }
            var10_10 = var10_10.trim();
            try {
                var11_13 = Integer.parseInt(var10_10);
                var9_9 = this.RememberedColumnTypes[var11_13 - 1];
            }
            catch (Exception var11_14) {
                var12_16 = false;
                if (var10_10.charAt(var10_10.length() - 1) == '\"') {
                    for (var13_18 = var10_10.length() - 2; var13_18 >= 0 && var10_10.charAt(var13_18) != '\"'; --var13_18) {
                    }
                    if (var13_18 >= 0) {
                        var10_10 = var10_10.substring(var13_18 + 1, var10_10.length() - 1);
                        var12_16 = true;
                    }
                } else {
                    var13_18 = var10_10.indexOf(46);
                    if (var13_18 != -1) {
                        var14_20 = var13_18;
                        while ((var13_18 = var10_10.indexOf(46, var14_20 + 1)) != -1) {
                            var14_20 = var13_18;
                        }
                        var10_10 = var10_10.substring(var14_20 + 1);
                    }
                }
                for (var13_18 = 0; var13_18 < var8_7; ++var13_18) {
                    if (var12_16) {
                        if (!var10_10.equals(this.RememberedColumnNames[var13_18])) continue;
                        var9_9 = this.RememberedColumnTypes[var13_18];
                        break;
                    }
                    if (!var10_10.equalsIgnoreCase(this.RememberedColumnNames[var13_18])) continue;
                    var9_9 = this.RememberedColumnTypes[var13_18];
                    break;
                }
            }
        }
        if (var9_9 == 0) {
            var9_9 = var4_4 != null && var4_4.length() == 0 ? 1 : (var2_2.sqlType == -8 || var2_2.sqlType == -9 || var2_2.sqlType == -10 ? -8 : (var2_2.sqlType == 1 || var2_2.sqlType == 12 || var2_2.sqlType == -1 || var2_2.sqlType == -8 ? (this.stmtContainsWhereClause ? 96 : 8) : (var2_2.sqlType == 2005 ? 112 : 24)));
        }
        var13_18 = 0;
        if (var9_9 < 0) {
            var9_9 = -var9_9;
            var13_18 = 1;
        }
        var14_21 = this.comm.transliterator;
        var15_22 = this.implConn.originalReportedOraCharset;
        var16_23 = this.implConn.maxBytesPerCharForOriginalReportedOraCharset;
        if (var13_18 != 0 || var2_2.sqlType == -8 || var2_2.sqlType == -9 || var2_2.sqlType == -10) {
            var14_21 = this.comm.transliteratorForNationalCharset;
            var15_22 = this.implConn.originalReportedOraNCharset;
            var16_23 = this.implConn.maxBytesPerCharForOriginalReportedOraNationalCharset;
        }
        if (var3_3 != null) {
            switch (var9_9) {
                case 23: 
                case 24: 
                case 113: {
                    if (var2_2.sqlType == -2 || var2_2.sqlType == -3 || var2_2.sqlType == -4 || var2_2.sqlType == 2004) break;
                    var3_3 = null;
                    break;
                }
                case 1: 
                case 2: 
                case 8: 
                case 96: 
                case 109: 
                case 112: {
                    if (var13_18 != 0) {
                        if (var2_2.sqlType == -8 || var2_2.sqlType == -9 || var2_2.sqlType == -10) break;
                        var3_3 = null;
                        break;
                    }
                    if (var2_2.sqlType == 1 || var2_2.sqlType == 12 || var2_2.sqlType == -1 || var2_2.sqlType == 2005) break;
                    var3_3 = null;
                    break;
                }
                default: {
                    var17_24 = new String[]{"Unexpected native column type"};
                    throw this.comm.exceptions.getException(6001, var17_24);
                }
            }
        }
        switch (var9_9) {
            case 113: {
                var17_25 = this.SQLStmtType == 3 ? Math.min(32512, this.implConn.largestAllowableMaxLengthValueForVARCHARandRAWParams) : this.implConn.largestAllowableMaxLengthValueForVARCHARandRAWParams;
                if (var3_3 != null) ** GOTO lbl110
                if (var5_5 == -1L || var5_5 > (long)var17_25) {
                    var18_26 = false;
                } else {
                    var7_6.m_nativeDataIn = null;
                    var12_17 = 23;
                    var10_11 = var5_5;
                    var7_6.m_baseParameter = var2_2;
                    break;
lbl110:
                    // 1 sources

                    var18_26 = var3_3.length != 0 && var3_3.length <= var17_25;
                }
                if (var18_26) {
                    var7_6.m_nativeDataIn = var3_3;
                    var12_17 = 23;
                    var10_11 = var7_6.m_nativeDataIn.length;
                    break;
                }
                var12_17 = 113;
                var19_27 = this.createTempBlob(var2_2, var3_3);
                var2_2.setBytes(var19_27.bloblocator);
                var7_6.m_nativeDataIn = var19_27.bloblocator;
                var10_11 = 86L;
                break;
            }
            case 112: {
                var19_28 = true;
                if (var3_3 != null) ** GOTO lbl141
                if (var4_4 != null) {
                    if (var4_4.length() == 0) {
                        var19_28 = false;
                    } else {
                        var3_3 = var14_21.encode(var4_4);
                        if (var3_3.length > this.implConn.largestAllowableMaxLengthValueForVARCHARandRAWParams) {
                            var19_28 = false;
                        }
                    }
                } else if (var5_5 == -1L || var5_5 * (long)var16_23 > (long)this.implConn.largestAllowableMaxLengthValueForVARCHARandRAWParams) {
                    var19_28 = false;
                } else {
                    var7_6.m_nativeDataIn = null;
                    var12_17 = 1;
                    var10_11 = var5_5 * (long)var16_23;
                    var7_6.m_baseParameter = var2_2;
                    break;
lbl141:
                    // 1 sources

                    if (var3_3.length > this.implConn.largestAllowableMaxLengthValueForVARCHARandRAWParams) {
                        var19_28 = false;
                    }
                }
                if (var19_28) {
                    var7_6.m_nativeDataIn = var3_3;
                    var12_17 = 1;
                    var10_11 = var7_6.m_nativeDataIn.length;
                    break;
                }
                var12_17 = 112;
                var20_29 = this.createTempClob(var2_2, var15_22, (boolean)var13_18, var4_4, var3_3);
                var2_2.setBytes(var20_29.cloblocator);
                var7_6.m_nativeDataIn = var20_29.cloblocator;
                var10_11 = 86L;
                break;
            }
            case 109: {
                var12_17 = 112;
                var20_30 = this.createTempClob(var2_2, var15_22, (boolean)var13_18, var4_4, var3_3);
                var2_2.setBytes(var20_30.cloblocator);
                var7_6.m_nativeDataIn = var20_30.cloblocator;
                var10_11 = 86L;
                break;
            }
            case 23: {
                this.paramMayBeForLOBColumn[var1_1] = false;
                var12_17 = 23;
                var10_11 = this.implConn.largestAllowableMaxLengthValueForVARCHARandRAWParams;
                if (var3_3 == null) {
                    var7_6.m_nativeDataIn = var2_2.getBytes(-1, this.comm.exceptions);
                    break;
                }
                var7_6.m_nativeDataIn = var3_3;
                break;
            }
            case 24: {
                this.paramMayBeForLOBColumn[var1_1] = false;
                var12_17 = 24;
                if (var3_3 == null) {
                    var10_11 = var5_5 == -1L ? 0x7FFFFFFFL : var5_5;
                    var7_6.m_nativeDataIn = null;
                    var7_6.m_baseParameter = var2_2;
                    break;
                }
                var7_6.m_nativeDataIn = var3_3;
                if (this.SQLStmtType == 3) {
                    var10_11 = 32767L;
                    break;
                }
                var10_11 = Math.max(32767, var7_6.m_nativeDataIn.length);
                break;
            }
            case 8: {
                this.paramMayBeForLOBColumn[var1_1] = false;
                var12_17 = 8;
                var10_11 = 0x7FFFFFFFL;
                if (var3_3 == null) {
                    if (var4_4 == null) {
                        var7_6.m_nativeDataIn = null;
                        var7_6.m_baseParameter = var2_2;
                        break;
                    }
                    var7_6.m_nativeDataIn = var14_21.encode(var4_4);
                    break;
                }
                var7_6.m_nativeDataIn = var3_3;
                break;
            }
            default: {
                this.paramMayBeForLOBColumn[var1_1] = false;
                if (var3_3 == null) {
                    if (var4_4 == null) {
                        var4_4 = var2_2.getString(-1, this.comm.exceptions);
                    }
                    var7_6.m_nativeDataIn = var14_21.encode(var4_4);
                } else {
                    var7_6.m_nativeDataIn = var3_3;
                }
                if (this.SQLStmtType == 3 || (var7_6.m_direction & 16) != 0) {
                    var12_17 = 8;
                    var10_11 = 0x7FFFFFFFL;
                    break;
                }
                var12_17 = 96;
                var10_11 = var7_6.m_nativeDataIn.length > 1 ? (long)var7_6.m_nativeDataIn.length : 1L;
            }
        }
        var7_6.m_nativeBindType = var12_17;
        var7_6.m_precision = 0;
        var7_6.m_scale = 0;
        var7_6.m_maxlen = var10_11;
        var7_6.m_transliterator = var14_21;
        if (var13_18 != 0) {
            var7_6.m_charSetId = this.implConn.originalReportedOraNCharset;
            var7_6.m_charSetForm = 2;
        } else {
            var7_6.m_charSetId = 0;
            var7_6.m_charSetForm = 0;
        }
        if (var7_6.m_nativeDataIn != null) {
            var7_6.m_nativeDataInLength = var7_6.m_nativeDataIn.length;
        }
    }

    private void rememberBindTypes(OracleInternalParameterSet oracleInternalParameterSet) {
        if (this.m_orgParamBindInfo == null) {
            this.m_orgParamBindInfo = new OracleInternalParameterSet();
        } else {
            this.m_orgParamBindInfo.reset();
        }
        for (int i = 0; i < oracleInternalParameterSet.getNumParams(); ++i) {
            OracleInternalParameter oracleInternalParameter = this.m_orgParamBindInfo.getAvailableParameter();
            oracleInternalParameter.copy(oracleInternalParameterSet.paramSet[i]);
        }
    }

    private void formulateParamBindInfo(OracleInternalParameterSet[] oracleInternalParameterSetArray, int n) {
        if (this.m_requiredParamBindInfo == null) {
            this.m_requiredParamBindInfo = new OracleInternalParameterSet();
        } else {
            this.m_requiredParamBindInfo.reset();
        }
        int n2 = oracleInternalParameterSetArray[0].getNumParams();
        for (int i = 0; i < n2; ++i) {
            long l;
            OracleInternalParameter oracleInternalParameter = this.m_requiredParamBindInfo.getAvailableParameter();
            OracleInternalParameter oracleInternalParameter2 = oracleInternalParameterSetArray[0].paramSet[i];
            oracleInternalParameter.copy(oracleInternalParameter2);
            if (oracleInternalParameter2.m_nativeBindType != 96 && oracleInternalParameter2.m_nativeBindType != 1 && oracleInternalParameter2.m_nativeBindType != 23) continue;
            if (n == 1) {
                if (this.m_orgParamBindInfo == null || oracleInternalParameter2.m_maxlen <= (l = this.m_orgParamBindInfo.paramSet[i].m_maxlen)) continue;
                if (oracleInternalParameter2.m_nativeBindType == 23) {
                    if (oracleInternalParameter2.m_maxlen >= (long)this.implConn.largestAllowableMaxLengthValueForVARCHARandRAWParams) continue;
                    long l2 = oracleInternalParameter2.m_maxlen + (oracleInternalParameter2.m_maxlen - l);
                    if (l2 > (long)this.implConn.largestAllowableMaxLengthValueForVARCHARandRAWParams) {
                        oracleInternalParameter.m_maxlen = this.implConn.largestAllowableMaxLengthValueForVARCHARandRAWParams;
                        continue;
                    }
                    oracleInternalParameter.m_maxlen = l2;
                    continue;
                }
                if (oracleInternalParameter2.m_maxlen >= (long)this.implConn.thresholdForTreatingCharParamsAsLong) continue;
                long l3 = oracleInternalParameter2.m_maxlen + (oracleInternalParameter2.m_maxlen - l);
                if (l3 > (long)this.implConn.thresholdForTreatingCharParamsAsLong) {
                    oracleInternalParameter.m_maxlen = this.implConn.thresholdForTreatingCharParamsAsLong;
                    continue;
                }
                oracleInternalParameter.m_maxlen = l3;
                continue;
            }
            l = oracleInternalParameter2.m_maxlen;
            for (int j = 1; j < n; ++j) {
                oracleInternalParameter2 = oracleInternalParameterSetArray[j].paramSet[i];
                if (l >= oracleInternalParameter2.m_maxlen) continue;
                l = oracleInternalParameter2.m_maxlen;
            }
            oracleInternalParameter.m_maxlen = l;
        }
    }

    private boolean bindTypesOrMaxLensHaveChanged(OracleInternalParameterSet oracleInternalParameterSet) {
        if (this.m_orgParamBindInfo != null) {
            for (int i = 0; i < this.m_orgParamBindInfo.getNumParams(); ++i) {
                OracleInternalParameter oracleInternalParameter = this.m_orgParamBindInfo.paramSet[i];
                OracleInternalParameter oracleInternalParameter2 = oracleInternalParameterSet.paramSet[i];
                if (oracleInternalParameter.m_nativeBindType == oracleInternalParameter2.m_nativeBindType && oracleInternalParameter.m_maxlen >= oracleInternalParameter2.m_maxlen && oracleInternalParameter.m_charSetId == oracleInternalParameter2.m_charSetId) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean paramTypesMatchForAllParamSets() {
        int n = this.parameterSets == null ? 1 : this.parameterSets.size();
        int n2 = this.m_internalParamSets[0].getNumParams();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.m_internalParamSets[0].paramSet[i].m_nativeBindType;
            for (int j = 1; j < n; ++j) {
                OracleInternalParameter oracleInternalParameter = this.m_internalParamSets[j].paramSet[i];
                if (oracleInternalParameter != null && oracleInternalParameter.m_nativeBindType == n3) continue;
                return false;
            }
        }
        return true;
    }

    private class storedProcParamInfo {
        String name;
        String nativeTypeName;
        int nativeType;
        String overload;
        String direction;

        private storedProcParamInfo() {
        }
    }
}

