/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BlockedOnMemoryException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.lob.CharLobChunk;
import com.metamatrix.common.lob.LobChunk;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.InvalidReferenceException;
import com.metamatrix.common.types.SQLXMLImpl;
import com.metamatrix.common.types.XMLType;
import com.metamatrix.core.jdbc.SQLXML;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.BaseProcessorPlan;
import com.metamatrix.query.processor.DescribableUtil;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.TempTableDataManager;
import com.metamatrix.query.processor.xml.DocumentInProgress;
import com.metamatrix.query.processor.xml.ProcessorInstruction;
import com.metamatrix.query.processor.xml.Program;
import com.metamatrix.query.processor.xml.ProgramUtil;
import com.metamatrix.query.processor.xml.XMLContext;
import com.metamatrix.query.processor.xml.XMLPlan;
import com.metamatrix.query.processor.xml.XMLProcessorEnvironment;
import com.metamatrix.query.processor.xml.XMLUtil;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.tempdata.TempTableStore;
import com.metamatrix.query.tempdata.TempTableStoreImpl;
import com.metamatrix.query.util.CommandContext;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XMLPlan
extends BaseProcessorPlan
implements ProcessorPlan {
    private XMLProcessorEnvironment env;
    private Program originalProgram;
    XMLContext context = new XMLContext();
    private ProcessorDataManager dataMgr;
    private BufferManager bufferMgr;
    private int chunkSize = 102400;
    private int nextBatchCount = 1;
    TupleSourceID resultsTupleSourceId = null;
    boolean docInProgress = false;
    TupleSourceID docInProgressTupleSourceId = null;
    int chunkPosition = 0;
    private String styleSheet;
    private boolean shouldValidate = false;
    private Collection xmlSchemas;
    public static final String XERCES_VALIDATION_FEATURE = QueryExecPlugin.Util.getString("XMLPlan.Validation_feature");
    public static final String XERCES_SCHEMA_VALIDATION_FEATURE = QueryExecPlugin.Util.getString("XMLPlan.Schema_validation_feature");
    public static final String XERCES_NAMESPACES_FEATURE = QueryExecPlugin.Util.getString("XMLPlan.Namespaces_features");
    public static final String XERCES_NO_NAMESPACE_PROPERTY = QueryExecPlugin.Util.getString("XMLPlan.No_namespace_property");
    public static final String XERCES_EXTERNAL_SCHEMA_LOCATION = QueryExecPlugin.Util.getString("XMLPlan.External_schema_location");

    public XMLPlan(XMLProcessorEnvironment env) {
        this.env = env;
        this.originalProgram = this.env.getCurrentProgram();
    }

    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        this.setContext(context);
        if (context.getStreamingBatchSize() != 0) {
            this.chunkSize = context.getStreamingBatchSize() * 1024;
        }
        TempTableStoreImpl tempTableStore = new TempTableStoreImpl(bufferMgr, context.getConnectionID(), (TempTableStore)context.getTempTableStore());
        this.dataMgr = new TempTableDataManager(dataMgr, tempTableStore);
        this.bufferMgr = bufferMgr;
        this.env.initialize(context, this.dataMgr, this.bufferMgr);
    }

    public void reset() {
        super.reset();
        this.styleSheet = null;
        this.shouldValidate = false;
        this.nextBatchCount = 1;
        this.env = (XMLProcessorEnvironment)this.env.clone();
        LogManager.logTrace((String)"XML_PLAN", (String)"XMLPlan reset");
    }

    public ProcessorDataManager getDataManager() {
        return this.dataMgr;
    }

    public void connectTupleSource(TupleSource source, int dataRequestID) {
    }

    public List getOutputElements() {
        ArrayList<ElementSymbol> output = new ArrayList<ElementSymbol>(1);
        ElementSymbol xml = new ElementSymbol("xml");
        xml.setType(DataTypeManager.DefaultDataClasses.XML);
        output.add(xml);
        return output;
    }

    public void open() throws MetaMatrixComponentException {
        if (this.resultsTupleSourceId == null) {
            this.resultsTupleSourceId = XMLUtil.createXMLTupleSource((BufferManager)this.bufferMgr, (String)this.getContext().getConnectionID());
        }
    }

    public TupleBatch nextBatch() throws MetaMatrixComponentException, MetaMatrixProcessingException, BlockedException {
        List rows = this.processXML();
        if (rows == null) {
            TupleBatch batch = new TupleBatch(this.nextBatchCount++, Collections.EMPTY_LIST);
            batch.setTerminationFlag(true);
            this.addBatchToBufferManager(batch);
            return batch;
        }
        ArrayList<List> listOfRows = new ArrayList<List>();
        listOfRows.add(rows);
        TupleBatch batch = new TupleBatch(this.nextBatchCount++, listOfRows);
        batch.setTerminationFlag(false);
        this.addBatchToBufferManager(batch);
        return batch;
    }

    void addBatchToBufferManager(TupleBatch batch) throws MetaMatrixComponentException {
        try {
            this.bufferMgr.addTupleBatch(this.resultsTupleSourceId, batch);
            if (batch.getTerminationFlag()) {
                this.bufferMgr.setStatus(this.resultsTupleSourceId, 2);
            }
        }
        catch (TupleSourceNotFoundException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    private List processXML() throws MetaMatrixComponentException, MetaMatrixProcessingException, BlockedException {
        boolean postProcess = this.styleSheet != null || this.shouldValidate;
        CharLobChunk chunk = this.getNextXMLChunk(this.chunkSize);
        XMLType xml = null;
        if (chunk == null) {
            return null;
        }
        if (!this.docInProgress && chunk.isLast()) {
            xml = new XMLType((SQLXML)new SQLXMLImpl(chunk.getChars(), this.getProperties()));
        } else {
            if (!this.docInProgress) {
                this.docInProgress = true;
                this.docInProgressTupleSourceId = XMLUtil.createXMLTupleSource((BufferManager)this.bufferMgr, (String)this.resultsTupleSourceId.getStringID());
                this.chunkPosition = 1;
            }
            this.bufferMgr.addStreamablePart(this.docInProgressTupleSourceId, (LobChunk)chunk, this.chunkPosition++);
            if (chunk.isLast()) {
                this.bufferMgr.setStatus(this.docInProgressTupleSourceId, 2);
                xml = new XMLType();
                xml.setPersistenceStreamId(this.docInProgressTupleSourceId.getStringID());
                this.docInProgress = false;
                this.docInProgressTupleSourceId = null;
                this.chunkPosition = 0;
            } else {
                throw BlockedOnMemoryException.INSTANCE;
            }
        }
        if (postProcess) {
            xml = this.postProcessDocument(xml, this.getProperties());
        }
        ArrayList<XMLType> row = new ArrayList<XMLType>(1);
        row.add(xml);
        return row;
    }

    CharLobChunk getNextXMLChunk(int size) throws MetaMatrixComponentException, MetaMatrixProcessingException, BlockedException {
        ProcessorInstruction inst = this.env.getCurrentInstruction();
        while (inst != null) {
            char[] chunk;
            this.context = inst.process(this.env, this.context);
            DocumentInProgress doc = this.env.getDocumentInProgress();
            if (doc != null && (chunk = doc.getNextChunk(size)) != null) {
                if (doc.isFinished()) {
                    this.env.setDocumentInProgress(null);
                }
                return new CharLobChunk(chunk, doc.isFinished());
            }
            inst = this.env.getCurrentInstruction();
        }
        return null;
    }

    private Properties getProperties() {
        Properties props = new Properties();
        if ("Tree".equals(this.env.getXMLFormat())) {
            props.setProperty("indent", "yes");
        }
        return props;
    }

    private XMLType postProcessDocument(XMLType xmlDoc, Properties props) throws MetaMatrixComponentException {
        Reader source = null;
        try {
            try {
                source = xmlDoc.getCharacterStream();
            }
            catch (InvalidReferenceException e) {
                xmlDoc = XMLUtil.getFromBufferManager((BufferManager)this.bufferMgr, (TupleSourceID)new TupleSourceID(xmlDoc.getPersistenceStreamId()), (Properties)props);
                source = xmlDoc.getCharacterStream();
            }
            if (this.shouldValidate) {
                this.validateDoc(source);
            }
            xmlDoc = this.transformXML(xmlDoc, props);
            return xmlDoc;
        }
        catch (SQLException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public void setXMLSchemas(Collection xmlSchema) {
        this.xmlSchemas = xmlSchema;
    }

    public Collection getXMLSchemas() {
        return this.xmlSchemas;
    }

    private void validateDoc(Reader xmlStream) throws SQLException, MetaMatrixComponentException {
        Collection schemas = this.getXMLSchemas();
        if (schemas == null || schemas.isEmpty()) {
            MetaMatrixComponentException noSchema = new MetaMatrixComponentException("ERR.015.006.0042", QueryExecPlugin.Util.getString("ERR.015.006.0042"));
            this.addWarning((MetaMatrixException)((Object)noSchema));
            return;
        }
        HashMap nameSpaceMap = null;
        try {
            nameSpaceMap = this.getTargetNameSpaces(schemas);
        }
        catch (MetaMatrixException me) {
            this.addWarning(me);
        }
        SAXParser parser = new SAXParser();
        try {
            parser.setFeature(XERCES_VALIDATION_FEATURE, true);
            parser.setFeature(XERCES_SCHEMA_VALIDATION_FEATURE, true);
            parser.setFeature(XERCES_NAMESPACES_FEATURE, true);
            if (nameSpaceMap != null && !nameSpaceMap.isEmpty()) {
                Iterator nameSpaces = nameSpaceMap.keySet().iterator();
                StringBuffer sb = new StringBuffer();
                while (nameSpaces.hasNext()) {
                    String nameSpace = (String)nameSpaces.next();
                    sb.append(nameSpace).append(" ").append(nameSpace).append(".xsd ");
                }
                parser.setProperty(XERCES_EXTERNAL_SCHEMA_LOCATION, (Object)sb.toString());
            }
        }
        catch (SAXNotRecognizedException snre) {
            throw new MetaMatrixComponentException("ERR.015.006.0040", QueryExecPlugin.Util.getString("ERR.015.006.0040", (Object)snre));
        }
        catch (SAXNotSupportedException sns) {
            throw new MetaMatrixComponentException("ERR.015.006.0041", QueryExecPlugin.Util.getString("ERR.015.006.0041", (Object)sns));
        }
        MultiEntityResolver xmlEntityResolver = new MultiEntityResolver(nameSpaceMap);
        parser.setEntityResolver((EntityResolver)xmlEntityResolver);
        MMErrorHandler errorHandler = new MMErrorHandler(null);
        parser.setErrorHandler((ErrorHandler)errorHandler);
        InputSource source = new InputSource(xmlStream);
        try {
            parser.parse(source);
        }
        catch (SAXException se) {
            throw new MetaMatrixComponentException((Throwable)se);
        }
        catch (IOException io) {
            throw new MetaMatrixComponentException((Throwable)io);
        }
        if (errorHandler.hasExceptions()) {
            List exceptionList = errorHandler.getExceptionList();
            Iterator i = exceptionList.iterator();
            while (i.hasNext()) {
                this.addWarning((MetaMatrixException)((Object)i.next()));
            }
        }
    }

    private HashMap getTargetNameSpaces(Collection schemas) throws MetaMatrixException {
        HashMap<String, String> nameSpaceMap = new HashMap<String, String>();
        SAXParser parser = new SAXParser();
        PeekContentHandler pch = new PeekContentHandler();
        Iterator it = schemas.iterator();
        while (it.hasNext()) {
            String schema = (String)it.next();
            StringReader reader = new StringReader(schema);
            InputSource source = new InputSource(reader);
            try {
                pch.targetNameSpace = null;
                parser.setContentHandler((ContentHandler)pch);
                parser.parse(source);
            }
            catch (SAXException e) {
                throw new MetaMatrixException(e.getMessage());
            }
            catch (IOException io) {
                throw new MetaMatrixException((Throwable)io);
            }
            if (pch.targetNameSpace == null) continue;
            nameSpaceMap.put(pch.targetNameSpace, schema);
        }
        return nameSpaceMap;
    }

    private XMLType transformXML(XMLType xmlResults, Properties props) throws SQLException, MetaMatrixComponentException {
        if (this.styleSheet != null && this.styleSheet.trim().length() > 0) {
            StringReader styleReader = new StringReader(this.styleSheet);
            StreamSource styleSource = new StreamSource(styleReader);
            StreamSource xmlSource = new StreamSource(xmlResults.getCharacterStream());
            StringWriter resultOut = new StringWriter();
            StreamResult result = new StreamResult(resultOut);
            try {
                TransformerFactoryImpl factory = new TransformerFactoryImpl();
                Transformer transformer = factory.newTransformer(styleSource);
                transformer.transform(xmlSource, result);
            }
            catch (Exception e) {
                throw new MetaMatrixComponentException((Throwable)e, "ERR.015.006.0046", QueryExecPlugin.Util.getString("ERR.015.006.0046"));
            }
            xmlResults = new XMLType((SQLXML)new SQLXMLImpl(resultOut.toString(), props));
        }
        return xmlResults;
    }

    public void setStylesheet(String styleSheet) {
        this.styleSheet = styleSheet;
    }

    public void setXMLFormat(String xmlFormat) {
        this.env.setXMLFormat(xmlFormat);
    }

    public void setShouldValidate(boolean validate) {
        this.shouldValidate = validate;
    }

    public boolean canHandleData(int dataRequestID) {
        return true;
    }

    public void close() throws MetaMatrixComponentException {
        if (this.resultsTupleSourceId != null) {
            try {
                this.bufferMgr.removeTupleSource(this.resultsTupleSourceId);
            }
            catch (TupleSourceNotFoundException tupleSourceNotFoundException) {
                // empty catch block
            }
            this.resultsTupleSourceId = null;
        }
    }

    public String toString() {
        try {
            return "XMLPlan:\n" + ProgramUtil.programToString((Program)this.originalProgram);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogManager.logWarning((String)"XML_PLAN", (Throwable)e, (String)QueryExecPlugin.Util.getString("ERR.015.006.0001"));
            return "XMLPlan";
        }
    }

    public Object clone() {
        XMLPlan xmlPlan = new XMLPlan((XMLProcessorEnvironment)this.env.clone());
        return xmlPlan;
    }

    public Map getDescriptionProperties() {
        Map props = this.originalProgram.getDescriptionProperties();
        Collection childRelationalPlans = this.env.getChildPlans();
        ArrayList children = (ArrayList)props.get("children");
        Iterator childRelationalPlansIterator = childRelationalPlans.iterator();
        while (childRelationalPlansIterator.hasNext()) {
            ProcessorPlan relationalPlan = (ProcessorPlan)childRelationalPlansIterator.next();
            Map planProperties = relationalPlan.getDescriptionProperties();
            children.add(planProperties);
        }
        props.put("children", children);
        props.put("type", "XML Plan");
        props.put("outputCols", DescribableUtil.getOutputColumnProperties((List)this.getOutputElements()));
        return props;
    }

    public Collection getChildPlans() {
        return this.env.getChildPlans();
    }

    public GroupSymbol getDocumentGroup() {
        return this.env.getDocumentGroup();
    }

    public Program getOriginalProgram() {
        return this.originalProgram;
    }
}

