/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.slbase;

import com.metamatrix.jdbcx.slbase.BaseConnectionWrapper;
import com.metamatrix.jdbcx.slbase.BaseResultSetWrapper;
import com.metamatrix.jdbcx.slbase.BaseStatementWrapper;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class BasePreparedStatementWrapper
extends BaseStatementWrapper
implements PreparedStatement {
    protected PreparedStatement realPreparedStatement;

    public void doClose() {
        this.realPreparedStatement = null;
        super.doClose();
    }

    BasePreparedStatementWrapper(BaseConnectionWrapper baseConnectionWrapper, PreparedStatement preparedStatement) {
        super(baseConnectionWrapper, preparedStatement);
        this.realPreparedStatement = preparedStatement;
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            ResultSet resultSet = this.realPreparedStatement.executeQuery();
            BaseResultSetWrapper baseResultSetWrapper = new BaseResultSetWrapper(this, resultSet, this.connectionWrapper);
            return baseResultSetWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            return this.realPreparedStatement.executeUpdate();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean execute() throws SQLException {
        try {
            return this.realPreparedStatement.execute();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        try {
            this.realPreparedStatement.setNull(n, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        try {
            this.realPreparedStatement.setNull(n, n2, string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        try {
            this.realPreparedStatement.setBoolean(n, bl);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        try {
            this.realPreparedStatement.setByte(n, by);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setShort(int n, short s) throws SQLException {
        try {
            this.realPreparedStatement.setShort(n, s);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        try {
            this.realPreparedStatement.setInt(n, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setLong(int n, long l) throws SQLException {
        try {
            this.realPreparedStatement.setLong(n, l);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        try {
            this.realPreparedStatement.setFloat(n, f);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        try {
            this.realPreparedStatement.setDouble(n, d);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            this.realPreparedStatement.setBigDecimal(n, bigDecimal);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setString(int n, String string) throws SQLException {
        try {
            this.realPreparedStatement.setString(n, string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            this.realPreparedStatement.setBytes(n, byArray);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        try {
            this.realPreparedStatement.setDate(n, date);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        try {
            this.realPreparedStatement.setTime(n, time);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            this.realPreparedStatement.setTimestamp(n, timestamp);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.realPreparedStatement.setAsciiStream(n, inputStream, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.realPreparedStatement.setUnicodeStream(n, inputStream, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.realPreparedStatement.setBinaryStream(n, inputStream, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void clearParameters() throws SQLException {
        try {
            this.realPreparedStatement.clearParameters();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setObject(n, object, n2, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        try {
            this.realPreparedStatement.setObject(n, object, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        try {
            this.realPreparedStatement.setObject(n, object);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void addBatch() throws SQLException {
        try {
            this.realPreparedStatement.addBatch();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            this.realPreparedStatement.setCharacterStream(n, reader, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        try {
            this.realPreparedStatement.setRef(n, ref);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        try {
            this.realPreparedStatement.setBlob(n, blob);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        try {
            this.realPreparedStatement.setClob(n, clob);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setArray(int n, Array array) throws SQLException {
        try {
            this.realPreparedStatement.setArray(n, array);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.realPreparedStatement.getMetaData();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        try {
            this.realPreparedStatement.setDate(n, date, calendar);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        try {
            this.realPreparedStatement.setTime(n, time, calendar);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            this.realPreparedStatement.setTimestamp(n, timestamp, calendar);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setURL(int n, URL uRL) throws SQLException {
        try {
            this.realPreparedStatement.setURL(n, uRL);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this.realPreparedStatement.getParameterMetaData();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }
}

