/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net;

import com.metamatrix.sequelink.net.IIOP;
import com.metamatrix.sequelink.net.NetByteOrder;
import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.util.OutputStreamOnByteArray;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class IIOPOctetSequence {
    private static final byte[] ALIGNMENT = new byte[]{0};
    private byte[] octetSequence;
    private byte[] iiopOctetSequence;

    IIOPOctetSequence(byte[] byArray, boolean bl) throws NetworkException {
        this.octetSequence = byArray;
        this.encodeOctetSequence(bl);
    }

    IIOPOctetSequence(DataInputStream dataInputStream, boolean bl) throws NetworkException {
        this.decodeOctetSequence(dataInputStream, bl);
    }

    public byte[] getIIOPOctetSequence() {
        return this.iiopOctetSequence;
    }

    public byte[] getOctetSequence() {
        return this.octetSequence;
    }

    public static int getLengthIIOPOctetSequence(byte[] byArray) {
        return IIOPOctetSequence.lengthOctetSequence(byArray.length);
    }

    private static int alignmentLengthOctetSequence(int n) {
        return (n / 4 + 1) * 4 - n;
    }

    private static int lengthOctetSequence(int n) {
        int n2 = 4;
        int n3 = n;
        int n4 = IIOPOctetSequence.alignmentLengthOctetSequence(n);
        return n2 + n3 + n4;
    }

    private void encodeOctetSequence(boolean bl) throws NetworkException {
        int n = this.octetSequence.length;
        int n2 = NetByteOrder.htonl(n, bl);
        int n3 = IIOPOctetSequence.lengthOctetSequence(n);
        int n4 = IIOPOctetSequence.alignmentLengthOctetSequence(n);
        this.iiopOctetSequence = new byte[n3];
        OutputStreamOnByteArray outputStreamOnByteArray = new OutputStreamOnByteArray(this.iiopOctetSequence);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStreamOnByteArray);
        try {
            dataOutputStream.writeInt(n2);
            outputStreamOnByteArray.write(this.octetSequence, 0, n);
            for (int i = 0; i < n4; ++i) {
                outputStreamOnByteArray.write(ALIGNMENT, 0, 1);
            }
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
    }

    private void decodeOctetSequence(DataInputStream dataInputStream, boolean bl) throws NetworkException {
        try {
            int n = dataInputStream.readInt();
            int n2 = NetByteOrder.htonl(n, bl);
            int n3 = IIOPOctetSequence.alignmentLengthOctetSequence(n2);
            this.octetSequence = new byte[n2];
            dataInputStream.readFully(this.octetSequence, 0, n2);
            dataInputStream.skipBytes(n3);
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
    }
}

