/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.impl;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueWorker;
import com.metamatrix.common.queue.QueueWorkerException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.data.api.AsynchQueryExecution;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.BatchedExecution;
import com.metamatrix.data.api.BatchedUpdatesExecution;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ProcedureExecution;
import com.metamatrix.data.api.SynchQueryExecution;
import com.metamatrix.data.api.UpdateExecution;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IBatchedUpdates;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.xa.api.XAConnection;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.datamgr.impl.ConnectorRequestStateManager;
import com.metamatrix.dqp.internal.datamgr.impl.ExecutionContextImpl;
import com.metamatrix.dqp.internal.datamgr.impl.PollingRequestTask;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.dqp.transaction.TransactionServer;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import javax.transaction.xa.XAResource;

public class ConnectorWorker
extends QueueWorker {
    private ConnectorRequestStateManager stateMgr;
    private MetadataService metadataService;
    private int maxResultRows;
    private boolean exceptionOnMaxRows = true;
    private TransactionService transactionService;
    private ClassLoader connectorClassLoader;
    private WorkerPool workerPool;

    public ConnectorWorker(ConnectorRequestStateManager stateMgr, ApplicationEnvironment connectorMgrEnv, MetadataService metadataService, TransactionService transactionService, ClassLoader connectorClassLoader, WorkerPool workerPool) {
        String exceptionOnMaxRowsString;
        this.stateMgr = stateMgr;
        this.metadataService = metadataService;
        this.transactionService = transactionService;
        this.connectorClassLoader = connectorClassLoader;
        this.workerPool = workerPool;
        String maxResultRowsString = connectorMgrEnv.getApplicationProperties().getProperty("MaxResultRows");
        if (maxResultRowsString != null && maxResultRowsString.trim().length() > 0) {
            try {
                this.maxResultRows = Integer.parseInt(maxResultRowsString);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{"MaxResultRows"};
                String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Couldn__t_parse_property", params);
                LogManager.logWarning((String)"CONNECTOR", (Throwable)e, (String)msg);
            }
        }
        if ((exceptionOnMaxRowsString = connectorMgrEnv.getApplicationProperties().getProperty("ExceptionOnMaxRows")) != null) {
            Boolean bool = Boolean.valueOf(exceptionOnMaxRowsString);
            this.exceptionOnMaxRows = bool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(Object request) throws QueueWorkerException {
        block12: {
            block11: {
                atomicReq = (AtomicRequestMessage)request;
                contextloader = this.getContextClassLoader();
                started = false;
                try {
                    try {
                        this.setContextClassLoader(this.connectorClassLoader);
                        if (!this.stateMgr.startProcessing(atomicReq)) {
                            LogManager.logTrace((String)"CONNECTOR", (Object[])new Object[]{"failed to enqueue atomic-request:", atomicReq});
                            var8_5 = null;
                            break block11;
                        }
                        switch (atomicReq.getType()) {
                            case 1: {
                                LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getAtomicRequestID(), "Processing NEW request:", atomicReq.getCommand()});
                                queryMetadata = this.metadataService.lookupMetadata(atomicReq.getVdbName(), atomicReq.getVdbVersion());
                                execution = this.stateMgr.createExecution(atomicReq, queryMetadata);
                                LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getAtomicRequestID(), "Obtained execution"});
                                started = true;
                                this.processNewRequest(atomicReq, queryMetadata, execution);
                                ** break;
                            }
                            case 2: {
                                started = true;
                                this.processMoreRequest(atomicReq);
                                ** break;
                            }
                            case 4: {
                                started = true;
                                LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getAtomicRequestID(), "Processing Close Request:", atomicReq.getCommand()});
                                this.processClose(atomicReq, true);
                                ** break;
                            }
                        }
                        throw new MetaMatrixComponentException(DQPPlugin.Util.getString("ConnectorWorker.invalidAtomicType", atomicReq.getType()));
                    }
                    catch (Throwable t) {
                        this.handleError(atomicReq, t, started);
                        var8_7 = null;
                        this.setContextClassLoader(contextloader);
                        if (started == false) return;
                        this.stateMgr.endProcessing(atomicReq);
                        return;
                    }
lbl39:
                    // 3 sources

                    break block12;
                }
                catch (Throwable var7_12) {
                    var8_8 = null;
                    this.setContextClassLoader(contextloader);
                    if (started == false) throw var7_12;
                    this.stateMgr.endProcessing(atomicReq);
                    throw var7_12;
                }
            }
            this.setContextClassLoader(contextloader);
            if (started == false) return;
            this.stateMgr.endProcessing(atomicReq);
            return;
        }
        var8_6 = null;
        this.setContextClassLoader(contextloader);
        if (started == false) return;
        this.stateMgr.endProcessing(atomicReq);
    }

    private void handleError(AtomicRequestMessage atomicReq, Throwable t, boolean started) {
        ResultsMessage response;
        this.stateMgr.logSRCCommand(atomicReq, (short)4, -1);
        String msg = DQPPlugin.Util.getString("ConnectorWorker.process_failed", new Object[]{atomicReq.getAtomicRequestID()});
        if (this.stateMgr.isCancelled(atomicReq)) {
            LogManager.logDetail((String)"CONNECTOR", (String)msg);
        } else {
            LogManager.logError((String)"CONNECTOR", (Throwable)t, (String)msg);
        }
        if (!(t instanceof CommunicationException)) {
            response = new ResultsMessage((RequestMessage)atomicReq);
            response.setException(t);
            this.safeSendResponse(atomicReq, response);
        }
        if (started) {
            this.processClose(atomicReq, false);
        } else {
            response = new ResultsMessage((RequestMessage)atomicReq);
            response.setRequestClosed(true);
            this.safeSendResponse(atomicReq, response);
            try {
                this.closeConnection(atomicReq);
            }
            catch (ConnectorException e) {
                // empty catch block
            }
        }
    }

    private void safeSendResponse(AtomicRequestMessage atomicReq, ResultsMessage response) {
        try {
            this.sendResponse(atomicReq, response);
        }
        catch (CommunicationException e) {
            String msg = DQPPlugin.Util.getString("ConnectorWorker.Can__t_communicate_error_to_client");
            LogManager.logError((String)"CONNECTOR", (Throwable)e, (String)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processClose(AtomicRequestMessage atomicReq, boolean success) {
        if (success) {
            this.stateMgr.logSRCCommand(atomicReq, (short)2, this.stateMgr.getRowsProcessed(atomicReq));
        }
        try {
            try {
                this.closeProcessing(atomicReq);
            }
            catch (ConnectorException e) {
                LogManager.logWarning((String)"CONNECTOR", (String)e.getMessage());
                Object var5_4 = null;
                ResultsMessage response = new ResultsMessage((RequestMessage)atomicReq);
                response.setRequestClosed(true);
                this.safeSendResponse(atomicReq, response);
                return;
            }
            catch (Throwable e) {
                LogManager.logError((String)"CONNECTOR", (Throwable)e, (String)e.getMessage());
                Object var5_5 = null;
                ResultsMessage response = new ResultsMessage((RequestMessage)atomicReq);
                response.setRequestClosed(true);
                this.safeSendResponse(atomicReq, response);
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ResultsMessage response = new ResultsMessage((RequestMessage)atomicReq);
            response.setRequestClosed(true);
            this.safeSendResponse(atomicReq, response);
            throw throwable;
        }
        ResultsMessage response = new ResultsMessage((RequestMessage)atomicReq);
        response.setRequestClosed(true);
        this.safeSendResponse(atomicReq, response);
    }

    private void processNewRequest(AtomicRequestMessage atomicReq, QueryMetadataInterface queryMetadata, Execution execution) throws ConnectorException, XATransactionException, MetaMatrixComponentException, CommunicationException {
        ICommand translatedCommand = this.stateMgr.getTranslatedCommand(atomicReq);
        int executionMode = this.stateMgr.getExecutionMode(atomicReq);
        this.stateMgr.logSRCCommand(atomicReq, (short)1, -1);
        this.enlistResource(atomicReq);
        BasicBatch aBatch = null;
        switch (executionMode) {
            case 0: {
                ((SynchQueryExecution)execution).execute((IQuery)translatedCommand, atomicReq.getFetchSize());
                break;
            }
            case 1: 
            case 4: {
                int count = ((UpdateExecution)execution).execute(translatedCommand);
                aBatch = new BasicBatch();
                aBatch.addRow(Arrays.asList(new Integer(count)));
                aBatch.setLast();
                break;
            }
            case 3: {
                List updates = ((IBatchedUpdates)translatedCommand).getUpdateCommands();
                ICommand[] updatesArray = updates.toArray(new ICommand[updates.size()]);
                int[] count = ((BatchedUpdatesExecution)execution).execute(updatesArray);
                aBatch = new BasicBatch();
                for (int i = 0; i < count.length; ++i) {
                    aBatch.addRow(Arrays.asList(new Integer(count[i])));
                }
                aBatch.setLast();
                break;
            }
            case 2: {
                ((ProcedureExecution)execution).execute((IProcedure)translatedCommand, atomicReq.getFetchSize());
                break;
            }
            case 5: {
                ((AsynchQueryExecution)execution).executeAsynch((IQuery)translatedCommand, atomicReq.getFetchSize());
                break;
            }
            default: {
                String msg = DQPPlugin.Util.getString("ConnectorWorker.Unable_to_open_connector_execution");
                throw new MetaMatrixComponentException(msg);
            }
        }
        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getAtomicRequestID(), "Executed command"});
        if (executionMode == 0 || executionMode == 2 || executionMode == 5) {
            aBatch = this.getNextBatch((BatchedExecution)execution, translatedCommand);
            LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getAtomicRequestID(), "Obtained first batch, row count:" + aBatch.getRowCount()});
            boolean exceededMax = this.checkMaxResultRows(aBatch.getRowCount());
            if (exceededMax) {
                aBatch = this.setBatchAtMaxRows((Batch)aBatch, this.maxResultRows);
            }
        }
        this.handleBatch(atomicReq, execution, (Batch)aBatch, aBatch.getRowCount());
    }

    private boolean checkMaxResultRows(int rowCount) throws ConnectorException {
        boolean exceededMax = false;
        if (this.maxResultRows != 0 && rowCount > this.maxResultRows) {
            if (this.exceptionOnMaxRows) {
                String msg = DQPPlugin.Util.getString("ConnectorWorker.MaxResultRowsExceed", this.maxResultRows);
                throw new ConnectorException(msg);
            }
            exceededMax = true;
        }
        return exceededMax;
    }

    private Batch setBatchAtMaxRows(Batch origBatch, int maxRowsAllowed) {
        List[] origResults = origBatch.getResults();
        List[] newResults = new List[maxRowsAllowed];
        System.arraycopy(origResults, 0, newResults, 0, maxRowsAllowed);
        List<List> newResultsList = Arrays.asList(newResults);
        BasicBatch newBatch = new BasicBatch(newResultsList);
        newBatch.setLast();
        return newBatch;
    }

    private void handleBatch(AtomicRequestMessage atomicReq, Execution execution, Batch aBatch, int rowCount) throws XATransactionException, ConnectorException, MetaMatrixComponentException, CommunicationException {
        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getAtomicRequestID(), "Sending results from connector"});
        boolean lastBatch = aBatch.isLast();
        this.delistResource(atomicReq, 0x2000000);
        if (lastBatch) {
            LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getAtomicRequestID(), "Obtained last batch, total row count:" + rowCount});
        }
        this.stateMgr.addRowsProcessed(atomicReq, aBatch.getRowCount());
        if (aBatch.getRowCount() == 0 && !aBatch.isLast() && execution instanceof AsynchQueryExecution && atomicReq.getType() == 2) {
            this.schedulePollingTask((AsynchQueryExecution)execution, atomicReq);
        } else {
            this.sendResults(atomicReq, aBatch, atomicReq.getCommand().getProjectedSymbols(), rowCount);
        }
    }

    private void schedulePollingTask(AsynchQueryExecution execution, AtomicRequestMessage request) {
        PollingRequestTask task = new PollingRequestTask(request, this.workerPool);
        long delay = execution.getPollInterval();
        this.stateMgr.scheduleTask((TimerTask)task, delay);
    }

    private void processMoreRequest(AtomicRequestMessage atomicReq) throws XATransactionException, ConnectorException, MetaMatrixComponentException, CommunicationException {
        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getAtomicRequestID(), "Processing MORE request"});
        Execution execution = this.stateMgr.getExecution(atomicReq);
        if (execution == null) {
            throw new ConnectorException(DQPPlugin.Util.getString("ConnectorWorker.could_not_retrieve_execution", (Object)atomicReq.getAtomicRequestID()));
        }
        this.enlistResource(atomicReq);
        this.verifyIsQuery(atomicReq, execution);
        Batch aBatch = ((BatchedExecution)execution).nextBatch();
        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getAtomicRequestID(), "Obtained batch, row count:" + aBatch.getRowCount()});
        int rowsSoFar = this.stateMgr.getRowsProcessed(atomicReq);
        int rowCnt = rowsSoFar + aBatch.getRowCount();
        boolean exceededMax = this.checkMaxResultRows(rowCnt);
        if (exceededMax) {
            int maxAllowedForBatch = this.maxResultRows - rowsSoFar;
            aBatch = this.setBatchAtMaxRows(aBatch, maxAllowedForBatch);
            rowCnt = rowsSoFar + aBatch.getRowCount();
        }
        this.handleBatch(atomicReq, execution, aBatch, rowCnt);
    }

    private void enlistResource(AtomicRequestMessage request) throws XATransactionException, ConnectorException {
        if (!request.isTransactional()) {
            return;
        }
        int executionMode = this.stateMgr.getExecutionMode(request);
        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{"AtomicRequest", request.getAtomicRequestID(), "enlist(" + request.getTransactionContext() + ")"});
        Connection conn = this.stateMgr.getConnection(request, false);
        if (conn.getCapabilities().supportsXATransactions()) {
            TransactionContext txnCtx = this.stateMgr.getTransactionContext(request);
            XAResource xaRes = ((XAConnection)conn).getXAResource();
            this.getTransactionServer().enlist(txnCtx, xaRes);
        } else if (executionMode != 0) {
            String msg = DQPPlugin.Util.getString("ConnectorWorker.transactionNotSupported");
            throw new ConnectorException(msg);
        }
    }

    private void delistResource(AtomicRequestMessage request, int flags) throws ConnectorException, XATransactionException {
        if (!request.isTransactional()) {
            return;
        }
        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{"AtomicRequest", request.getAtomicRequestID(), "delist(" + request.getTransactionContext() + ")"});
        Connection conn = this.stateMgr.getConnection(request, false);
        if (conn.getCapabilities().supportsXATransactions()) {
            TransactionContext txnCtx = this.stateMgr.getTransactionContext(request);
            XAResource xaRes = ((XAConnection)conn).getXAResource();
            this.getTransactionServer().delist(txnCtx, xaRes, flags);
        }
    }

    private void verifyIsQuery(AtomicRequestMessage atomicReq, Execution execution) throws ConnectorException {
        int executionMode = this.stateMgr.getExecutionMode(atomicReq);
        if (executionMode != 0 && executionMode != 2 && executionMode != 5) {
            Object[] params = new Object[]{execution.getClass().getName()};
            throw new ConnectorException(DQPPlugin.Util.getString("ConnectorWorker.ConnectorWorker_expecting_an_Execution_of_type_SynchExecution,_got", params));
        }
    }

    private Batch getNextBatch(BatchedExecution execution, ICommand command) throws ConnectorException {
        if (command instanceof IProcedure) {
            return ConnectorWorker.getNextProcedureBatch((ProcedureExecution)execution, (IProcedure)command);
        }
        return execution.nextBatch();
    }

    static Batch getNextProcedureBatch(ProcedureExecution execution, IProcedure command) throws ConnectorException {
        ArrayList results = new ArrayList();
        List params = command.getParameters();
        int paramCols = 0;
        int resultSetCols = 0;
        if (params != null && !params.isEmpty()) {
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                IParameter param = (IParameter)iter.next();
                if (param.getDirection() == 4) {
                    resultSetCols = param.getMetadataID().getChildIDs().size();
                    continue;
                }
                if (param.getDirection() != 3 && param.getDirection() != 1 && param.getDirection() != 2) continue;
                ++paramCols;
            }
        }
        Batch abatch = execution.nextBatch();
        boolean atLast = false;
        if (abatch.getResults() != null && abatch.getResults().length > 0) {
            for (int i = 0; i < abatch.getResults().length; ++i) {
                results.add(new ArrayList(abatch.getResults()[i]));
            }
            int resultSetSize = ((List)results.get(0)).size();
            if (resultSetSize != resultSetCols) {
                throw new ConnectorException(DQPPlugin.Util.getString("ConnectorWorker.ConnectorWorker_result_set_unexpected_columns", new Object[]{command, new Integer(resultSetCols), new Integer(resultSetSize)}));
            }
            if (paramCols != 0) {
                List<Object> resultsPadding = Arrays.asList(new Object[paramCols]);
                Iterator iter = results.iterator();
                while (iter.hasNext()) {
                    ((List)iter.next()).addAll(resultsPadding);
                }
            }
        } else {
            atLast = true;
        }
        if (atLast || abatch.isLast()) {
            return ConnectorWorker.prepareLastProcedureBatch(execution, results, params, paramCols, resultSetCols);
        }
        BasicBatch batch = new BasicBatch(results);
        return batch;
    }

    private static Batch prepareLastProcedureBatch(ProcedureExecution execution, List results, List params, int paramCols, int resultSetCols) throws ConnectorException {
        ArrayList<Object> outParamValues = new ArrayList<Object>(params.size());
        if (params != null && !params.isEmpty()) {
            IParameter param;
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                param = (IParameter)iter.next();
                if (param.getDirection() != 3) continue;
                outParamValues.add(execution.getOutputValue(param));
            }
            iter = params.iterator();
            while (iter.hasNext()) {
                param = (IParameter)iter.next();
                if (param.getDirection() != 1 && param.getDirection() != 2) continue;
                outParamValues.add(execution.getOutputValue(param));
            }
            Iterator i = outParamValues.iterator();
            int index = resultSetCols;
            while (i.hasNext()) {
                Object[] newRow = new Object[paramCols + resultSetCols];
                newRow[index] = i.next();
                results.add(Arrays.asList(newRow));
                ++index;
            }
        }
        BasicBatch batch = new BasicBatch(results);
        batch.setLast();
        return batch;
    }

    public void initialize() throws QueueWorkerException {
    }

    public void cleanup() throws QueueWorkerException {
    }

    private void sendResults(AtomicRequestMessage request, Batch batch, List elements, int rowsProcessed) throws CommunicationException {
        boolean done = batch.isLast();
        int rowCount = batch.getRowCount();
        if (!done && rowCount == 0) {
            LogManager.logWarning((String)"CONNECTOR", (String)DQPPlugin.Util.getString("ConnectorWorker.zero_size_non_last_batch", (Object)request.getConnectorID()));
        }
        ExecutionContextImpl context = (ExecutionContextImpl)this.stateMgr.getExecutionContext(request);
        ResultsMessage response = new ResultsMessage((RequestMessage)request, batch.getResults(), elements);
        response.setFirstRow(rowsProcessed + 1 - rowCount);
        response.setLastRow(rowsProcessed);
        response.setSupportsImplicitClose(!context.keepExecutionAlive());
        if (done) {
            response.setFinalRow(rowsProcessed);
            response.setPartialResults(false);
        } else {
            response.setFinalRow(-1);
            response.setPartialResults(true);
        }
        this.sendResponse(request, response);
    }

    private void sendResponse(AtomicRequestMessage request, ResultsMessage response) throws CommunicationException {
        request.getClientConnection().send((Message)response, request.getMessageKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void closeProcessing(AtomicRequestMessage atomicReq) throws ConnectorException {
        block38: {
            if (!this.stateMgr.isActive(atomicReq)) {
                return;
            }
            this.stateMgr.closeProcessing(atomicReq);
            this.enlistResource(atomicReq);
            var4_2 = null;
            try {
                try {
                    execution = this.stateMgr.getExecution(atomicReq);
                    if (execution != null) {
                        execution.close();
                        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getAtomicRequestID(), "Closed execution"});
                    }
                    errorMsg = DQPPlugin.Util.getString("DQPCore.The_atomic_request_closed", new Object[]{atomicReq.getAtomicRequestID()});
                    LogManager.logDetail((String)"CONNECTOR", (String)errorMsg);
                    v0 = null;
                }
                catch (ConnectorException e) {
                    LogManager.logWarning((String)"CONNECTOR", (String)e.getMessage());
                    v0 = null;
                }
            }
            catch (Throwable var7_14) {
                v0 = null;
            }
            var8_18 = v0;
            try {
                this.delistResource(atomicReq, 0x4000000);
            }
            catch (ConnectorException e) {
                LogManager.logWarning((String)"CONNECTOR", (String)e.getMessage());
            }
            catch (XATransactionException e) {
                LogManager.logWarning((String)"CONNECTOR", (String)e.getMessage());
            }
            finally {
                this.closeConnection(atomicReq);
            }
            {
                catch (ConnectorException e) {
                    LogManager.logWarning((String)"CONNECTOR", (String)e.getMessage());
                    var4_3 = null;
                    try {
                        try {
                            execution = this.stateMgr.getExecution(atomicReq);
                            if (execution != null) {
                                execution.close();
                                LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getAtomicRequestID(), "Closed execution"});
                            }
                            errorMsg = DQPPlugin.Util.getString("DQPCore.The_atomic_request_closed", new Object[]{atomicReq.getAtomicRequestID()});
                            LogManager.logDetail((String)"CONNECTOR", (String)errorMsg);
                            v1 = null;
                        }
                        catch (ConnectorException e) {
                            LogManager.logWarning((String)"CONNECTOR", (String)e.getMessage());
                            v1 = null;
                        }
                    }
                    catch (Throwable var7_15) {
                        v1 = null;
                    }
                    var8_19 = v1;
                    try {
                        this.delistResource(atomicReq, 0x4000000);
                    }
                    catch (ConnectorException e) {
                        ** try [egrp 5[TRYBLOCK] [13 : 194->206)] { 
lbl68:
                        // 1 sources

                        LogManager.logWarning((String)"CONNECTOR", (String)e.getMessage());
                        this.closeConnection(atomicReq);
                        break block38;
                    }
                    catch (XATransactionException e) {
                        ** try [egrp 6[TRYBLOCK] [14 : 214->226)] { 
lbl-1000:
                        // 3 sources

                        {
                            catch (Throwable var10_31) {
                                this.closeConnection(atomicReq);
                                throw var10_31;
                            }
                        }
lbl76:
                        // 1 sources

                        LogManager.logWarning((String)"CONNECTOR", (String)e.getMessage());
                        this.closeConnection(atomicReq);
                        break block38;
                    }
                    this.closeConnection(atomicReq);
                    break block38;
                }
                catch (XATransactionException e) {
                    LogManager.logWarning((String)"CONNECTOR", (String)e.getMessage());
                    var4_4 = null;
                    try {
                        try {
                            execution = this.stateMgr.getExecution(atomicReq);
                            if (execution != null) {
                                execution.close();
                                LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getAtomicRequestID(), "Closed execution"});
                            }
                            errorMsg = DQPPlugin.Util.getString("DQPCore.The_atomic_request_closed", new Object[]{atomicReq.getAtomicRequestID()});
                            LogManager.logDetail((String)"CONNECTOR", (String)errorMsg);
                            v2 = null;
                        }
                        catch (ConnectorException e) {
                            LogManager.logWarning((String)"CONNECTOR", (String)e.getMessage());
                            v2 = null;
                        }
                    }
                    catch (Throwable var7_16) {
                        v2 = null;
                    }
                    var8_20 = v2;
                    try {
                        this.delistResource(atomicReq, 0x4000000);
                    }
                    catch (ConnectorException e) {
                        ** try [egrp 5[TRYBLOCK] [13 : 194->206)] { 
lbl107:
                        // 1 sources

                        LogManager.logWarning((String)"CONNECTOR", (String)e.getMessage());
                        this.closeConnection(atomicReq);
                        break block38;
                    }
                    catch (XATransactionException e) {
                        ** try [egrp 6[TRYBLOCK] [14 : 214->226)] { 
lbl-1000:
                        // 3 sources

                        {
                            catch (Throwable var10_32) {
                                this.closeConnection(atomicReq);
                                throw var10_32;
                            }
                        }
lbl115:
                        // 1 sources

                        LogManager.logWarning((String)"CONNECTOR", (String)e.getMessage());
                        this.closeConnection(atomicReq);
                        break block38;
                    }
                    this.closeConnection(atomicReq);
                    break block38;
                }
            }
            catch (Throwable var3_36) {
                block40: {
                    var4_5 = null;
                    try {
                        try {
                            execution = this.stateMgr.getExecution(atomicReq);
                            if (execution != null) {
                                execution.close();
                                LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getAtomicRequestID(), "Closed execution"});
                            }
                            errorMsg = DQPPlugin.Util.getString("DQPCore.The_atomic_request_closed", new Object[]{atomicReq.getAtomicRequestID()});
                            LogManager.logDetail((String)"CONNECTOR", (String)errorMsg);
                            v3 = null;
                        }
                        catch (ConnectorException e) {
                            LogManager.logWarning((String)"CONNECTOR", (String)e.getMessage());
                            v3 = null;
                        }
                    }
                    catch (Throwable var7_17) {
                        v3 = null;
                    }
                    var8_21 = v3;
                    try {
                        this.delistResource(atomicReq, 0x4000000);
                    }
                    catch (ConnectorException e) {
                        ** try [egrp 5[TRYBLOCK] [13 : 194->206)] { 
lbl144:
                        // 1 sources

                        LogManager.logWarning((String)"CONNECTOR", (String)e.getMessage());
                        this.closeConnection(atomicReq);
                        break block40;
                    }
                    catch (XATransactionException e) {
                        ** try [egrp 6[TRYBLOCK] [14 : 214->226)] { 
lbl-1000:
                        // 3 sources

                        {
                            catch (Throwable var10_33) {
                                this.closeConnection(atomicReq);
                                throw var10_33;
                            }
                        }
lbl152:
                        // 1 sources

                        LogManager.logWarning((String)"CONNECTOR", (String)e.getMessage());
                        this.closeConnection(atomicReq);
                    }
                    this.closeConnection(atomicReq);
                }
                throw var3_36;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(AtomicRequestMessage atomicReq) throws ConnectorException {
        try {
            Connection connection = this.stateMgr.getConnection(atomicReq, false);
            if (connection != null) {
                connection.release();
                LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getAtomicRequestID(), "Closed connection"});
            }
        }
        finally {
            this.stateMgr.removeState(atomicReq);
        }
    }

    private TransactionServer getTransactionServer() {
        return this.transactionService.getTransactionServer();
    }
}

