/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.tns;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.oracle.tns.TnsFailoverMode;
import com.metamatrix.jdbc.oracle.tns.TnsValueInfo;
import java.sql.SQLException;
import java.util.ArrayList;

public class TnsConnectData {
    private static String footprint = "$Revision:   1.3.2.0  $";
    public static int TNSSERVERTYPE_SHARED = 0;
    public static int TNSSERVERTYPE_DEDICATED = 1;
    public static int TNSSERVERTYPE_DEFAULT = 2;
    private String m_serviceName = "";
    private String m_sid = "";
    private int m_serverType = TNSSERVERTYPE_DEFAULT;
    private TnsFailoverMode m_failoverMode;
    private String m_globalName = "";
    private boolean m_hs;
    private String m_instanceName = "";
    private String m_rdbDatabase = "";

    public TnsConnectData(String string, String string2, String string3, BaseExceptions baseExceptions) throws SQLException {
        if (string3 == null) {
            this.m_serverType = TNSSERVERTYPE_DEFAULT;
        } else if (string3.equalsIgnoreCase("DEDICATED")) {
            this.m_serverType = TNSSERVERTYPE_DEDICATED;
        } else if (string3.equalsIgnoreCase("SHARED")) {
            this.m_serverType = TNSSERVERTYPE_SHARED;
        } else {
            throw baseExceptions.getException(7020, "08001");
        }
        if (string2 == null && string == null) {
            this.m_sid = "ORCL";
        } else if (string != null) {
            this.m_serviceName = string;
        } else {
            this.m_sid = string2;
        }
    }

    TnsConnectData(TnsValueInfo tnsValueInfo) {
        ArrayList arrayList = tnsValueInfo.getValues();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            TnsValueInfo tnsValueInfo2 = new TnsValueInfo((String)arrayList.get(i));
            if (tnsValueInfo2.Equals("SID")) {
                this.m_sid = tnsValueInfo2.getValue();
                continue;
            }
            if (tnsValueInfo2.Equals("SERVICE_NAME")) {
                this.m_serviceName = tnsValueInfo2.getValue();
                continue;
            }
            if (tnsValueInfo2.Equals("SERVER")) {
                if (tnsValueInfo2.ValueEquals("SHARED")) {
                    this.m_serverType = TNSSERVERTYPE_SHARED;
                    continue;
                }
                if (!tnsValueInfo2.ValueEquals("DEDICATED")) continue;
                this.m_serverType = TNSSERVERTYPE_DEDICATED;
                continue;
            }
            if (tnsValueInfo2.Equals("FAILOVER_MODE")) {
                this.m_failoverMode = new TnsFailoverMode(tnsValueInfo2);
                continue;
            }
            if (tnsValueInfo2.Equals("GLOBAL_NAME")) {
                this.m_globalName = tnsValueInfo2.getValue();
                continue;
            }
            if (tnsValueInfo2.Equals("RDB_DATABASE")) {
                this.m_rdbDatabase = tnsValueInfo2.getValue();
                continue;
            }
            if (tnsValueInfo2.Equals("INSTANCE_NAME")) {
                this.m_instanceName = tnsValueInfo2.getValue();
                continue;
            }
            if (!tnsValueInfo2.Equals("HS")) continue;
            this.m_hs = tnsValueInfo2.ValueEquals("OK");
        }
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public String getSID() {
        return this.m_sid;
    }

    public int getServerType() {
        return this.m_serverType;
    }

    public TnsFailoverMode getFailoverMode() {
        return this.m_failoverMode;
    }

    public String getGlobalName() {
        return this.m_globalName;
    }

    public boolean getHS() {
        return this.m_hs;
    }

    public String getInstanceName() {
        return this.m_instanceName;
    }

    public String getRdbDatabase() {
        return this.m_rdbDatabase;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(CONNECT_DATA=");
        if (this.m_serviceName.length() != 0) {
            stringBuffer.append("(SERVICE_NAME=" + this.m_serviceName + ")");
        }
        if (this.m_sid.length() != 0) {
            stringBuffer.append("(SID=" + this.m_sid + ")");
        }
        if (this.m_globalName.length() != 0) {
            stringBuffer.append("(GLOBAL_NAME=" + this.m_globalName + ")");
        }
        if (this.m_instanceName.length() != 0) {
            stringBuffer.append("(INSTANCE_NAME=" + this.m_instanceName + ")");
        }
        if (this.m_rdbDatabase.length() != 0) {
            stringBuffer.append("(RDB_DATABASE=" + this.m_rdbDatabase + ")");
        }
        if (this.m_hs) {
            stringBuffer.append("(HS=ok)");
        }
        if (this.m_serverType != TNSSERVERTYPE_DEFAULT) {
            stringBuffer.append("(SERVER=" + (this.m_serverType == TNSSERVERTYPE_DEDICATED ? "DEDICATED" : "SHARED") + ")");
        }
        return stringBuffer.toString();
    }
}

