/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1String;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.PrintableString;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.utils.CryptoUtils;
import iaik.utils.RFC2253NameParserException;
import iaik.utils.Util;
import java.util.Hashtable;

public class AVA
implements ASN1Type {
    private ASN1Object a;
    private ObjectID b;
    static ASN c;
    static ASN e;
    static Hashtable d;

    public String toString(boolean bl) {
        Object object = AVA.a(this.a, this.b);
        if (!(object instanceof String)) {
            try {
                object = AVA.a(this.a, true, ":");
            }
            catch (Exception exception) {
                object = AVA.a(this.a, this.b);
            }
        }
        return String.valueOf(bl ? this.b.getName() : this.b.getShortName()) + "=" + object;
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b);
        sEQUENCE.addComponent(this.a);
        return sEQUENCE;
    }

    public static void setNonPrintableDefaultEncoding(ASN aSN) {
        c = aSN;
    }

    public static void setDefaultEncoding(ASN aSN) {
        e = aSN;
    }

    private static ASN1Object a(Object object, ObjectID objectID, ASN aSN) throws CodingException {
        try {
            ASN aSN2 = AVA.getEncoding(objectID);
            if (aSN != null) {
                aSN2 = aSN;
            }
            if (aSN2 == null) {
                aSN2 = e;
                if (object instanceof String && (e == ASN.NumericString || e == ASN.PrintableString) && !PrintableString.isPrintableString((String)object)) {
                    aSN2 = c;
                }
            }
            if (objectID == ObjectID.uniqueIdentifier && object instanceof String && aSN2.equals(ASN.BIT_STRING)) {
                PrintableString printableString = new PrintableString((String)object);
                BIT_STRING bIT_STRING = new BIT_STRING(DerCoder.encode(printableString));
                return bIT_STRING;
            }
            return ASN.create(aSN2, object);
        }
        catch (Exception exception) {
            throw new CodingException(exception.getMessage());
        }
    }

    public int hashCode() {
        return this.b.hashCode() + AVA.a(this.a, this.b).hashCode();
    }

    private static Object a(ASN1Object aSN1Object, ObjectID objectID) {
        Object object = null;
        if (objectID.equals(ObjectID.uniqueIdentifier) && !aSN1Object.isA(ASN.PrintableString)) {
            try {
                ASN1Object aSN1Object2 = DerCoder.decode((byte[])aSN1Object.getValue());
                object = aSN1Object2.getValue();
            }
            catch (Exception exception) {}
        }
        if (object == null) {
            object = aSN1Object.getValue();
        }
        return object;
    }

    public Object getValue() {
        return AVA.a(this.a, this.b);
    }

    public ObjectID getType() {
        return this.b;
    }

    public String getRFC2253String() throws RFC2253NameParserException {
        Object object = AVA.a(this.a, this.b);
        ASN aSN = this.a.getAsnType();
        boolean bl = aSN.equals(ASN.BIT_STRING);
        if (!(object instanceof String) || bl || !ObjectID.hasRegisteredName(this.b.getID())) {
            try {
                object = AVA.a(this.a, false, "");
            }
            catch (Exception exception) {
                throw new RFC2253NameParserException("Cannot write this AVA: " + exception.getMessage());
            }
        } else if (object instanceof String) {
            try {
                object = UTF8String.getRFC2253String((String)object);
            }
            catch (CodingException codingException) {
                throw new RFC2253NameParserException("Cannot write this AVA: " + codingException.getMessage());
            }
        } else {
            throw new RFC2253NameParserException("Cannot write this AVA: unknown representation.");
        }
        return String.valueOf(this.b.getShortName()) + "=" + object;
    }

    public static ASN getNonPrintableDefaultEncoding() {
        return c;
    }

    private static String a(ASN1Object aSN1Object, boolean bl, String string) {
        String string2;
        if (aSN1Object.isA(ASN.BIT_STRING) && bl) {
            BIT_STRING bIT_STRING = (BIT_STRING)aSN1Object;
            string2 = "#'" + bIT_STRING.getBinaryString() + "'B";
        } else {
            byte[] byArray = DerCoder.encode(aSN1Object);
            String string3 = Util.toString(byArray, string);
            string2 = "#" + string3;
        }
        return string2;
    }

    public static ASN getEncoding(ObjectID objectID) {
        return (ASN)d.get(objectID);
    }

    public static ASN getDefaultEncoding() {
        return e;
    }

    public ASN1Object getASN1Value() throws CodingException {
        return this.a;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AVA)) {
            return false;
        }
        AVA aVA = (AVA)object;
        if (!this.b.equals(aVA.b)) {
            return false;
        }
        if (this.a.isStringType()) {
            return ((ASN1String)this.a).equals(aVA.a);
        }
        return CryptoUtils.equalsBlock(DerCoder.encode(this.a), DerCoder.encode(aVA.a));
    }

    public static void defineEncoding(ObjectID objectID, ASN aSN) {
        d.put(objectID, aSN);
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.b = (ObjectID)aSN1Object.getComponentAt(0);
        this.a = aSN1Object.getComponentAt(1);
    }

    public AVA(ObjectID objectID, Object object, ASN aSN) throws IllegalArgumentException {
        if (objectID == null || object == null) {
            throw new IllegalArgumentException("Type and value must be non null for creating an AVA!");
        }
        this.b = objectID;
        if (object instanceof ASN1Object) {
            this.a = (ASN1Object)object;
            return;
        }
        try {
            this.a = AVA.a(object, objectID, aSN);
            return;
        }
        catch (CodingException codingException) {
            throw new IllegalArgumentException("Cannot create ASN.1 representation of given object for requested type!");
        }
    }

    public AVA(ObjectID objectID, Object object) throws IllegalArgumentException {
        this(objectID, object, null);
    }

    public AVA(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new CodingException("Cannot create an AVA from a null object!");
        }
        this.decode(aSN1Object);
    }

    static {
        d = new Hashtable();
        e = ASN.PrintableString;
        c = ASN.UTF8String;
        AVA.defineEncoding(ObjectID.emailAddress, ASN.IA5String);
        AVA.defineEncoding(ObjectID.uniqueIdentifier, ASN.BIT_STRING);
    }
}

