/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink;

import com.metamatrix.jdbc.sequelink.SequeLinkImplConnection;
import com.metamatrix.jdbc.slbase.BaseImplClob;
import com.metamatrix.sequelink.ssp.DiagnosticList;
import com.metamatrix.sequelink.ssp.Message;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.sequelink.ssp.SspLob;
import com.metamatrix.sequelink.ssp.SspOutputStream;
import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilTransliterator;
import com.metamatrix.slutil.UtilTransliteratorForUCS2;
import java.io.IOException;
import java.sql.SQLException;

public class SequeLinkImplClob
extends BaseImplClob
implements SspLob {
    private SequeLinkImplConnection implCon;
    private byte[] locator;
    private long lobLength;
    private boolean moreToCome;
    private int lobOptions;
    private String encoding;
    private UtilTransliterator ut;
    private UtilTransliteratorForUCS2 ucs2;

    public SequeLinkImplClob(SequeLinkImplConnection sequeLinkImplConnection, byte[] byArray, String string, UtilTransliterator utilTransliterator) {
        super(sequeLinkImplConnection.exceptions);
        this.implCon = sequeLinkImplConnection;
        this.locator = byArray;
        this.lobLength = -1L;
        try {
            this.lobOptions = sequeLinkImplConnection.conCtxt.supportsLobs(DiagnosticList.GetADummyList());
        }
        catch (SQLException sQLException) {
            throw new InternalError("SequeLinkImplClob ctor " + sQLException.toString());
        }
        this.ut = utilTransliterator;
        this.encoding = string;
        this.ucs2 = new UtilTransliteratorForUCS2();
    }

    public int getCharacterEncoding() {
        return 2;
    }

    public long getMaxChunkSize() {
        return 30000L;
    }

    public int readData(byte[] byArray, int n, long l, int n2) throws SQLException {
        if ((this.lobOptions & 1) == 0) {
            String[] stringArray = new String[]{"Clob.readData"};
            throw this.exceptions.getException(6003, stringArray);
        }
        return this.implCon.getLobData(this, byArray, n, l - 1L, n2);
    }

    public int writeData(long l, byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2;
        if ((this.lobOptions & 4) == 0) {
            String[] stringArray = new String[]{"Clob.writeData"};
            throw this.exceptions.getException(6003, stringArray);
        }
        try {
            String string = this.ucs2.decode(byArray, n, n2 * 2);
            byArray2 = this.ut.encode(string);
        }
        catch (UtilException utilException) {
            SQLException sQLException = Message.Gen.getSqlException(7452);
            Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
            throw sQLException;
        }
        int n3 = this.implCon.setLobData(this, byArray2, 0, l - 1L, byArray2.length);
        int n4 = n2;
        if (this.lobLength != -1L) {
            this.lobLength = Math.max(this.lobLength, l - 1L + (long)n4);
        }
        return n4;
    }

    public long getLength() throws SQLException {
        if (this.lobLength != -1L) {
            return this.lobLength;
        }
        this.implCon.getLobLength(this);
        return this.lobLength;
    }

    public boolean supportsSearch() {
        return true;
    }

    public long find(String string, long l) throws SQLException {
        byte[] byArray;
        try {
            byArray = this.ut.encode(string);
        }
        catch (UtilException utilException) {
            SQLException sQLException = Message.Gen.getSqlException(7452);
            Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
            throw sQLException;
        }
        return this.implCon.getLobPosition(this, byArray, l);
    }

    public void truncate(long l) throws SQLException {
        if ((this.lobOptions & 4) == 0) {
            String[] stringArray = new String[]{"Clob.truncate"};
            throw this.exceptions.getException(6003, stringArray);
        }
        if (this.lobLength != -1L && l >= this.lobLength) {
            return;
        }
        this.implCon.lobTruncate(this, l);
        if (this.lobLength != -1L) {
            this.lobLength = l;
        }
    }

    public void close() throws SQLException {
        this.implCon = null;
    }

    public void setLocator(byte[] byArray) {
        this.locator = byArray;
    }

    public byte[] getLocator() {
        return this.locator;
    }

    public int getLobType() {
        return 2;
    }

    public void setLobLength(long l) {
        this.lobLength = l;
    }

    public void setMoreToCome(boolean bl) {
        this.moreToCome = bl;
    }

    public String getEncoding() {
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readLobData(SspInputStream sspInputStream, byte[] byArray, int n, int n2) throws IOException, UtilException {
        String string;
        UtilTransliterator utilTransliterator = sspInputStream.getTransliterator();
        if (utilTransliterator == this.ut) {
            string = sspInputStream.readSSPString();
        } else {
            try {
                sspInputStream.setTransliterator(this.ut);
                string = sspInputStream.readSSPString();
            }
            finally {
                sspInputStream.setTransliterator(utilTransliterator);
            }
        }
        byte[] byArray2 = this.ucs2.encode(string);
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    public int writeLobData(SspOutputStream sspOutputStream, byte[] byArray, int n, int n2) throws IOException, UtilException {
        sspOutputStream.writeSSPLongVarChar(byArray, n, n2);
        return n2;
    }
}

