/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.security.cipher.DES;
import iaik.security.cipher.DESKeyGenerator;
import iaik.security.cipher.SecretKey;
import iaik.security.pbe.PBEGenParameterSpec;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class PbeWithMD5AndDES_CBC
extends DES {
    static /* synthetic */ Class a;
    protected AlgorithmParameters params;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void initCipher(int n2, Key key) throws InvalidAlgorithmParameterException, InvalidKeyException {
        MessageDigest messageDigest;
        PBEParameterSpec pBEParameterSpec;
        if (key == null || !key.getAlgorithm().equals("PBE") || !key.getFormat().equals("RAW")) {
            throw new InvalidKeyException("Must be a PBEKey in RAW format.");
        }
        byte[] byArray = key.getEncoded();
        try {
            pBEParameterSpec = (PBEParameterSpec)this.params.getParameterSpec(a != null ? a : (a = PbeWithMD5AndDES_CBC.a("javax.crypto.spec.PBEParameterSpec")));
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException.getMessage());
        }
        byte[] byArray2 = pBEParameterSpec.getSalt();
        int n3 = pBEParameterSpec.getIterationCount();
        if (byArray2.length != 8) {
            throw new InvalidAlgorithmParameterException("Salt must be 8 bytes long.");
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(noSuchAlgorithmException.toString());
        }
        int n4 = 0;
        while (n4 < n3) {
            byArray3 = messageDigest.digest(byArray3);
            ++n4;
        }
        DESKeyGenerator.adjustParity(byArray3, 0);
        SecretKey secretKey = new SecretKey(byArray3, 0, 8, "RAW");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3, 8, 8);
        super.engineInit(n2, (Key)secretKey, ivParameterSpec, null);
    }

    public void engineSetPadding(String string) {
    }

    public void engineSetMode(String string) {
    }

    public void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (algorithmParameterSpec == null) {
            this.engineInit(n2, key, secureRandom);
            return;
        }
        if (algorithmParameterSpec instanceof PBEParameterSpec) {
            try {
                this.params.init(algorithmParameterSpec);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Error setting algorithm parameters.");
            }
        } else if (algorithmParameterSpec instanceof PBEGenParameterSpec) {
            try {
                AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("PBE");
                algorithmParameterGenerator.init(algorithmParameterSpec, secureRandom);
                this.params = algorithmParameterGenerator.generateParameters();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidAlgorithmParameterException("Error setting algorithm parameters.");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of PBEParameterSpec or PBEGenParameterSpec.");
        }
        this.initCipher(n2, key);
    }

    public void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("PBE");
            algorithmParameterGenerator.init(8, secureRandom);
            this.params = algorithmParameterGenerator.generateParameters();
            this.initCipher(n2, key);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    public void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (algorithmParameters == null || algorithmParameters.getAlgorithm() != "PBE") {
            throw new InvalidAlgorithmParameterException("Parameters must be of type PBEParameters.");
        }
        this.params = algorithmParameters;
        this.initCipher(n2, key);
    }

    public AlgorithmParameters engineGetParameters() {
        return this.params;
    }

    public PbeWithMD5AndDES_CBC() throws NoSuchPaddingException, NoSuchAlgorithmException {
        super.engineSetPadding("PKCS5Padding");
        super.engineSetMode("CBC");
        this.params = AlgorithmParameters.getInstance("PBE");
    }
}

