/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplResultSetService;
import com.metamatrix.jdbc.base.BaseResultSetSortDescriptor;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import java.sql.SQLException;

public final class BaseImplResultSetClientSideSorter
extends BaseImplResultSetService {
    private static String footprint = "$Revision:   3.8.1.0  $";
    private UtilPagedTempBuffer rowPositionBuffer;
    boolean haveSortedRows = false;
    BaseResultSetSortDescriptor sortDescriptor;
    private BaseData[] sortedRow;
    private BaseData[] nextRowToBeSorted;

    public void postSetupInitialize() throws SQLException {
        this.rowPositionBuffer = new UtilPagedTempBuffer();
        super.postSetupInitialize();
    }

    public void setSortCriteria(BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        this.sortDescriptor = baseResultSetSortDescriptor;
    }

    public void close() throws SQLException {
        super.close();
        try {
            this.rowPositionBuffer.truncate();
        }
        catch (UtilException utilException) {
            // empty catch block
        }
    }

    public int getColumnAccess() {
        return 2;
    }

    public void setFetchSize(int n) {
    }

    public boolean fetchAtPosition(int n) throws SQLException {
        if (!this.haveSortedRows) {
            this.initializeRows();
            this.fetchAndSortRows();
        }
        if (n > this.maxCursorPosition) {
            return false;
        }
        this.getSortedFromSubResultSet(n, false);
        return true;
    }

    private void fetchAndSortRows() throws SQLException {
        boolean bl;
        int n = 1;
        do {
            if (!(bl = this.subImplResultSet.fetchAtPosition(n))) continue;
            this.getCurrentFromSubResultSet(this.nextRowToBeSorted, false);
            this.insertSubResultSetRowIntoSortList(n);
            ++n;
        } while (bl);
        this.haveSortedRows = true;
        this.maxCursorPosition = n - 1;
    }

    private void insertSubResultSetRowIntoSortList(int n) throws SQLException {
        try {
            int n2;
            int n3;
            int n4 = 0;
            boolean bl = true;
            if (n != 1) {
                int n5;
                n3 = 1;
                n2 = n;
                int n6 = (n3 + n2) / 2;
                boolean bl2 = false;
                do {
                    n5 = n6;
                    this.getSortedFromSubResultSet(n6, true);
                    bl = this.compareCurrentRows();
                    if (bl) {
                        n3 = n6;
                        bl2 = true;
                        continue;
                    }
                    n2 = n6;
                    bl2 = false;
                } while (n5 != (n6 = (n3 + n2) / 2));
                n4 = n6 - 1 + (bl2 ? 1 : 0);
            }
            n3 = n;
            n2 = 0;
            while (n4 < n) {
                if (n4 != n - 1) {
                    n2 = this.rowPositionBuffer.readInt((long)(n4 * 4));
                }
                this.rowPositionBuffer.writeInt((long)(n4 * 4), n3);
                n3 = n2;
                ++n4;
            }
        }
        catch (UtilException utilException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException((Exception)((Object)utilException));
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6043, "TMPDIR");
        }
    }

    private void getSortedFromSubResultSet(int n, boolean bl) throws SQLException {
        try {
            n = this.rowPositionBuffer.readInt((long)((n - 1) * 4));
            this.subImplResultSet.fetchAtPosition(n);
            this.getCurrentFromSubResultSet(this.sortedRow, bl);
        }
        catch (UtilException utilException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException((Exception)((Object)utilException));
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6043, "TMPDIR");
        }
    }

    private void getCurrentFromSubResultSet(BaseData[] baseDataArray, boolean bl) throws SQLException {
        if (bl) {
            int n = this.sortDescriptor.getSortCount();
            for (int i = 0; i < n; ++i) {
                int n2 = this.sortDescriptor.getSortColumnOrdinal(i);
                BaseData baseData = this.subImplResultSet.getData(n2, this.columns.get((int)n2).baseDataType);
                baseDataArray[n2 - 1].populate(baseData);
            }
        } else {
            int n = this.columns.count(1);
            for (int i = 1; i <= n; ++i) {
                BaseData baseData = this.subImplResultSet.getData(i, this.columns.get((int)i).baseDataType);
                baseDataArray[i - 1].populate(baseData);
            }
        }
    }

    private boolean compareCurrentRows() throws SQLException {
        int n = 0;
        for (int i = 0; i < this.sortDescriptor.getSortCount() && n == 0; ++i) {
            int n2 = this.sortDescriptor.getSortColumnOrdinal(i);
            n = BaseData.compare(this.nextRowToBeSorted[n2 - 1], this.sortedRow[n2 - 1], BaseData.mapJDBCTypeToJavaObjectType(this.columns.get((int)n2).type), this.implStatement.implConnection.useASCIISort, this.implStatement.implConnection.exceptions);
        }
        return n >= 0;
    }

    private void initializeRows() {
        int n = this.columns.count(1);
        this.sortedRow = new BaseData[n];
        this.nextRowToBeSorted = new BaseData[n];
        for (int i = 0; i < n; ++i) {
            BaseColumn baseColumn = this.columns.get(i + 1);
            this.sortedRow[i] = new BaseData(null);
            this.nextRowToBeSorted[i] = new BaseData(null);
        }
    }

    public BaseData getData(int n, int n2) throws SQLException {
        return this.sortedRow[n - 1];
    }
}

