/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.security;

import COM.rsa.jsafe.JSAFE_IVException;
import COM.rsa.jsafe.JSAFE_InvalidKeyException;
import COM.rsa.jsafe.JSAFE_InvalidUseException;
import COM.rsa.jsafe.JSAFE_SecretKey;
import COM.rsa.jsafe.JSAFE_SymmetricCipher;
import COM.rsa.jsafe.JSAFE_UnimplementedException;
import com.metamatrix.sequelink.security.Message;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public final class JSafeRC4Cipher
extends CipherSpi {
    private static final String JSAFE_DEVICE = "Java";
    private static final String JSAFE_RC4_ALG = "RC4";
    private JSAFE_SymmetricCipher realCipher;
    private boolean isEncryption;

    public JSafeRC4Cipher() {
        try {
            this.realCipher = JSAFE_SymmetricCipher.getInstance((String)JSAFE_RC4_ALG, (String)JSAFE_DEVICE);
        }
        catch (Exception exception) {
            throw new RuntimeException(Message.Gen.getException(7665, exception.toString()));
        }
    }

    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = null;
        if (this.isEncryption) {
            try {
                byArray2 = this.realCipher.encryptUpdate(byArray, n2, n3);
            }
            catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
                throw new RuntimeException(Message.Gen.getException(7667, jSAFE_InvalidUseException.toString()));
            }
            catch (JSAFE_IVException jSAFE_IVException) {
                throw new RuntimeException(Message.Gen.getException(7667, jSAFE_IVException.toString()));
            }
        }
        try {
            byArray2 = this.realCipher.decryptUpdate(byArray, n2, n3);
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(Message.Gen.getException(7668, jSAFE_InvalidUseException.toString()));
        }
        catch (JSAFE_IVException jSAFE_IVException) {
            throw new RuntimeException(Message.Gen.getException(7668, jSAFE_IVException.toString()));
        }
        return byArray2;
    }

    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n5 = 0;
        if (this.isEncryption) {
            try {
                n5 = this.realCipher.encryptUpdate(byArray, n2, n3, byArray2, n4);
            }
            catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
                throw new RuntimeException(Message.Gen.getException(7667, jSAFE_InvalidUseException.toString()));
            }
            catch (JSAFE_IVException jSAFE_IVException) {
                throw new RuntimeException(Message.Gen.getException(7667, jSAFE_IVException.toString()));
            }
        }
        try {
            n5 = this.realCipher.decryptUpdate(byArray, n2, n3, byArray2, n4);
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(Message.Gen.getException(7668, jSAFE_InvalidUseException.toString()));
        }
        catch (JSAFE_IVException jSAFE_IVException) {
            throw new RuntimeException(Message.Gen.getException(7668, jSAFE_IVException.toString()));
        }
        return n5;
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetOutputSize(int n2) {
        return 0;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n2, key, secureRandom);
    }

    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n2, key, secureRandom);
    }

    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            JSAFE_SecretKey jSAFE_SecretKey = JSafeRC4Cipher.getJSafeRC4Key(key.getEncoded());
            switch (n2) {
                case 1: {
                    this.realCipher.encryptInit(jSAFE_SecretKey, null);
                    this.isEncryption = true;
                    break;
                }
                case 2: {
                    this.realCipher.decryptInit(jSAFE_SecretKey);
                    this.isEncryption = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Message.Gen.getException(7654));
                }
            }
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(Message.Gen.getException(7666, jSAFE_InvalidUseException.toString()));
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new InvalidKeyException(Message.Gen.getException(7666, jSAFE_InvalidKeyException.toString()));
        }
        catch (JSAFE_IVException jSAFE_IVException) {
            throw new RuntimeException(Message.Gen.getException(7666, jSAFE_IVException.toString()));
        }
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
    }

    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = null;
        if (this.isEncryption) {
            try {
                byArray2 = this.realCipher.encryptUpdate(byArray, n2, n3);
            }
            catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
                throw new RuntimeException(Message.Gen.getException(7667, jSAFE_InvalidUseException.toString()));
            }
            catch (JSAFE_IVException jSAFE_IVException) {
                throw new RuntimeException(Message.Gen.getException(7667, jSAFE_IVException.toString()));
            }
        }
        try {
            byArray2 = this.realCipher.decryptUpdate(byArray, n2, n3);
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(Message.Gen.getException(7668, jSAFE_InvalidUseException.toString()));
        }
        catch (JSAFE_IVException jSAFE_IVException) {
            throw new RuntimeException(Message.Gen.getException(7668, jSAFE_IVException.toString()));
        }
        return byArray2;
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        int n5 = 0;
        if (this.isEncryption) {
            try {
                n5 = this.realCipher.encryptUpdate(byArray, n2, n3, byArray2, n4);
            }
            catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
                throw new RuntimeException(Message.Gen.getException(7667, jSAFE_InvalidUseException.toString()));
            }
            catch (JSAFE_IVException jSAFE_IVException) {
                throw new RuntimeException(Message.Gen.getException(7667, jSAFE_IVException.toString()));
            }
        }
        try {
            n5 = this.realCipher.decryptUpdate(byArray, n2, n3, byArray2, n4);
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(Message.Gen.getException(7668, jSAFE_InvalidUseException.toString()));
        }
        catch (JSAFE_IVException jSAFE_IVException) {
            throw new RuntimeException(Message.Gen.getException(7668, jSAFE_IVException.toString()));
        }
        return n5;
    }

    private static JSAFE_SecretKey getJSafeRC4Key(byte[] byArray) {
        try {
            JSAFE_SecretKey jSAFE_SecretKey = JSAFE_SecretKey.getInstance((String)JSAFE_RC4_ALG, (String)JSAFE_DEVICE);
            byte[][] byArrayArray = new byte[][]{byArray};
            jSAFE_SecretKey.setKeyData((byte[][])byArrayArray);
            return jSAFE_SecretKey;
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new RuntimeException(Message.Gen.getException(7666, jSAFE_InvalidKeyException.toString()));
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new RuntimeException(Message.Gen.getException(7666, jSAFE_UnimplementedException.toString()));
        }
    }
}

