/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.server;

import com.metamatrix.common.comm.CommonCommPlugin;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.service.ClientConnectionWithConnectionId;
import com.metamatrix.common.comm.service.ExceptionHolder;
import com.metamatrix.core.proxy.ServiceInterceptor;
import com.metamatrix.core.proxy.ServiceInterceptorStack;
import com.metamatrix.core.proxy.ServiceInvocation;
import com.metamatrix.core.proxy.ServiceInvocationStruct;
import com.metamatrix.core.proxy.TerminalServiceInterceptor;
import java.io.Serializable;

public class MessageServiceAgent
implements ServerListener {
    protected Class serviceInterface;
    private ServiceInterceptor[] interceptors;
    private TerminalServiceInterceptor terminalInterceptor;

    public MessageServiceAgent(Class serviceInterface, ServiceInterceptor[] interceptors, TerminalServiceInterceptor terminalInterceptor) {
        this.serviceInterface = serviceInterface;
        this.interceptors = interceptors;
        this.terminalInterceptor = terminalInterceptor;
    }

    public void connectionAdded(ClientConnection connection) {
    }

    public void connectionRemoved(ClientConnection connection) {
    }

    public void receive(ClientConnection connection, Message message, String messageKey) {
        throw new UnsupportedOperationException();
    }

    public Message receive(ClientConnection connection, Message message) throws ApplicationException {
        MessageHolder requestMessage = (MessageHolder)message;
        ServiceInterceptorStack interceptorStack = new ServiceInterceptorStack(this.interceptors, this.terminalInterceptor);
        ServiceInvocation invocation = new ServiceInvocation((ServiceInvocationStruct)requestMessage.contents, this.serviceInterface, interceptorStack);
        return MessageServiceAgent.receiveLocal(connection, invocation);
    }

    private static Message receiveLocal(ClientConnection connection, ServiceInvocation invocation) {
        ClientConnectionWithConnectionId connectionWithConnectionId;
        String connectionID;
        if (connection instanceof ClientConnectionWithConnectionId && (connectionID = (connectionWithConnectionId = (ClientConnectionWithConnectionId)connection).getConnectionId()) != null) {
            invocation.setAttribute("connectionId", (Serializable)((Object)connectionID));
        }
        Object result = null;
        MessageHolder responseMessage = new MessageHolder();
        try {
            result = invocation.invokeNext();
        }
        catch (Throwable ex) {
            CommonCommPlugin.Util.log(ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            responseMessage.contents = new ExceptionHolder(ex);
        }
        if (responseMessage.contents == null) {
            responseMessage.contents = (Serializable)result;
        }
        return responseMessage;
    }

    public static Message receive(ClientConnection connection, Message message, Class serviceInterface, ServiceInterceptor[] interceptors, TerminalServiceInterceptor terminalInterceptor) throws ApplicationException {
        MessageHolder requestMessage = (MessageHolder)message;
        ServiceInterceptorStack interceptorStack = new ServiceInterceptorStack(interceptors, terminalInterceptor);
        ServiceInvocation invocation = new ServiceInvocation((ServiceInvocationStruct)requestMessage.contents, serviceInterface, interceptorStack);
        return MessageServiceAgent.receiveLocal(connection, invocation);
    }

    public String toString() {
        return "ServiceInterceptor[]= " + this.interceptors + "TerminalServiceInterceptor= " + this.terminalInterceptor;
    }
}

