/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform;

import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.server.ClientConnectionImpl;
import com.metamatrix.platform.resource.MessageReceiver;
import com.metamatrix.platform.resource.RemoteResource;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class RemoteResourceImpl
implements RemoteResource {
    private Map sessionToClientConnection = Collections.synchronizedMap(new HashMap());
    private ServerListener listener;

    public RemoteResourceImpl(ServerListener listener) {
        this.listener = listener;
    }

    public void send(Message message, String messageKey, Object clientIdentifier) throws RemoteException {
        ClientConnection clientConn = (ClientConnection)this.sessionToClientConnection.get(clientIdentifier);
        if (CommPlatformPlugin.DEBUG) {
            String debug = CommPlatformPlugin.Util.getString("RemoteResourceImpl.Send_asynch", clientIdentifier, (Object)message);
            CommPlatformPlugin.Util.log(1, debug);
        }
        this.listener.receive(clientConn, message, messageKey);
    }

    public Message send(Message message, Object clientIdentifier) throws ApplicationException, RemoteException {
        ClientConnection clientConn = (ClientConnection)this.sessionToClientConnection.get(clientIdentifier);
        if (CommPlatformPlugin.DEBUG) {
            String debug = CommPlatformPlugin.Util.getString("RemoteResourceImpl.Send_asynch", clientIdentifier, (Object)message);
            CommPlatformPlugin.Util.log(1, debug);
        }
        return this.listener.receive(clientConn, message);
    }

    public void setMessageReceiver(MessageReceiver receiver, Properties props, Object clientIdentifier) throws RemoteException {
        ClientConnectionImpl clientConn = new ClientConnectionImpl(receiver, props, clientIdentifier.toString());
        this.sessionToClientConnection.put(clientIdentifier, clientConn);
        if (CommPlatformPlugin.DEBUG) {
            String debug = CommPlatformPlugin.Util.getString("RemoteResourceImpl.Set_message_receiver", clientIdentifier, (Object)receiver, (Object)props);
            CommPlatformPlugin.Util.log(1, debug);
        }
    }

    public void clientShutdown(Object clientIdentifier) throws RemoteException {
        ClientConnection clientConn = (ClientConnection)this.sessionToClientConnection.get(clientIdentifier);
        this.sessionToClientConnection.remove(clientIdentifier);
        this.listener.connectionRemoved(clientConn);
    }
}

