/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.bridges.io;

import MITI.sdk.MIRAssociation;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRCandidateKey;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDatabaseCatalog;
import MITI.sdk.MIRDatabaseSchema;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRDiagram;
import MITI.sdk.MIRForeignKey;
import MITI.sdk.MIRGeneralization;
import MITI.sdk.MIRIndex;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperation;
import MITI.sdk.MIRPresentationElement;
import MITI.sdk.MIRSQLViewAssociation;
import MITI.sdk.MIRSQLViewAttribute;
import MITI.sdk.MIRSQLViewEntity;
import MITI.sdk.MIRSynonym;
import MITI.sdk.MIRXmlSchema;
import MITI.util.MIRIterator;
import com.metamatrix.bridges.BridgesPlugin;
import com.metamatrix.bridges.io.BridgeEntityFactory;
import com.metamatrix.bridges.io.BridgeImporter;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.internal.core.container.ContainerImpl;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.resource.MMXmiResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.util.XSDResourceImpl;

public class BridgeModelProcessor {
    private final BridgeImporter importer;
    private final IProgressMonitor monitor;
    private final BridgeEntityFactory entityFactory;
    private boolean logicalOnlyModel;
    private boolean physicalOnlyModel;
    private Resource logicalResource;
    private Resource physicalResource;
    private Resource relationshipResource;
    private XSDResourceImpl dataTypeResource;

    public BridgeModelProcessor(BridgeImporter importer) {
        this.importer = importer;
        this.monitor = importer.getProgressMonitor();
        this.entityFactory = new BridgeEntityFactory(this, importer);
    }

    public void process(MIRModel model) {
        if (this.monitor.isCanceled()) {
            return;
        }
        byte dl = model.getDesignLevel();
        this.physicalOnlyModel = 2 == dl;
        this.logicalOnlyModel = 1 == dl;
        this.entityFactory.initializeResources(model);
        this.entityFactory.initEntityRelationships();
        ArrayList logicalPackages = new ArrayList();
        MIRIterator mirPackages = model.getChildPackageIterator();
        ArrayList<Object> tmp = new ArrayList<Object>();
        while (mirPackages.hasNext()) {
            tmp.add(mirPackages.next());
        }
        Iterator packages = tmp.iterator();
        this.entityFactory.setProcessingLogical(false);
        while (packages.hasNext()) {
            Object nextPackage = packages.next();
            if (nextPackage instanceof MIRDataPackage && !this.isLogicalOnlyModel()) {
                this.process(nextPackage, null);
                continue;
            }
            logicalPackages.add(nextPackage);
        }
        this.entityFactory.setProcessingLogical(true);
        if (!this.isPhysicalOnlyModel()) {
            Iterator logicalPkgs = logicalPackages.iterator();
            while (logicalPkgs.hasNext()) {
                Object nextPackage = logicalPkgs.next();
                this.process(nextPackage, null);
            }
        }
        this.entityFactory.postProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finish(boolean doSave) {
        try {
            try {
                String msg;
                this.postProcess();
                if (!doSave) {
                    Object var10_2 = null;
                    this.logicalResource = null;
                    this.physicalResource = null;
                    this.relationshipResource = null;
                    this.dataTypeResource = null;
                    return;
                }
                boolean hasLogicalModel = true;
                boolean hasPhysicalModel = true;
                boolean hasRelationshipModel = true;
                boolean hasDatatypeModel = true;
                HashMap options = new HashMap();
                if (this.isWorkspaceResource(this.logicalResource)) {
                    try {
                        if (this.physicalOnlyModel || this.logicalResource.getContents().size() < 2) {
                            this.logicalResource.getResourceSet().getResources().remove((Object)this.logicalResource);
                            this.logicalResource = null;
                            hasLogicalModel = false;
                        } else {
                            this.logicalResource.save(options);
                        }
                    }
                    catch (Exception e1) {
                        msg = BridgesPlugin.Util.getString("BridgeReaderAdapter.Unexpected_error_saving_logical_resource_1");
                        this.importer.log(msg, 4, e1);
                    }
                }
                if (this.isWorkspaceResource(this.physicalResource)) {
                    try {
                        if (this.logicalOnlyModel || this.physicalResource.getContents().size() < 2) {
                            this.physicalResource.getResourceSet().getResources().remove((Object)this.physicalResource);
                            this.physicalResource = null;
                            hasPhysicalModel = false;
                        } else {
                            this.physicalResource.save(options);
                        }
                    }
                    catch (Exception e1) {
                        msg = BridgesPlugin.Util.getString("BridgeReaderAdapter.Unexpected_error_saving_physical_resource_2");
                        this.importer.log(msg, 4, e1);
                    }
                }
                if (this.isWorkspaceResource(this.relationshipResource)) {
                    try {
                        if (this.logicalOnlyModel || this.physicalOnlyModel || this.relationshipResource.getContents().size() < 2) {
                            this.relationshipResource.getResourceSet().getResources().remove((Object)this.relationshipResource);
                            this.relationshipResource = null;
                            hasRelationshipModel = false;
                        } else {
                            this.relationshipResource.save(options);
                        }
                    }
                    catch (Exception e1) {
                        msg = BridgesPlugin.Util.getString("BridgeReaderAdapter.Unexpected_error_saving_relationship_resource_3");
                        this.importer.log(msg, 4, e1);
                    }
                }
                if (this.isWorkspaceResource((Resource)this.dataTypeResource)) {
                    try {
                        if (this.dataTypeResource.getSchema() != null && !this.dataTypeResource.getSchema().getTypeDefinitions().isEmpty()) {
                            this.dataTypeResource.save(options);
                        } else {
                            this.dataTypeResource.getResourceSet().getResources().remove((Object)this.dataTypeResource);
                            this.dataTypeResource = null;
                            hasDatatypeModel = false;
                        }
                    }
                    catch (Exception e1) {
                        msg = BridgesPlugin.Util.getString("BridgeReaderAdapter.Unexpected_error_saving_data_type_resource_4");
                        this.importer.log(msg, 4, e1);
                    }
                }
                ModelEditor me = ModelerCore.getModelEditor();
                try {
                    if (hasPhysicalModel && hasDatatypeModel) {
                        me.addModelImport((MMXmiResource)((EmfResource)this.physicalResource), (Resource)this.dataTypeResource);
                    }
                    if (hasRelationshipModel && hasPhysicalModel) {
                        me.addModelImport((MMXmiResource)((EmfResource)this.relationshipResource), this.physicalResource);
                    }
                    if (hasRelationshipModel && hasLogicalModel) {
                        me.addModelImport((MMXmiResource)((EmfResource)this.relationshipResource), this.logicalResource);
                    }
                    if (hasRelationshipModel && hasDatatypeModel) {
                        me.addModelImport((MMXmiResource)((EmfResource)this.relationshipResource), (Resource)this.dataTypeResource);
                    }
                }
                catch (ModelerCoreException e) {
                    this.importer.log(e.getMessage(), 4, (Exception)((Object)e));
                }
            }
            catch (Exception e) {
                this.importer.log(e.getMessage(), 4, e);
                Object var10_4 = null;
                this.logicalResource = null;
                this.physicalResource = null;
                this.relationshipResource = null;
                this.dataTypeResource = null;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_5 = null;
            this.logicalResource = null;
            this.physicalResource = null;
            this.relationshipResource = null;
            this.dataTypeResource = null;
            throw throwable;
        }
        Object var10_3 = null;
        this.logicalResource = null;
        this.physicalResource = null;
        this.relationshipResource = null;
        this.dataTypeResource = null;
    }

    public boolean isLogicalOnlyModel() {
        return this.logicalOnlyModel;
    }

    public boolean isPhysicalOnlyModel() {
        return this.physicalOnlyModel;
    }

    public Resource getPhysicalResource() {
        if (this.physicalResource == null) {
            try {
                this.physicalResource = this.importer.createResource(this.importer.getTargetPhysicalModelName());
            }
            catch (MetaMatrixCoreException e) {
                this.importer.log(e.getMessage(), 4, (Exception)((Object)e));
            }
        }
        return this.physicalResource;
    }

    public Resource getLogicalResource() {
        if (this.logicalResource == null) {
            try {
                this.logicalResource = this.importer.createResource(this.importer.getTargetLogicalModelName());
            }
            catch (MetaMatrixCoreException e) {
                this.importer.log(e.getMessage(), 4, (Exception)((Object)e));
            }
        }
        return this.logicalResource;
    }

    public Resource getRelationshipResource() {
        if (this.relationshipResource == null) {
            try {
                this.relationshipResource = this.importer.createResource(this.importer.getTargetRelationshipsModelName());
            }
            catch (MetaMatrixCoreException e) {
                this.importer.log(e.getMessage(), 4, (Exception)((Object)e));
            }
        }
        return this.relationshipResource;
    }

    public XSDResourceImpl getDatatypeResource() {
        if (this.dataTypeResource == null) {
            try {
                this.dataTypeResource = (XSDResourceImpl)this.importer.createResource(this.importer.getTargetDatatypeModelName());
            }
            catch (MetaMatrixCoreException e) {
                this.importer.log(e.getMessage(), 4, (Exception)((Object)e));
            }
        }
        return this.dataTypeResource;
    }

    private void process(Object obj, Object parent) {
        if (obj instanceof MIRDatabaseCatalog) {
            this.process((MIRDatabaseCatalog)obj, parent);
        } else if (obj instanceof MIRDatabaseSchema) {
            this.process((MIRDatabaseSchema)obj, parent);
        } else if (obj instanceof MIRDesignPackage) {
            this.process((MIRDesignPackage)obj, parent);
        } else if (obj instanceof MIRXmlSchema) {
            this.process((MIRXmlSchema)obj, parent);
        } else if (obj instanceof MIRClass) {
            this.process((MIRClass)obj, parent);
        } else if (obj instanceof MIRAttribute) {
            this.process((MIRAttribute)obj, parent);
        } else if (obj instanceof MIRCandidateKey) {
            this.process((MIRCandidateKey)obj, parent);
        } else if (obj instanceof MIRForeignKey) {
            this.process((MIRForeignKey)obj, parent);
        } else if (obj instanceof MIRIndex) {
            this.process((MIRIndex)obj, parent);
        } else if (obj instanceof MIRGeneralization) {
            this.process((MIRGeneralization)obj, parent);
        } else if (obj instanceof MIRAssociation) {
            this.process((MIRAssociation)obj, parent);
        } else if (obj instanceof MIRSQLViewEntity) {
            this.process((MIRSQLViewEntity)obj, parent);
        } else if (obj instanceof MIRSQLViewAttribute) {
            this.process((MIRSQLViewAttribute)obj, parent);
        } else if (!(obj instanceof MIRDiagram || obj instanceof MIRPresentationElement || obj instanceof MIROperation || obj instanceof MIRSynonym || obj instanceof MIRSQLViewAssociation)) {
            String name = obj == null ? "NULL" : obj.getClass().getName();
            String msg = BridgesPlugin.Util.getString("BridgeModelProcessor.unexpectedEntity", (Object)name);
            this.importer.log(msg, 4, null);
        }
    }

    private void process(MIRDatabaseCatalog cat, Object parent) {
        Object entity = null;
        try {
            entity = this.entityFactory.createEntity(cat, parent);
        }
        catch (BridgeEntityFactory.DesignLevelException err) {
            return;
        }
        MIRIterator elements = cat.getElementNodeIterator();
        while (elements.hasNext()) {
            this.process(elements.next(), entity);
        }
        MIRIterator modelObjects = cat.getModelObjectIterator();
        while (modelObjects.hasNext()) {
            Object next = modelObjects.next();
            if (next instanceof MIRIndex) continue;
            this.process(next, entity);
        }
        MIRIterator children = cat.getChildPackageIterator();
        while (children.hasNext()) {
            this.process(children.next(), entity);
        }
    }

    private void process(MIRDatabaseSchema schema, Object parent) {
        Object entity = null;
        try {
            entity = this.entityFactory.createEntity(schema, parent);
        }
        catch (BridgeEntityFactory.DesignLevelException err) {
            return;
        }
        MIRIterator elements = schema.getElementNodeIterator();
        while (elements.hasNext()) {
            this.process(elements.next(), entity);
        }
        MIRIterator modelObjects = schema.getModelObjectIterator();
        while (modelObjects.hasNext()) {
            Object next = modelObjects.next();
            if (next instanceof MIRIndex) continue;
            this.process(next, entity);
        }
        MIRIterator children = schema.getChildPackageIterator();
        while (children.hasNext()) {
            this.process(children.next(), entity);
        }
    }

    private void process(MIRSQLViewEntity view, Object parent) {
        Object entity = null;
        try {
            entity = this.entityFactory.createEntity(view, parent);
        }
        catch (BridgeEntityFactory.DesignLevelException err) {
            return;
        }
        MIRIterator elements = view.getElementNodeIterator();
        while (elements.hasNext()) {
            this.process(elements.next(), entity);
        }
        Iterator features = view.getFeatureByPosition().iterator();
        while (features.hasNext()) {
            this.process(features.next(), entity);
        }
    }

    private void process(MIRXmlSchema schema, Object parent) {
        Object entity = null;
        try {
            entity = this.entityFactory.createEntity((MIRObject)schema, parent);
        }
        catch (BridgeEntityFactory.DesignLevelException err) {
            return;
        }
        MIRIterator elements = schema.getElementNodeIterator();
        while (elements.hasNext()) {
            this.process(elements.next(), entity);
        }
        MIRIterator modelObjects = schema.getModelObjectIterator();
        while (modelObjects.hasNext()) {
            this.process(modelObjects.next(), entity);
        }
        MIRIterator children = schema.getChildPackageIterator();
        while (children.hasNext()) {
            this.process(children.next(), entity);
        }
    }

    private void process(MIRClass classifier, Object parent) {
        Object entity = null;
        try {
            entity = this.entityFactory.createEntity(classifier, parent);
        }
        catch (BridgeEntityFactory.DesignLevelException err) {
            return;
        }
        MIRIterator elements = classifier.getElementNodeIterator();
        while (elements.hasNext()) {
            this.process(elements.next(), entity);
        }
        Iterator features = classifier.getFeatureByPosition().iterator();
        while (features.hasNext()) {
            this.process(features.next(), entity);
        }
        MIRIterator keys = classifier.getKeyIterator();
        while (keys.hasNext()) {
            this.process(keys.next(), entity);
        }
        MIRIterator indexes = classifier.getIndexIterator();
        while (indexes.hasNext()) {
            this.process(indexes.next(), entity);
        }
    }

    private void process(MIRAttribute mirAttr, Object parent) {
        try {
            this.entityFactory.createEntity(mirAttr, parent);
        }
        catch (BridgeEntityFactory.DesignLevelException err) {
            return;
        }
    }

    private void process(MIRSQLViewAttribute mirAttr, Object parent) {
        try {
            this.entityFactory.createEntity(mirAttr, parent);
        }
        catch (BridgeEntityFactory.DesignLevelException err) {
            return;
        }
    }

    private void process(MIRIndex mirIndex, Object parent) {
        try {
            this.entityFactory.createEntity(mirIndex, parent);
        }
        catch (BridgeEntityFactory.DesignLevelException err) {
            return;
        }
    }

    private void process(MIRCandidateKey mirKey, Object parent) {
        try {
            this.entityFactory.createEntity(mirKey, parent);
        }
        catch (BridgeEntityFactory.DesignLevelException err) {
            return;
        }
    }

    private void process(MIRForeignKey mirKey, Object parent) {
        try {
            this.entityFactory.createEntity(mirKey, parent);
        }
        catch (BridgeEntityFactory.DesignLevelException err) {
            return;
        }
    }

    private void process(MIRDesignPackage dp, Object parent) {
        Object entity = null;
        try {
            entity = this.entityFactory.createEntity(dp, parent);
        }
        catch (BridgeEntityFactory.DesignLevelException err) {
            return;
        }
        MIRIterator elements = dp.getElementNodeIterator();
        while (elements.hasNext()) {
            this.process(elements.next(), entity);
        }
        MIRIterator modelElements = dp.getModelElementIterator();
        while (modelElements.hasNext()) {
            this.process(modelElements.next(), entity);
        }
        MIRIterator children = dp.getChildPackageIterator();
        while (children.hasNext()) {
            this.process(children.next(), entity);
        }
        MIRIterator diagrams = dp.getDiagramIterator();
        while (diagrams.hasNext()) {
            this.process(diagrams.next(), entity);
        }
    }

    private void process(MIRAssociation mirAssoc, Object parent) {
        this.entityFactory.createEntity(mirAssoc, parent);
    }

    private void process(MIRGeneralization mirGen, Object parent) {
        try {
            this.entityFactory.createEntity(mirGen, parent);
        }
        catch (BridgeEntityFactory.DesignLevelException err) {
            return;
        }
    }

    private void postProcess() {
        if (this.importer.getProgressMonitor().isCanceled()) {
            this.removeResources();
            return;
        }
    }

    private boolean isWorkspaceResource(Resource rsrc) {
        ResourceSet rs;
        ContainerImpl updateCntr;
        if (rsrc == null) {
            return false;
        }
        return !this.importer.getUpdateExisting() || (updateCntr = (ContainerImpl)this.importer.getUpdateResourceSet()) != (rs = rsrc.getResourceSet()) && updateCntr.getResourceSet() != rs;
    }

    private void removeResources() {
        if (this.logicalResource != null) {
            this.logicalResource.getResourceSet().getResources().remove((Object)this.logicalResource);
        }
        if (this.physicalResource != null) {
            this.physicalResource.getResourceSet().getResources().remove((Object)this.physicalResource);
        }
        if (this.relationshipResource != null) {
            this.relationshipResource.getResourceSet().getResources().remove((Object)this.relationshipResource);
        }
        if (this.dataTypeResource != null) {
            this.dataTypeResource.getResourceSet().getResources().remove((Object)this.dataTypeResource);
        }
    }
}

