/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.jdbc.ui.wizards;

import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.internal.jdbc.ui.util.JdbcUiUtil;
import com.metamatrix.modeler.internal.jdbc.ui.wizards.JdbcImportMetadataPage;
import com.metamatrix.modeler.internal.jdbc.ui.wizards.JdbcImportWizard;
import com.metamatrix.modeler.jdbc.JdbcImportSettings;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.metadata.Includes;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.ui.UiConstants;
import com.metamatrix.ui.internal.InternalUiConstants;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.util.WidgetUtil;
import com.metamatrix.ui.internal.util.WizardUtil;
import com.metamatrix.ui.internal.widget.IListPanelController;
import com.metamatrix.ui.internal.widget.ListPanel;
import com.metamatrix.ui.internal.wizard.IPersistentWizardPage;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

final class JdbcImportMetadataPage
extends WizardPage
implements InternalUiConstants.Widgets,
IPersistentWizardPage,
ListPanel.Constants,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$internal$jdbc$ui$wizards$JdbcImportMetadataPage == null ? (class$com$metamatrix$modeler$internal$jdbc$ui$wizards$JdbcImportMetadataPage = JdbcImportMetadataPage.class$("com.metamatrix.modeler.internal.jdbc.ui.wizards.JdbcImportMetadataPage")) : class$com$metamatrix$modeler$internal$jdbc$ui$wizards$JdbcImportMetadataPage));
    private static final String TITLE = JdbcImportMetadataPage.getString("title");
    private static final String APPROXIMATIONS_BUTTON = JdbcImportMetadataPage.getString("approximationsButton");
    private static final String FOREIGN_KEYS_BUTTON = JdbcImportMetadataPage.getString("foreignKeysButton");
    private static final String INDEXES_BUTTON = JdbcImportMetadataPage.getString("indexesButton");
    private static final String PROCEDURES_BUTTON = JdbcImportMetadataPage.getString("proceduresButton");
    private static final String UNIQUE_BUTTON = JdbcImportMetadataPage.getString("uniqueButton");
    private static final String TABLE_TYPES_GROUP = JdbcImportMetadataPage.getString("tableTypesGroup");
    private static final String INITIAL_MESSAGE = JdbcImportMetadataPage.getString("initialMessage");
    private static final String INVALID_PAGE_MESSAGE = JdbcImportMetadataPage.getString("invalidPageMessage", PROCEDURES_BUTTON, TABLE_TYPES_GROUP);
    private static final int COLUMN_COUNT = 2;
    private static final int CHECKBOX_TEXT_GAP = 5;
    private Includes incls;
    private JdbcImportSettings importSettings;
    private Button foreignKeysCheckBox;
    private Button indexesCheckBox;
    private Button uniqueCheckBox;
    private Button approximationsCheckBox;
    private Button proceduresCheckBox;
    private ListPanel listPanel;
    private Map enableMap;
    private boolean initd;
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$jdbc$ui$wizards$JdbcImportMetadataPage;

    private static String getString(String id) {
        return UiConstants.Util.getString(I18N_PREFIX + id);
    }

    private static String getString(String id, String parameter1, String parameter2) {
        return UiConstants.Util.getString(I18N_PREFIX + id, (Object)parameter1, (Object)parameter2);
    }

    JdbcImportMetadataPage() {
        super(ClassUtil.getSimpleClassName((Class)(class$com$metamatrix$modeler$internal$jdbc$ui$wizards$JdbcImportMetadataPage == null ? (class$com$metamatrix$modeler$internal$jdbc$ui$wizards$JdbcImportMetadataPage = JdbcImportMetadataPage.class$("com.metamatrix.modeler.internal.jdbc.ui.wizards.JdbcImportMetadataPage")) : class$com$metamatrix$modeler$internal$jdbc$ui$wizards$JdbcImportMetadataPage)), TITLE, null);
    }

    public void createControl(Composite parent) {
        Composite pg = new Composite(parent, 0);
        pg.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)pg);
        Composite checkBoxPanel = WidgetFactory.createPanel((Composite)pg, (int)8, (int)2);
        this.foreignKeysCheckBox = WidgetFactory.createCheckBox((Composite)checkBoxPanel, (String)FOREIGN_KEYS_BUTTON);
        this.foreignKeysCheckBox.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.indexesCheckBox = WidgetFactory.createCheckBox((Composite)checkBoxPanel);
        this.indexesCheckBox.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        int indent = this.indexesCheckBox.computeSize((int)-1, (int)-1, (boolean)true).x + 5;
        this.indexesCheckBox.setText(INDEXES_BUTTON);
        this.uniqueCheckBox = this.createNestedCheckbox(checkBoxPanel, UNIQUE_BUTTON, indent);
        this.uniqueCheckBox.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.approximationsCheckBox = this.createNestedCheckbox(checkBoxPanel, APPROXIMATIONS_BUTTON, indent);
        this.approximationsCheckBox.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.proceduresCheckBox = WidgetFactory.createCheckBox((Composite)checkBoxPanel, (String)PROCEDURES_BUTTON);
        this.proceduresCheckBox.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        6 ctrlr = new /* Unavailable Anonymous Inner Class!! */;
        this.listPanel = new ListPanel(pg, TABLE_TYPES_GROUP, (IListPanelController)ctrlr, 10, 4);
        this.listPanel.getViewer().addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void saveSettings() {
        IDialogSettings dlgSettings = this.getDialogSettings();
        Includes incls = ((JdbcImportWizard)this.getWizard()).getDatabase().getIncludes();
        dlgSettings.put(APPROXIMATIONS_BUTTON, incls.getApproximateIndexes());
        dlgSettings.put(FOREIGN_KEYS_BUTTON, incls.includeForeignKeys());
        dlgSettings.put(INDEXES_BUTTON, incls.includeIndexes());
        dlgSettings.put(PROCEDURES_BUTTON, incls.includeProcedures());
        dlgSettings.put(UNIQUE_BUTTON, incls.getUniqueIndexesOnly());
        String[] tableTypes = incls.getIncludedTableTypes();
        if (tableTypes != null) {
            dlgSettings.put(TABLE_TYPES_GROUP, tableTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean visible) {
        if (visible) {
            boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Initializing Import Settings", (Object)((Object)this));
            boolean succeeded = false;
            try {
                this.initializeInTransaction();
                succeeded = true;
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        this.setMessage(INITIAL_MESSAGE);
        super.setVisible(visible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void initializeInTransaction() {
        ResultSet result;
        block14: {
            JdbcDatabase db = ((JdbcImportWizard)this.getWizard()).getDatabase();
            if (db == null) {
                return;
            }
            this.incls = db.getIncludes();
            JdbcSource src = ((JdbcImportWizard)this.getWizard()).getSource();
            this.importSettings = src.getImportSettings();
            IDialogSettings dlgSettings = this.getDialogSettings();
            boolean updating = ((JdbcImportWizard)this.getWizard()).isUpdatedModel();
            if (!updating && dlgSettings.get(PROCEDURES_BUTTON) != null && !this.initd) {
                this.initd = true;
                this.incls.setApproximateIndexes(dlgSettings.getBoolean(APPROXIMATIONS_BUTTON));
                this.incls.setIncludeForeignKeys(dlgSettings.getBoolean(FOREIGN_KEYS_BUTTON));
                this.incls.setIncludeIndexes(dlgSettings.getBoolean(INDEXES_BUTTON));
                this.incls.setIncludeProcedures(dlgSettings.getBoolean(PROCEDURES_BUTTON));
                this.incls.setUniqueIndexesOnly(dlgSettings.getBoolean(UNIQUE_BUTTON));
                this.incls.setIncludedTableTypes(dlgSettings.getArray(TABLE_TYPES_GROUP));
                this.importSettings.setIncludeApproximateIndexes(dlgSettings.getBoolean(APPROXIMATIONS_BUTTON));
                this.importSettings.setIncludeForeignKeys(dlgSettings.getBoolean(FOREIGN_KEYS_BUTTON));
                this.importSettings.setIncludeIndexes(dlgSettings.getBoolean(INDEXES_BUTTON));
                this.importSettings.setIncludeProcedures(dlgSettings.getBoolean(PROCEDURES_BUTTON));
                this.importSettings.setIncludeUniqueIndexes(dlgSettings.getBoolean(UNIQUE_BUTTON));
                EList tableTypes = this.importSettings.getIncludedTableTypes();
                String[] ttypes = this.incls.getIncludedTableTypes();
                for (int i = 0; i < ttypes.length; ++i) {
                    String tableType = ttypes[i];
                    tableTypes.add(tableType);
                }
            }
            this.setSelected(this.approximationsCheckBox, this.incls.getApproximateIndexes());
            this.setSelected(this.foreignKeysCheckBox, this.incls.includeForeignKeys());
            this.setSelected(this.indexesCheckBox, this.incls.includeIndexes());
            this.setSelected(this.proceduresCheckBox, this.incls.includeProcedures());
            this.setSelected(this.uniqueCheckBox, this.incls.getUniqueIndexesOnly());
            TableViewer viewer = this.listPanel.getTableViewer();
            Object obj = viewer.getElementAt(0);
            while (obj != null) {
                viewer.remove(obj);
                obj = viewer.getElementAt(0);
            }
            result = null;
            result = db.getDatabaseMetaData().getTableTypes();
            ArrayList<String> types = new ArrayList<String>();
            while (result.next()) {
                String type = result.getString(1);
                if (types.contains(type)) continue;
                types.add(type);
            }
            if (types.isEmpty()) break block14;
            viewer.add(types.toArray());
            EList lastTypes = this.importSettings.getIncludedTableTypes();
            if (lastTypes != null && !lastTypes.isEmpty()) {
                viewer.setSelection((ISelection)new StructuredSelection((List)lastTypes));
                break block14;
            }
            viewer.setSelection((ISelection)new StructuredSelection(types));
        }
        Object var10_11 = null;
        if (result == null) return;
        try {
            result.close();
            return;
        }
        catch (SQLException e) {
            UiConstants.Util.log((Throwable)e);
        }
        return;
        {
            catch (Exception err) {
                JdbcUiUtil.showAccessError((Throwable)err);
                Object var10_12 = null;
                if (result == null) return;
                try {
                    result.close();
                    return;
                }
                catch (SQLException e) {
                    UiConstants.Util.log((Throwable)e);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (result == null) throw throwable;
            try {
                result.close();
                throw throwable;
            }
            catch (SQLException e) {
                UiConstants.Util.log((Throwable)e);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void approximationsCheckBoxSelected() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Opproxomations Option", (Object)((Object)this));
        boolean succeeded = false;
        try {
            this.incls.setApproximateIndexes(this.approximationsCheckBox.getSelection());
            this.importSettings.setIncludeApproximateIndexes(this.incls.getApproximateIndexes());
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void foreignKeysCheckBoxSelected() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Foreign Keys Option", (Object)((Object)this));
        boolean succeeded = false;
        try {
            this.incls.setIncludeForeignKeys(this.foreignKeysCheckBox.getSelection());
            this.importSettings.setIncludeForeignKeys(this.incls.includeForeignKeys());
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void indexesCheckBoxSelected() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Indexes Option", (Object)((Object)this));
        boolean succeeded = false;
        try {
            boolean enabled = this.indexesCheckBox.getSelection();
            this.incls.setIncludeIndexes(enabled);
            this.uniqueCheckBox.setEnabled(enabled);
            this.approximationsCheckBox.setEnabled(enabled);
            this.importSettings.setIncludeIndexes(this.incls.includeIndexes());
            this.importSettings.setIncludeUniqueIndexes(this.incls.getUniqueIndexesOnly());
            this.importSettings.setIncludeApproximateIndexes(this.incls.getApproximateIndexes());
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void procuduresButtonSelected() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Procedures Option", (Object)((Object)this));
        boolean succeeded = false;
        try {
            this.incls.setIncludeProcedures(this.proceduresCheckBox.getSelection());
            this.importSettings.setIncludeProcedures(this.incls.includeProcedures());
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        this.validatePage();
    }

    void tableTypesSelected(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        String[] types = new String[selection.size()];
        EList tableTypes = this.importSettings.getIncludedTableTypes();
        tableTypes.clear();
        Iterator iter = selection.iterator();
        for (int ndx = 0; ndx < types.length; ++ndx) {
            types[ndx] = (String)iter.next();
            tableTypes.add(types[ndx]);
        }
        this.incls.setIncludedTableTypes(types);
        boolean enabled = types.length > 0;
        this.foreignKeysCheckBox.setEnabled(enabled);
        this.indexesCheckBox.setEnabled(enabled);
        if (enabled) {
            if (this.enableMap != null) {
                WidgetUtil.restore((Map)this.enableMap);
                this.enableMap = null;
            }
        } else {
            this.enableMap = WidgetUtil.disable((Control[])new Control[]{this.uniqueCheckBox, this.approximationsCheckBox});
        }
        this.validatePage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uniqueCheckBoxSelected() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Unique Indexes Option", (Object)((Object)this));
        boolean succeeded = false;
        try {
            this.incls.setUniqueIndexesOnly(this.uniqueCheckBox.getSelection());
            this.importSettings.setIncludeUniqueIndexes(this.incls.getUniqueIndexesOnly());
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private Button createNestedCheckbox(Composite parent, String text, int indent) {
        Button button = WidgetFactory.createCheckBox((Composite)parent, (String)text);
        GridData gridData = (GridData)button.getLayoutData();
        gridData.horizontalIndent = indent;
        return button;
    }

    private void setSelected(Button checkBox, boolean selected) {
        checkBox.setSelection(selected);
        checkBox.notifyListeners(13, new Event());
    }

    private void validatePage() {
        if (this.proceduresCheckBox.getSelection() || !this.listPanel.getViewer().getSelection().isEmpty()) {
            WizardUtil.setPageComplete((WizardPage)this);
        } else {
            WizardUtil.setPageComplete((WizardPage)this, (String)INVALID_PAGE_MESSAGE, (int)3);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

