/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.ExecutionInfo;
import com.metamatrix.connector.xml.base.LargeOrSmallString;
import com.metamatrix.connector.xml.base.OutputXPathDesc;
import com.metamatrix.connector.xml.base.ValueConvertor;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import java.util.ArrayList;
import java.util.List;

public class BaseBatchProducer {
    public static int currentReturnIndex = 0;

    public static int getCurrentReturnIndex() {
        return currentReturnIndex;
    }

    public static Batch createBatch(List allResultsList, int returnIndex, int maxBatch, ExecutionInfo info, ExecutionContext exeCtx, ConnectorEnvironment connectorEnv) throws ConnectorException {
        BasicBatch batch = new BasicBatch();
        if (!allResultsList.isEmpty()) {
            ArrayList firstColumn = (ArrayList)allResultsList.get(0);
            while (returnIndex < firstColumn.size() && batch.getRowCount() < maxBatch) {
                ArrayList row = new ArrayList();
                boolean addRowToCollector = true;
                for (int colNum = 0; colNum < allResultsList.size(); ++colNum) {
                    Object resultObj = allResultsList.get(colNum);
                    ArrayList result = (ArrayList)resultObj;
                    Object valueObj = result.get(returnIndex);
                    LargeOrSmallString value = (LargeOrSmallString)valueObj;
                    addRowToCollector = BaseBatchProducer.passesCriteriaCheck(info.getCriteria(), value, colNum, exeCtx, connectorEnv);
                    if (!addRowToCollector) break;
                    BaseBatchProducer.setColumnValue(colNum, value, row, info, exeCtx, connectorEnv);
                }
                if (addRowToCollector) {
                    batch.addRow(row);
                }
                ++returnIndex;
            }
        }
        currentReturnIndex = returnIndex;
        return batch;
    }

    private static boolean passesCriteriaCheck(List criteriaPairs, LargeOrSmallString value, int colNum, ExecutionContext exeCtx, ConnectorEnvironment connectorEnv) throws ConnectorException {
        for (int x = 0; x < criteriaPairs.size(); ++x) {
            CriteriaDesc criteria = (CriteriaDesc)criteriaPairs.get(x);
            if (colNum != criteria.getColumnNumber()) continue;
            return ValueConvertor.evaluate(value, criteria, connectorEnv, exeCtx);
        }
        return true;
    }

    private static void setColumnValue(int colNum, LargeOrSmallString value, ArrayList row, ExecutionInfo info, ExecutionContext exeCtx, ConnectorEnvironment connectorEnv) throws ConnectorException {
        if (colNum < info.getColumnCount()) {
            OutputXPathDesc xpath = (OutputXPathDesc)info.getRequestedColumns().get(colNum);
            Class dataValueType = xpath.getDataType();
            Object valueObj = ValueConvertor.convertLargeOrSmallString(value, dataValueType, connectorEnv, exeCtx);
            row.add(valueObj);
        }
    }
}

