/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.types.ClobImpl;
import com.metamatrix.common.types.SQLXMLImpl;
import com.metamatrix.common.util.TimestampWithTimezone;
import com.metamatrix.core.jdbc.SQLXML;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

final class DataTypeTransformer {
    private DataTypeTransformer() {
    }

    static final BigDecimal getBigDecimal(Object value) throws SQLException {
        BigDecimal bigDecimalObject = null;
        if (value == null) {
            return bigDecimalObject;
        }
        try {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            if (value instanceof Boolean) {
                if (value.equals(Boolean.FALSE)) {
                    return new BigDecimal("0");
                }
                return new BigDecimal("1");
            }
            if (value instanceof Byte) {
                return new BigDecimal(((Byte)value).toString());
            }
            if (value instanceof Double) {
                return new BigDecimal(((Double)value).toString());
            }
            if (value instanceof Float) {
                return new BigDecimal(((Float)value).toString());
            }
            if (value instanceof Integer) {
                return new BigDecimal(((Integer)value).toString());
            }
            if (value instanceof Long) {
                return new BigDecimal(((Long)value).toString());
            }
            if (value instanceof Short) {
                return new BigDecimal(((Short)value).toString());
            }
            if (value instanceof String) {
                return new BigDecimal((String)value);
            }
            if (value instanceof Character) {
                return new BigDecimal((String)value);
            }
            throw DataTypeTransformer.createConversionError(value, "BigDecimal");
        }
        catch (RuntimeException e) {
            throw DataTypeTransformer.createRuntimeError(value, "BigDecimal", e);
        }
    }

    private static MMSQLException createConversionError(Object value, String type) {
        String msg = JDBCPlugin.Util.getString("DataTypeTransformer.Err_converting", (Object)type, value);
        return new MMSQLException(msg);
    }

    private static MMSQLException createRuntimeError(Object value, String type, RuntimeException e) {
        String msg = JDBCPlugin.Util.getString("DataTypeTransformer.Runtime_err_converting", value, (Object)type, (Object)e.getMessage());
        return new MMSQLException(msg);
    }

    static final Boolean getBoolean(Object value) throws SQLException {
        Number TRUE = null;
        Number FALSE = null;
        Boolean booleanObject = null;
        if (value == null) {
            return booleanObject;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof BigInteger) {
            FALSE = new BigInteger("0");
            TRUE = new BigInteger("1");
        } else if (value instanceof BigDecimal) {
            FALSE = new BigDecimal("0");
            TRUE = new BigDecimal("1");
        } else if (value instanceof Byte) {
            FALSE = new Byte(0);
            TRUE = new Byte(1);
        } else if (value instanceof Double) {
            FALSE = new Double(0.0);
            TRUE = new Double(1.0);
        } else if (value instanceof Float) {
            FALSE = new Float(0.0f);
            TRUE = new Float(1.0f);
        } else if (value instanceof Integer) {
            FALSE = new Integer(0);
            TRUE = new Integer(1);
        } else if (value instanceof Long) {
            FALSE = new Long(0L);
            TRUE = new Long(1L);
        } else if (value instanceof Short) {
            FALSE = new Short(0);
            TRUE = new Short(1);
        } else {
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
            if (value instanceof Character) {
                return Boolean.valueOf(value.toString());
            }
            throw DataTypeTransformer.createConversionError(value, "Boolean");
        }
        if (value.equals(TRUE)) {
            booleanObject = Boolean.TRUE;
        } else if (value.equals(FALSE)) {
            booleanObject = Boolean.FALSE;
        } else {
            String msg = JDBCPlugin.Util.getString("DataTypeTransformer.Err_converting_boolean", value);
            throw new MMSQLException(msg);
        }
        return booleanObject;
    }

    static final Byte getByte(Object value) throws SQLException {
        Byte byteObject = null;
        if (value == null) {
            return byteObject;
        }
        try {
            if (value instanceof Byte) {
                return (Byte)value;
            }
            if (value instanceof BigDecimal) {
                return new Byte(((BigDecimal)value).byteValue());
            }
            if (value instanceof BigInteger) {
                return new Byte(((BigInteger)value).byteValue());
            }
            if (value instanceof Boolean) {
                if (value.equals(Boolean.FALSE)) {
                    return new Byte(0);
                }
                return new Byte(1);
            }
            if (value instanceof Double) {
                return new Byte(((Double)value).byteValue());
            }
            if (value instanceof Float) {
                return new Byte(((Float)value).byteValue());
            }
            if (value instanceof Integer) {
                return new Byte(((Integer)value).byteValue());
            }
            if (value instanceof Long) {
                return new Byte(((Long)value).byteValue());
            }
            if (value instanceof Short) {
                return new Byte(((Short)value).byteValue());
            }
            if (value instanceof String) {
                return Byte.valueOf((String)value);
            }
            if (value instanceof Character) {
                return new Byte((byte)((Character)value).charValue());
            }
            throw DataTypeTransformer.createConversionError(value, "Byte");
        }
        catch (RuntimeException e) {
            throw DataTypeTransformer.createRuntimeError(value, "Byte", e);
        }
    }

    static final byte[] getBytes(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            long length = blob.length();
            if (length > Integer.MAX_VALUE) {
                throw new MMSQLException(JDBCPlugin.Util.getString("DataTypeTransformer.blob_too_big"));
            }
            return blob.getBytes(1L, (int)length);
        }
        throw new MMSQLException(JDBCPlugin.Util.getString("DataTypeTransformer.cannot_get_bytes"));
    }

    static final Character getCharacter(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            return new Character(value.toString().charAt(0));
        }
        catch (RuntimeException e) {
            String msg = JDBCPlugin.Util.getString("DataTypeTransformer.char_transform_failed", value, (Object)e.getMessage());
            throw new MMSQLException(msg);
        }
    }

    static final Date getDate(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                return Date.valueOf((String)value);
            }
            catch (Exception e) {
                String msg = JDBCPlugin.Util.getString("DataTypeTransformer.Err_converting_date", value);
                throw MMSQLException.create((Throwable)e, (String)msg);
            }
        }
        if (value instanceof java.util.Date) {
            return TimestampWithTimezone.createDate((java.util.Date)((java.util.Date)value));
        }
        throw DataTypeTransformer.createConversionError(value, "Date");
    }

    static final Double getDouble(Object value) throws SQLException {
        Double doubleObject = null;
        if (value == null) {
            return doubleObject;
        }
        try {
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof BigDecimal) {
                return new Double(((BigDecimal)value).doubleValue());
            }
            if (value instanceof BigInteger) {
                return new Double(((BigInteger)value).doubleValue());
            }
            if (value instanceof Boolean) {
                if (value.equals(Boolean.FALSE)) {
                    return new Double(0.0);
                }
                return new Double(1.0);
            }
            if (value instanceof Byte) {
                return new Double(((Byte)value).doubleValue());
            }
            if (value instanceof Float) {
                return new Double(((Float)value).doubleValue());
            }
            if (value instanceof Integer) {
                return new Double(((Integer)value).doubleValue());
            }
            if (value instanceof Long) {
                return new Double(((Long)value).doubleValue());
            }
            if (value instanceof Short) {
                return new Double(((Short)value).doubleValue());
            }
            if (value instanceof String) {
                return Double.valueOf((String)value);
            }
            if (value instanceof Character) {
                return new Double(((Character)value).charValue());
            }
            throw DataTypeTransformer.createConversionError(value, "Double");
        }
        catch (RuntimeException e) {
            throw DataTypeTransformer.createRuntimeError(value, "Double", e);
        }
    }

    static final Float getFloat(Object value) throws SQLException {
        Float floatObject = null;
        if (value == null) {
            return floatObject;
        }
        try {
            if (value instanceof Float) {
                return (Float)value;
            }
            if (value instanceof BigDecimal) {
                return new Float(((BigDecimal)value).floatValue());
            }
            if (value instanceof BigInteger) {
                return new Float(((BigInteger)value).floatValue());
            }
            if (value instanceof Boolean) {
                if (value.equals(Boolean.FALSE)) {
                    return new Float(0.0f);
                }
                return new Float(1.0f);
            }
            if (value instanceof Byte) {
                return new Float(((Byte)value).floatValue());
            }
            if (value instanceof Double) {
                return new Float(((Double)value).floatValue());
            }
            if (value instanceof Integer) {
                return new Float(((Integer)value).floatValue());
            }
            if (value instanceof Long) {
                return new Float(((Long)value).floatValue());
            }
            if (value instanceof Short) {
                return new Float(((Short)value).floatValue());
            }
            if (value instanceof String) {
                return Float.valueOf((String)value);
            }
            if (value instanceof Character) {
                return new Float(((Character)value).charValue());
            }
            throw DataTypeTransformer.createConversionError(value, "Float");
        }
        catch (RuntimeException e) {
            throw DataTypeTransformer.createRuntimeError(value, "Float", e);
        }
    }

    static final Integer getInteger(Object value) throws SQLException {
        Integer intObject = null;
        if (value == null) {
            return intObject;
        }
        try {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof BigDecimal) {
                return new Integer(((BigDecimal)value).intValue());
            }
            if (value instanceof BigInteger) {
                return new Integer(((BigInteger)value).intValue());
            }
            if (value instanceof Boolean) {
                if (value.equals(Boolean.FALSE)) {
                    return new Integer(0);
                }
                return new Integer(1);
            }
            if (value instanceof Byte) {
                return new Integer(((Byte)value).intValue());
            }
            if (value instanceof Double) {
                return new Integer(((Double)value).intValue());
            }
            if (value instanceof Float) {
                return new Integer(((Float)value).intValue());
            }
            if (value instanceof Long) {
                return new Integer(((Long)value).intValue());
            }
            if (value instanceof Short) {
                return new Integer(((Short)value).intValue());
            }
            if (value instanceof String) {
                return Integer.valueOf((String)value);
            }
            if (value instanceof Character) {
                return new Integer(((Character)value).charValue());
            }
            throw DataTypeTransformer.createConversionError(value, "Integer");
        }
        catch (RuntimeException e) {
            throw DataTypeTransformer.createRuntimeError(value, "Integer", e);
        }
    }

    static final Long getLong(Object value) throws SQLException {
        Long longObject = null;
        if (value == null) {
            return longObject;
        }
        try {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof BigDecimal) {
                return new Long(((BigDecimal)value).longValue());
            }
            if (value instanceof BigInteger) {
                return new Long(((BigInteger)value).longValue());
            }
            if (value instanceof Boolean) {
                if (value.equals(Boolean.FALSE)) {
                    return new Long(0L);
                }
                return new Long(1L);
            }
            if (value instanceof Byte) {
                return new Long(((Byte)value).longValue());
            }
            if (value instanceof Double) {
                return new Long(((Double)value).longValue());
            }
            if (value instanceof Float) {
                return new Long(((Float)value).longValue());
            }
            if (value instanceof Integer) {
                return new Long(((Integer)value).longValue());
            }
            if (value instanceof Short) {
                return new Long(((Short)value).longValue());
            }
            if (value instanceof String) {
                return Long.valueOf((String)value);
            }
            if (value instanceof Character) {
                return new Long(((Character)value).charValue());
            }
            throw DataTypeTransformer.createConversionError(value, "Long");
        }
        catch (RuntimeException e) {
            throw DataTypeTransformer.createRuntimeError(value, "Long", e);
        }
    }

    static final Short getShort(Object value) throws SQLException {
        Short shortObject = null;
        if (value == null) {
            return shortObject;
        }
        try {
            if (value instanceof Short) {
                return (Short)value;
            }
            if (value instanceof BigDecimal) {
                return new Short(((BigDecimal)value).shortValue());
            }
            if (value instanceof BigInteger) {
                return new Short(((BigInteger)value).shortValue());
            }
            if (value instanceof Boolean) {
                if (value.equals(Boolean.FALSE)) {
                    return new Short(0);
                }
                return new Short(1);
            }
            if (value instanceof Byte) {
                return new Short(((Byte)value).shortValue());
            }
            if (value instanceof Double) {
                return new Short(((Double)value).shortValue());
            }
            if (value instanceof Float) {
                return new Short(((Float)value).shortValue());
            }
            if (value instanceof Integer) {
                return new Short(((Integer)value).shortValue());
            }
            if (value instanceof Long) {
                return new Short(((Long)value).shortValue());
            }
            if (value instanceof String) {
                return Short.valueOf((String)value);
            }
            if (value instanceof Character) {
                return new Short((short)((Character)value).charValue());
            }
            throw DataTypeTransformer.createConversionError(value, "Short");
        }
        catch (RuntimeException e) {
            throw DataTypeTransformer.createRuntimeError(value, "Short", e);
        }
    }

    static final Time getTime(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                return Time.valueOf((String)value);
            }
            catch (Exception e) {
                String msg = JDBCPlugin.Util.getString("DataTypeTransformer.Err_converting_time", value);
                throw MMSQLException.create((Throwable)e, (String)msg);
            }
        }
        if (value instanceof java.util.Date) {
            return TimestampWithTimezone.createTime((java.util.Date)((java.util.Date)value));
        }
        throw DataTypeTransformer.createConversionError(value, "Time");
    }

    static final Timestamp getTimestamp(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                return Timestamp.valueOf((String)value);
            }
            catch (Exception e) {
                String msg = JDBCPlugin.Util.getString("DataTypeTransformer.Err_converting_timestamp", value);
                throw MMSQLException.create((Throwable)e, (String)msg);
            }
        }
        if (value instanceof java.util.Date) {
            return TimestampWithTimezone.createTimestamp((java.util.Date)((java.util.Date)value));
        }
        throw DataTypeTransformer.createConversionError(value, "Timestamp");
    }

    static final Blob getBlob(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Blob) {
            return (Blob)value;
        }
        throw DataTypeTransformer.createConversionError(value, "Blob");
    }

    static final Clob getClob(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Clob) {
            return (Clob)value;
        }
        if (value instanceof String) {
            return new ClobImpl(((String)value).toCharArray());
        }
        throw DataTypeTransformer.createConversionError(value, "Clob");
    }

    static final SQLXML getSQLXML(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof SQLXML) {
            return (SQLXML)value;
        }
        if (value instanceof String) {
            return new SQLXMLImpl((String)value);
        }
        throw DataTypeTransformer.createConversionError(value, "SQLXML");
    }
}

