/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Vector;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.NullUtil;
import org.eclipse.wst.wsi.internal.core.util.OperationSignature;
import org.eclipse.wst.wsi.internal.core.util.TypesRegistry;
import org.eclipse.wst.wsi.internal.core.util.WSDLUtil;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BP1107
extends AssertionProcessVisitor {
    private final BaseMessageValidator validator;
    private OperationSignature responseSig = null;
    private Vector faults = null;

    public BP1107(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public void visit(SOAPFault fault, Object parent, WSDLTraversalContext ctx) {
        Operation op;
        String faultName = fault.getName();
        if (faultName == null) {
            faultName = ctx.getBindingFault().getName();
        }
        if ((op = ctx.getBindingOperation().getOperation()) == null) {
            return;
        }
        Fault f = op.getFault(faultName);
        if (f == null) {
            return;
        }
        Message m = f.getMessage();
        if (m == null || m.getParts() == null || m.getParts().size() != 1) {
            return;
        }
        Part faultPart = (Part)m.getParts().values().iterator().next();
        TypesRegistry tReg = (TypesRegistry)ctx.getParameter("TypesRegistry");
        QName elemQName = faultPart.getElementName();
        QName typeQName = faultPart.getTypeName();
        if (typeQName == null) {
            typeQName = tReg.getType(faultPart.getElementName());
        }
        if (typeQName == null) {
            throw new IllegalArgumentException("Part type can not be null.");
        }
        int i = 0;
        while (i < this.faults.size()) {
            boolean matchByElement;
            Element elem = (Element)this.faults.get(i);
            boolean bl = matchByElement = elemQName != null && elem.getLocalName().equals(elemQName.getLocalPart()) && NullUtil.equals(elem.getNamespaceURI(), elemQName.getNamespaceURI());
            if (matchByElement) {
                this.faults.remove(i);
                continue;
            }
            ++i;
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (this.validator.isOneWayResponse(entryContext)) {
            this.result = "notApplicable";
        } else {
            Document docRequest = entryContext.getRequestDocument();
            Document docResponse = entryContext.getMessageEntryDocument();
            if (docRequest == null || docResponse == null) {
                this.result = "notApplicable";
            } else if (!this.validator.isFault(docResponse)) {
                this.result = "notApplicable";
            } else {
                OperationSignature.OperationMatch match = OperationSignature.matchOperation(docRequest, this.validator.getSoapAction(entryContext.getRequest().getHTTPHeaders()), this.validator.analyzerContext.getCandidateInfo().getBindings()[0], new TypesRegistry(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions(), this.validator));
                this.result = "notApplicable";
                if (match != null) {
                    this.responseSig = new OperationSignature(docResponse);
                    if ("rpc".equals(match.getOperationStyle())) {
                        this.responseSig.createRPCSignature();
                    }
                    WSDLTraversal traversal = new WSDLTraversal();
                    traversal.setVisitor(this);
                    traversal.visitSOAPFault(true);
                    traversal.ignoreBindingInput();
                    traversal.ignoreBindingOutput();
                    if (this.responseSig == null || !this.responseSig.isFault()) {
                        this.result = "notApplicable";
                    } else if (this.responseSig != null && this.responseSig.isFault()) {
                        Element body = XMLUtils.findChildElement(docResponse.getDocumentElement(), WSITag.ELEM_SOAP_BODY);
                        Element fault = XMLUtils.findChildElement(body, WSITag.ELEM_SOAP_FAULT);
                        Element detail = XMLUtils.getElement("detail", fault);
                        if (detail == null) {
                            this.result = "notApplicable";
                        } else {
                            this.result = "passed";
                            this.faults = XMLUtils.getChildElements(detail);
                            if (this.faults.size() > 0) {
                                HashMap<String, Object> m = new HashMap<String, Object>();
                                WSDLUtil.expandDefinition(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions());
                                m.put("definition", this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions());
                                TypesRegistry tReg = new TypesRegistry(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions(), this.validator);
                                m.put("TypesRegistry", tReg);
                                traversal.traverse(match.getOperation(), m);
                                if (this.faults.size() > 0) {
                                    this.result = "warning";
                                    StringWriter sw = new StringWriter();
                                    int i = 0;
                                    while (i < this.faults.size()) {
                                        try {
                                            XMLUtils.serializeElement((Element)this.faults.get(i), sw);
                                        }
                                        catch (Exception exception) {}
                                        ++i;
                                    }
                                    try {
                                        sw.close();
                                    }
                                    catch (Exception exception) {}
                                    this.failureDetail = this.validator.createFailureDetail("\nFaults:\n" + sw.toString(), entryContext);
                                } else {
                                    this.result = "passed";
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

