/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.GenerateCanonical;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.util.ValueIteratorProvider;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class RuleBreakCriteria
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, MetaMatrixComponentException {
        List selectNodes = NodeEditor.findAllNodes((PlanNode)plan, (int)13);
        Iterator i = selectNodes.iterator();
        while (i.hasNext()) {
            PlanNode critNode = (PlanNode)i.next();
            Criteria criteria = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
            if (!(criteria instanceof CompoundCriteria) || ((CompoundCriteria)criteria).getOperator() != 0) continue;
            LinkedList<PlanNode> newSelectNodes = new LinkedList<PlanNode>();
            List crits = Criteria.separateCriteriaByAnd((Criteria)criteria);
            Iterator critIter = crits.iterator();
            while (critIter.hasNext()) {
                Criteria conjunct = (Criteria)critIter.next();
                PlanNode selectNode = RuleBreakCriteria.createSelectNode(conjunct);
                selectNode.setProperty((Object)NodeConstants.Info.IS_HAVING, critNode.getProperty((Object)NodeConstants.Info.IS_HAVING));
                newSelectNodes.add(selectNode);
            }
            NodeEditor.replaceNode((PlanNode)critNode, newSelectNodes);
            List subqueryPlans = (List)critNode.getProperty((Object)NodeConstants.Info.SUBQUERY_PLANS);
            List subqueryValueProviders = (List)critNode.getProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS);
            List correlatedReferences = (List)critNode.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES);
            if (subqueryPlans == null && correlatedReferences == null) continue;
            this.distributeSubqueries(newSelectNodes, subqueryPlans, subqueryValueProviders, correlatedReferences);
        }
        return plan;
    }

    private void distributeSubqueries(List newSelectNodes, List subqueryPlans, List subqueryValueProviders, List correlatedReferences) {
        Iterator i = newSelectNodes.iterator();
        while (i.hasNext()) {
            PlanNode selectNode = (PlanNode)i.next();
            Criteria newCrit = (Criteria)selectNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
            Collection subqueriesInCrit = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)newCrit);
            if (subqueriesInCrit.size() <= 0) continue;
            if (subqueryPlans != null && subqueryPlans.size() > 0) {
                Iterator valueProviderIter = subqueryValueProviders.iterator();
                Iterator planIter = subqueryPlans.iterator();
                while (valueProviderIter.hasNext()) {
                    ValueIteratorProvider valueProp = (ValueIteratorProvider)valueProviderIter.next();
                    ProcessorPlan plan = (ProcessorPlan)planIter.next();
                    Iterator critValueProps = subqueriesInCrit.iterator();
                    while (critValueProps.hasNext()) {
                        ValueIteratorProvider critValueProp = (ValueIteratorProvider)critValueProps.next();
                        if (critValueProp != valueProp) continue;
                        this.addToListProperty(selectNode, NodeConstants.Info.SUBQUERY_PLANS, plan);
                        this.addToListProperty(selectNode, NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS, valueProp);
                        valueProviderIter.remove();
                        planIter.remove();
                    }
                }
            }
            if (correlatedReferences == null || correlatedReferences.size() <= 0) continue;
            List refs = ReferenceCollectorVisitor.getReferences((LanguageObject)newCrit);
            Iterator refIter = refs.iterator();
            while (refIter.hasNext()) {
                Reference ref = (Reference)refIter.next();
                Iterator correlatedRefIter = correlatedReferences.iterator();
                while (correlatedRefIter.hasNext()) {
                    Reference correlatedRef = (Reference)correlatedRefIter.next();
                    if (ref != correlatedRef) continue;
                    this.addToListProperty(selectNode, NodeConstants.Info.CORRELATED_REFERENCES, correlatedRef);
                    correlatedRefIter.remove();
                }
            }
        }
    }

    private void addToListProperty(PlanNode selectNode, Integer listProperty, Object value) {
        ArrayList<Object> listValue = (ArrayList<Object>)selectNode.getProperty((Object)listProperty);
        if (listValue == null) {
            listValue = new ArrayList<Object>();
            selectNode.setProperty((Object)listProperty, listValue);
        }
        listValue.add(value);
    }

    static PlanNode createSelectNode(Criteria crit) {
        return GenerateCanonical.createSelectNode(crit);
    }

    public String toString() {
        return "BreakCriteria";
    }
}

