/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relate.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.QueryProcessor;
import com.metamatrix.query.processor.relate.xml.ProcessorEnvironment;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.util.CommandContext;
import java.util.HashMap;
import java.util.Map;

class ProxyDataManager
implements ProcessorDataManager {
    private ProcessorDataManager processorDataManager;
    private ProcessorEnvironment env;
    private Map processors = new HashMap();

    public ProxyDataManager(ProcessorDataManager processorDataManager, ProcessorEnvironment env) {
        this.processorDataManager = processorDataManager;
        this.env = env;
    }

    public void registerProcessor(Object processorID, QueryProcessor processor) {
        if (!this.processors.containsKey(processorID)) {
            this.processors.put(processorID, processor);
        }
    }

    public void registerRequest(Object processorID, Command command, String modelName, int nodeID) throws MetaMatrixComponentException {
        TupleSource tempGroupSource;
        GroupSymbol thisSymbol = this.getGroupSymbol(command);
        LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"Proxy Data Manager, register request for group symbol", thisSymbol});
        if (thisSymbol != null && this.env.isTempGroup(thisSymbol) && (tempGroupSource = this.env.getTempGroupSource(thisSymbol.getName())) != null) {
            QueryProcessor processor = (QueryProcessor)this.processors.get(processorID);
            processor.connectTupleSource(tempGroupSource, nodeID);
            LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{QueryExecPlugin.Util.getString("ProxyDataManager.Proxy_Data_Manager_connected_tuple_source_for_group_symbol_2"), thisSymbol});
            return;
        }
        LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{QueryExecPlugin.Util.getString("ProxyDataManager.Proxy_Data_Manager,_group_symbol_3"), thisSymbol, QueryExecPlugin.Util.getString("ProxyDataManager.is_not_temp_group_symbol_4")});
        this.processorDataManager.registerRequest(processorID, command, modelName, nodeID);
    }

    public void unregisterProcessor(Object processorID) {
        this.processors.remove(processorID);
    }

    private GroupSymbol getGroupSymbol(Command command) {
        if (command instanceof Query) {
            Query query = (Query)command;
            GroupSymbol gs = (GroupSymbol)query.getFrom().getGroups().iterator().next();
            return gs;
        }
        return null;
    }

    public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, MetaMatrixComponentException {
        return this.processorDataManager.lookupCodeValue(context, codeTableName, returnElementName, keyElementName, keyValue);
    }

    public String user(CommandContext context) {
        return context.getUserName();
    }

    public QueryProcessor getProcessor(Object processorID) {
        return (QueryProcessor)this.processors.get(processorID);
    }
}

