/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.metadata.impl;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.data.MetadataRequest;
import com.metamatrix.modeler.jdbc.data.Request;
import com.metamatrix.modeler.jdbc.metadata.JdbcCatalog;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.jdbc.metadata.JdbcSchema;
import com.metamatrix.modeler.jdbc.metadata.JdbcTable;
import com.metamatrix.modeler.jdbc.metadata.JdbcTableType;
import com.metamatrix.modeler.jdbc.metadata.impl.DisabledRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.GetAccessForeignKeysRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.GetColumnsRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.GetDescriptionRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.GetExportedForeignKeysRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.GetImportedForeignKeysRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.GetIndexesRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.GetPrimaryKeyRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcNodeImpl;
import java.sql.DatabaseMetaData;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class JdbcTableImpl
extends JdbcNodeImpl
implements JdbcTable {
    private String remarks;

    public JdbcTableImpl(JdbcTableType parent, String name) {
        super(104, name, (JdbcNode)parent);
        ArgCheck.isNotNull((Object)parent);
    }

    protected JdbcNode[] computeChildren() throws JdbcException {
        return null;
    }

    public String getTypeName() {
        return this.getParent().getName();
    }

    public boolean allowsChildren() {
        return false;
    }

    protected int getDefaultSelectionMode() {
        return 1;
    }

    public String getFullyQualifiedName() {
        StringBuffer sb = new StringBuffer();
        String prefix = this.getParent().getFullyQualifiedName();
        if (prefix.length() != 0) {
            sb.append(prefix);
            sb.append(this.getQualifedNameDelimiter());
        }
        String unqualName = this.getUnqualifiedName();
        sb.append(unqualName);
        return sb.toString();
    }

    public IPath getPathInSource() {
        return this.getPathInSource(true, true);
    }

    public IPath getPathInSource(boolean includeCatalog, boolean includeSchema) {
        JdbcNode parent = this.getParent();
        while (!(parent instanceof JdbcSchema && includeSchema || parent instanceof JdbcCatalog && includeCatalog || parent instanceof JdbcDatabase)) {
            parent = parent.getParent();
        }
        if (parent instanceof JdbcDatabase) {
            return new Path(this.getName());
        }
        return parent.getPathInSource().append(this.getName());
    }

    public JdbcNode getParentDatabaseObject(boolean includeCatalog, boolean includeSchema) {
        JdbcNode parent;
        for (parent = this.getParent(); !(parent == null || parent instanceof JdbcSchema && includeSchema || parent instanceof JdbcCatalog && includeCatalog || parent instanceof JdbcDatabase); parent = parent.getParent()) {
        }
        if (parent != null && parent.isDatabaseObject()) {
            return parent;
        }
        return null;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String string) {
        this.remarks = string;
    }

    public JdbcDatabase getJdbcDatabase() {
        return this.getParent().getJdbcDatabase();
    }

    public void refresh() {
        super.refresh();
    }

    protected Request[] createRequests() throws JdbcException {
        DatabaseMetaData metadata = this.getJdbcDatabase().getDatabaseMetaData();
        String catalogNamePattern = JdbcNodeImpl.getCatalogPattern((JdbcNode)this);
        String schemaNamePattern = JdbcNodeImpl.getSchemaPattern((JdbcNode)this);
        String tableNamePattern = this.getName();
        String columnNamePattern = "%";
        Request[] requests = new Request[7];
        requests[0] = new GetColumnsRequest(metadata, catalogNamePattern, schemaNamePattern, tableNamePattern, "%");
        boolean uniqueOnly = this.getJdbcDatabase().getIncludes().getUniqueIndexesOnly();
        boolean approxAllowed = this.getJdbcDatabase().getIncludes().getApproximateIndexes();
        requests[1] = new GetIndexesRequest(metadata, catalogNamePattern, schemaNamePattern, tableNamePattern, uniqueOnly, approxAllowed);
        requests[2] = new GetPrimaryKeyRequest(metadata, catalogNamePattern, schemaNamePattern, tableNamePattern);
        requests[3] = new GetImportedForeignKeysRequest(metadata, catalogNamePattern, schemaNamePattern, tableNamePattern);
        requests[4] = new GetExportedForeignKeysRequest(metadata, catalogNamePattern, schemaNamePattern, tableNamePattern);
        requests[5] = new GetDescriptionRequest((JdbcNode)this, "getRemarks");
        if (!this.getJdbcDatabase().getIncludes().includeIndexes()) {
            requests[1] = new DisabledRequest((MetadataRequest)requests[1]);
        }
        if (!this.getJdbcDatabase().getIncludes().includeForeignKeys()) {
            requests[3] = new DisabledRequest((MetadataRequest)requests[3]);
            requests[4] = new DisabledRequest((MetadataRequest)requests[4]);
        }
        requests[6] = new GetAccessForeignKeysRequest(this.getJdbcDatabase().getConnection(), catalogNamePattern, schemaNamePattern, tableNamePattern);
        return requests;
    }
}

